/*
 * Decompiled with CFR 0.152.
 */
package io.jans.config.api.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.jans.config.api.client.model.ScriptError;
import io.jans.config.api.client.model.SimpleCustomProperty;
import io.jans.config.api.client.model.SimpleExtendedCustomProperty;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"dn", "inum", "name", "aliases", "description", "script", "scriptType", "programmingLanguage", "moduleProperties", "configurationProperties", "level", "revision", "enabled", "scriptError", "modified", "internal", "locationType", "locationPath", "baseDn"})
public class CustomScript {
    public static final String JSON_PROPERTY_DN = "dn";
    private String dn;
    public static final String JSON_PROPERTY_INUM = "inum";
    private String inum;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_ALIASES = "aliases";
    private List<String> aliases;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_SCRIPT = "script";
    private String script;
    public static final String JSON_PROPERTY_SCRIPT_TYPE = "scriptType";
    private ScriptTypeEnum scriptType;
    public static final String JSON_PROPERTY_PROGRAMMING_LANGUAGE = "programmingLanguage";
    private ProgrammingLanguageEnum programmingLanguage;
    public static final String JSON_PROPERTY_MODULE_PROPERTIES = "moduleProperties";
    private List<SimpleCustomProperty> moduleProperties;
    public static final String JSON_PROPERTY_CONFIGURATION_PROPERTIES = "configurationProperties";
    private List<SimpleExtendedCustomProperty> configurationProperties;
    public static final String JSON_PROPERTY_LEVEL = "level";
    private Integer level;
    public static final String JSON_PROPERTY_REVISION = "revision";
    private Long revision;
    public static final String JSON_PROPERTY_ENABLED = "enabled";
    private Boolean enabled;
    public static final String JSON_PROPERTY_SCRIPT_ERROR = "scriptError";
    private ScriptError scriptError;
    public static final String JSON_PROPERTY_MODIFIED = "modified";
    private Boolean modified;
    public static final String JSON_PROPERTY_INTERNAL = "internal";
    private Boolean internal;
    public static final String JSON_PROPERTY_LOCATION_TYPE = "locationType";
    private LocationTypeEnum locationType;
    public static final String JSON_PROPERTY_LOCATION_PATH = "locationPath";
    private String locationPath;
    public static final String JSON_PROPERTY_BASE_DN = "baseDn";
    private String baseDn;

    public CustomScript dn(String dn) {
        this.dn = dn;
        return this;
    }

    @Nullable
    @JsonProperty(value="dn")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDn() {
        return this.dn;
    }

    @JsonProperty(value="dn")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDn(String dn) {
        this.dn = dn;
    }

    public CustomScript inum(String inum) {
        this.inum = inum;
        return this;
    }

    @Nullable
    @JsonProperty(value="inum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getInum() {
        return this.inum;
    }

    @JsonProperty(value="inum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInum(String inum) {
        this.inum = inum;
    }

    public CustomScript name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public CustomScript aliases(List<String> aliases) {
        this.aliases = aliases;
        return this;
    }

    public CustomScript addAliasesItem(String aliasesItem) {
        if (this.aliases == null) {
            this.aliases = new ArrayList<String>();
        }
        this.aliases.add(aliasesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="aliases")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getAliases() {
        return this.aliases;
    }

    @JsonProperty(value="aliases")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAliases(List<String> aliases) {
        this.aliases = aliases;
    }

    public CustomScript description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public CustomScript script(String script) {
        this.script = script;
        return this;
    }

    @Nullable
    @JsonProperty(value="script")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getScript() {
        return this.script;
    }

    @JsonProperty(value="script")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setScript(String script) {
        this.script = script;
    }

    public CustomScript scriptType(ScriptTypeEnum scriptType) {
        this.scriptType = scriptType;
        return this;
    }

    @Nullable
    @JsonProperty(value="scriptType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ScriptTypeEnum getScriptType() {
        return this.scriptType;
    }

    @JsonProperty(value="scriptType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setScriptType(ScriptTypeEnum scriptType) {
        this.scriptType = scriptType;
    }

    public CustomScript programmingLanguage(ProgrammingLanguageEnum programmingLanguage) {
        this.programmingLanguage = programmingLanguage;
        return this;
    }

    @Nullable
    @JsonProperty(value="programmingLanguage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ProgrammingLanguageEnum getProgrammingLanguage() {
        return this.programmingLanguage;
    }

    @JsonProperty(value="programmingLanguage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProgrammingLanguage(ProgrammingLanguageEnum programmingLanguage) {
        this.programmingLanguage = programmingLanguage;
    }

    public CustomScript moduleProperties(List<SimpleCustomProperty> moduleProperties) {
        this.moduleProperties = moduleProperties;
        return this;
    }

    public CustomScript addModulePropertiesItem(SimpleCustomProperty modulePropertiesItem) {
        if (this.moduleProperties == null) {
            this.moduleProperties = new ArrayList<SimpleCustomProperty>();
        }
        this.moduleProperties.add(modulePropertiesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="moduleProperties")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SimpleCustomProperty> getModuleProperties() {
        return this.moduleProperties;
    }

    @JsonProperty(value="moduleProperties")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setModuleProperties(List<SimpleCustomProperty> moduleProperties) {
        this.moduleProperties = moduleProperties;
    }

    public CustomScript configurationProperties(List<SimpleExtendedCustomProperty> configurationProperties) {
        this.configurationProperties = configurationProperties;
        return this;
    }

    public CustomScript addConfigurationPropertiesItem(SimpleExtendedCustomProperty configurationPropertiesItem) {
        if (this.configurationProperties == null) {
            this.configurationProperties = new ArrayList<SimpleExtendedCustomProperty>();
        }
        this.configurationProperties.add(configurationPropertiesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="configurationProperties")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SimpleExtendedCustomProperty> getConfigurationProperties() {
        return this.configurationProperties;
    }

    @JsonProperty(value="configurationProperties")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setConfigurationProperties(List<SimpleExtendedCustomProperty> configurationProperties) {
        this.configurationProperties = configurationProperties;
    }

    public CustomScript level(Integer level) {
        this.level = level;
        return this;
    }

    @Nullable
    @JsonProperty(value="level")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getLevel() {
        return this.level;
    }

    @JsonProperty(value="level")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLevel(Integer level) {
        this.level = level;
    }

    public CustomScript revision(Long revision) {
        this.revision = revision;
        return this;
    }

    @Nullable
    @JsonProperty(value="revision")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getRevision() {
        return this.revision;
    }

    @JsonProperty(value="revision")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRevision(Long revision) {
        this.revision = revision;
    }

    public CustomScript enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Nullable
    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getEnabled() {
        return this.enabled;
    }

    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public CustomScript scriptError(ScriptError scriptError) {
        this.scriptError = scriptError;
        return this;
    }

    @Nullable
    @JsonProperty(value="scriptError")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ScriptError getScriptError() {
        return this.scriptError;
    }

    @JsonProperty(value="scriptError")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setScriptError(ScriptError scriptError) {
        this.scriptError = scriptError;
    }

    public CustomScript modified(Boolean modified) {
        this.modified = modified;
        return this;
    }

    @Nullable
    @JsonProperty(value="modified")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getModified() {
        return this.modified;
    }

    @JsonProperty(value="modified")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setModified(Boolean modified) {
        this.modified = modified;
    }

    public CustomScript internal(Boolean internal) {
        this.internal = internal;
        return this;
    }

    @Nullable
    @JsonProperty(value="internal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getInternal() {
        return this.internal;
    }

    @JsonProperty(value="internal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInternal(Boolean internal) {
        this.internal = internal;
    }

    public CustomScript locationType(LocationTypeEnum locationType) {
        this.locationType = locationType;
        return this;
    }

    @Nullable
    @JsonProperty(value="locationType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocationTypeEnum getLocationType() {
        return this.locationType;
    }

    @JsonProperty(value="locationType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLocationType(LocationTypeEnum locationType) {
        this.locationType = locationType;
    }

    public CustomScript locationPath(String locationPath) {
        this.locationPath = locationPath;
        return this;
    }

    @Nullable
    @JsonProperty(value="locationPath")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLocationPath() {
        return this.locationPath;
    }

    @JsonProperty(value="locationPath")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLocationPath(String locationPath) {
        this.locationPath = locationPath;
    }

    public CustomScript baseDn(String baseDn) {
        this.baseDn = baseDn;
        return this;
    }

    @Nullable
    @JsonProperty(value="baseDn")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBaseDn() {
        return this.baseDn;
    }

    @JsonProperty(value="baseDn")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBaseDn(String baseDn) {
        this.baseDn = baseDn;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomScript customScript = (CustomScript)o;
        return Objects.equals(this.dn, customScript.dn) && Objects.equals(this.inum, customScript.inum) && Objects.equals(this.name, customScript.name) && Objects.equals(this.aliases, customScript.aliases) && Objects.equals(this.description, customScript.description) && Objects.equals(this.script, customScript.script) && Objects.equals((Object)this.scriptType, (Object)customScript.scriptType) && Objects.equals((Object)this.programmingLanguage, (Object)customScript.programmingLanguage) && Objects.equals(this.moduleProperties, customScript.moduleProperties) && Objects.equals(this.configurationProperties, customScript.configurationProperties) && Objects.equals(this.level, customScript.level) && Objects.equals(this.revision, customScript.revision) && Objects.equals(this.enabled, customScript.enabled) && Objects.equals(this.scriptError, customScript.scriptError) && Objects.equals(this.modified, customScript.modified) && Objects.equals(this.internal, customScript.internal) && Objects.equals((Object)this.locationType, (Object)customScript.locationType) && Objects.equals(this.locationPath, customScript.locationPath) && Objects.equals(this.baseDn, customScript.baseDn);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.dn, this.inum, this.name, this.aliases, this.description, this.script, this.scriptType, this.programmingLanguage, this.moduleProperties, this.configurationProperties, this.level, this.revision, this.enabled, this.scriptError, this.modified, this.internal, this.locationType, this.locationPath, this.baseDn});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CustomScript {\n");
        sb.append("    dn: ").append(this.toIndentedString(this.dn)).append("\n");
        sb.append("    inum: ").append(this.toIndentedString(this.inum)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    aliases: ").append(this.toIndentedString(this.aliases)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    script: ").append(this.toIndentedString(this.script)).append("\n");
        sb.append("    scriptType: ").append(this.toIndentedString((Object)this.scriptType)).append("\n");
        sb.append("    programmingLanguage: ").append(this.toIndentedString((Object)this.programmingLanguage)).append("\n");
        sb.append("    moduleProperties: ").append(this.toIndentedString(this.moduleProperties)).append("\n");
        sb.append("    configurationProperties: ").append(this.toIndentedString(this.configurationProperties)).append("\n");
        sb.append("    level: ").append(this.toIndentedString(this.level)).append("\n");
        sb.append("    revision: ").append(this.toIndentedString(this.revision)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    scriptError: ").append(this.toIndentedString(this.scriptError)).append("\n");
        sb.append("    modified: ").append(this.toIndentedString(this.modified)).append("\n");
        sb.append("    internal: ").append(this.toIndentedString(this.internal)).append("\n");
        sb.append("    locationType: ").append(this.toIndentedString((Object)this.locationType)).append("\n");
        sb.append("    locationPath: ").append(this.toIndentedString(this.locationPath)).append("\n");
        sb.append("    baseDn: ").append(this.toIndentedString(this.baseDn)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ScriptTypeEnum {
        PERSON_AUTHENTICATION("person_authentication"),
        AUTHORIZATION_CHALLENGE("authorization_challenge"),
        INTROSPECTION("introspection"),
        RESOURCE_OWNER_PASSWORD_CREDENTIALS("resource_owner_password_credentials"),
        APPLICATION_SESSION("application_session"),
        LINK_INTERCEPTION("link_interception"),
        CLIENT_REGISTRATION("client_registration"),
        ID_GENERATOR("id_generator"),
        UMA_RPT_POLICY("uma_rpt_policy"),
        UMA_RPT_CLAIMS("uma_rpt_claims"),
        UMA_CLAIMS_GATHERING("uma_claims_gathering"),
        ACCESS_EVALUATION("access_evaluation"),
        ACCESS_EVALUATION_DISCOVERY("access_evaluation_discovery"),
        TOKEN_EXCHANGE("token_exchange"),
        CONSENT_GATHERING("consent_gathering"),
        DYNAMIC_SCOPE("dynamic_scope"),
        SPONTANEOUS_SCOPE("spontaneous_scope"),
        END_SESSION("end_session"),
        POST_AUTHN("post_authn"),
        CLIENT_AUTHN("client_authn"),
        SELECT_ACCOUNT("select_account"),
        CREATE_USER("create_user"),
        SCIM("scim"),
        CIBA_END_USER_NOTIFICATION("ciba_end_user_notification"),
        REVOKE_TOKEN("revoke_token"),
        PERSISTENCE_EXTENSION("persistence_extension"),
        IDP("idp"),
        DISCOVERY("discovery"),
        COOKIE("cookie"),
        HEALTH_CHECK("health_check"),
        AUTHZ_DETAIL("authz_detail"),
        UPDATE_TOKEN("update_token"),
        LOGOUT_STATUS_JWT("logout_status_jwt"),
        CONFIG_API_AUTH("config_api_auth"),
        MODIFY_SSA_RESPONSE("modify_ssa_response"),
        FIDO2_EXTENSION("fido2_extension"),
        LOCK_EXTENSION("lock_extension");

        private String value;

        private ScriptTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ScriptTypeEnum fromValue(String value) {
            for (ScriptTypeEnum b : ScriptTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum ProgrammingLanguageEnum {
        PYTHON("python"),
        JAVA("java");

        private String value;

        private ProgrammingLanguageEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ProgrammingLanguageEnum fromValue(String value) {
            for (ProgrammingLanguageEnum b : ProgrammingLanguageEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum LocationTypeEnum {
        LDAP("ldap"),
        DB("db"),
        FILE("file");

        private String value;

        private LocationTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static LocationTypeEnum fromValue(String value) {
            for (LocationTypeEnum b : LocationTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

