/*
 * Decompiled with CFR 0.152.
 */
package io.jans.config.api.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.jans.config.api.client.model.Document;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"start", "totalEntriesCount", "entriesCount", "entries"})
public class DocumentPagedResult {
    public static final String JSON_PROPERTY_START = "start";
    private Integer start;
    public static final String JSON_PROPERTY_TOTAL_ENTRIES_COUNT = "totalEntriesCount";
    private Integer totalEntriesCount;
    public static final String JSON_PROPERTY_ENTRIES_COUNT = "entriesCount";
    private Integer entriesCount;
    public static final String JSON_PROPERTY_ENTRIES = "entries";
    private List<Document> entries;

    public DocumentPagedResult start(Integer start) {
        this.start = start;
        return this;
    }

    @Nullable
    @JsonProperty(value="start")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getStart() {
        return this.start;
    }

    @JsonProperty(value="start")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStart(Integer start) {
        this.start = start;
    }

    public DocumentPagedResult totalEntriesCount(Integer totalEntriesCount) {
        this.totalEntriesCount = totalEntriesCount;
        return this;
    }

    @Nullable
    @JsonProperty(value="totalEntriesCount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getTotalEntriesCount() {
        return this.totalEntriesCount;
    }

    @JsonProperty(value="totalEntriesCount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalEntriesCount(Integer totalEntriesCount) {
        this.totalEntriesCount = totalEntriesCount;
    }

    public DocumentPagedResult entriesCount(Integer entriesCount) {
        this.entriesCount = entriesCount;
        return this;
    }

    @Nullable
    @JsonProperty(value="entriesCount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getEntriesCount() {
        return this.entriesCount;
    }

    @JsonProperty(value="entriesCount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEntriesCount(Integer entriesCount) {
        this.entriesCount = entriesCount;
    }

    public DocumentPagedResult entries(List<Document> entries) {
        this.entries = entries;
        return this;
    }

    public DocumentPagedResult addEntriesItem(Document entriesItem) {
        if (this.entries == null) {
            this.entries = new ArrayList<Document>();
        }
        this.entries.add(entriesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="entries")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Document> getEntries() {
        return this.entries;
    }

    @JsonProperty(value="entries")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEntries(List<Document> entries) {
        this.entries = entries;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentPagedResult documentPagedResult = (DocumentPagedResult)o;
        return Objects.equals(this.start, documentPagedResult.start) && Objects.equals(this.totalEntriesCount, documentPagedResult.totalEntriesCount) && Objects.equals(this.entriesCount, documentPagedResult.entriesCount) && Objects.equals(this.entries, documentPagedResult.entries);
    }

    public int hashCode() {
        return Objects.hash(this.start, this.totalEntriesCount, this.entriesCount, this.entries);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DocumentPagedResult {\n");
        sb.append("    start: ").append(this.toIndentedString(this.start)).append("\n");
        sb.append("    totalEntriesCount: ").append(this.toIndentedString(this.totalEntriesCount)).append("\n");
        sb.append("    entriesCount: ").append(this.toIndentedString(this.entriesCount)).append("\n");
        sb.append("    entries: ").append(this.toIndentedString(this.entries)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

