/*
 * Decompiled with CFR 0.152.
 */
package io.jans.kc.api.admin.client;

import io.jans.kc.api.admin.client.KeycloakAdminClientApiError;
import io.jans.kc.api.admin.client.KeycloakConfiguration;
import io.jans.kc.api.admin.client.KeycloakConfigurationError;
import io.jans.kc.api.admin.client.model.AuthenticationFlow;
import io.jans.kc.api.admin.client.model.ManagedSamlClient;
import io.jans.kc.api.admin.client.model.ProtocolMapper;
import io.jans.saml.metadata.model.EntityDescriptor;
import io.jans.saml.metadata.model.KeyDescriptor;
import io.jans.saml.metadata.model.SAMLBinding;
import io.jans.saml.metadata.model.SPSSODescriptor;
import io.jans.saml.metadata.model.ds.KeyInfo;
import io.jans.saml.metadata.model.ds.X509Data;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.core.Response;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.engines.ApacheHttpClient43Engine;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.KeycloakBuilder;
import org.keycloak.admin.client.resource.AuthenticationManagementResource;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.ClientsResource;
import org.keycloak.admin.client.resource.ProtocolMappersResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.representations.idm.AuthenticationFlowRepresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeycloakApi {
    private static final Integer DEFAULT_CONNPOOL_SIZE = 5;
    private static final Integer DEFAULT_MAX_CONN_PER_ROUTE = 100;
    private static final String SAML_PROTOCOL = "saml";
    private static final Pattern MANAGED_SAML_CLIENT_NAME_REGEX = Pattern.compile("^managed_saml_client_([a-zA-Z0-9\\-]+)$");
    private static final String MANAGED_SAML_CLIENT_NAME_FORMAT = "managed_saml_client_%s";
    private static final String MANAGED_SAML_CLIENT_DESC_FORMAT = "#REF %s.\r\n!!! DO NOT ALTER THIS CLIENT MANUALLY!!!";
    private static final String BROWSER_AUTHN_FLOW_KEY = "browser";
    private static final Logger log = LoggerFactory.getLogger(KeycloakApi.class);
    private Keycloak keycloak;

    private KeycloakApi(Keycloak keycloak) {
        this.keycloak = keycloak;
    }

    public AuthenticationFlow getAuthenticationFlowFromAlias(String realmname, String alias) {
        try {
            RealmResource realmresource = this.realmByName(realmname);
            AuthenticationManagementResource authnmanagementresource = realmresource.flows();
            List flows = authnmanagementresource.getFlows();
            Optional<AuthenticationFlowRepresentation> authnflow = flows.stream().filter(f -> f.getAlias() != null && f.getAlias().equals(alias)).findFirst();
            return authnflow.isPresent() ? new AuthenticationFlow(authnflow.get()) : null;
        }
        catch (Exception e) {
            throw new KeycloakAdminClientApiError("Could not find authentication flow with alias " + alias, e);
        }
    }

    public List<ManagedSamlClient> findAllManagedSamlClients(String realmname) {
        try {
            RealmResource realmresource = this.realmByName(realmname);
            List clientsrep = realmresource.clients().findAll();
            log.debug("Clients from realm count : {}", (Object)clientsrep.size());
            return clientsrep.stream().filter(KeycloakApi::isManagedSamlClientRepresentation).map(KeycloakApi::toManagedSamlClient).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new KeycloakAdminClientApiError("Could not get managed clients", e);
        }
    }

    public void deleteManagedSamlClient(String realmname, ManagedSamlClient client) {
        try {
            RealmResource realmresource = this.realmByName(realmname);
            ClientResource clientresource = realmresource.clients().get(client.keycloakId());
            if (clientresource != null) {
                clientresource.remove();
            }
        }
        catch (Exception e) {
            throw new KeycloakAdminClientApiError("Could not delete managed saml client", e);
        }
    }

    public ManagedSamlClient createManagedSamlClient(String realmname, String externalref, AuthenticationFlow browserflow, EntityDescriptor entitydesc) {
        try {
            RealmResource realmresource = this.realmByName(realmname);
            ClientsResource clientsresource = realmresource.clients();
            ClientRepresentation clientrep = new ClientRepresentation();
            ManagedSamlClient client = new ManagedSamlClient(clientrep, externalref);
            this.configureBasicManagedClientProperties(KeycloakApi.managedSamlClientName(externalref), KeycloakApi.managedSamlClientDescription(externalref), entitydesc.getEntityId(), client);
            this.configureSamlRedirectUris(entitydesc, client);
            this.configureSamlEncryptionAndSigning(entitydesc, client);
            this.configureKeycloakAuthentication(browserflow, client);
            Response response = clientsresource.create(clientrep);
            int code = response.getStatus();
            if (code != Response.Status.CREATED.getStatusCode()) {
                String body = (String)response.readEntity(String.class);
                throw new KeycloakAdminClientApiError(String.format("Could not create managed saml client(http code %d). %s.", code, body));
            }
            String id = ((ClientRepresentation)clientsresource.findByClientId(client.clientId()).get(0)).getId();
            client.setKeycloakId(id);
            return client;
        }
        catch (Exception e) {
            throw new KeycloakAdminClientApiError("Could not create managed saml client", e);
        }
    }

    public void updateManagedSamlClient(String realmname, ManagedSamlClient client, EntityDescriptor entitydesc) {
        try {
            RealmResource realmresource = this.realmByName(realmname);
            ClientResource clientresource = realmresource.clients().get(client.keycloakId());
            String externalref = client.externalRef();
            String description = KeycloakApi.managedSamlClientDescription(client.externalRef());
            this.configureBasicManagedClientProperties(null, description, entitydesc.getEntityId(), client);
            this.configureSamlRedirectUris(entitydesc, client);
            this.configureSamlEncryptionAndSigning(entitydesc, client);
            clientresource.update(client.clientRepresentation());
        }
        catch (Exception e) {
            throw new KeycloakAdminClientApiError("Could not create update managed saml client", e);
        }
    }

    public void addProtocolMappersToManagedSamlClient(String realmname, ManagedSamlClient client, List<ProtocolMapper> mappers) {
        try {
            RealmResource realmresource = this.realmByName(realmname);
            ClientResource clientresource = realmresource.clients().get(client.keycloakId());
            clientresource.getProtocolMappers().createMapper(mappers.stream().map(m -> m.representation()).toList());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new KeycloakAdminClientApiError("Could not add protocol mapper to managed saml client", e);
        }
    }

    public void updateManagedSamlClientProtocolMapper(String realmname, ManagedSamlClient client, ProtocolMapper mapper) {
        try {
            RealmResource realmresource = this.realmByName(realmname);
            ClientResource clientresource = realmresource.clients().get(client.keycloakId());
            clientresource.getProtocolMappers().update(mapper.getId(), mapper.representation());
        }
        catch (Exception e) {
            throw new KeycloakAdminClientApiError("Could not update protocol mapper for managed saml client", e);
        }
    }

    public List<ProtocolMapper> getManagedSamlClientProtocolMappers(String realmname, ManagedSamlClient client) {
        try {
            RealmResource realmresource = this.realmByName(realmname);
            ClientResource clientresource = realmresource.clients().get(client.keycloakId());
            ProtocolMappersResource protocolmappers = clientresource.getProtocolMappers();
            List mappers = protocolmappers.getMappersPerProtocol(ProtocolMapper.Protocol.SAML.value());
            return mappers.stream().map(m -> new ProtocolMapper((ProtocolMapperRepresentation)m)).toList();
        }
        catch (Exception e) {
            throw new KeycloakAdminClientApiError("Could not get managed saml client protocol mappers", e);
        }
    }

    public void deleteManagedSamlClientProtocolMapper(String realmname, ManagedSamlClient client, ProtocolMapper mapper) {
        try {
            RealmResource realmresource = this.realmByName(realmname);
            ClientResource clientresource = realmresource.clients().get(client.keycloakId());
            clientresource.getProtocolMappers().delete(mapper.getId());
        }
        catch (Exception e) {
            throw new KeycloakAdminClientApiError("Could not delete managed saml client protocol mapper", e);
        }
    }

    private void configureBasicManagedClientProperties(String name, String description, String clientid, ManagedSamlClient client) {
        if (name != null) {
            client.setName(name);
        }
        if (description != null) {
            client.setDescription(description);
        }
        if (clientid != null) {
            client.setClientId(clientid);
        }
    }

    private void configureSamlRedirectUris(EntityDescriptor entitydescriptor, ManagedSamlClient client) {
        SPSSODescriptor spssodescriptor = entitydescriptor.getFirstSpssoDescriptor();
        if (spssodescriptor != null) {
            List acs_endpoints = spssodescriptor.getAssertionConsumerServices();
            client.setSamlRedirectUris(acs_endpoints.stream().filter(e -> e.getBinding() == SAMLBinding.HTTP_REDIRECT || e.getBinding() == SAMLBinding.HTTP_POST).map(e -> e.getLocation()).toList());
            boolean has_no_http_get_urls = acs_endpoints.stream().filter(e -> e.getBinding() == SAMLBinding.HTTP_REDIRECT).count() == 0L;
            client.samlForcePostBinding(acs_endpoints.size() > 0 && has_no_http_get_urls);
        }
    }

    private void configureSamlEncryptionAndSigning(EntityDescriptor entitydescriptor, ManagedSamlClient client) {
        SPSSODescriptor spssodescriptor = entitydescriptor.getFirstSpssoDescriptor();
        if (spssodescriptor != null) {
            List encryptionkeys;
            client.samlClientSignatureRequired(spssodescriptor.getAuthnRequestsSigned());
            client.samlSignAssertions(spssodescriptor.getWantAssertionsSigned());
            List signingkeys = spssodescriptor.getSigningKeys();
            if (!signingkeys.isEmpty()) {
                this.configureSamlSigningKey((KeyDescriptor)signingkeys.get(0), client);
            }
            if (!(encryptionkeys = spssodescriptor.getEncryptionKeys()).isEmpty()) {
                this.configureSamlEncryptionKey((KeyDescriptor)encryptionkeys.get(0), client);
            }
        }
    }

    private void configureSamlSigningKey(KeyDescriptor keydescriptor, ManagedSamlClient client) {
        KeyInfo keyinfo = keydescriptor.getKeyInfo();
        List certdata = keyinfo.getDatalist();
        if (!certdata.isEmpty()) {
            client.samlClientSignatureRequired(true);
            client.samlClientSigningCertificate(((X509Data)certdata.get(0)).getFirstX509Certificate());
        }
    }

    private void configureSamlEncryptionKey(KeyDescriptor keydescriptor, ManagedSamlClient client) {
        KeyInfo keyinfo = keydescriptor.getKeyInfo();
        List certdata = keyinfo.getDatalist();
        if (!certdata.isEmpty()) {
            client.samlEncryptAssertions(true);
            client.samlClientEncryptionCertificate(((X509Data)certdata.get(0)).getFirstX509Certificate());
        }
    }

    private void configureKeycloakAuthentication(AuthenticationFlow browserflow, ManagedSamlClient client) {
        client.setBrowserFlow(browserflow.getId());
    }

    private Optional<AuthenticationFlowRepresentation> authnFlowFromAlias(RealmResource realm, String flowalias) {
        AuthenticationManagementResource authn = realm.flows();
        List flows = authn.getFlows();
        return flows.stream().filter(f -> f.getAlias().equalsIgnoreCase(flowalias)).findFirst();
    }

    private RealmResource realmByName(String realmname) {
        return this.keycloak.realm(realmname);
    }

    private Optional<AuthenticationFlowRepresentation> authnFlowByName(String realmname, String flowname) {
        RealmResource realm = this.keycloak.realm(realmname);
        if (realm == null) {
            return null;
        }
        AuthenticationManagementResource authnmanagement = realm.flows();
        List realmflows = authnmanagement.getFlows();
        return realmflows.stream().filter(f -> f.getAlias().equalsIgnoreCase(flowname)).findFirst();
    }

    public static final KeycloakApi createInstance(KeycloakConfiguration kcConfig) {
        try {
            Keycloak kc = KeycloakApi.createKeycloakInstance(kcConfig);
            kc.serverInfo().getInfo();
            return new KeycloakApi(kc);
        }
        catch (IllegalStateException e) {
            throw new KeycloakConfigurationError("Could not create keycloak instance", e);
        }
    }

    private static final Keycloak createKeycloakInstance(KeycloakConfiguration kcConfig) throws IllegalStateException {
        return KeycloakBuilder.builder().serverUrl(kcConfig.serverUrl()).realm(kcConfig.realm()).username(kcConfig.username()).password(kcConfig.password()).clientId(kcConfig.clientId()).grantType("password").resteasyClient(KeycloakApi.createResteasyClient(kcConfig)).build();
    }

    private static final Client createResteasyClient(KeycloakConfiguration kcConfig) {
        Integer effectivecpsize = DEFAULT_CONNPOOL_SIZE;
        effectivecpsize = kcConfig.connPoolSize() == null || kcConfig.connPoolSize() == 0 ? DEFAULT_CONNPOOL_SIZE : kcConfig.connPoolSize();
        PoolingHttpClientConnectionManager connmgr = new PoolingHttpClientConnectionManager();
        CloseableHttpClient httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connmgr).build();
        connmgr.setMaxTotal(effectivecpsize.intValue());
        connmgr.setDefaultMaxPerRoute(DEFAULT_MAX_CONN_PER_ROUTE.intValue());
        ApacheHttpClient43Engine engine = new ApacheHttpClient43Engine((HttpClient)httpClient);
        return ((ResteasyClientBuilder)ClientBuilder.newBuilder()).httpEngine((ClientHttpEngine)engine).build();
    }

    private static boolean isManagedSamlClientRepresentation(ClientRepresentation client) {
        if (!SAML_PROTOCOL.equalsIgnoreCase(client.getProtocol())) {
            return false;
        }
        Matcher matcher = MANAGED_SAML_CLIENT_NAME_REGEX.matcher(client.getName());
        return matcher.matches();
    }

    private static ManagedSamlClient toManagedSamlClient(ClientRepresentation client) {
        Matcher matcher = MANAGED_SAML_CLIENT_NAME_REGEX.matcher(client.getName());
        if (matcher.matches()) {
            return new ManagedSamlClient(client, matcher.group(1));
        }
        return null;
    }

    private static String managedSamlClientName(String externalclientref) {
        return String.format(MANAGED_SAML_CLIENT_NAME_FORMAT, externalclientref);
    }

    private static String managedSamlClientDescription(String externalclientref) {
        return String.format(MANAGED_SAML_CLIENT_DESC_FORMAT, externalclientref);
    }

    private static Map<String, String> authnFlowBindingOverrides(final AuthenticationFlowRepresentation browserflow) {
        return new HashMap<String, String>(){
            {
                this.put(KeycloakApi.BROWSER_AUTHN_FLOW_KEY, browserflow.getId());
            }
        };
    }
}

