/*
 * Decompiled with CFR 0.152.
 */
package io.jans.kc.api.admin.client.model;

import io.jans.kc.api.admin.client.model.SamlNameIDFormat;
import io.jans.kc.api.admin.client.model.SamlSignatureAlgorithm;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.keycloak.representations.idm.ClientRepresentation;

public class ManagedSamlClient {
    private String externalRef;
    private ClientRepresentation clientRepresentation;
    private final Map<String, String> authnFlowBindingOverrides = new HashMap<String, String>();
    private final Map<String, String> attributes = new HashMap<String, String>();
    private static final String ATTR_SAML_ASSERTION_SIGNATURE = "saml.assertion.signature";
    private static final String ATTR_SAML_ENCRYPTION_PRIVATE_KEY = "saml.encryption.private.key";
    private static final String ATTR_SAML_FORCE_POST_BINDING = "saml.force.post.binding";
    private static final String ATTR_SAML_ENCRYPT = "saml.encrypt";
    private static final String ATTR_POST_LOGOUT_REDIRECT_URIS = "post.logout.redirect.uris";
    private static final String ATTR_SAML_SERVER_SIGNATURE = "saml.server.signature";
    private static final String ATTR_SAML_SERVER_SIGNATURE_KEYINFO_EXT = "saml.server.signature.keyinfo.ext";
    private static final String ATTR_SAML_SIGNING_CERTIFICATE = "saml.signing.certificate";
    private static final String ATTR_SAML_ARTIFACT_BINDING_ID = "saml.artifact.binding.identifier";
    private static final String ATTR_SAML_ARTIFACT_BINDING = "saml.artifact.binding";
    private static final String ATTR_SAML_SIGNATURE_ALGORITHM = "saml.signature.algorithm";
    private static final String ATTR_SAML_FORCE_NAME_ID_FORMAT = "saml.force_name_id_format";
    private static final String ATTR_SAML_CLIENT_SIGNATURE = "saml.client.signature";
    private static final String ATTR_SAML_ENCRYPTION_CERTIFICATE = "saml.encryption.certificate";
    private static final String ATTR_SAML_AUTHNSTATEMENT = "saml.authnstatement";
    private static final String ATTR_SAML_NAMEID_FORMAT = "saml_name_id_format";
    private static final String ATTR_SAML_SIGNING_PRIVATE_KEY = "saml.signing.private.key";
    private static final String ATTR_SAML_ALLOW_ECP_FLOW = "saml.allow.ecp.flow";
    private static final String ATTR_SAML_SIGNATURE_C14N_METHOD = "saml_signature_canonicalization_method";
    private static final String ATTR_SAML_ONETIMEUSE_CONDITION = "saml.onetimeuse.condition";

    public ManagedSamlClient(String externalRef) {
        this.externalRef = externalRef;
        this.clientRepresentation = new ClientRepresentation();
        this.initClientRepresentation();
    }

    public ManagedSamlClient(ClientRepresentation clientRepresentation, String externalRef) {
        this.clientRepresentation = clientRepresentation;
        this.externalRef = externalRef;
        this.initClientRepresentation();
    }

    private void initClientRepresentation() {
        if (this.clientRepresentation != null) {
            this.clientRepresentation.setEnabled(Boolean.valueOf(true));
            this.clientRepresentation.setProtocol(Protocol.SAML.value());
            this.clientRepresentation.setAlwaysDisplayInConsole(Boolean.valueOf(false));
            this.clientRepresentation.setClientAuthenticatorType(AuthenticatorType.CLIENT_JWT.value());
            this.clientRepresentation.setConsentRequired(Boolean.valueOf(false));
            this.clientRepresentation.setAttributes(this.attributes);
            this.clientRepresentation.setAuthenticationFlowBindingOverrides(this.authnFlowBindingOverrides);
            this.samlShoulDocumentsBeSigned(true);
            this.samlSignAssertions(true);
            this.samlForcePostBinding(false);
            this.samlEncryptAssertions(false);
            this.samlForceArtifactBinding(false);
            this.samlSignatureAlgorithm(SamlSignatureAlgorithm.RSA_SHA256);
            this.samlForceNameIdFormat(false);
            this.samlClientSignatureRequired(false);
            this.samlIncludeAuthnStatement(true);
            this.samlNameIDFormat(SamlNameIDFormat.USERNAME);
            this.samlAllowEcpFLow(false);
            this.samlXmlSignatureCanonicalizationMethod("http://www.w3.org/2001/10/xml-exc-c14n#");
            this.samlIncludeOneTimeUseCondition(false);
        }
    }

    public String externalRef() {
        return this.externalRef;
    }

    public ClientRepresentation clientRepresentation() {
        return this.clientRepresentation;
    }

    public boolean correspondsToExternalRef(String externalRef) {
        return this.externalRef.equals(externalRef);
    }

    public String keycloakId() {
        return this.clientRepresentation.getId();
    }

    public ManagedSamlClient setKeycloakId(String keycloakid) {
        this.clientRepresentation.setId(keycloakid);
        return this;
    }

    public ManagedSamlClient setName(String name) {
        this.clientRepresentation.setName(name);
        return this;
    }

    public ManagedSamlClient setDescription(String description) {
        this.clientRepresentation.setDescription(description);
        return this;
    }

    public ManagedSamlClient setClientId(String clientid) {
        this.clientRepresentation.setClientId(clientid);
        return this;
    }

    public String clientId() {
        return this.clientRepresentation.getClientId();
    }

    public ManagedSamlClient setEnabled(Boolean enabled) {
        this.clientRepresentation.setEnabled(enabled);
        return this;
    }

    public ManagedSamlClient setBrowserFlow(String browserflowid) {
        this.authnFlowBindingOverrides.put(AuthnFlowOverrideType.BROWSER.value(), browserflowid);
        return this;
    }

    public ManagedSamlClient setDirectGrantFlow(String directgrantflowid) {
        this.authnFlowBindingOverrides.put(AuthnFlowOverrideType.DIRECT_GRANT.value(), directgrantflowid);
        return this;
    }

    public ManagedSamlClient setSamlRedirectUris(List<String> uris) {
        this.clientRepresentation.setRedirectUris(uris);
        return this;
    }

    public ManagedSamlClient samlSignAssertions(Boolean sign) {
        this.attributes.put(ATTR_SAML_ASSERTION_SIGNATURE, sign.toString());
        return this;
    }

    public ManagedSamlClient samlEncryptionPrivateKey(String privatekey) {
        this.attributes.put(ATTR_SAML_ENCRYPTION_PRIVATE_KEY, privatekey);
        return this;
    }

    public ManagedSamlClient samlForcePostBinding(Boolean forcepostbinding) {
        this.attributes.put(ATTR_SAML_FORCE_POST_BINDING, forcepostbinding.toString());
        return this;
    }

    public ManagedSamlClient samlEncryptAssertions(Boolean encryptassertions) {
        this.attributes.put(ATTR_SAML_ENCRYPT, encryptassertions.toString());
        return this;
    }

    public ManagedSamlClient samlPostLogoutRedirectUrls(List<String> urls) {
        this.attributes.put(ATTR_POST_LOGOUT_REDIRECT_URIS, String.join((CharSequence)"##", urls));
        return this;
    }

    public ManagedSamlClient samlShoulDocumentsBeSigned(Boolean signed) {
        this.attributes.put(ATTR_SAML_SERVER_SIGNATURE, signed.toString());
        return this;
    }

    public ManagedSamlClient samlClientSigningCertificate(String certificate) {
        this.attributes.put(ATTR_SAML_SIGNING_CERTIFICATE, certificate);
        return this;
    }

    public ManagedSamlClient samlForceArtifactBinding(Boolean force) {
        this.attributes.put(ATTR_SAML_ARTIFACT_BINDING, force.toString());
        return this;
    }

    public ManagedSamlClient samlSignatureAlgorithm(SamlSignatureAlgorithm algorithm) {
        this.attributes.put(ATTR_SAML_SIGNATURE_ALGORITHM, algorithm.value());
        return this;
    }

    public ManagedSamlClient samlForceNameIdFormat(Boolean force) {
        this.attributes.put(ATTR_SAML_FORCE_NAME_ID_FORMAT, force.toString());
        return this;
    }

    public ManagedSamlClient samlClientSignatureRequired(Boolean required) {
        this.attributes.put(ATTR_SAML_CLIENT_SIGNATURE, required.toString());
        return this;
    }

    public ManagedSamlClient samlClientEncryptionCertificate(String certificate) {
        this.attributes.put(ATTR_SAML_ENCRYPTION_CERTIFICATE, certificate);
        return this;
    }

    public ManagedSamlClient samlIncludeAuthnStatement(Boolean include) {
        this.attributes.put(ATTR_SAML_AUTHNSTATEMENT, include.toString());
        return this;
    }

    public ManagedSamlClient samlNameIDFormat(SamlNameIDFormat format) {
        this.attributes.put(ATTR_SAML_NAMEID_FORMAT, format.value());
        return this;
    }

    public ManagedSamlClient samlClientPrivateKey(String privatekey) {
        this.attributes.put(ATTR_SAML_SIGNING_PRIVATE_KEY, privatekey);
        return this;
    }

    public ManagedSamlClient samlAllowEcpFLow(Boolean allow) {
        this.attributes.put(ATTR_SAML_ALLOW_ECP_FLOW, allow.toString());
        return this;
    }

    public ManagedSamlClient samlXmlSignatureCanonicalizationMethod(String method) {
        this.attributes.put(ATTR_SAML_SIGNATURE_C14N_METHOD, method);
        return this;
    }

    public ManagedSamlClient samlIncludeOneTimeUseCondition(Boolean include) {
        this.attributes.put(ATTR_SAML_ONETIMEUSE_CONDITION, include.toString());
        return this;
    }

    public static enum Protocol {
        SAML("saml"),
        OPENID("openid");

        private final String value;

        private Protocol(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static enum AuthenticatorType {
        CLIENT_SECRET("client-secret"),
        CLIENT_JWT("client-jwt");

        private final String value;

        private AuthenticatorType(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static enum AuthnFlowOverrideType {
        BROWSER("browser"),
        DIRECT_GRANT("direct-grant");

        private final String value;

        private AuthnFlowOverrideType(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

