/*
 * Decompiled with CFR 0.152.
 */
package io.jans.kc.scheduler;

import io.jans.kc.api.admin.client.KeycloakApi;
import io.jans.kc.api.admin.client.model.AuthenticationFlow;
import io.jans.kc.api.admin.client.model.ManagedSamlClient;
import io.jans.kc.api.admin.client.model.ProtocolMapper;
import io.jans.kc.api.config.client.JansConfigApi;
import io.jans.kc.api.config.client.model.JansAttributeRepresentation;
import io.jans.kc.api.config.client.model.JansTrustRelationship;
import io.jans.kc.scheduler.App;
import io.jans.kc.scheduler.job.ExecutionContext;
import io.jans.kc.scheduler.job.RecurringJob;
import io.jans.saml.metadata.model.EntityDescriptor;
import io.jans.saml.metadata.model.SAMLMetadata;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrustRelationshipSyncJob
extends RecurringJob {
    private static final Logger log = LoggerFactory.getLogger(TrustRelationshipSyncJob.class);
    private final JansConfigApi jansConfigApi = App.jansConfigApi();
    private final KeycloakApi keycloakApi = App.keycloakApi();
    private final String realm = App.configuration().keycloakResourcesRealm();
    private AuthenticationFlow authnBrowserFlow;
    private final String samlUserAttributeMapperId = App.configuration().keycloakResourcesSamlUserAttributeMapper();

    public TrustRelationshipSyncJob() {
        this.authnBrowserFlow = this.keycloakApi.getAuthenticationFlowFromAlias(this.realm, App.configuration().keycloakResourcesBrowserFlowAlias());
    }

    @Override
    public void run(ExecutionContext context) {
        this.performSyncTasks();
    }

    private void performSyncTasks() {
        try {
            log.info("Performing Saml client housekeeping");
            this.performSamlClientsHousekeeping();
            log.info("Saml client housekeeping complete");
            log.info("Creating new managed saml clients");
            this.createNewManagedSamlClients();
            log.info("Creating new managed saml clients complete");
            log.info("Updating existing managed saml clients");
            this.updateExistingManagedSamlClients();
            log.info("Updating existing managed saml clients complete");
        }
        catch (Exception e) {
            log.error("Error running tr sync job", (Throwable)e);
        }
    }

    private void performSamlClientsHousekeeping() {
        this.deleteUnmanagedSamlClients();
    }

    private void deleteUnmanagedSamlClients() {
        log.debug("Deleting unmanaged SAML clients");
        List<ManagedSamlClient> managedsamlclients = this.keycloakApi.findAllManagedSamlClients(this.realm);
        if (managedsamlclients.isEmpty()) {
            log.debug("No previously managed SAML clients found in keycloak.");
            return;
        }
        log.debug("Previously managed SAML clients found in keycloak. Count: {}", (Object)managedsamlclients.size());
        managedsamlclients.forEach(c -> {
            if (!this.jansConfigApi.trustRelationshipExists(c.externalRef())) {
                log.debug("Deleting previously managed SAML client with id: {}", (Object)c.keycloakId());
                this.keycloakApi.deleteManagedSamlClient(this.realm, (ManagedSamlClient)c);
            }
        });
    }

    private void createNewManagedSamlClients() {
        if (this.authnBrowserFlow == null) {
            log.warn("Misconfigured browser authentication flow, skipping creation of new saml clients");
            return;
        }
        List<JansTrustRelationship> unassociatedtrs = this.unassociatedJansTrustRelationships();
        if (unassociatedtrs.isEmpty()) {
            log.debug("No unmanaged trust relationships found in Janssen.");
            return;
        }
        log.debug("Unmanaged trust relationships found in Janssen. Count: {}", (Object)unassociatedtrs.size());
        unassociatedtrs.stream().forEach(this::createNewManagedSamlClient);
    }

    private void createNewManagedSamlClient(JansTrustRelationship trustrelationship) {
        try {
            log.debug("Creating managed SAML client from Janssen TR with inum {}", (Object)trustrelationship.getInum());
            SAMLMetadata metadata = this.jansConfigApi.getTrustRelationshipSamlMetadata(trustrelationship);
            List entitydescriptors = metadata.getEntityDescriptors();
            if (!entitydescriptors.isEmpty()) {
                String trinum = trustrelationship.getInum();
                ManagedSamlClient client = this.keycloakApi.createManagedSamlClient(this.realm, trinum, this.authnBrowserFlow, (EntityDescriptor)entitydescriptors.get(0));
                List<JansAttributeRepresentation> attrs = this.jansConfigApi.getTrustRelationshipReleasedAttributes(trustrelationship);
                this.addReleasedAttributesToManagedSamlClient(client, attrs);
                log.debug("Created managed SAML client with id {} from Janssen TR with inum {}", (Object)client.keycloakId(), (Object)trinum);
            }
        }
        catch (Exception e) {
            log.warn("Could not create managed SAML client using tr with inum {}", (Object)trustrelationship.getInum());
            log.warn("Resulting exception: ", (Throwable)e);
        }
    }

    private void updateExistingManagedSamlClients() {
        List<JansTrustRelationship> alltr = this.jansConfigApi.findAllTrustRelationships();
        List<ManagedSamlClient> clients = this.keycloakApi.findAllManagedSamlClients(this.realm);
        log.debug("Updating existing managed saml clients. Count: {}", (Object)clients.size());
        clients.stream().forEach(c -> {
            Optional<JansTrustRelationship> tr = alltr.stream().filter(t -> c.correspondsToExternalRef(t.getInum())).findFirst();
            if (tr.isPresent()) {
                this.updateExistingSamlClient((ManagedSamlClient)c, tr.get());
            }
        });
    }

    private void updateExistingSamlClient(ManagedSamlClient client, JansTrustRelationship trustrelationship) {
        try {
            log.debug("Updating managed SAML client with id {}. Associated trust relationship inum: {}", (Object)client.keycloakId(), (Object)client.externalRef());
            SAMLMetadata metadata = this.jansConfigApi.getTrustRelationshipSamlMetadata(trustrelationship);
            List entitydescriptors = metadata.getEntityDescriptors();
            if (!entitydescriptors.isEmpty()) {
                this.keycloakApi.updateManagedSamlClient(this.realm, client, (EntityDescriptor)entitydescriptors.get(0));
                List<JansAttributeRepresentation> releasedattributes = this.jansConfigApi.getTrustRelationshipReleasedAttributes(trustrelationship);
                List<ProtocolMapper> mappers = this.keycloakApi.getManagedSamlClientProtocolMappers(this.realm, client);
                mappers.forEach(m -> {
                    String inum = this.inumFromProtocolMapperName(m.getName());
                    if (!releasedattributes.stream().anyMatch(r -> inum.equals(r.getInum()))) {
                        log.debug("Removing attribute {} for managed saml client {} because it's no more part of the released attributes", (Object)m.getName(), (Object)client.clientId());
                        this.deleteProtolMapperFromManagedClient(client, (ProtocolMapper)m);
                    }
                });
                List<JansAttributeRepresentation> newattributes = releasedattributes.stream().filter(r -> !mappers.stream().anyMatch(m -> {
                    String inum = this.inumFromProtocolMapperName(m.getName());
                    return inum.equals(r.getInum());
                })).toList();
                this.addReleasedAttributesToManagedSamlClient(client, newattributes);
                mappers.forEach(m -> {
                    String inum = this.inumFromProtocolMapperName(m.getName());
                    Optional<JansAttributeRepresentation> attr = releasedattributes.stream().filter(r -> inum.equals(r.getInum())).findFirst();
                    if (attr.isPresent()) {
                        this.updateManagedSamlClientProtocolMapper(client, (ProtocolMapper)m, attr.get());
                    }
                });
            }
        }
        catch (Exception e) {
            log.warn("Could not update managed SAML client with id {}", (Object)client.keycloakId());
            log.warn("Resulting exception: ", (Throwable)e);
        }
    }

    private List<JansTrustRelationship> unassociatedJansTrustRelationships() {
        List<JansTrustRelationship> alltr = this.jansConfigApi.findAllTrustRelationships();
        List<ManagedSamlClient> clients = this.keycloakApi.findAllManagedSamlClients(this.realm);
        return alltr.stream().filter(t -> clients.stream().noneMatch(c -> c.externalRef().equals(t.getInum()))).toList();
    }

    private void addReleasedAttributesToManagedSamlClient(ManagedSamlClient client, List<JansAttributeRepresentation> releasedattributes) {
        List<ProtocolMapper> protmappers = releasedattributes.stream().map(r -> {
            log.debug("Preparing to add released attribute {} to managed saml client with clientId {}", (Object)r.getName(), (Object)client.clientId());
            return ProtocolMapper.samlUserAttributeMapper(this.samlUserAttributeMapperId).name(this.generateKeycloakUniqueProtocolMapperName((JansAttributeRepresentation)r)).jansAttributeName(r.getName()).build();
        }).toList();
        this.keycloakApi.addProtocolMappersToManagedSamlClient(this.realm, client, protmappers);
    }

    private void updateManagedSamlClientProtocolMapper(ManagedSamlClient client, ProtocolMapper mapper, JansAttributeRepresentation releasedattribute) {
        log.debug("Updating managed client released attribute. Client id: {} / Attribute name: {}", (Object)client.clientId(), (Object)releasedattribute.getName());
        ProtocolMapper newmapper = ProtocolMapper.samlUserAttributeMapper(mapper).jansAttributeName(releasedattribute.getName()).build();
        this.keycloakApi.updateManagedSamlClientProtocolMapper(this.realm, client, newmapper);
    }

    private void deleteProtolMapperFromManagedClient(ManagedSamlClient client, ProtocolMapper mapper) {
        log.debug("Deleting released attribute from managed client. Client id: {} / Attribute name: {}", (Object)client.clientId(), (Object)mapper.getName());
        this.keycloakApi.deleteManagedSamlClientProtocolMapper(this.realm, client, mapper);
    }

    private final String generateKeycloakUniqueProtocolMapperName(JansAttributeRepresentation rep) {
        return String.format("%s:%s", rep.getInum(), rep.getName());
    }

    private final String inumFromProtocolMapperName(String name) {
        int idx = name.indexOf(":");
        if (idx != -1) {
            return name.substring(0, idx);
        }
        return "";
    }
}

