/*
 * Decompiled with CFR 0.152.
 */
package io.jans.kc.scheduler.job.impl;

import io.jans.kc.scheduler.job.Job;
import io.jans.kc.scheduler.job.impl.QuartzExecutionContext;
import java.lang.reflect.Constructor;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public class QuartzJobWrapper
implements org.quartz.Job {
    public static final String JOB_NAME_ENTRY_KEY = "jans.job.name";
    public static final String JOB_CLASS_ENTRY_KEY = "jans.job.class";
    public static final String JOB_EXECUTION_CONTEXT_ENTRY_KEY = "jobexecutioncontext";
    private static final Logger log = LoggerFactory.getLogger(QuartzJobWrapper.class);

    public void execute(JobExecutionContext context) throws JobExecutionException {
        String jobname = context.getMergedJobDataMap().getString(JOB_NAME_ENTRY_KEY);
        String jobclassname = context.getMergedJobDataMap().getString(JOB_CLASS_ENTRY_KEY);
        try {
            Class<?> jobclass = Class.forName(jobclassname);
            Constructor<?> constructor = jobclass.getConstructor(new Class[0]);
            Job job = (Job)constructor.newInstance(new Object[0]);
            QuartzExecutionContext effectivecontext = new QuartzExecutionContext(context.getMergedJobDataMap());
            job.run(effectivecontext);
        }
        catch (Exception e) {
            throw new JobExecutionException("Failed to run job " + jobname, (Throwable)e);
        }
    }
}

