/*
 * Decompiled with CFR 0.152.
 */
package io.jans.config.api.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.jans.config.api.client.model.ProjectMetadata;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"folders", "libs", "error", "autoconfigure", "flowsError", "projectMetadata"})
public class DeploymentDetails {
    public static final String JSON_PROPERTY_FOLDERS = "folders";
    private List<String> folders;
    public static final String JSON_PROPERTY_LIBS = "libs";
    private List<String> libs;
    public static final String JSON_PROPERTY_ERROR = "error";
    private String error;
    public static final String JSON_PROPERTY_AUTOCONFIGURE = "autoconfigure";
    private Boolean autoconfigure;
    public static final String JSON_PROPERTY_FLOWS_ERROR = "flowsError";
    private Map<String, String> flowsError = new HashMap<String, String>();
    public static final String JSON_PROPERTY_PROJECT_METADATA = "projectMetadata";
    private ProjectMetadata projectMetadata;

    public DeploymentDetails folders(List<String> folders) {
        this.folders = folders;
        return this;
    }

    public DeploymentDetails addFoldersItem(String foldersItem) {
        if (this.folders == null) {
            this.folders = new ArrayList<String>();
        }
        this.folders.add(foldersItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="folders")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getFolders() {
        return this.folders;
    }

    @JsonProperty(value="folders")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFolders(List<String> folders) {
        this.folders = folders;
    }

    public DeploymentDetails libs(List<String> libs) {
        this.libs = libs;
        return this;
    }

    public DeploymentDetails addLibsItem(String libsItem) {
        if (this.libs == null) {
            this.libs = new ArrayList<String>();
        }
        this.libs.add(libsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="libs")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getLibs() {
        return this.libs;
    }

    @JsonProperty(value="libs")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLibs(List<String> libs) {
        this.libs = libs;
    }

    public DeploymentDetails error(String error) {
        this.error = error;
        return this;
    }

    @Nullable
    @JsonProperty(value="error")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getError() {
        return this.error;
    }

    @JsonProperty(value="error")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setError(String error) {
        this.error = error;
    }

    public DeploymentDetails autoconfigure(Boolean autoconfigure) {
        this.autoconfigure = autoconfigure;
        return this;
    }

    @Nullable
    @JsonProperty(value="autoconfigure")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAutoconfigure() {
        return this.autoconfigure;
    }

    @JsonProperty(value="autoconfigure")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAutoconfigure(Boolean autoconfigure) {
        this.autoconfigure = autoconfigure;
    }

    public DeploymentDetails flowsError(Map<String, String> flowsError) {
        this.flowsError = flowsError;
        return this;
    }

    public DeploymentDetails putFlowsErrorItem(String key, String flowsErrorItem) {
        if (this.flowsError == null) {
            this.flowsError = new HashMap<String, String>();
        }
        this.flowsError.put(key, flowsErrorItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="flowsError")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getFlowsError() {
        return this.flowsError;
    }

    @JsonProperty(value="flowsError")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFlowsError(Map<String, String> flowsError) {
        this.flowsError = flowsError;
    }

    public DeploymentDetails projectMetadata(ProjectMetadata projectMetadata) {
        this.projectMetadata = projectMetadata;
        return this;
    }

    @Nullable
    @JsonProperty(value="projectMetadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ProjectMetadata getProjectMetadata() {
        return this.projectMetadata;
    }

    @JsonProperty(value="projectMetadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProjectMetadata(ProjectMetadata projectMetadata) {
        this.projectMetadata = projectMetadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeploymentDetails deploymentDetails = (DeploymentDetails)o;
        return Objects.equals(this.folders, deploymentDetails.folders) && Objects.equals(this.libs, deploymentDetails.libs) && Objects.equals(this.error, deploymentDetails.error) && Objects.equals(this.autoconfigure, deploymentDetails.autoconfigure) && Objects.equals(this.flowsError, deploymentDetails.flowsError) && Objects.equals(this.projectMetadata, deploymentDetails.projectMetadata);
    }

    public int hashCode() {
        return Objects.hash(this.folders, this.libs, this.error, this.autoconfigure, this.flowsError, this.projectMetadata);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DeploymentDetails {\n");
        sb.append("    folders: ").append(this.toIndentedString(this.folders)).append("\n");
        sb.append("    libs: ").append(this.toIndentedString(this.libs)).append("\n");
        sb.append("    error: ").append(this.toIndentedString(this.error)).append("\n");
        sb.append("    autoconfigure: ").append(this.toIndentedString(this.autoconfigure)).append("\n");
        sb.append("    flowsError: ").append(this.toIndentedString(this.flowsError)).append("\n");
        sb.append("    projectMetadata: ").append(this.toIndentedString(this.projectMetadata)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

