/*
 * Decompiled with CFR 0.152.
 */
package io.jans.kc.api.admin.client.model;

import java.util.HashMap;
import java.util.Map;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;

public class ProtocolMapper {
    private final ProtocolMapperRepresentation representation;

    public ProtocolMapper() {
        this.representation = new ProtocolMapperRepresentation();
    }

    public ProtocolMapper(ProtocolMapperRepresentation representation) {
        this.representation = representation;
    }

    public String getId() {
        return this.representation.getId();
    }

    public ProtocolMapperRepresentation representation() {
        return this.representation;
    }

    public String getName() {
        return this.representation.getName();
    }

    public static SamlUserAttributeMapperBuilder samlUserAttributeMapper(String id) {
        return new SamlUserAttributeMapperBuilder(id);
    }

    public static SamlUserAttributeMapperBuilder samlUserAttributeMapper(ProtocolMapper mapper) {
        return new SamlUserAttributeMapperBuilder(mapper);
    }

    public static class SamlUserAttributeMapperBuilder {
        private static final String NAMEFORMAT_OPT_BASIC = "Basic";
        private static final String NAMEFORMAT_OPT_URI_REFERENCE = "URI Reference";
        private static final String NAMEFORMAT_OPT_UNSPECIFIED = "Unspecified";
        private final ProtocolMapper mapper;
        private final Map<String, String> config;

        public SamlUserAttributeMapperBuilder(String mapperid) {
            ProtocolMapperRepresentation pmr = new ProtocolMapperRepresentation();
            pmr.setProtocol(Protocol.SAML.value());
            pmr.setProtocolMapper(mapperid);
            this.mapper = new ProtocolMapper(pmr);
            this.config = new HashMap<String, String>();
            pmr.setConfig(this.config);
        }

        private SamlUserAttributeMapperBuilder(ProtocolMapper other) {
            this.mapper = new ProtocolMapper(other.representation);
            this.config = this.mapper.representation().getConfig();
        }

        public SamlUserAttributeMapperBuilder name(String name) {
            this.mapper.representation.setName(name);
            return this;
        }

        public SamlUserAttributeMapperBuilder userAttribute(String userattribute) {
            this.config.put("user.attribute", userattribute);
            return this;
        }

        public SamlUserAttributeMapperBuilder friendlyName(String friendlyname) {
            this.config.put("friendly.name", friendlyname);
            return this;
        }

        public SamlUserAttributeMapperBuilder attributeName(String attributename) {
            this.config.put("attribute.name", attributename);
            return this;
        }

        public SamlUserAttributeMapperBuilder attributeNameFormatBasic() {
            this.config.put("attribute.nameformat", NAMEFORMAT_OPT_BASIC);
            return this;
        }

        public SamlUserAttributeMapperBuilder attributeNameFormatUriReference() {
            this.config.put("attribute.nameformat", NAMEFORMAT_OPT_URI_REFERENCE);
            return this;
        }

        public SamlUserAttributeMapperBuilder attributeNameFormatUnspecified() {
            this.config.put("attribute.nameformat", NAMEFORMAT_OPT_UNSPECIFIED);
            return this;
        }

        public SamlUserAttributeMapperBuilder jansAttributeName(String attributename) {
            this.config.put("jans.attribute.name", attributename);
            return this;
        }

        public ProtocolMapper build() {
            return this.mapper;
        }
    }

    public static enum Protocol {
        OPENID("openid"),
        SAML("saml");

        private final String value;

        private Protocol(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

