/*
 * Decompiled with CFR 0.152.
 */
package io.jans.config.api.client;

import io.jans.config.api.client.ApiClient;
import io.jans.config.api.client.ApiException;
import io.jans.config.api.client.Configuration;
import io.jans.config.api.client.Pair;
import io.jans.config.api.client.model.JansAttribute;
import io.jans.config.api.client.model.PagedResult;
import io.jans.config.api.client.model.PatchRequest;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class AttributeApi {
    private ApiClient apiClient;

    public AttributeApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AttributeApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public void deleteAttributesByInum(String inum) throws ApiException {
        Object localVarPostBody = null;
        if (inum == null) {
            throw new ApiException(400, "Missing the required parameter 'inum' when calling deleteAttributesByInum");
        }
        String localVarPath = "/api/v1/attributes/{inum}".replaceAll("\\{format\\}", "json").replaceAll("\\{inum\\}", this.apiClient.escapeString(inum.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public PagedResult getAttributes(Integer limit, String pattern, String status, Integer startIndex, String sortBy, String sortOrder, String fieldValuePair) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/attributes".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "pattern", pattern));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "status", status));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "startIndex", startIndex));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sortBy", sortBy));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sortOrder", sortOrder));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "fieldValuePair", fieldValuePair));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<PagedResult> localVarReturnType = new GenericType<PagedResult>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public JansAttribute getAttributesByInum(String inum) throws ApiException {
        Object localVarPostBody = null;
        if (inum == null) {
            throw new ApiException(400, "Missing the required parameter 'inum' when calling getAttributesByInum");
        }
        String localVarPath = "/api/v1/attributes/{inum}".replaceAll("\\{format\\}", "json").replaceAll("\\{inum\\}", this.apiClient.escapeString(inum.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<JansAttribute> localVarReturnType = new GenericType<JansAttribute>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public JansAttribute patchAttributesByInum(String inum, List<PatchRequest> patchRequest) throws ApiException {
        List<PatchRequest> localVarPostBody = patchRequest;
        if (inum == null) {
            throw new ApiException(400, "Missing the required parameter 'inum' when calling patchAttributesByInum");
        }
        String localVarPath = "/api/v1/attributes/{inum}".replaceAll("\\{format\\}", "json").replaceAll("\\{inum\\}", this.apiClient.escapeString(inum.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json-patch+json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<JansAttribute> localVarReturnType = new GenericType<JansAttribute>(){};
        return this.apiClient.invokeAPI(localVarPath, "PATCH", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public JansAttribute postAttributes(JansAttribute jansAttribute) throws ApiException {
        JansAttribute localVarPostBody = jansAttribute;
        String localVarPath = "/api/v1/attributes".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<JansAttribute> localVarReturnType = new GenericType<JansAttribute>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public JansAttribute putAttributes(JansAttribute jansAttribute) throws ApiException {
        JansAttribute localVarPostBody = jansAttribute;
        String localVarPath = "/api/v1/attributes".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<JansAttribute> localVarReturnType = new GenericType<JansAttribute>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

