/*
 * Decompiled with CFR 0.152.
 */
package io.jans.saml.metadata.util;

import io.jans.saml.metadata.util.SAMLMetadataNamespaceContext;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPathUtils {
    private static final Object xpathFactorysync = new Object();
    private static final String ENTITIES_DESCRIPTOR_SELECTOR = "md:EntitiesDescriptor";
    private static final String ENTITY_DESCRIPTOR_SELECTOR = "md:EntityDescriptor";
    private static final String ROLE_DESCRIPTOR_SELECTOR = "md:RoleDescriptor";
    private static final String IDPSSO_DESCRIPTOR_SELECTOR = "md:IDPSSODescriptor";
    private static final String SPSSO_DESCRIPTOR_SELECTOR = "md:SPSSODescriptor";
    private static final String AUTHN_AUTHORITY_DESCRIPTOR_SELECTOR = "md:AuthnAuthorityDescriptor";
    private static final String ATTRIBUTE_AUTHORITY_DESCRIPTOR_SELECTOR = "md:AttributeAuthorityDescriptor";
    private static final String PDP_DESCRIPTOR_SELECTOR = "md:PDPDescriptor";
    private static final String ORGANIZATION_SELECTOR = "md:Organization";
    private static final String ORGANIZATION_NAME_SELECTOR = "md:OrganizationName";
    private static final String ORGANIZATION_DISPLAY_NAME_SELECTOR = "md:OrganizationDisplayName";
    private static final String ORGANIZATION_URL_SELECTOR = "md:OrganizationURL";
    private static final String CONTACT_PERSON_SELECTOR = "md:ContactPerson";
    private static final String COMPANY_SELECTOR = "md:Company";
    private static final String GIVEN_NAME_SELECTOR = "md:GivenName";
    private static final String SURNAME_SELECTOR = "md:SurName";
    private static final String EMAIL_ADDRESS_SELECTOR = "md:EmailAddress";
    private static final String TELEPHONE_NUMBER_SELECTOR = "md:TelephoneNumber";
    private static final String NAMEID_FORMAT_SELECTOR = "md:NameIDFormat";
    private static final String KEYDESCRIPTOR_SELECTOR = "md:KeyDescriptor";
    private static final String KEYINFO_SELECTOR = "ds:KeyInfo";
    private static final String ENCRYPTION_METHOD_SELECTOR = "md:EncryptionMethod";
    private static final String KEYSIZE_SELECTOR = "xenc:KeySize";
    private static final String OAEP_PARAMS_SELECTOR = "xenc:OEAPparams";
    private static final String X509_DATA_SELECTOR = "ds:X509Data";
    private static final String X509_CERTIFICATE_SELECTOR = "ds:X509Certificate";
    private static final String SINGLE_LOGOUT_SERVICE_SELECTOR = "md:SingleLogoutService";
    private static final String ASSERTION_CONSUMER_SERVICE_SELECTOR = "md:AssertionConsumerService";
    private static final String ID_ATTR_SELECTOR = "./@ID";
    private static final String ENTITY_ID_ATTR_SELECTOR = "./@entityID";
    private static final String VALID_UNTIL_ATTR_SELECTOR = "./@validUntil";
    private static final String CACHEDURATION_ATTR_SELECTOR = "./@cacheDuration";
    private static final String AUTHN_REQUESTS_SIGNED_ATTR_SELECTOR = "./@AuthnRequestsSigned";
    private static final String WANT_ASSERTIONS_SIGNED_ATTR_SELECTOR = "./@WantAssertionsSigned";
    private static final String PROTOCOL_SUPPORT_ENUMERATION_ATTR_SELECTOR = "./@protocolSupportEnumeration";
    private static final String ERROR_URL_ATTR_SELECTOR = "./@errorURL";
    private static final String LANGUAGE_ATTR_SELECTOR = "./@xml:lang";
    private static final String CONTACT_TYPE_ATTR_SELECTOR = "./@contactType";
    private static final String USE_ATTR_SELECTOR = "./@use";
    private static final String ALGORITHM_ATTR_SELECTOR = "./@Algorithm";
    private static final String DSIG_ID_ATTR_SELECTOR = "./@Id";
    private static final String BINDING_ATTR_SELECTOR = "./@Binding";
    private static final String LOCATION_ATTR_SELECTOR = "./@Location";
    private static final String RESPONSE_LOCATION_ATTR_SELECTOR = "./@ResponseLocation";
    private static final String INDEX_ATTR_SELECTOR = "./@index";
    private static final String IS_DEFAULT_ATTR_SELECTOR = "./@isDefault";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final XPath newXPath() {
        Object object = xpathFactorysync;
        synchronized (object) {
            XPath xpath = XPathFactory.newInstance().newXPath();
            xpath.setNamespaceContext(new SAMLMetadataNamespaceContext());
            return xpath;
        }
    }

    public static boolean entityDescriptorIsDocumentRoot(XPath xpath, Document doc) throws XPathExpressionException {
        return xpath.evaluate(ENTITY_DESCRIPTOR_SELECTOR, doc, XPathConstants.NODE) != null;
    }

    public static Node entityDescriptorFromParentNode(XPath xpath, Node parent) throws XPathExpressionException {
        return (Node)xpath.evaluate(ENTITY_DESCRIPTOR_SELECTOR, parent, XPathConstants.NODE);
    }

    public static NodeList entityDescriptorListFromParentNode(XPath xpath, Node parent) throws XPathExpressionException {
        return (NodeList)xpath.evaluate(ENTITY_DESCRIPTOR_SELECTOR, parent, XPathConstants.NODESET);
    }

    public static Node entitiesDescriptorFromParentNode(XPath xpath, Node parent) throws XPathExpressionException {
        return (Node)xpath.evaluate(ENTITIES_DESCRIPTOR_SELECTOR, parent, XPathConstants.NODE);
    }

    public static NodeList entitiesDescriptorListFromParentNode(XPath xpath, Node parent) throws XPathExpressionException {
        return (NodeList)xpath.evaluate(ENTITIES_DESCRIPTOR_SELECTOR, parent, XPathConstants.NODESET);
    }

    public static Node keyDescriptorFromParentNode(XPath xpath, Node parent) throws XPathExpressionException {
        return (Node)xpath.evaluate(KEYDESCRIPTOR_SELECTOR, parent, XPathConstants.NODE);
    }

    public static NodeList roleDescriptorFromParentNode(RoleDescriptorNodeType nodetype, XPath xpath, Node parent) throws XPathExpressionException {
        NodeList ret = null;
        switch (nodetype) {
            case ROLE_DESCRIPTOR_NODE: {
                ret = (NodeList)xpath.evaluate(ROLE_DESCRIPTOR_SELECTOR, parent, XPathConstants.NODESET);
                break;
            }
            case IDPSSO_DESCRIPTOR_NODE: {
                ret = (NodeList)xpath.evaluate(IDPSSO_DESCRIPTOR_SELECTOR, parent, XPathConstants.NODESET);
                break;
            }
            case SPSSO_DESCRIPTOR_NODE: {
                ret = (NodeList)xpath.evaluate(SPSSO_DESCRIPTOR_SELECTOR, parent, XPathConstants.NODESET);
                break;
            }
            case AUTHN_AUTHORITY_DESCRIPTOR_NODE: {
                ret = (NodeList)xpath.evaluate(AUTHN_AUTHORITY_DESCRIPTOR_SELECTOR, parent, XPathConstants.NODESET);
                break;
            }
            case ATTRIBUTE_AUTHORITY_DESCRIPTOR_NODE: {
                ret = (NodeList)xpath.evaluate(ATTRIBUTE_AUTHORITY_DESCRIPTOR_SELECTOR, parent, XPathConstants.NODESET);
                break;
            }
            case PDP_DESCRIPTOR_NODE: {
                ret = (NodeList)xpath.evaluate(PDP_DESCRIPTOR_SELECTOR, parent, XPathConstants.NODESET);
            }
        }
        return ret;
    }

    public static Node organizationFromParentNode(XPath xpath, Node parent) throws XPathExpressionException {
        return (Node)xpath.evaluate(ORGANIZATION_SELECTOR, parent, XPathConstants.NODE);
    }

    public static NodeList organizationNameListFromParentNode(XPath xpath, Node parent) throws XPathExpressionException {
        return (NodeList)xpath.evaluate(ORGANIZATION_NAME_SELECTOR, parent, XPathConstants.NODESET);
    }

    public static NodeList organizationDisplayNameListFromParentNode(XPath xpath, Node parent) throws XPathExpressionException {
        return (NodeList)xpath.evaluate(ORGANIZATION_DISPLAY_NAME_SELECTOR, parent, XPathConstants.NODESET);
    }

    public static NodeList organizationUrlListFromParentNode(XPath xpath, Node parent) throws XPathExpressionException {
        return (NodeList)xpath.evaluate(ORGANIZATION_URL_SELECTOR, parent, XPathConstants.NODESET);
    }

    public static NodeList contactPersonListFromParentNode(XPath xpath, Node parent) throws XPathExpressionException {
        return (NodeList)xpath.evaluate(CONTACT_PERSON_SELECTOR, parent, XPathConstants.NODESET);
    }

    public static String companyValueFromParentNode(XPath xpath, Node parent) throws XPathExpressionException {
        Node node = (Node)xpath.evaluate(COMPANY_SELECTOR, parent, XPathConstants.NODE);
        if (node == null) {
            return null;
        }
        return XPathUtils.nodeValueAsString(node);
    }

    public static String givenNameValueFromParentNode(XPath xpath, Node parent) throws XPathExpressionException {
        Node node = (Node)xpath.evaluate(GIVEN_NAME_SELECTOR, parent, XPathConstants.NODE);
        if (node == null) {
            return null;
        }
        return XPathUtils.nodeValueAsString(node);
    }

    public static String surnameValueFromParentNode(XPath xpath, Node parent) throws XPathExpressionException {
        Node node = (Node)xpath.evaluate(SURNAME_SELECTOR, parent, XPathConstants.NODE);
        if (node == null) {
            return null;
        }
        return XPathUtils.nodeValueAsString(node);
    }

    public static List<String> emailAddressListFromParentNode(XPath xpath, Node parent) throws XPathExpressionException {
        NodeList nodes = (NodeList)xpath.evaluate(EMAIL_ADDRESS_SELECTOR, parent, XPathConstants.NODESET);
        return XPathUtils.nodesAsStringList(nodes);
    }

    public static List<String> telephoneNumberListFromParentNode(XPath xpath, Node parent) throws XPathExpressionException {
        NodeList nodes = (NodeList)xpath.evaluate(TELEPHONE_NUMBER_SELECTOR, parent, XPathConstants.NODESET);
        return XPathUtils.nodesAsStringList(nodes);
    }

    public static NodeList keyDescriptorListFromParentNode(XPath xpath, Node parent) throws XPathExpressionException {
        return (NodeList)xpath.evaluate(KEYDESCRIPTOR_SELECTOR, parent, XPathConstants.NODESET);
    }

    public static Node keyInfoFromParentNode(XPath xpath, Node parent) throws XPathExpressionException {
        return (Node)xpath.evaluate(KEYINFO_SELECTOR, parent, XPathConstants.NODE);
    }

    public static NodeList encryptionMethodListFromParentNode(XPath xpath, Node parent) throws XPathExpressionException {
        return (NodeList)xpath.evaluate(ENCRYPTION_METHOD_SELECTOR, parent, XPathConstants.NODESET);
    }

    public static Integer keySizeFromParentNode(XPath xpath, Node parent) throws XPathExpressionException {
        Node node = (Node)xpath.evaluate(KEYSIZE_SELECTOR, parent, XPathConstants.NODE);
        if (node == null) {
            return null;
        }
        return XPathUtils.nodeValueAsInt(node);
    }

    public static NodeList x509DataListFromParentNode(XPath xpath, Node parent) throws XPathExpressionException {
        return (NodeList)xpath.evaluate(X509_DATA_SELECTOR, parent, XPathConstants.NODESET);
    }

    public static String oaepParamsFromParentNode(XPath xpath, Node parent) throws XPathExpressionException {
        Node node = (Node)xpath.evaluate(OAEP_PARAMS_SELECTOR, parent, XPathConstants.NODE);
        if (node == null) {
            return null;
        }
        return XPathUtils.nodeValueAsString(node);
    }

    public static List<String> x509CertificatesFromParentNode(XPath xpath, Node parent) throws XPathExpressionException {
        NodeList nodes = (NodeList)xpath.evaluate(X509_CERTIFICATE_SELECTOR, parent, XPathConstants.NODESET);
        return XPathUtils.nodesAsStringList(nodes);
    }

    public static List<String> nameIDFormatListFromParentNode(XPath xpath, Node parent) throws XPathExpressionException {
        NodeList nodes = (NodeList)xpath.evaluate(NAMEID_FORMAT_SELECTOR, parent, XPathConstants.NODESET);
        return XPathUtils.nodesAsStringList(nodes);
    }

    public static NodeList singleLogoutServiceListFromParentNode(XPath xpath, Node parent) throws XPathExpressionException {
        return (NodeList)xpath.evaluate(SINGLE_LOGOUT_SERVICE_SELECTOR, parent, XPathConstants.NODESET);
    }

    public static NodeList assertionConsumerServiceListFromParentNode(XPath xpath, Node parent) throws XPathExpressionException {
        return (NodeList)xpath.evaluate(ASSERTION_CONSUMER_SERVICE_SELECTOR, parent, XPathConstants.NODESET);
    }

    public static String idAttributeValue(XPath xpath, Node node) throws XPathExpressionException {
        return XPathUtils.stringAttributeValue(xpath, ID_ATTR_SELECTOR, node);
    }

    public static String entityIDAttributeValue(XPath xpath, Node node) throws XPathExpressionException {
        return XPathUtils.stringAttributeValue(xpath, ENTITY_ID_ATTR_SELECTOR, node);
    }

    public static Duration cacheDurationAttributeValue(XPath xpath, Node node) throws XPathExpressionException {
        return XPathUtils.durationAttributeValue(xpath, CACHEDURATION_ATTR_SELECTOR, node);
    }

    public static Date validUntilAttributeValue(XPath xpath, Node node) throws XPathExpressionException {
        return XPathUtils.dateAttributeValue(xpath, VALID_UNTIL_ATTR_SELECTOR, node);
    }

    public static Boolean authnRequestsSignedAttributeValue(XPath xpath, Node node) throws XPathExpressionException {
        return XPathUtils.booleanAttributeValue(xpath, AUTHN_REQUESTS_SIGNED_ATTR_SELECTOR, node);
    }

    public static Boolean wantAssertionsSignedAttributeValue(XPath xpath, Node node) throws XPathExpressionException {
        return XPathUtils.booleanAttributeValue(xpath, WANT_ASSERTIONS_SIGNED_ATTR_SELECTOR, node);
    }

    public static String protocolSupportEnumerationAttributeValue(XPath xpath, Node node) throws XPathExpressionException {
        return XPathUtils.stringAttributeValue(xpath, PROTOCOL_SUPPORT_ENUMERATION_ATTR_SELECTOR, node);
    }

    public static String errorUrlAttributeValue(XPath xpath, Node node) throws XPathExpressionException {
        return XPathUtils.stringAttributeValue(xpath, ERROR_URL_ATTR_SELECTOR, node);
    }

    public static String languageAttributeValue(XPath xpath, Node node) throws XPathExpressionException {
        return XPathUtils.stringAttributeValue(xpath, LANGUAGE_ATTR_SELECTOR, node);
    }

    public static String contactTypeAttributeValue(XPath xpath, Node node) throws XPathExpressionException {
        return XPathUtils.stringAttributeValue(xpath, CONTACT_TYPE_ATTR_SELECTOR, node);
    }

    public static String useAttributeValue(XPath xpath, Node node) throws XPathExpressionException {
        return XPathUtils.stringAttributeValue(xpath, USE_ATTR_SELECTOR, node);
    }

    public static String algorithmAttributeValue(XPath xpath, Node node) throws XPathExpressionException {
        return XPathUtils.stringAttributeValue(xpath, ALGORITHM_ATTR_SELECTOR, node);
    }

    public static String dsigIdAttributeValue(XPath xpath, Node node) throws XPathExpressionException {
        return XPathUtils.stringAttributeValue(xpath, DSIG_ID_ATTR_SELECTOR, node);
    }

    public static String bindingAttributeValue(XPath xpath, Node node) throws XPathExpressionException {
        return XPathUtils.stringAttributeValue(xpath, BINDING_ATTR_SELECTOR, node);
    }

    public static String locationAttributeValue(XPath xpath, Node node) throws XPathExpressionException {
        return XPathUtils.stringAttributeValue(xpath, LOCATION_ATTR_SELECTOR, node);
    }

    public static String responseLocationAttributeValue(XPath xpath, Node node) throws XPathExpressionException {
        return XPathUtils.stringAttributeValue(xpath, RESPONSE_LOCATION_ATTR_SELECTOR, node);
    }

    public static Integer indexAttributeValue(XPath xpath, Node node) throws XPathExpressionException {
        return XPathUtils.intAttributeValue(xpath, INDEX_ATTR_SELECTOR, node);
    }

    public static Boolean isDefaultAttributeValue(XPath xpath, Node node) throws XPathExpressionException {
        return XPathUtils.booleanAttributeValue(xpath, IS_DEFAULT_ATTR_SELECTOR, node);
    }

    private static String stringAttributeValue(XPath xpath, String selector, Node node) throws XPathExpressionException {
        Node attrnode = (Node)xpath.evaluate(selector, node, XPathConstants.NODE);
        if (attrnode == null) {
            return null;
        }
        return attrnode.getNodeValue();
    }

    private static Date dateAttributeValue(XPath xpath, String selector, Node node) throws XPathExpressionException {
        try {
            String strvalue = XPathUtils.stringAttributeValue(xpath, selector, node);
            if (strvalue == null) {
                return null;
            }
            DateFormat df = XPathUtils.createDateTimeFormat();
            return df.parse(strvalue);
        }
        catch (ParseException e) {
            return null;
        }
    }

    private static Duration durationAttributeValue(XPath xpath, String selector, Node node) throws XPathExpressionException {
        try {
            String strvalue = XPathUtils.stringAttributeValue(xpath, selector, node);
            if (strvalue == null) {
                return null;
            }
            return Duration.parse(strvalue);
        }
        catch (DateTimeParseException e) {
            return null;
        }
    }

    public static Boolean booleanAttributeValue(XPath xpath, String selector, Node node) throws XPathExpressionException {
        String strvalue = XPathUtils.stringAttributeValue(xpath, selector, node);
        if (strvalue == null) {
            return false;
        }
        return Boolean.parseBoolean(strvalue);
    }

    public static Integer intAttributeValue(XPath xpath, String selector, Node node) throws XPathExpressionException {
        String strvalue = XPathUtils.stringAttributeValue(xpath, selector, node);
        if (strvalue == null) {
            return null;
        }
        return Integer.parseInt(strvalue);
    }

    private static DateFormat createDateTimeFormat() {
        return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'"){

            @Override
            public Date parse(String source, ParsePosition pos) {
                return super.parse(source.replaceFirst(":(?=[0-9]{2}$)", ""), pos);
            }
        };
    }

    private static String nodeValueAsString(Node node) {
        return node.getTextContent();
    }

    private static List<String> nodesAsStringList(NodeList nodes) {
        ArrayList<String> ret = new ArrayList<String>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            ret.add(XPathUtils.nodeValueAsString(nodes.item(i)));
        }
        return ret;
    }

    private static Integer nodeValueAsInt(Node node) {
        return Integer.parseInt(node.getNodeValue());
    }

    public static enum RoleDescriptorNodeType {
        ROLE_DESCRIPTOR_NODE,
        IDPSSO_DESCRIPTOR_NODE,
        SPSSO_DESCRIPTOR_NODE,
        AUTHN_AUTHORITY_DESCRIPTOR_NODE,
        ATTRIBUTE_AUTHORITY_DESCRIPTOR_NODE,
        PDP_DESCRIPTOR_NODE;

    }
}

