/*
 * Decompiled with CFR 0.152.
 */
package io.jans.kc.api.admin.client;

import io.jans.kc.api.admin.client.AdminClientApiError;
import io.jans.kc.api.admin.client.KeycloakConfiguration;
import io.jans.kc.api.admin.client.KeycloakConfigurationError;
import io.jans.kc.api.admin.client.model.ManagedSamlClient;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.engines.ApacheHttpClient43Engine;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.KeycloakBuilder;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.ClientsResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.representations.idm.ClientRepresentation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminClientApi {
    private static final Integer DEFAULT_CONNPOOL_SIZE = 5;
    private static final Integer DEFAULT_MAX_CONN_PER_ROUTE = 100;
    private static final String SAML_PROTOCOL = "saml";
    private static final Pattern CLIENT_NAME_REGEX = Pattern.compile("^jans_saml_([a-zA-Z0-9\\-]+)$");
    private static final Logger log = LoggerFactory.getLogger(AdminClientApi.class);
    private Keycloak keycloak;

    private AdminClientApi(Keycloak keycloak) {
        this.keycloak = keycloak;
    }

    public List<ManagedSamlClient> findAllManagedSamlClients(String realmname) {
        try {
            RealmResource realmresource = this.realmByName(realmname);
            ClientsResource clientsresource = realmresource.clients();
            List clientsrep = clientsresource.findAll();
            log.debug("Clients from realm count : {}", (Object)clientsrep.size());
            return clientsrep.stream().filter(AdminClientApi::isManagedClientRepresentation).map(AdminClientApi::toManagedSamlClient).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new AdminClientApiError("Could not get managed clients", e);
        }
    }

    public void deleteManagedSamlClient(String realmname, ManagedSamlClient client) {
        try {
            RealmResource realmresource = this.realmByName(realmname);
            ClientsResource clientsresource = realmresource.clients();
            ClientResource clientresource = clientsresource.get(client.keycloakId());
            if (clientresource != null) {
                clientresource.remove();
            }
        }
        catch (Exception e) {
            throw new AdminClientApiError("Could not delete managed client", e);
        }
    }

    private RealmResource realmByName(String realmname) {
        return this.keycloak.realm(realmname);
    }

    public static final AdminClientApi createInstance(KeycloakConfiguration kcConfig) {
        try {
            Keycloak kc = AdminClientApi.createKeycloakInstance(kcConfig);
            kc.serverInfo().getInfo();
            return new AdminClientApi(kc);
        }
        catch (IllegalStateException e) {
            throw new KeycloakConfigurationError("Could not create keycloak instance", e);
        }
    }

    private static final Keycloak createKeycloakInstance(KeycloakConfiguration kcConfig) throws IllegalStateException {
        return KeycloakBuilder.builder().serverUrl(kcConfig.serverUrl()).realm(kcConfig.realm()).username(kcConfig.username()).password(kcConfig.password()).clientId(kcConfig.clientId()).grantType("password").resteasyClient(AdminClientApi.createResteasyClient(kcConfig)).build();
    }

    private static final Client createResteasyClient(KeycloakConfiguration kcConfig) {
        Integer effectivecpsize = DEFAULT_CONNPOOL_SIZE;
        effectivecpsize = kcConfig.connPoolSize() == null || kcConfig.connPoolSize() == 0 ? DEFAULT_CONNPOOL_SIZE : kcConfig.connPoolSize();
        PoolingHttpClientConnectionManager connmgr = new PoolingHttpClientConnectionManager();
        CloseableHttpClient httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connmgr).build();
        connmgr.setMaxTotal(effectivecpsize.intValue());
        connmgr.setDefaultMaxPerRoute(DEFAULT_MAX_CONN_PER_ROUTE.intValue());
        ApacheHttpClient43Engine engine = new ApacheHttpClient43Engine((HttpClient)httpClient);
        return ((ResteasyClientBuilder)ClientBuilder.newBuilder()).httpEngine((ClientHttpEngine)engine).build();
    }

    private static boolean isManagedClientRepresentation(ClientRepresentation client) {
        log.debug("Protocol: {} / Name: {}", (Object)client.getProtocol(), (Object)client.getName());
        if (!SAML_PROTOCOL.equalsIgnoreCase(client.getProtocol())) {
            log.debug("Protocol does not match");
            return false;
        }
        Matcher matcher = CLIENT_NAME_REGEX.matcher(client.getName());
        boolean res = matcher.matches();
        log.debug("Matches: {}", (Object)res);
        return res;
    }

    private static ManagedSamlClient toManagedSamlClient(ClientRepresentation client) {
        Matcher matcher = CLIENT_NAME_REGEX.matcher(client.getName());
        if (matcher.matches()) {
            return new ManagedSamlClient(client, matcher.group(1));
        }
        return null;
    }
}

