/*
 * Decompiled with CFR 0.152.
 */
package io.jans.kc.api.config.client.model;

import io.jans.config.api.client.model.SAMLMetadata;
import io.jans.config.api.client.model.TrustRelationship;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JansTrustRelationship {
    private static final Pattern ATTRIBUTE_DN_PATTERN = Pattern.compile("^inum=([A-F0-9]+),ou=attributes,o=jans$");
    private TrustRelationship tr;

    public JansTrustRelationship(TrustRelationship tr) {
        this.tr = tr;
    }

    public String getInum() {
        return this.tr.getInum();
    }

    public boolean metadataIsFile() {
        return this.tr.getSpMetaDataSourceType() == TrustRelationship.SpMetaDataSourceTypeEnum.FILE;
    }

    public boolean metadataIsManual() {
        return this.tr.getSpMetaDataSourceType() == TrustRelationship.SpMetaDataSourceTypeEnum.MANUAL;
    }

    public SAMLMetadata getManualSamlMetadata() {
        return this.tr.getSamlMetadata();
    }

    public List<String> getReleasedAttributesInums() {
        ArrayList<String> ret = new ArrayList<String>();
        for (String attributedn : this.tr.getReleasedAttributes()) {
            Matcher matcher = ATTRIBUTE_DN_PATTERN.matcher(attributedn);
            if (!matcher.matches()) continue;
            try {
                ret.add(matcher.group(1));
            }
            catch (IllegalStateException | IndexOutOfBoundsException runtimeException) {}
        }
        return ret;
    }
}

