/*
 * Decompiled with CFR 0.152.
 */
package io.jans.kc.scheduler.job.impl;

import io.jans.kc.scheduler.job.JobScheduler;
import io.jans.kc.scheduler.job.JobSchedulerException;
import io.jans.kc.scheduler.job.RecurringJobSpec;
import io.jans.kc.scheduler.job.impl.QuartzJobWrapper;
import java.util.Properties;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.simpl.RAMJobStore;
import org.quartz.simpl.SimpleThreadPool;
import org.quartz.spi.JobStore;
import org.quartz.spi.ThreadPool;

public class QuartzJobScheduler
implements JobScheduler {
    private static final Integer DEFAULT_THREAD_POOL_SIZE = 3;
    private Scheduler quartzScheduler;

    private QuartzJobScheduler(Scheduler quartzScheduler) {
        this.quartzScheduler = quartzScheduler;
    }

    @Override
    public JobScheduler start() {
        try {
            this.quartzScheduler.start();
            return this;
        }
        catch (SchedulerException e) {
            throw new JobSchedulerException("Unable to start job scheduler", e);
        }
    }

    @Override
    public JobScheduler stop() {
        try {
            this.quartzScheduler.shutdown(true);
        }
        catch (SchedulerException e) {
            throw new JobSchedulerException("Unable to stop job scheduler", e);
        }
        return this;
    }

    @Override
    public JobScheduler scheduleRecurringJob(RecurringJobSpec spec) {
        try {
            Trigger trigger = this.createRecurringJobTrigger(spec);
            JobDetail jobdetail = JobBuilder.newJob(QuartzJobWrapper.class).withIdentity(spec.getName()).usingJobData("jans.job.name", spec.getName()).usingJobData("jans.job.class", spec.getJobClass().getName()).build();
            this.quartzScheduler.scheduleJob(jobdetail, trigger);
            return this;
        }
        catch (SchedulerException e) {
            throw new JobSchedulerException("Unable to schedule recurring job", e);
        }
    }

    private Trigger createRecurringJobTrigger(RecurringJobSpec spec) {
        Trigger trigger = null;
        int interval = Math.toIntExact(spec.schedulingInterval().toSeconds());
        int count = spec.repeatCount();
        if (spec.repeatForever()) {
            TriggerBuilder triggerBuilder = TriggerBuilder.newTrigger().withIdentity(this.recurringJobTriggerKey(spec));
            SimpleScheduleBuilder.simpleSchedule();
            trigger = triggerBuilder.withSchedule((ScheduleBuilder)SimpleScheduleBuilder.repeatSecondlyForever((int)interval)).startNow().build();
        } else {
            TriggerBuilder triggerBuilder = TriggerBuilder.newTrigger().withIdentity(this.recurringJobTriggerKey(spec));
            SimpleScheduleBuilder.simpleSchedule();
            trigger = triggerBuilder.withSchedule((ScheduleBuilder)SimpleScheduleBuilder.repeatSecondlyForTotalCount((int)count, (int)interval)).startNow().build();
        }
        return trigger;
    }

    private TriggerKey recurringJobTriggerKey(RecurringJobSpec spec) {
        String name = String.format("r_job_%s", spec.getName());
        String group = String.format("r_job_grp_%s", spec.getName());
        return TriggerKey.triggerKey((String)name, (String)group);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String name = null;
        private String instanceId = null;
        private Integer threadPoolSize = DEFAULT_THREAD_POOL_SIZE;

        private Builder() {
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public Builder threadPoolSize(Integer threadPoolSize) {
            this.threadPoolSize = threadPoolSize;
            return this;
        }

        public final QuartzJobScheduler build() {
            if (this.name == null || this.name.isEmpty()) {
                throw new JobSchedulerException("No scheduler name was specified");
            }
            if (this.instanceId == null || this.instanceId.isEmpty()) {
                throw new JobSchedulerException("No scheduler instanceId was specified");
            }
            if (this.threadPoolSize <= 0) {
                throw new JobSchedulerException("Invalid thread pool size specified (<= 0)");
            }
            try {
                StdSchedulerFactory schedulerfactory = new StdSchedulerFactory();
                schedulerfactory.initialize(this.schedulerProperties());
                Scheduler scheduler = schedulerfactory.getScheduler();
                return new QuartzJobScheduler(scheduler);
            }
            catch (SchedulerException e) {
                throw new JobSchedulerException("Could not create quartz scheduler", e);
            }
        }

        private JobStore createJobStore() {
            return new RAMJobStore();
        }

        private ThreadPool createThreadPool() {
            return new SimpleThreadPool(this.threadPoolSize.intValue(), 5);
        }

        private Properties schedulerProperties() {
            Properties props = new Properties();
            props.setProperty("org.quartz.scheduler.instanceName", this.name);
            props.setProperty("org.quartz.scheduler.instanceId", this.instanceId);
            props.setProperty("org.quartz.scheduler.threadsInheritContextClassLoaderOfInitializer", "true");
            props.setProperty("org.quartz.threadPool.class", SimpleThreadPool.class.getName());
            props.setProperty("org.quartz.threadPool.threadCount", Integer.toString(this.threadPoolSize));
            props.setProperty("org.quartz.threadPool.threadPriority", Integer.toString(5));
            props.setProperty("org.quartz.threadPool.threadsInheritContextClassLoaderOfInitializingThread", "true");
            props.setProperty("org.quartz.jobStore.class", "org.quartz.simpl.RAMJobStore");
            return props;
        }
    }
}

