/*
 * Decompiled with CFR 0.152.
 */
package io.jans.service.logger;

import io.jans.model.types.LoggingLayoutType;
import io.jans.service.cdi.async.Asynchronous;
import io.jans.service.cdi.event.ConfigurationUpdate;
import io.jans.service.cdi.event.LoggerUpdateEvent;
import io.jans.service.cdi.event.Scheduled;
import io.jans.service.timer.event.TimerEvent;
import io.jans.service.timer.schedule.TimerSchedule;
import io.jans.util.StringHelper;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.event.Observes;
import jakarta.inject.Inject;
import java.io.File;
import java.lang.annotation.Annotation;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.LogManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LoggerContext;
import org.slf4j.Logger;

public abstract class LoggerService {
    private static final int DEFAULT_INTERVAL = 15;
    @Inject
    private Logger log;
    @Inject
    private Event<TimerEvent> timerEvent;
    private Level prevLogLevel;
    private AtomicBoolean isActive;

    @PostConstruct
    public void create() {
        this.isActive = new AtomicBoolean(false);
    }

    public void initTimer() {
        this.initTimer(false);
    }

    public void initTimer(boolean updateNow) {
        this.log.info("Initializing Logger Update Timer");
        int delay = 15;
        int interval = 15;
        this.prevLogLevel = this.getCurrentLogLevel();
        this.timerEvent.fire((Object)new TimerEvent(new TimerSchedule(15, 15), (Object)new LoggerUpdateEvent(), new Annotation[]{Scheduled.Literal.INSTANCE}));
        if (updateNow) {
            this.updateLoggerTimerEvent(null);
        }
    }

    @Asynchronous
    public void updateLoggerTimerEvent(@Observes @Scheduled LoggerUpdateEvent loggerUpdateEvent) {
        if (this.isActive.get()) {
            return;
        }
        if (!this.isActive.compareAndSet(false, true)) {
            return;
        }
        try {
            this.updateLoggerConfiguration();
            this.prevLogLevel = this.getCurrentLogLevel();
        }
        catch (Throwable ex) {
            this.log.error("Exception happened while updating newly added logger configuration", ex);
        }
        finally {
            this.isActive.set(false);
        }
    }

    private void updateLoggerConfiguration() {
        String loggingLevel = this.getLoggingLevel();
        if (StringHelper.isEmpty((String)loggingLevel) || StringUtils.isEmpty((CharSequence)this.getLoggingLayout()) || StringHelper.equalsIgnoreCase((String)"DEFAULT", (String)loggingLevel)) {
            return;
        }
        Level level = Level.toLevel((String)loggingLevel, (Level)Level.INFO);
        LoggingLayoutType loggingLayout = LoggingLayoutType.getByValue((String)this.getLoggingLayout().toUpperCase());
        this.updateAppendersAndLogLevel(loggingLayout, this.prevLogLevel, level);
    }

    public void updateLoggerSeverity(@Observes @ConfigurationUpdate Object appConfiguration) {
        if (this.isActive.get()) {
            return;
        }
        if (!this.isActive.compareAndSet(false, true)) {
            return;
        }
        try {
            this.updateLoggerSeverityImpl();
        }
        catch (Throwable ex) {
            this.log.error("Exception happened while updating logger configuration after base configuration update", ex);
        }
        finally {
            this.isActive.set(false);
        }
    }

    public void updateLoggerSeverity() {
        this.updateLoggerSeverityImpl();
    }

    private void updateLoggerSeverityImpl() {
        this.setDisableJdkLogger();
        if (this.setExternalLoggerConfig()) {
            return;
        }
        this.resetLoggerConfigLocation();
        String loggingLevel = this.getLoggingLevel();
        if (StringHelper.isEmpty((String)loggingLevel) || StringUtils.isEmpty((CharSequence)this.getLoggingLayout()) || StringHelper.equalsIgnoreCase((String)"DEFAULT", (String)loggingLevel)) {
            return;
        }
        Level level = Level.toLevel((String)loggingLevel, (Level)Level.INFO);
        LoggingLayoutType loggingLayout = LoggingLayoutType.getByValue((String)this.getLoggingLayout().toUpperCase());
        this.log.info("Setting layout and loggers level to '{}`, `{}' after configuration update", (Object)loggingLayout, (Object)loggingLevel);
        this.updateAppendersAndLogLevel(loggingLayout, this.prevLogLevel, level);
    }

    private void setDisableJdkLogger() {
        if (this.isDisableJdkLogger()) {
            LogManager.getLogManager().reset();
            java.util.logging.Logger globalLogger = java.util.logging.Logger.getLogger("global");
            if (globalLogger != null) {
                globalLogger.setLevel(java.util.logging.Level.OFF);
            }
        }
    }

    private boolean setExternalLoggerConfig() {
        String externalLoggerConfiguration = this.getExternalLoggerConfiguration();
        this.log.info("External log configuration: {}", (Object)externalLoggerConfiguration);
        if (StringUtils.isEmpty((CharSequence)externalLoggerConfiguration)) {
            return false;
        }
        File log4jFile = new File(externalLoggerConfiguration);
        if (!log4jFile.exists()) {
            this.log.info("External log configuration does not exist.");
            return false;
        }
        LoggerContext loggerContext = LoggerContext.getContext((boolean)false);
        loggerContext.setConfigLocation(log4jFile.toURI());
        loggerContext.reconfigure();
        return true;
    }

    public void resetLoggerConfigLocation() {
        this.log.info("Reloading log4j2 configuration");
        LoggerContext loggerContext = LoggerContext.getContext((boolean)false);
        if (loggerContext.getConfigLocation() != null) {
            loggerContext.setConfigLocation(null);
        }
        loggerContext.reconfigure();
    }

    private void updateAppendersAndLogLevel(LoggingLayoutType loggingLayout, Level prevLevel, Level newLevel) {
        if (loggingLayout == LoggingLayoutType.TEXT) {
            if (newLevel != prevLevel) {
                LoggerContext ctx = LoggerContext.getContext((boolean)false);
                ctx.getConfiguration().getRootLogger().setLevel(newLevel);
                ctx.reconfigure();
            }
            LoggerContext loggerContext = LoggerContext.getContext((boolean)false);
            int count = 0;
            for (org.apache.logging.log4j.core.Logger logger : loggerContext.getLoggers()) {
                String loggerName = logger.getName();
                if (!loggerName.startsWith("io.jans") || logger.getLevel() == newLevel) continue;
                ++count;
                logger.setLevel(newLevel);
            }
            if (count > 0) {
                this.log.info("Updated log level of '{}' loggers to {}", (Object)count, (Object)newLevel.toString());
            }
        }
    }

    private Level getCurrentLogLevel() {
        String loggingLevel = this.getLoggingLevel();
        if (StringHelper.isEmpty((String)loggingLevel) || StringUtils.isEmpty((CharSequence)this.getLoggingLayout()) || StringHelper.equalsIgnoreCase((String)"DEFAULT", (String)loggingLevel)) {
            return Level.INFO;
        }
        Level level = Level.toLevel((String)loggingLevel, (Level)Level.INFO);
        return level;
    }

    public abstract boolean isDisableJdkLogger();

    public abstract String getLoggingLevel();

    public abstract String getExternalLoggerConfiguration();

    public abstract String getLoggingLayout();
}

