/*
 * Decompiled with CFR 0.152.
 */
package io.jans.service.custom.script;

import io.jans.exception.PythonException;
import io.jans.model.ProgrammingLanguage;
import io.jans.model.SimpleCustomProperty;
import io.jans.model.custom.script.CustomScriptType;
import io.jans.model.custom.script.model.CustomScript;
import io.jans.model.custom.script.model.ScriptError;
import io.jans.model.custom.script.type.BaseExternalType;
import io.jans.service.PythonService;
import io.jans.service.custom.script.AbstractCustomScriptService;
import io.jans.service.custom.script.jit.SimpleJavaCompiler;
import io.jans.util.StringHelper;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.python.core.PyLong;
import org.python.core.PyObject;
import org.slf4j.Logger;

@ApplicationScoped
public class ExternalTypeCreator {
    @Inject
    protected Logger log;
    @Inject
    protected PythonService pythonService;
    @Inject
    protected AbstractCustomScriptService customScriptService;

    public BaseExternalType createExternalType(CustomScript customScript, Map<String, SimpleCustomProperty> configurationAttributes) {
        String customScriptInum = customScript.getInum();
        BaseExternalType externalType = null;
        Throwable loadException = null;
        try {
            externalType = customScript.getProgrammingLanguage() == ProgrammingLanguage.JAVA ? this.createExternalTypeWithJava(customScript) : this.createExternalTypeFromStringWithPythonException(customScript);
        }
        catch (Throwable ex) {
            loadException = ex;
            this.log.error("Failed to prepare external type '{}', exception: '{}'", (Object)customScriptInum, (Object)ExceptionUtils.getStackTrace((Throwable)ex));
            this.log.error("Script '{}'", (Object)customScript.getScript());
            this.log.error("Classpath '{}'", (Object)SimpleJavaCompiler.getClasspath());
        }
        externalType = this.initExternalType(externalType, customScript, configurationAttributes);
        if (externalType == null) {
            if (loadException == null) {
                loadException = new Exception("Using default external type class");
            }
            this.log.debug("Using default external type class");
            this.saveScriptError(customScript, loadException, true);
            externalType = customScript.getScriptType().getDefaultImplementation();
        } else {
            this.clearScriptError(customScript);
        }
        return externalType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BaseExternalType initExternalType(BaseExternalType externalType, CustomScript customScript, Map<String, SimpleCustomProperty> configurationAttributes) {
        if (externalType == null) {
            return null;
        }
        boolean initialized = false;
        try {
            ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            try {
                if (externalType.getApiVersion() > 10) {
                    initialized = externalType.init(customScript, configurationAttributes);
                } else {
                    initialized = externalType.init(configurationAttributes);
                    this.log.warn(" Update the script's init method to init(self, customScript, configurationAttributes), script name: {}", (Object)customScript.getName());
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldClassLoader);
            }
        }
        catch (Exception ex) {
            this.log.error("Failed to initialize custom script: '{}', exception: {}", (Object)customScript.getName(), (Object)ex);
        }
        if (initialized) {
            return externalType;
        }
        return null;
    }

    private BaseExternalType createExternalTypeWithJava(CustomScript customScript) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Class<BaseExternalType> aClass = SimpleJavaCompiler.compile(BaseExternalType.class, customScript.getScript());
        return aClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public BaseExternalType createExternalTypeFromStringWithPythonException(CustomScript customScript) throws PythonException, IOException {
        String script = customScript.getScript();
        String scriptName = StringHelper.toLowerCase((String)customScript.getName()) + ".py";
        if (script == null) {
            return null;
        }
        CustomScriptType customScriptType = customScript.getScriptType();
        try (ByteArrayInputStream bis = new ByteArrayInputStream(script.getBytes(StandardCharsets.UTF_8));){
            BaseExternalType baseExternalType = this.pythonService.loadPythonScript(bis, scriptName, customScriptType.getClassName(), customScriptType.getCustomScriptType(), new PyObject[]{new PyLong(System.currentTimeMillis())});
            return baseExternalType;
        }
    }

    public void saveScriptError(CustomScript customScript, Throwable exception) {
        this.saveScriptError(customScript, exception, false);
    }

    public void saveScriptError(CustomScript customScript, Throwable exception, boolean overwrite) {
        try {
            this.saveScriptErrorImpl(customScript, exception, overwrite);
        }
        catch (Exception ex) {
            this.log.error("Failed to store script '{}' error", (Object)customScript.getInum(), (Object)ex);
        }
    }

    protected void saveScriptErrorImpl(CustomScript customScript, Throwable exception, boolean overwrite) {
        String customScriptDn = customScript.getDn();
        Class<? extends CustomScript> scriptType = customScript.getScriptType().getCustomScriptModel();
        CustomScript loadedCustomScript = this.customScriptService.getCustomScriptByDn(scriptType, customScriptDn);
        ScriptError currError = loadedCustomScript.getScriptError();
        if (!overwrite && currError != null) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(ExceptionUtils.getStackTrace((Throwable)exception));
        String message = exception.getMessage();
        if (message != null && !StringUtils.isEmpty((CharSequence)message)) {
            builder.append("\n==================Further details============================\n");
            builder.append(message);
        }
        loadedCustomScript.setScriptError(new ScriptError(new Date(), builder.toString()));
        this.customScriptService.update(loadedCustomScript);
    }

    public void clearScriptError(CustomScript customScript) {
        try {
            this.clearScriptErrorImpl(customScript);
        }
        catch (Exception ex) {
            this.log.error("Failed to clear script '{}' error", (Object)customScript.getInum(), (Object)ex);
        }
    }

    protected void clearScriptErrorImpl(CustomScript customScript) {
        String customScriptDn = customScript.getDn();
        Class<? extends CustomScript> scriptType = customScript.getScriptType().getCustomScriptModel();
        CustomScript loadedCustomScript = this.customScriptService.getCustomScriptByDn(scriptType, customScriptDn);
        ScriptError currError = loadedCustomScript.getScriptError();
        if (currError == null) {
            return;
        }
        loadedCustomScript.setScriptError(null);
        this.customScriptService.update(loadedCustomScript);
    }
}

