/*
 * Decompiled with CFR 0.152.
 */
package io.jans.util.process;

import io.jans.util.StringHelper;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecuteResultHandler;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteResultHandler;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.PumpStreamHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProcessHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessHelper.class);
    private static final long PRINT_JOB_TIMEOUT = 100000L;

    private ProcessHelper() {
    }

    public static boolean executeProgram(String programPath, boolean executeInBackground, int successExitValue, OutputStream outputStream) {
        return ProcessHelper.executeProgram(programPath, null, executeInBackground, successExitValue, outputStream);
    }

    public static boolean executeProgram(String programPath, String workingDirectory, boolean executeInBackground, int successExitValue, OutputStream outputStream) {
        CommandLine commandLine = new CommandLine(programPath);
        return ProcessHelper.executeProgram(commandLine, workingDirectory, executeInBackground, successExitValue, outputStream);
    }

    public static boolean executeProgram(CommandLine commandLine, boolean executeInBackground, int successExitValue, OutputStream outputStream) {
        return ProcessHelper.executeProgram(commandLine, null, executeInBackground, successExitValue, outputStream);
    }

    public static boolean executeProgram(CommandLine commandLine, String workingDirectory, boolean executeInBackground, int successExitValue, OutputStream outputStream) {
        long printJobTimeout = 100000L;
        PumpStreamHandler streamHandler = null;
        if (outputStream != null) {
            streamHandler = new PumpStreamHandler(outputStream);
        }
        PrintResultHandler printResult = null;
        try {
            LOG.debug(String.format("Preparing to start process %s", commandLine.toString()));
            printResult = ProcessHelper.executeProgram(commandLine, workingDirectory, printJobTimeout, executeInBackground, successExitValue, (ExecuteStreamHandler)streamHandler);
            LOG.debug(String.format("Successfully start process %s", commandLine.toString()));
        }
        catch (Exception ex) {
            LOG.trace(String.format("Problem during starting process %s", commandLine.toString()), (Throwable)ex);
            ex.printStackTrace();
            return false;
        }
        LOG.debug(String.format("Waiting for the proces %s finish", commandLine.toString()));
        try {
            if (printResult == null) {
                return false;
            }
            printResult.waitFor();
        }
        catch (InterruptedException ex) {
            LOG.error(String.format("Problem during process execution %s", commandLine.toString()), (Throwable)ex);
        }
        LOG.debug(String.format("Process %s has finished", commandLine.toString()));
        return true;
    }

    public static PrintResultHandler executeProgram(CommandLine commandLine, long printJobTimeout, boolean printInBackground, int successExitValue, ExecuteStreamHandler streamHandler) throws IOException {
        return ProcessHelper.executeProgram(commandLine, null, printJobTimeout, printInBackground, successExitValue, streamHandler);
    }

    public static PrintResultHandler executeProgram(CommandLine commandLine, String workingDirectory, long printJobTimeout, boolean printInBackground, int successExitValue, ExecuteStreamHandler streamHandler) throws IOException {
        PrintResultHandler resultHandler;
        ExecuteWatchdog watchdog = null;
        DefaultExecutor executor = new DefaultExecutor();
        executor.setExitValue(successExitValue);
        if (StringHelper.isNotEmpty(workingDirectory)) {
            executor.setWorkingDirectory(new File(workingDirectory));
        }
        if (streamHandler != null) {
            executor.setStreamHandler(streamHandler);
        }
        if (printJobTimeout > 0L) {
            watchdog = new ExecuteWatchdog(printJobTimeout);
            executor.setWatchdog(watchdog);
        }
        if (printInBackground) {
            LOG.debug(String.format("Executing non-blocking process %s", commandLine.toString()));
            resultHandler = new PrintResultHandler(watchdog);
            executor.execute(commandLine, (ExecuteResultHandler)resultHandler);
        } else {
            LOG.debug(String.format("Executing blocking process %s", commandLine.toString()));
            successExitValue = executor.execute(commandLine);
            resultHandler = new PrintResultHandler(successExitValue);
        }
        return resultHandler;
    }

    private static class PrintResultHandler
    extends DefaultExecuteResultHandler {
        private ExecuteWatchdog watchdog;

        PrintResultHandler(ExecuteWatchdog watchdog) {
            this.watchdog = watchdog;
        }

        PrintResultHandler(int exitValue) {
            super.onProcessComplete(exitValue);
        }

        public void onProcessComplete(int exitValue) {
            super.onProcessComplete(exitValue);
            LOG.debug("The process successfully executed");
        }

        public void onProcessFailed(ExecuteException ex) {
            super.onProcessFailed(ex);
            if (this.watchdog != null && this.watchdog.killedProcess()) {
                LOG.debug("The process timed out");
            } else {
                LOG.debug("The process failed to do", (Throwable)ex);
            }
        }
    }
}

