/*
 * Decompiled with CFR 0.152.
 */
package io.jans.orm.service;

import io.jans.orm.PersistenceEntryManagerFactory;
import io.jans.orm.ldap.impl.LdapEntryManagerFactory;
import io.jans.orm.model.PersistenceConfiguration;
import io.jans.orm.service.BaseFactoryService;
import io.jans.orm.util.StringHelper;
import io.jans.orm.util.properties.FileConfiguration;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import java.io.File;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class PersistanceFactoryService
implements BaseFactoryService {
    public static String DB_PROPERTY_MYSQL_SIMPLE_JSON;
    public static List<String> ADDIONAL_ENV_DB_PROPERTIES;
    public static final String BASE_DIR;
    public static final String DIR;
    private static final String JANS_FILE_PATH;
    @Inject
    private Logger log;
    @Inject
    private Instance<PersistenceEntryManagerFactory> persistenceEntryManagerFactoryInstance;

    public PersistenceConfiguration loadPersistenceConfiguration() {
        return this.loadPersistenceConfiguration(null);
    }

    public PersistenceConfiguration loadPersistenceConfiguration(String applicationPropertiesFile) {
        PersistenceConfiguration currentPersistenceConfiguration = null;
        String jansFileName = this.determineJansConfigurationFileName(applicationPropertiesFile);
        if (jansFileName != null) {
            currentPersistenceConfiguration = this.createPersistenceConfiguration(jansFileName);
        }
        if (currentPersistenceConfiguration == null) {
            this.getLog().warn("Failed to load persistence configuration. Attempting to use LDAP layer");
            PersistenceEntryManagerFactory defaultEntryManagerFactory = this.getPersistenceEntryManagerFactory(LdapEntryManagerFactory.class);
            currentPersistenceConfiguration = this.createPersistenceConfiguration(defaultEntryManagerFactory.getPersistenceType(), LdapEntryManagerFactory.class, defaultEntryManagerFactory.getConfigurationFileNames(null));
        }
        return currentPersistenceConfiguration;
    }

    private PersistenceConfiguration createPersistenceConfiguration(String jansFileName) {
        try {
            FileConfiguration jansFileConf = new FileConfiguration(jansFileName);
            if (!jansFileConf.isLoaded()) {
                this.getLog().error("Unable to load configuration file '{}'", (Object)jansFileName);
                return null;
            }
            String persistenceType = jansFileConf.getString("persistence.type");
            PersistenceEntryManagerFactory persistenceEntryManagerFactory = this.getPersistenceEntryManagerFactory(persistenceType);
            if (persistenceEntryManagerFactory == null) {
                this.getLog().error("Unable to get Persistence Entry Manager Factory by type '{}'", (Object)persistenceType);
                return null;
            }
            Class<?> persistenceEntryManagerFactoryType = persistenceEntryManagerFactory.getClass();
            if (PersistenceEntryManagerFactory.class.isAssignableFrom(persistenceEntryManagerFactoryType.getSuperclass())) {
                persistenceEntryManagerFactoryType = persistenceEntryManagerFactoryType.getSuperclass();
            }
            Map persistenceFileNames = persistenceEntryManagerFactory.getConfigurationFileNames(null);
            PersistenceConfiguration persistenceConfiguration = this.createPersistenceConfiguration(persistenceType, persistenceEntryManagerFactoryType, persistenceFileNames);
            return persistenceConfiguration;
        }
        catch (Exception e) {
            this.getLog().error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private PersistenceConfiguration createPersistenceConfiguration(String persistenceType, Class<? extends PersistenceEntryManagerFactory> persistenceEntryManagerFactoryType, Map<String, String> persistenceFileNames) {
        if (persistenceFileNames == null) {
            this.getLog().error("Unable to get Persistence Entry Manager Factory by type '{}'", (Object)persistenceType);
            return null;
        }
        PropertiesConfiguration mergedPropertiesConfiguration = new PropertiesConfiguration();
        long mergedPersistenceFileLastModifiedTime = -1L;
        StringBuilder mergedPersistenceFileName = new StringBuilder();
        for (String prefix : persistenceFileNames.keySet()) {
            String persistenceFileName = persistenceFileNames.get(prefix);
            if (mergedPersistenceFileName.length() > 0) {
                mergedPersistenceFileName.append("!");
            }
            mergedPersistenceFileName.append(persistenceFileName);
            String persistenceFileNamePath = DIR + persistenceFileName;
            File persistenceFile = new File(persistenceFileNamePath);
            if (!persistenceFile.exists()) {
                this.getLog().error("Unable to load configuration file '{}'", (Object)persistenceFileNamePath);
                return null;
            }
            mergedPersistenceFileLastModifiedTime = Math.max(mergedPersistenceFileLastModifiedTime, persistenceFile.lastModified());
            FileConfiguration persistenceFileConf = new FileConfiguration(persistenceFileNamePath);
            if (!persistenceFileConf.isLoaded()) {
                this.getLog().error("Unable to load configuration file '{}'", (Object)persistenceFileNamePath);
                return null;
            }
            PropertiesConfiguration propertiesConfiguration = persistenceFileConf.getPropertiesConfiguration();
            this.replaceWithSystemValues(propertiesConfiguration, ADDIONAL_ENV_DB_PROPERTIES);
            this.replaceWithUpperCasedSystemValues(propertiesConfiguration);
            this.replaceWithJavaVariablesValues(propertiesConfiguration);
            this.appendPropertiesWithPrefix(mergedPropertiesConfiguration, propertiesConfiguration, prefix);
        }
        FileConfiguration mergedFileConfiguration = new FileConfiguration(mergedPersistenceFileName.toString(), mergedPropertiesConfiguration);
        PersistenceConfiguration persistenceConfiguration = new PersistenceConfiguration(mergedPersistenceFileName.toString(), mergedFileConfiguration, persistenceEntryManagerFactoryType, mergedPersistenceFileLastModifiedTime);
        return persistenceConfiguration;
    }

    private void replaceWithSystemValues(PropertiesConfiguration propertiesConfiguration, List<String> additionalKeys) {
        Iterator keys = propertiesConfiguration.getKeys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (System.getenv(key) == null) continue;
            propertiesConfiguration.setProperty(key, (Object)System.getenv(key));
        }
        if (additionalKeys != null) {
            for (String key : additionalKeys) {
                if (System.getenv(key) == null) continue;
                propertiesConfiguration.setProperty(key, (Object)System.getenv(key));
            }
        }
    }

    private void replaceWithUpperCasedSystemValues(PropertiesConfiguration propertiesConfiguration) {
        Iterator keys = propertiesConfiguration.getKeys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String envKey = key.toUpperCase().replaceAll("\\.", "\\_").replaceAll("\\-", "\\_");
            if (System.getenv(envKey) == null) continue;
            propertiesConfiguration.setProperty(key, (Object)System.getenv(envKey));
        }
    }

    private void replaceWithJavaVariablesValues(PropertiesConfiguration propertiesConfiguration) {
        Iterator keys = propertiesConfiguration.getKeys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (System.getProperty(key) == null) continue;
            propertiesConfiguration.setProperty(key, (Object)System.getProperty(key));
        }
    }

    private void appendPropertiesWithPrefix(PropertiesConfiguration mergedConfiguration, PropertiesConfiguration appendConfiguration, String prefix) {
        Iterator keys = appendConfiguration.getKeys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            Object value = appendConfiguration.getProperty(key);
            mergedConfiguration.setProperty(prefix + "#" + key, value);
        }
    }

    private String determineJansConfigurationFileName(String applicationPropertiesFile) {
        String applicationFilePath = DIR + applicationPropertiesFile;
        File applicationFile = new File(applicationFilePath);
        if (applicationFile.exists()) {
            return applicationFilePath;
        }
        File ldapFile = new File(JANS_FILE_PATH);
        if (ldapFile.exists()) {
            return JANS_FILE_PATH;
        }
        return null;
    }

    public PersistenceEntryManagerFactory getPersistenceEntryManagerFactory(PersistenceConfiguration persistenceConfiguration) {
        return this.getPersistenceEntryManagerFactory(persistenceConfiguration.getEntryManagerFactoryType());
    }

    public PersistenceEntryManagerFactory getPersistenceEntryManagerFactory(Class<? extends PersistenceEntryManagerFactory> persistenceEntryManagerFactoryClass) {
        PersistenceEntryManagerFactory persistenceEntryManagerFactory = (PersistenceEntryManagerFactory)this.persistenceEntryManagerFactoryInstance.select(persistenceEntryManagerFactoryClass, new Annotation[0]).get();
        return persistenceEntryManagerFactory;
    }

    public PersistenceEntryManagerFactory getPersistenceEntryManagerFactory(String persistenceType) {
        String basePersistenceType = this.getBasePersistenceType(persistenceType);
        for (PersistenceEntryManagerFactory currentPersistenceEntryManagerFactory : this.persistenceEntryManagerFactoryInstance) {
            this.log.debug("Found Persistence Entry Manager Factory with type '{}'", (Object)currentPersistenceEntryManagerFactory);
            if (!StringHelper.equalsIgnoreCase((String)currentPersistenceEntryManagerFactory.getPersistenceType(), (String)basePersistenceType)) continue;
            return currentPersistenceEntryManagerFactory;
        }
        return null;
    }

    public Logger getLog() {
        if (this.log == null) {
            this.log = LoggerFactory.getLogger(PersistanceFactoryService.class);
        }
        return this.log;
    }

    public String getBasePersistenceType(String persistenceType) {
        if (StringHelper.isEmpty((String)persistenceType) || !persistenceType.contains(".")) {
            return persistenceType;
        }
        int index = persistenceType.indexOf(".");
        return persistenceType.substring(0, index);
    }

    public String getPersistenceTypeAlias(String persistenceType) {
        if (StringHelper.isEmpty((String)persistenceType) || !persistenceType.contains(".")) {
            return null;
        }
        int index = persistenceType.indexOf(".");
        if (index < persistenceType.length() - 1) {
            return persistenceType.substring(index + 1);
        }
        return null;
    }

    static {
        BASE_DIR = System.getProperty("jans.base") != null ? System.getProperty("jans.base") : (System.getProperty("catalina.base") != null && System.getProperty("catalina.base.ignore") == null ? System.getProperty("catalina.base") : (System.getProperty("catalina.home") != null ? System.getProperty("catalina.home") : (System.getProperty("jboss.home.dir") != null ? System.getProperty("jboss.home.dir") : null)));
        DB_PROPERTY_MYSQL_SIMPLE_JSON = "mysql.simple-json";
        ADDIONAL_ENV_DB_PROPERTIES = Arrays.asList(DB_PROPERTY_MYSQL_SIMPLE_JSON);
        DIR = BASE_DIR + File.separator + "conf" + File.separator;
        JANS_FILE_PATH = DIR + "jans.properties";
    }
}

