/*
 * Decompiled with CFR 0.152.
 */
package io.jans.service.message.provider;

import io.jans.service.message.model.config.MessageConfiguration;
import io.jans.service.message.model.config.MessageProviderType;
import io.jans.service.message.provider.AbstractMessageProvider;
import io.jans.service.message.provider.MessageProvider;
import io.jans.service.message.provider.NullMessageProvider;
import io.jans.service.message.provider.PostgresMessageProvider;
import io.jans.service.message.provider.RedisMessageProvider;
import io.jans.util.security.StringEncrypter;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandaloneMessageProviderFactory {
    private static final Logger LOG = LoggerFactory.getLogger(StandaloneMessageProviderFactory.class);
    private StringEncrypter stringEncrypter;
    private ExecutorService executorService;

    public StandaloneMessageProviderFactory(ExecutorService executorService, StringEncrypter stringEncrypter) {
        this.executorService = executorService;
        this.stringEncrypter = stringEncrypter;
    }

    public StandaloneMessageProviderFactory(StringEncrypter stringEncrypter) {
        this.executorService = Executors.newCachedThreadPool(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable);
                thread.setName("MessageProviderThread");
                thread.setDaemon(true);
                return thread;
            }
        });
        this.stringEncrypter = stringEncrypter;
    }

    public MessageProvider<?> getMessageProvider(MessageConfiguration messageConfiguration) {
        MessageProviderType messageProviderType = messageConfiguration.getMessageProviderType();
        if (messageProviderType == null) {
            LOG.error("Failed to initialize messageProvider, messageProviderType is null. Fallback to NULL type.");
            messageProviderType = MessageProviderType.DISABLED;
        }
        AbstractMessageProvider messageProvider = null;
        switch (messageProviderType) {
            case DISABLED: {
                if (this.stringEncrypter == null) {
                    throw new RuntimeException("Factory is not initialized properly. stringEncrypter is not specified");
                }
                NullMessageProvider nullMessageProvider = new NullMessageProvider();
                nullMessageProvider.configure(messageConfiguration, this.stringEncrypter);
                nullMessageProvider.init();
                messageProvider = nullMessageProvider;
                break;
            }
            case REDIS: {
                if (this.stringEncrypter == null) {
                    throw new RuntimeException("Factory is not initialized properly. stringEncrypter is not specified");
                }
                RedisMessageProvider redisMessageProvider = new RedisMessageProvider();
                redisMessageProvider.configure(messageConfiguration, this.stringEncrypter);
                redisMessageProvider.init();
                messageProvider = redisMessageProvider;
                break;
            }
            case POSTGRES: {
                if (this.stringEncrypter == null) {
                    throw new RuntimeException("Factory is not initialized properly. stringEncrypter is not specified");
                }
                PostgresMessageProvider postgresMessageProvider = new PostgresMessageProvider();
                postgresMessageProvider.configure(messageConfiguration, this.stringEncrypter);
                postgresMessageProvider.init();
                messageProvider = postgresMessageProvider;
            }
        }
        if (messageProvider == null) {
            throw new RuntimeException("Failed to initialize messageProvider, messageProviderType is unsupported: " + messageProvider);
        }
        messageProvider.create(this.executorService);
        return messageProvider;
    }

    public int getActiveCount() {
        return ((ThreadPoolExecutor)this.executorService).getActiveCount();
    }

    public int getPoolSize() {
        return ((ThreadPoolExecutor)this.executorService).getPoolSize();
    }
}

