/*
 * Decompiled with CFR 0.152.
 */
package io.jans.service.document.store.manager;

import io.jans.service.cdi.async.Asynchronous;
import io.jans.service.cdi.event.Scheduled;
import io.jans.service.document.store.conf.DocumentStoreType;
import io.jans.service.document.store.model.Document;
import io.jans.service.document.store.service.DocumentStoreService;
import io.jans.service.document.store.service.cdi.event.ReloadDocument;
import io.jans.service.document.store.service.cdi.event.UpdateDocumentStoreEvent;
import io.jans.service.timer.event.TimerEvent;
import io.jans.service.timer.schedule.TimerSchedule;
import io.jans.util.StringHelper;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.BeforeDestroyed;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.event.Observes;
import jakarta.inject.Inject;
import jakarta.servlet.ServletContext;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;

@ApplicationScoped
public class DocumentStoreManager {
    public static final String DOCUMENT_DATA_MODIFIED_EVENT_TYPE = "documentDataModifiedEvent";
    public static final int DEFAULT_INTERVAL = 30;
    protected static final String[] CUSTOM_SCRIPT_CHECK_ATTRIBUTES = new String[]{"dn", "inum", "creationDate", "jansRevision", "jansEnabled", "jansFilePath", "displayName"};
    @Inject
    protected Logger log;
    @Inject
    private Event<TimerEvent> timerEvent;
    @Inject
    @ReloadDocument
    private Event<String> event;
    @Inject
    private DocumentStoreService documentStoreService;
    private AtomicBoolean isActive;
    private long lastFinishedTime;
    private boolean initialized = false;
    private List<String> supportedServiceTypes = new ArrayList<String>();
    private DocumentStoreType previousServiceType;
    private Map<String, Object> loadedDocumentsStore = new TreeMap<String, Object>();

    @Asynchronous
    public void initTimer(List<String> serviceTypes) {
        this.initTimer(serviceTypes, 30);
    }

    @Asynchronous
    public void initTimer(List<String> serviceTypes, int interval) {
        this.supportedServiceTypes.addAll(serviceTypes);
        this.configure();
        int delay = 30;
        this.reload(true);
        this.timerEvent.fire((Object)new TimerEvent(new TimerSchedule(30, 30), (Object)new UpdateDocumentStoreEvent(), new Annotation[]{Scheduled.Literal.INSTANCE}));
        this.initialized = true;
    }

    protected void configure() {
        this.isActive = new AtomicBoolean(false);
        this.lastFinishedTime = System.currentTimeMillis();
    }

    public void reloadTimerEvent(@Observes @Scheduled UpdateDocumentStoreEvent updateDocumentStoreEvent) {
        if (this.isActive.get()) {
            return;
        }
        if (!this.isActive.compareAndSet(false, true)) {
            return;
        }
        try {
            this.reload(false);
        }
        catch (Throwable ex) {
            this.log.error("Exception happened while reloading custom scripts configuration", ex);
        }
        finally {
            this.isActive.set(false);
            this.lastFinishedTime = System.currentTimeMillis();
            this.log.trace("Last finished time '{}'", (Object)new Date(this.lastFinishedTime));
        }
    }

    public void destroy(@BeforeDestroyed(value=ApplicationScoped.class) ServletContext init) {
        this.log.debug("Destroying documents store");
        this.loadedDocumentsStore.clear();
    }

    private void reload(boolean syncUpdate) {
        boolean modified = this.reloadImpl();
        if (modified || syncUpdate) {
            this.event.fire((Object)DOCUMENT_DATA_MODIFIED_EVENT_TYPE);
        }
    }

    private boolean reloadImpl() {
        boolean supportedServiceType;
        DocumentStoreType currentServiceType = this.documentStoreService.getProviderType();
        boolean storeTypeChanged = currentServiceType != this.previousServiceType;
        boolean bl = supportedServiceType = DocumentStoreType.DB == currentServiceType;
        if (storeTypeChanged) {
            this.log.warn("Document store type were changed!!!");
        }
        this.previousServiceType = currentServiceType;
        List<Object> loadedDocuments = !supportedServiceType || this.supportedServiceTypes.isEmpty() ? new ArrayList<Object>() : this.documentStoreService.findDocumentsByModules((List)this.supportedServiceTypes, CUSTOM_SCRIPT_CHECK_ATTRIBUTES);
        ReloadResult reloadResult = this.updateDocuments(this.loadedDocumentsStore, loadedDocuments);
        this.loadedDocumentsStore = reloadResult.getDocumentsStore();
        return reloadResult.isModified();
    }

    private ReloadResult updateDocuments(Map<String, Object> prevDocumentsStore, List<Object> newLoadedDocuments) {
        HashMap<Object, Object> newDocumentStore;
        boolean modified = false;
        if (prevDocumentsStore == null) {
            newDocumentStore = new HashMap();
            modified = true;
        } else {
            newDocumentStore = new HashMap<String, Object>(prevDocumentsStore);
        }
        ArrayList<String> newLoadedDocumentsInums = new ArrayList<String>();
        for (Object newDocumentObject : newLoadedDocuments) {
            Document newDocument = (Document)newDocumentObject;
            if (!newDocument.isEnabled()) continue;
            String newDocumentInum = StringHelper.toLowerCase((String)newDocument.getInum());
            newLoadedDocumentsInums.add(newDocumentInum);
            Document prevDocument = (Document)newDocumentStore.get(newDocumentInum);
            if (prevDocument != null && prevDocument.getRevision() == newDocument.getRevision()) continue;
            this.saveDocument(newDocument);
            newDocumentStore.put(newDocumentInum, newDocument);
            modified = true;
        }
        Iterator it = newDocumentStore.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry newDocumentStoreEntry = it.next();
            String prevDocumentStoreEntryInum = (String)newDocumentStoreEntry.getKey();
            if (newLoadedDocumentsInums.contains(prevDocumentStoreEntryInum)) continue;
            this.removeDocument((Document)newDocumentStoreEntry.getValue());
            it.remove();
            modified = true;
        }
        return new ReloadResult(newDocumentStore, modified);
    }

    private void saveDocument(Document document) {
        try (InputStream is = this.documentStoreService.readBinaryDocumentAsStream(document.getFileName());){
            this.log.info("Writing file {} as stream", (Object)document.getFileName());
            Path path = Paths.get(document.getFilePath(), document.getFileName());
            File file = path.toFile();
            try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));){
                IOUtils.copy((InputStream)is, (OutputStream)os);
            }
            this.log.info("File {} was created successfully", (Object)document.getFileName());
        }
        catch (Exception ex) {
            this.log.error("Failed to write file {} as stream", (Object)document.getFileName(), (Object)ex);
        }
    }

    private void removeDocument(Document document) {
        try {
            File file = new File(document.getFileName());
            boolean res = file.delete();
            if (res) {
                this.log.info("File was {} removed successfully", (Object)document.getFileName());
            } else {
                this.log.error("Failed to remove file {}", (Object)document.getFileName());
            }
        }
        catch (Exception ex) {
            this.log.error("Failed to remove file {}", (Object)document.getFileName(), (Object)ex);
        }
    }

    public List<String> getSupportedServiceTypes() {
        return this.supportedServiceTypes;
    }

    public boolean isSupportedServiceType(List<String> serviceTypes) {
        return this.supportedServiceTypes.containsAll(serviceTypes);
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    private class ReloadResult {
        private Map<String, Object> documentsStore;
        private boolean modified;

        ReloadResult(Map<String, Object> documentsStore, boolean modified) {
            this.documentsStore = documentsStore;
            this.modified = modified;
        }

        public Map<String, Object> getDocumentsStore() {
            return this.documentsStore;
        }

        public boolean isModified() {
            return this.modified;
        }
    }
}

