/*
 * Decompiled with CFR 0.152.
 */
package io.jans.service.document.store.provider;

import io.jans.service.document.store.LocalDocumentStore;
import io.jans.service.document.store.conf.DocumentStoreConfiguration;
import io.jans.service.document.store.conf.DocumentStoreType;
import io.jans.service.document.store.provider.DBDocumentStoreProvider;
import io.jans.service.document.store.provider.DocumentStoreProvider;
import io.jans.service.document.store.provider.JcaDocumentStoreProvider;
import io.jans.service.document.store.provider.LocalDocumentStoreProvider;
import io.jans.service.document.store.provider.WebDavDocumentStoreProvider;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import org.slf4j.Logger;

@ApplicationScoped
public class DocumentStoreProviderFactory {
    @Inject
    private Logger log;
    @Inject
    private DocumentStoreConfiguration documentStoreConfiguration;
    @Inject
    @Any
    private Instance<DocumentStoreProvider> instance;

    @Produces
    @ApplicationScoped
    public DocumentStoreProvider getDocumentStoreProvider() {
        this.log.debug("Started to create document store provider");
        return this.getDocumentStoreProvider(this.documentStoreConfiguration);
    }

    public DocumentStoreProvider getDocumentStoreProvider(DocumentStoreConfiguration documentStoreConfiguration) {
        DocumentStoreType documentStoreType = documentStoreConfiguration.getDocumentStoreType();
        if (documentStoreType == null) {
            this.log.error("Failed to initialize DocumentStoreProvider, DocumentStoreProviderType is null. Fallback to LOCAL type.");
            documentStoreType = DocumentStoreType.LOCAL;
        }
        DocumentStoreProvider documentStoreProvider = null;
        switch (documentStoreType) {
            case LOCAL: {
                documentStoreProvider = (DocumentStoreProvider)this.instance.select(LocalDocumentStoreProvider.class, new Annotation[0]).get();
                break;
            }
            case JCA: {
                documentStoreProvider = (DocumentStoreProvider)this.instance.select(JcaDocumentStoreProvider.class, new Annotation[0]).get();
                break;
            }
            case WEB_DAV: {
                documentStoreProvider = (DocumentStoreProvider)this.instance.select(WebDavDocumentStoreProvider.class, new Annotation[0]).get();
                break;
            }
            case DB: {
                documentStoreProvider = (DocumentStoreProvider)this.instance.select(DBDocumentStoreProvider.class, new Annotation[0]).get();
            }
        }
        if (documentStoreProvider == null) {
            throw new RuntimeException("Failed to initialize DocumentStoreProvider, DocumentStoreProviderType is unsupported: " + documentStoreType);
        }
        documentStoreProvider.create();
        return documentStoreProvider;
    }

    @Produces
    @ApplicationScoped
    @LocalDocumentStore
    public DocumentStoreProvider getLocalDocumentStoreProvider() {
        this.log.debug("Started to create local document store provider");
        DocumentStoreType documentStoreType = DocumentStoreType.LOCAL;
        DocumentStoreProvider documentStoreProvider = (DocumentStoreProvider)this.instance.select(LocalDocumentStoreProvider.class, new Annotation[0]).get();
        if (documentStoreProvider == null) {
            throw new RuntimeException("Failed to initialize DocumentStoreProvider, DocumentStoreProviderType is unsupported: " + documentStoreType);
        }
        documentStoreProvider.create();
        return documentStoreProvider;
    }
}

