/*
 * Decompiled with CFR 0.152.
 */
package io.jans.orm.cloud.spanner.impl;

import com.google.cloud.spanner.Type;
import io.jans.orm.annotation.AttributeEnum;
import io.jans.orm.cloud.spanner.model.ConvertedExpression;
import io.jans.orm.cloud.spanner.model.TableMapping;
import io.jans.orm.cloud.spanner.model.ValueWithStructField;
import io.jans.orm.cloud.spanner.operation.SpannerOperationService;
import io.jans.orm.exception.operation.SearchException;
import io.jans.orm.ldap.impl.LdapFilterConverter;
import io.jans.orm.reflect.property.PropertyAnnotation;
import io.jans.orm.reflect.util.ReflectHelper;
import io.jans.orm.search.filter.Filter;
import io.jans.orm.search.filter.FilterType;
import io.jans.orm.util.ArrayHelper;
import io.jans.orm.util.StringHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.NotExpression;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.UserVariable;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExistsExpression;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.GreaterThanEquals;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.IsNullExpression;
import net.sf.jsqlparser.expression.operators.relational.ItemsList;
import net.sf.jsqlparser.expression.operators.relational.LikeExpression;
import net.sf.jsqlparser.expression.operators.relational.MinorThanEquals;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SubSelect;
import net.sf.jsqlparser.statement.select.TableFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpannerFilterConverter {
    private static final Logger LOG = LoggerFactory.getLogger(SpannerFilterConverter.class);
    private static final LdapFilterConverter ldapFilterConverter = new LdapFilterConverter();
    private SpannerOperationService operationService;
    private Table tableAlias = new Table("doc");

    public SpannerFilterConverter(SpannerOperationService operationService) {
        this.operationService = operationService;
    }

    public ConvertedExpression convertToSqlFilter(TableMapping tableMapping, Filter genericFilter, Map<String, PropertyAnnotation> propertiesAnnotationsMap) throws SearchException {
        return this.convertToSqlFilter(tableMapping, genericFilter, propertiesAnnotationsMap, false);
    }

    public ConvertedExpression convertToSqlFilter(TableMapping tableMapping, Filter genericFilter, Map<String, PropertyAnnotation> propertiesAnnotationsMap, boolean skipAlias) throws SearchException {
        return this.convertToSqlFilter(tableMapping, genericFilter, propertiesAnnotationsMap, null, skipAlias);
    }

    public ConvertedExpression convertToSqlFilter(TableMapping tableMapping, Filter genericFilter, Map<String, PropertyAnnotation> propertiesAnnotationsMap, Function<? super Filter, Boolean> processor) throws SearchException {
        return this.convertToSqlFilter(tableMapping, genericFilter, propertiesAnnotationsMap, processor, false);
    }

    public ConvertedExpression convertToSqlFilter(TableMapping tableMapping, Filter genericFilter, Map<String, PropertyAnnotation> propertiesAnnotationsMap, Function<? super Filter, Boolean> processor, boolean skipAlias) throws SearchException {
        HashMap<String, ValueWithStructField> queryParameters = new HashMap<String, ValueWithStructField>();
        HashMap<String, Join> joinTables = new HashMap<String, Join>();
        ConvertedExpression convertedExpression = this.convertToSqlFilterImpl(tableMapping, genericFilter, propertiesAnnotationsMap, queryParameters, joinTables, processor, skipAlias);
        return convertedExpression;
    }

    /*
     * WARNING - void declaration
     */
    private ConvertedExpression convertToSqlFilterImpl(TableMapping tableMapping, Filter genericFilter, Map<String, PropertyAnnotation> propertiesAnnotationsMap, Map<String, ValueWithStructField> queryParameters, Map<String, Join> joinTables, Function<? super Filter, Boolean> processor, boolean skipAlias) throws SearchException {
        Expression variableExpression;
        if (genericFilter == null) {
            return null;
        }
        Filter currentGenericFilter = genericFilter;
        FilterType type = currentGenericFilter.getType();
        if (FilterType.RAW == type) {
            LOG.warn("RAW Ldap filter to SQL convertion will be removed in new version!!!");
            currentGenericFilter = ldapFilterConverter.convertRawLdapFilterToFilter(currentGenericFilter.getFilterString());
            LOG.debug(String.format("Converted RAW filter: %s", currentGenericFilter));
            type = currentGenericFilter.getType();
        }
        if (processor != null) {
            processor.apply((Filter)currentGenericFilter);
        }
        if (FilterType.NOT == type || FilterType.AND == type || FilterType.OR == type) {
            Filter[] genericFilters = currentGenericFilter.getFilters();
            Expression[] expFilters = new Expression[genericFilters.length];
            if (genericFilters != null) {
                boolean canJoinOrFilters = FilterType.OR == type;
                ArrayList<Filter> joinOrFilters = new ArrayList<Filter>();
                String joinOrAttributeName = null;
                for (int i = 0; i < genericFilters.length; ++i) {
                    Filter filter = genericFilters[i];
                    expFilters[i] = this.convertToSqlFilterImpl(tableMapping, filter, propertiesAnnotationsMap, queryParameters, joinTables, processor, skipAlias).expression();
                    if (!canJoinOrFilters) continue;
                    if (FilterType.EQUALITY != filter.getType() || filter.getFilters() != null) {
                        canJoinOrFilters = false;
                        continue;
                    }
                    if (filter.getMultiValued() != null) {
                        canJoinOrFilters = false;
                        continue;
                    }
                    Boolean isMultiValuedDetected = this.determineMultiValuedByType(filter.getAttributeName(), propertiesAnnotationsMap);
                    if (!Boolean.FALSE.equals(isMultiValuedDetected) && !Boolean.FALSE.equals(currentGenericFilter.getMultiValued())) {
                        canJoinOrFilters = false;
                        continue;
                    }
                    if (joinOrAttributeName == null) {
                        joinOrAttributeName = filter.getAttributeName();
                        joinOrFilters.add(filter);
                        continue;
                    }
                    if (!joinOrAttributeName.equals(filter.getAttributeName())) {
                        canJoinOrFilters = false;
                        continue;
                    }
                    joinOrFilters.add(filter);
                }
                if (FilterType.NOT == type) {
                    return ConvertedExpression.build((Expression)new NotExpression(expFilters[0]), queryParameters, joinTables);
                }
                if (FilterType.AND == type) {
                    void var16_26;
                    Expression result = expFilters[0];
                    boolean bl = true;
                    while (var16_26 < expFilters.length) {
                        result = new AndExpression(result, expFilters[var16_26]);
                        ++var16_26;
                    }
                    return ConvertedExpression.build((Expression)new Parenthesis(result), queryParameters, joinTables);
                }
                if (FilterType.OR == type) {
                    void var16_30;
                    if (canJoinOrFilters) {
                        ExpressionList expressionList = new ExpressionList();
                        for (Expression expression : expFilters) {
                            expressionList.addExpressions(new Expression[]{((EqualsTo)expression).getRightExpression()});
                        }
                        InExpression inExpression = new InExpression(this.buildExpression(tableMapping, (Filter)joinOrFilters.get(0), false, false, propertiesAnnotationsMap, queryParameters, joinTables, processor, skipAlias), (ItemsList)expressionList);
                        return ConvertedExpression.build((Expression)inExpression, queryParameters, joinTables);
                    }
                    Expression result = expFilters[0];
                    boolean bl = true;
                    while (var16_30 < expFilters.length) {
                        result = new OrExpression(result, expFilters[var16_30]);
                        ++var16_30;
                    }
                    return ConvertedExpression.build((Expression)new Parenthesis(result), queryParameters, joinTables);
                }
            }
        }
        String internalAttribute = this.toInternalAttribute(currentGenericFilter);
        boolean multiValued = this.isMultiValue(tableMapping, internalAttribute, currentGenericFilter, propertiesAnnotationsMap);
        boolean hasChildTableForAttribute = tableMapping.hasChildTableForAttribute(internalAttribute.toLowerCase());
        Expression leftExpression = this.buildExpression(tableMapping, currentGenericFilter, multiValued, !hasChildTableForAttribute, propertiesAnnotationsMap, queryParameters, joinTables, processor, skipAlias);
        if (FilterType.EQUALITY == type) {
            variableExpression = this.buildVariableExpression(tableMapping, internalAttribute, currentGenericFilter.getAssertionValue(), queryParameters);
            EqualsTo expression = new EqualsTo(leftExpression, variableExpression);
            if (multiValued) {
                if (hasChildTableForAttribute) {
                    this.addJoinTable(tableMapping, internalAttribute, joinTables);
                } else {
                    expression = this.buildExistsInArrayExpression(internalAttribute, (Expression)expression);
                }
                return ConvertedExpression.build((Expression)expression, queryParameters, joinTables);
            }
            return ConvertedExpression.build((Expression)expression, queryParameters, joinTables);
        }
        if (FilterType.LESS_OR_EQUAL == type) {
            variableExpression = this.buildVariableExpression(tableMapping, internalAttribute, currentGenericFilter.getAssertionValue(), queryParameters);
            MinorThanEquals expression = new MinorThanEquals().withLeftExpression(leftExpression).withRightExpression(variableExpression);
            if (multiValued) {
                if (hasChildTableForAttribute) {
                    this.addJoinTable(tableMapping, internalAttribute, joinTables);
                } else {
                    expression = this.buildExistsInArrayExpression(internalAttribute, (Expression)expression);
                }
                return ConvertedExpression.build((Expression)expression, queryParameters, joinTables);
            }
            return ConvertedExpression.build((Expression)expression, queryParameters, joinTables);
        }
        if (FilterType.GREATER_OR_EQUAL == type) {
            variableExpression = this.buildVariableExpression(tableMapping, internalAttribute, currentGenericFilter.getAssertionValue(), queryParameters);
            GreaterThanEquals expression = new GreaterThanEquals().withLeftExpression(leftExpression).withRightExpression(variableExpression);
            if (multiValued) {
                if (hasChildTableForAttribute) {
                    this.addJoinTable(tableMapping, internalAttribute, joinTables);
                } else {
                    expression = this.buildExistsInArrayExpression(internalAttribute, (Expression)expression);
                }
                return ConvertedExpression.build((Expression)expression, queryParameters, joinTables);
            }
            return ConvertedExpression.build((Expression)expression, queryParameters, joinTables);
        }
        if (FilterType.PRESENCE == type) {
            IsNullExpression expression = new IsNullExpression().withLeftExpression(leftExpression).withNot(true);
            if (multiValued) {
                if (hasChildTableForAttribute) {
                    this.addJoinTable(tableMapping, internalAttribute, joinTables);
                } else {
                    expression = this.buildExistsInArrayExpression(internalAttribute, (Expression)expression);
                }
                return ConvertedExpression.build((Expression)expression, queryParameters, joinTables);
            }
            return ConvertedExpression.build((Expression)expression, queryParameters, joinTables);
        }
        if (FilterType.APPROXIMATE_MATCH == type) {
            throw new SearchException("Convertion from APPROXIMATE_MATCH LDAP filter to SQL filter is not implemented");
        }
        if (FilterType.SUBSTRING == type) {
            StringBuilder like = new StringBuilder();
            if (currentGenericFilter.getSubInitial() != null) {
                like.append(currentGenericFilter.getSubInitial());
            }
            like.append("%");
            String[] subAny = currentGenericFilter.getSubAny();
            if (subAny != null && subAny.length > 0) {
                for (String string : subAny) {
                    like.append(string);
                    like.append("%");
                }
            }
            if (currentGenericFilter.getSubFinal() != null) {
                like.append(currentGenericFilter.getSubFinal());
            }
            String string = like.toString();
            Expression variableExpression2 = this.buildVariableExpression(tableMapping, internalAttribute, string, queryParameters);
            LikeExpression expression = new LikeExpression().withLeftExpression(leftExpression).withRightExpression(variableExpression2);
            if (multiValued) {
                if (hasChildTableForAttribute) {
                    this.addJoinTable(tableMapping, internalAttribute, joinTables);
                } else {
                    expression = this.buildExistsInArrayExpression(internalAttribute, (Expression)expression);
                }
                return ConvertedExpression.build((Expression)expression, queryParameters, joinTables);
            }
            return ConvertedExpression.build((Expression)expression, queryParameters, joinTables);
        }
        if (FilterType.LOWERCASE == type) {
            net.sf.jsqlparser.expression.Function lowerFunction = new net.sf.jsqlparser.expression.Function();
            lowerFunction.setName("LOWER");
            lowerFunction.setParameters(new ExpressionList(new Expression[]{leftExpression}));
            return ConvertedExpression.build((Expression)lowerFunction, queryParameters, joinTables);
        }
        throw new SearchException(String.format("Unknown filter type '%s'", type));
    }

    protected Boolean isMultiValue(TableMapping tableMapping, String attributeName, Filter currentGenericFilter, Map<String, PropertyAnnotation> propertiesAnnotationsMap) throws SearchException {
        Type.StructField structField = this.getStructField(tableMapping, attributeName);
        boolean hasChildTableForAttribute = tableMapping.hasChildTableForAttribute(attributeName.toLowerCase());
        Type.Code columnTypeCode = structField.getType().getCode();
        if (Type.Code.ARRAY == columnTypeCode || hasChildTableForAttribute) {
            boolean multiValuedDetected;
            boolean bl = multiValuedDetected = Boolean.TRUE.equals(currentGenericFilter.getMultiValued()) || Boolean.TRUE.equals(this.determineMultiValuedByType(currentGenericFilter.getAttributeName(), propertiesAnnotationsMap));
            if (!multiValuedDetected) {
                LOG.warn(String.format("\u0421olumn name '%s' was defined as multi valued in table/child table '%s' but detected as single value", attributeName, tableMapping.getTableName()));
            }
            return true;
        }
        return false;
    }

    private Type.StructField getStructField(TableMapping tableMapping, String attributeName) throws SearchException {
        TableMapping childTableMapping;
        String attributeNameLower = attributeName.toLowerCase();
        Type.StructField structField = tableMapping.getColumTypes().get(attributeNameLower);
        if (structField == null && (childTableMapping = tableMapping.getChildTableMappingForAttribute(attributeNameLower)) != null) {
            structField = childTableMapping.getColumTypes().get(attributeNameLower);
        }
        if (structField == null) {
            throw new SearchException(String.format("Unknown column name '%s' in table/child table '%s'", attributeName, tableMapping.getTableName()));
        }
        return structField;
    }

    private Boolean determineMultiValuedByType(String attributeName, Map<String, PropertyAnnotation> propertiesAnnotationsMap) {
        if (attributeName == null || propertiesAnnotationsMap == null) {
            return null;
        }
        if (StringHelper.equalsIgnoreCase((String)attributeName, (String)"objectClass")) {
            return false;
        }
        PropertyAnnotation propertyAnnotation = propertiesAnnotationsMap.get(attributeName);
        if (propertyAnnotation == null || propertyAnnotation.getParameterType() == null) {
            return null;
        }
        Class parameterType = propertyAnnotation.getParameterType();
        boolean isMultiValued = parameterType.equals(Object[].class) || parameterType.equals(String[].class) || ReflectHelper.assignableFrom((Class)parameterType, List.class) || ReflectHelper.assignableFrom((Class)parameterType, AttributeEnum[].class);
        return isMultiValued;
    }

    private String toInternalAttribute(Filter filter) {
        String attributeName = filter.getAttributeName();
        if (StringHelper.isEmpty((String)attributeName)) {
            Filter subFilter;
            Filter[] filterArray = filter.getFilters();
            int n = filterArray.length;
            for (int i = 0; i < n && !StringHelper.isNotEmpty((String)(attributeName = (subFilter = filterArray[i]).getAttributeName())); ++i) {
            }
        }
        return this.toInternalAttribute(attributeName);
    }

    private String toInternalAttribute(String attributeName) {
        if (this.operationService == null) {
            return attributeName;
        }
        return this.operationService.toInternalAttribute(attributeName);
    }

    private Expression buildVariableExpression(TableMapping tableMapping, String attributeName, Object attribyteValue, Map<String, ValueWithStructField> queryParameters) throws SearchException {
        Type.StructField structField = this.getStructField(tableMapping, attributeName);
        Object usedAttributeName = attributeName;
        int idx = 0;
        while (queryParameters.containsKey(usedAttributeName) && idx < 100) {
            usedAttributeName = attributeName + Integer.toString(idx++);
        }
        queryParameters.put((String)usedAttributeName, new ValueWithStructField(attribyteValue, structField));
        return new UserVariable((String)usedAttributeName);
    }

    private Expression buildExistsInArrayExpression(String attributeName, Expression whereExpression) {
        PlainSelect arrayQuery = new PlainSelect();
        String columnAlias = "_" + attributeName;
        arrayQuery.addSelectItems(new SelectItem[]{new SelectExpressionItem((Expression)new Column(this.tableAlias, "doc_id"))});
        arrayQuery.setWhere(whereExpression);
        TableFunction fromTableFunction = new TableFunction();
        fromTableFunction.setAlias(new Alias(columnAlias, false));
        net.sf.jsqlparser.expression.Function unnestFunction = new net.sf.jsqlparser.expression.Function();
        unnestFunction.setName("UNNEST");
        unnestFunction.setParameters(new ExpressionList(new Expression[]{new Column(this.tableAlias, attributeName)}));
        fromTableFunction.setFunction(unnestFunction);
        arrayQuery.setFromItem((FromItem)fromTableFunction);
        SubSelect arraySubSelect = new SubSelect();
        arraySubSelect.setSelectBody((SelectBody)arrayQuery);
        arraySubSelect.withUseBrackets(true);
        ExistsExpression existsExpression = new ExistsExpression();
        existsExpression.setRightExpression((Expression)arraySubSelect);
        return existsExpression;
    }

    private Expression buildExpression(TableMapping tableMapping, Filter genericFilter, boolean multiValued, boolean useExistsInArray, Map<String, PropertyAnnotation> propertiesAnnotationsMap, Map<String, ValueWithStructField> queryParameters, Map<String, Join> joinTables, Function<? super Filter, Boolean> processor, boolean skipAlias) throws SearchException {
        boolean hasSubFilters = ArrayHelper.isNotEmpty((Object[])genericFilter.getFilters());
        if (hasSubFilters) {
            return this.convertToSqlFilterImpl(tableMapping, genericFilter.getFilters()[0], propertiesAnnotationsMap, queryParameters, joinTables, processor, skipAlias).expression();
        }
        Object internalAttribute = this.toInternalAttribute(genericFilter);
        if (multiValued) {
            skipAlias = true;
            internalAttribute = useExistsInArray ? "_" + (String)internalAttribute : (String)internalAttribute + "." + (String)internalAttribute;
        }
        return this.buildColumnExpression((String)internalAttribute, skipAlias);
    }

    private Expression buildColumnExpression(String attributeName, boolean skipAlias) {
        if (skipAlias) {
            return new Column(attributeName);
        }
        return new Column(this.tableAlias, attributeName);
    }

    private void addJoinTable(TableMapping tableMapping, String attributeName, Map<String, Join> joinTables) {
        if (joinTables.containsKey(attributeName)) {
            return;
        }
        TableMapping childTableMapping = tableMapping.getChildTableMappingForAttribute(attributeName.toLowerCase());
        Table childTable = new Table(childTableMapping.getTableName());
        childTable.setAlias(new Alias(attributeName, false));
        EqualsTo onExpression = new EqualsTo().withLeftExpression((Expression)new Column().withTable(this.tableAlias).withColumnName("doc_id")).withRightExpression((Expression)new Column().withTable(childTable).withColumnName("doc_id"));
        Join join = new Join();
        join.setRightItem((FromItem)childTable);
        join.setOnExpression((Expression)onExpression);
        joinTables.put(attributeName, join);
    }
}

