/*
 * Decompiled with CFR 0.152.
 */
package io.jans.service.cache;

import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.exception.EntryPersistenceException;
import io.jans.orm.exception.operation.DuplicateEntryException;
import io.jans.orm.model.base.SimpleBranch;
import io.jans.orm.search.filter.Filter;
import io.jans.service.cache.AbstractCacheProvider;
import io.jans.service.cache.CacheConfiguration;
import io.jans.service.cache.CacheProviderType;
import io.jans.service.cache.NativePersistenceCacheEntity;
import io.jans.service.cache.NativePersistenceConfiguration;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class NativePersistenceCacheProvider
extends AbstractCacheProvider<PersistenceEntryManager> {
    @Inject
    private Logger log;
    @Inject
    private CacheConfiguration cacheConfiguration;
    @Inject
    private PersistenceEntryManager entryManager;
    private String baseDn;
    private boolean deleteExpiredOnGetRequest;
    private boolean skipRemoveBeforePut;
    private boolean attemptUpdateBeforeInsert;

    @PostConstruct
    public void init() {
    }

    @Override
    public void create() {
        try {
            this.baseDn = this.cacheConfiguration.getNativePersistenceConfiguration().getBaseDn();
            this.deleteExpiredOnGetRequest = this.cacheConfiguration.getNativePersistenceConfiguration().isDeleteExpiredOnGetRequest();
            if (StringUtils.isBlank((CharSequence)this.baseDn)) {
                this.log.error("Failed to create NATIVE_PERSISTENCE cache provider. 'baseDn' in CacheConfiguration is not initialized. It has to be set by client application (e.g. oxAuth has to set it in ApplicationFactory.)");
                throw new RuntimeException("Failed to create NATIVE_PERSISTENCE cache provider. 'baseDn' in CacheConfiguration is not initialized. It has to be set by client application.");
            }
            String branchDn = String.format("ou=cache,%s", this.baseDn);
            if (this.entryManager.hasBranchesSupport(branchDn) && !this.entryManager.contains(branchDn, SimpleBranch.class)) {
                SimpleBranch branch = new SimpleBranch();
                branch.setOrganizationalUnitName("cache");
                branch.setDn(branchDn);
                this.entryManager.persist((Object)branch);
            }
            this.baseDn = branchDn;
            this.cacheConfiguration.getNativePersistenceConfiguration().setBaseDn(this.baseDn);
            String persistenceType = this.entryManager.getPersistenceType(this.baseDn);
            this.skipRemoveBeforePut = "couchbase".equals(persistenceType);
            this.attemptUpdateBeforeInsert = "sql".equals(persistenceType);
            if (this.cacheConfiguration.getNativePersistenceConfiguration().isDisableAttemptUpdateBeforeInsert()) {
                this.attemptUpdateBeforeInsert = false;
            }
            this.log.info("Created NATIVE_PERSISTENCE cache provider. `baseDn`: " + this.baseDn);
        }
        catch (Exception e) {
            this.log.error("Failed to create NATIVE_PERSISTENCE cache provider.", (Throwable)e);
            throw new RuntimeException("Failed to create NATIVE_PERSISTENCE cache provider.", e);
        }
    }

    public void configure(CacheConfiguration cacheConfiguration, PersistenceEntryManager entryManager) {
        this.log = LoggerFactory.getLogger(NativePersistenceCacheProvider.class);
        this.cacheConfiguration = cacheConfiguration;
        this.entryManager = entryManager;
    }

    @Override
    public void destroy() {
    }

    @Override
    public PersistenceEntryManager getDelegate() {
        return this.entryManager;
    }

    @Override
    public boolean hasKey(String key) {
        try {
            key = NativePersistenceCacheProvider.hashKey(key);
            boolean hasKey = this.entryManager.contains(this.createDn(key), NativePersistenceCacheEntity.class);
            return hasKey;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public Object get(String key) {
        try {
            key = NativePersistenceCacheProvider.hashKey(key);
            NativePersistenceCacheEntity entity = (NativePersistenceCacheEntity)this.entryManager.find(NativePersistenceCacheEntity.class, (Object)this.createDn(key));
            if (entity != null && entity.getData() != null) {
                if (NativePersistenceCacheProvider.isExpired(entity.getExpirationDate()) && entity.isDeletable().booleanValue()) {
                    this.log.trace("Cache entity exists but expired, return null, expirationDate:" + entity.getExpirationDate() + ", key: " + key);
                    if (this.deleteExpiredOnGetRequest && !this.skipRemoveBeforePut) {
                        this.remove(key);
                    }
                    return null;
                }
                Object o = this.fromString(entity.getData());
                return o;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private String createDn(String key) {
        return String.format("uuid=%s,%s", key, this.baseDn);
    }

    public static String hashKey(String key) {
        return DigestUtils.sha256Hex((String)key);
    }

    @Override
    public void put(int expirationInSeconds, String key, Object object) {
        Date creationDate = new Date();
        expirationInSeconds = expirationInSeconds > 0 ? expirationInSeconds : this.cacheConfiguration.getNativePersistenceConfiguration().getDefaultPutExpiration();
        this.putImpl(key, object, creationDate, expirationInSeconds);
    }

    private void putImpl(String key, Object object, Date creationDate, int expirationInSeconds) {
        Calendar expirationDate = Calendar.getInstance();
        expirationDate.setTime(creationDate);
        expirationDate.add(13, expirationInSeconds);
        String originalKey = key;
        key = NativePersistenceCacheProvider.hashKey(key);
        NativePersistenceCacheEntity entity = new NativePersistenceCacheEntity();
        entity.setTtl(expirationInSeconds);
        entity.setData(this.asString(object));
        entity.setId(key);
        entity.setDn(this.createDn(key));
        entity.setCreationDate(creationDate);
        entity.setExpirationDate(expirationDate.getTime());
        entity.setDeletable(true);
        try {
            if (this.attemptUpdateBeforeInsert) {
                this.entryManager.merge((Object)entity);
            } else {
                if (!this.skipRemoveBeforePut) {
                    this.silentlyRemoveEntityIfExists(entity.getDn());
                }
                this.entryManager.persist((Object)entity);
            }
        }
        catch (EntryPersistenceException e) {
            if (e.getCause() instanceof DuplicateEntryException) {
                try {
                    this.silentlyRemoveEntityIfExists(entity.getDn());
                    this.entryManager.persist((Object)entity);
                    return;
                }
                catch (Exception ex) {
                    this.log.error("Failed to retry put entry, key: " + originalKey + ", hashedKey: " + key + ", message: " + ex.getMessage(), (Throwable)ex);
                }
            }
            if (this.attemptUpdateBeforeInsert) {
                try {
                    this.entryManager.persist((Object)entity);
                    return;
                }
                catch (Exception ex) {
                    this.log.error("Failed to retry put entry, key: " + originalKey + ", hashedKey: " + key + ", message: " + ex.getMessage(), (Throwable)ex);
                }
            }
            this.log.error("Failed to put entry, key: " + originalKey + ", hashedKey: " + key + ", message: " + e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            this.log.error("Failed to put entry, key: " + originalKey + ", hashedKey: " + key + ", message: " + e.getMessage(), (Throwable)e);
        }
    }

    private boolean silentlyRemoveEntityIfExists(String dn) {
        try {
            if (this.entryManager.find(NativePersistenceCacheEntity.class, (Object)dn) != null) {
                this.entryManager.remove(dn, NativePersistenceCacheEntity.class);
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static boolean isExpired(Date expiredAt) {
        return expiredAt == null || expiredAt.before(new Date());
    }

    @Override
    public void remove(String key) {
        if (this.silentlyRemoveEntityIfExists(this.createDn(NativePersistenceCacheProvider.hashKey(key)))) {
            this.log.trace("Removed entity, key: " + key);
        }
    }

    @Override
    public void clear() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object fromString(String s) {
        Object object;
        byte[] data = Base64.decodeBase64((String)s);
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(data));
        try {
            Object o = ois.readObject();
            ois.close();
            object = o;
        }
        catch (Throwable throwable) {
            try {
                IOUtils.closeQuietly((InputStream)ois);
                throw throwable;
            }
            catch (Exception e) {
                this.log.error("Failed to deserizalize cache entity, data: " + s, (Throwable)e);
                return null;
            }
        }
        IOUtils.closeQuietly((InputStream)ois);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String asString(Object o) {
        String string;
        ObjectOutputStream oos = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(baos);
            oos.writeObject(o);
            oos.close();
            string = Base64.encodeBase64String((byte[])baos.toByteArray());
        }
        catch (Exception e) {
            String string2;
            try {
                this.log.error("Failed to serizalize cache entity to string, object: 0", (Throwable)e);
                string2 = null;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(oos);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)oos);
            return string2;
        }
        IOUtils.closeQuietly((OutputStream)oos);
        return string;
    }

    @Override
    public void cleanup(Date now) {
        NativePersistenceConfiguration nativePersistenceConfiguration = this.cacheConfiguration.getNativePersistenceConfiguration();
        if (!this.entryManager.hasExpirationSupport(nativePersistenceConfiguration.getBaseDn())) {
            this.cleanup(now, this.cacheConfiguration.getNativePersistenceConfiguration().getDefaultCleanupBatchSize());
        }
    }

    public void cleanup(Date now, int batchSize) {
        this.log.debug("Start NATIVE_PERSISTENCE clean up");
        try {
            Filter filter = Filter.createANDFilter((Filter[])new Filter[]{Filter.createEqualityFilter((String)"del", (Object)true), Filter.createLessOrEqualFilter((String)"exp", (Object)this.entryManager.encodeTime(this.baseDn, now))});
            int removedCount = this.entryManager.remove(this.baseDn, NativePersistenceCacheEntity.class, filter, batchSize);
            this.log.debug("End NATIVE_PERSISTENCE clean up, items removed: " + removedCount);
        }
        catch (Exception e) {
            this.log.error("Failed to perform clean up.", (Throwable)e);
        }
    }

    @Override
    public CacheProviderType getProviderType() {
        return CacheProviderType.NATIVE_PERSISTENCE;
    }

    public void setEntryManager(PersistenceEntryManager entryManager) {
        this.entryManager = entryManager;
    }

    public void setBaseDn(String baseDn) {
        this.baseDn = baseDn;
    }

    public void setCacheConfiguration(CacheConfiguration cacheConfiguration) {
        this.cacheConfiguration = cacheConfiguration;
    }

    public static void main(String[] args) {
        NativePersistenceCacheProvider cp = new NativePersistenceCacheProvider();
        Object obj = cp.fromString("rO0ABXNyAClvcmcuZ2x1dS5veGF1dGgubW9kZWwuY29tbW9uLkNsaWVudFRva2Vuc/Aib54fThHVAgACTAAIY2xpZW50SWR0ABJMamF2YS9sYW5nL1N0cmluZztMAAt0b2tlbkhhc2hlc3QAD0xqYXZhL3V0aWwvU2V0O3hwdAApMTAwMS45MGQ0MGI2OS02ZDFmLTQxMmYtOTg5ZS00MThmN2E2Y2M1MTNzcgARamF2YS51dGlsLkhhc2hTZXS6RIWVlri3NAMAAHhwdwwAAAAQP0AAAAAAAAF0AEA3M2M1NDBhYjRlNzU2ZTk2ZjQ2NzU2ODZjNzU0ZDg1ZjZiOWExYmI0ZjI1ZWY5NTZjYmRkZTQ0NjlmZTA2OGVjeA==");
        System.out.println(obj);
    }
}

