/*
 * Decompiled with CFR 0.152.
 */
package io.jans.service.cache;

import java.util.ArrayList;
import redis.clients.jedis.params.Params;
import redis.clients.jedis.util.SafeEncoder;

public final class RedisSetParams
extends Params {
    private static final String XX = "xx";
    private static final String NX = "nx";
    private static final String PX = "px";
    private static final String EX = "ex";

    private RedisSetParams() {
    }

    public static RedisSetParams setParams() {
        return new RedisSetParams();
    }

    public RedisSetParams ex(int secondsToExpire) {
        this.addParam(EX, secondsToExpire);
        return this;
    }

    public RedisSetParams px(long millisecondsToExpire) {
        this.addParam(PX, millisecondsToExpire);
        return this;
    }

    public RedisSetParams nx() {
        this.addParam(NX);
        return this;
    }

    public RedisSetParams xx() {
        this.addParam(XX);
        return this;
    }

    public byte[][] getByteParams(byte[] ... args) {
        ArrayList<byte[]> byteParams = new ArrayList<byte[]>();
        for (byte[] arg : args) {
            byteParams.add(arg);
        }
        if (this.contains(NX)) {
            byteParams.add(SafeEncoder.encode((String)NX));
        }
        if (this.contains(XX)) {
            byteParams.add(SafeEncoder.encode((String)XX));
        }
        if (this.contains(EX)) {
            byteParams.add(SafeEncoder.encode((String)EX));
            byteParams.add(SafeEncoder.encode((String)String.valueOf((char[])this.getParam(EX))));
        }
        if (this.contains(PX)) {
            byteParams.add(SafeEncoder.encode((String)PX));
            byteParams.add(SafeEncoder.encode((String)String.valueOf((char[])this.getParam(PX))));
        }
        return (byte[][])byteParams.toArray((T[])new byte[byteParams.size()][]);
    }
}

