/*
 * Decompiled with CFR 0.152.
 */
package io.jans.orm.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.annotation.AttributeEnum;
import io.jans.orm.annotation.AttributeName;
import io.jans.orm.annotation.AttributesList;
import io.jans.orm.annotation.CustomObjectClass;
import io.jans.orm.annotation.DN;
import io.jans.orm.annotation.DataEntry;
import io.jans.orm.annotation.Expiration;
import io.jans.orm.annotation.JsonObject;
import io.jans.orm.annotation.LanguageTag;
import io.jans.orm.annotation.ObjectClass;
import io.jans.orm.annotation.Password;
import io.jans.orm.annotation.SchemaEntry;
import io.jans.orm.exception.EntryPersistenceException;
import io.jans.orm.exception.InvalidArgumentException;
import io.jans.orm.exception.MappingException;
import io.jans.orm.extension.PersistenceExtension;
import io.jans.orm.model.AttributeData;
import io.jans.orm.model.AttributeDataModification;
import io.jans.orm.model.AttributeType;
import io.jans.orm.model.PasswordAttributeData;
import io.jans.orm.model.PersistenceMetadata;
import io.jans.orm.model.SearchScope;
import io.jans.orm.model.base.LocalizedString;
import io.jans.orm.operation.PersistenceOperationService;
import io.jans.orm.reflect.property.Getter;
import io.jans.orm.reflect.property.PropertyAnnotation;
import io.jans.orm.reflect.property.Setter;
import io.jans.orm.reflect.util.ReflectHelper;
import io.jans.orm.search.filter.Filter;
import io.jans.orm.search.filter.FilterProcessor;
import io.jans.orm.util.ArrayHelper;
import io.jans.orm.util.StringHelper;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Base64;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseEntryManager<O extends PersistenceOperationService>
implements PersistenceEntryManager {
    private static final Logger LOG = LoggerFactory.getLogger(BaseEntryManager.class);
    private static final Class<?>[] LDAP_ENTRY_TYPE_ANNOTATIONS = new Class[]{DataEntry.class, SchemaEntry.class, ObjectClass.class};
    private static final Class<?>[] LDAP_ENTRY_PROPERTY_ANNOTATIONS = new Class[]{AttributeName.class, AttributesList.class, JsonObject.class, LanguageTag.class, Password.class};
    private static final Class<?>[] LDAP_CUSTOM_OBJECT_CLASS_PROPERTY_ANNOTATION = new Class[]{CustomObjectClass.class};
    private static final Class<?>[] LDAP_DN_PROPERTY_ANNOTATION = new Class[]{DN.class};
    private static final Class<?>[] LDAP_EXPIRATION_PROPERTY_ANNOTATION = new Class[]{Expiration.class};
    public static final String OBJECT_CLASS = "objectClass";
    public static final String USER_PASSWORD = "userPassword";
    private static final String MASKED = "*masked*";
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final Class<?>[] GROUP_BY_ALLOWED_DATA_TYPES = new Class[]{String.class, Date.class, Integer.class, AttributeEnum.class};
    private static final Class<?>[] SUM_BY_ALLOWED_DATA_TYPES = new Class[]{Integer.TYPE, Integer.class, Float.TYPE, Float.class, Double.TYPE, Double.class};
    private final Map<String, List<PropertyAnnotation>> classAnnotations = new HashMap<String, List<PropertyAnnotation>>();
    private final Map<String, Getter> classGetters = new HashMap<String, Getter>();
    private final Map<String, Setter> classSetters = new HashMap<String, Setter>();
    private static Object CLASS_ANNOTATIONS_LOCK = new Object();
    private static Object CLASS_SETTERS_LOCK = new Object();
    private static Object CLASS_GETTERS_LOCK = new Object();
    private static final ObjectMapper JSON_OBJECT_MAPPER = new ObjectMapper();
    protected static final String[] NO_STRINGS = new String[0];
    protected static final Object[] NO_OBJECTS = new Object[0];
    protected static final Comparator<String> LINE_LENGHT_COMPARATOR = new LineLenghtComparator<String>(false);
    protected static final int DEFAULT_PAGINATION_SIZE = 100;
    protected O operationService = null;
    protected PersistenceExtension persistenceExtension = null;
    protected FilterProcessor filterProcessor = new FilterProcessor();

    @Override
    public void persist(Object entry) {
        if (entry == null) {
            throw new MappingException("Entry to persist is null");
        }
        Class<?> entryClass = entry.getClass();
        this.checkEntryClass(entryClass, false);
        List<PropertyAnnotation> propertiesAnnotations = this.getEntryPropertyAnnotations(entryClass);
        Object dnValue = this.getDNValue(entry, entryClass);
        Integer expirationValue = this.getExpirationValue(entry, entryClass, false);
        List<AttributeData> attributes = this.getAttributesListForPersist(entry, propertiesAnnotations);
        Object[] objectClasses = this.getObjectClasses(entry, entryClass);
        attributes.add(new AttributeData(OBJECT_CLASS, objectClasses, true));
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("LDAP attributes for persist: %s", this.maskSensetiveData(attributes)));
        }
        this.persist(dnValue.toString(), (String[])objectClasses, attributes, expirationValue);
    }

    protected abstract void persist(String var1, String[] var2, List<AttributeData> var3, Integer var4);

    @Override
    public <T> List<T> findEntries(Object entry, int count) {
        if (entry == null) {
            throw new MappingException("Entry to find is null");
        }
        Class<?> entryClass = entry.getClass();
        this.checkEntryClass(entryClass, false);
        List<PropertyAnnotation> propertiesAnnotations = this.getEntryPropertyAnnotations(entryClass);
        Object dnValue = this.getDNValue(entry, entryClass);
        List<AttributeData> attributes = this.getAttributesListForPersist(entry, propertiesAnnotations);
        Filter searchFilter = this.createFilterByEntry(entry, entryClass, attributes);
        return this.findEntries(dnValue.toString(), entryClass, searchFilter, SearchScope.SUB, null, 0, count, 100);
    }

    @Override
    public <T> List<T> findEntries(Object entry) {
        return this.findEntries(entry, 0);
    }

    @Override
    public <T> List<T> findEntries(String baseDN, Class<T> entryClass, Filter filter) {
        return this.findEntries(baseDN, entryClass, filter, SearchScope.SUB, null, null, 0, 0, 0);
    }

    @Override
    public <T> List<T> findEntries(String baseDN, Class<T> entryClass, Filter filter, int count) {
        return this.findEntries(baseDN, entryClass, filter, SearchScope.SUB, null, null, 0, count, 0);
    }

    @Override
    public <T> List<T> findEntries(String baseDN, Class<T> entryClass, Filter filter, String[] ldapReturnAttributes) {
        return this.findEntries(baseDN, entryClass, filter, SearchScope.SUB, ldapReturnAttributes, null, 0, 0, 0);
    }

    @Override
    public <T> List<T> findEntries(String baseDN, Class<T> entryClass, Filter filter, String[] ldapReturnAttributes, int count) {
        return this.findEntries(baseDN, entryClass, filter, SearchScope.SUB, ldapReturnAttributes, null, 0, count, 0);
    }

    @Override
    public <T> List<T> findEntries(String baseDN, Class<T> entryClass, Filter filter, SearchScope scope, String[] ldapReturnAttributes, int start, int count, int chunkSize) {
        return this.findEntries(baseDN, entryClass, filter, scope, ldapReturnAttributes, null, start, count, chunkSize);
    }

    @Override
    public <T> int countEntries(Object entry) {
        if (entry == null) {
            throw new MappingException("Entry to count is null");
        }
        Class<?> entryClass = entry.getClass();
        this.checkEntryClass(entryClass, false);
        List<PropertyAnnotation> propertiesAnnotations = this.getEntryPropertyAnnotations(entryClass);
        Object dnValue = this.getDNValue(entry, entryClass);
        List<AttributeData> attributes = this.getAttributesListForPersist(entry, propertiesAnnotations);
        Filter searchFilter = this.createFilterByEntry(entry, entryClass, attributes);
        return this.countEntries(dnValue.toString(), entryClass, searchFilter);
    }

    protected Void merge(Object entry, boolean isSchemaUpdate, boolean isConfigurationUpdate, AttributeDataModification.AttributeModificationType schemaModificationType) {
        if (entry == null) {
            throw new MappingException("Entry for check if exists is null");
        }
        Class<?> entryClass = entry.getClass();
        this.checkEntryClass(entryClass, isSchemaUpdate);
        boolean forceUpdate = this.isUseEntryForceUpdate(entryClass);
        String[] objectClasses = this.getObjectClasses(entry, entryClass);
        List<PropertyAnnotation> propertiesAnnotations = this.getEntryPropertyAnnotations(entryClass);
        Map<String, PropertyAnnotation> propertiesAnnotationsMap = this.prepareEntryPropertiesTypes(entryClass, propertiesAnnotations);
        Object dnValue = this.getDNValue(entry, entryClass);
        Integer expirationValue = this.getExpirationValue(entry, entryClass, true);
        List<AttributeData> attributesToPersist = this.getAttributesListForPersist(entry, propertiesAnnotations);
        Map<String, AttributeData> attributesToPersistMap = this.getAttributesMap(attributesToPersist);
        List<AttributeData> attributesFromLdap = null;
        if (isSchemaUpdate || forceUpdate) {
            attributesFromLdap = new ArrayList<AttributeData>();
        } else {
            List<String> currentLdapReturnAttributesList = this.buildAttributesListForUpdate(entry, objectClasses, propertiesAnnotations);
            if (!isConfigurationUpdate) {
                currentLdapReturnAttributesList.add(OBJECT_CLASS);
            }
            attributesFromLdap = this.find(dnValue.toString(), objectClasses, propertiesAnnotationsMap, currentLdapReturnAttributesList.toArray(EMPTY_STRING_ARRAY));
        }
        if (LOG.isTraceEnabled()) {
            this.dumpAttributes("attributesFromLdap", attributesFromLdap);
            this.dumpAttributes("attributesToPersist", attributesToPersist);
        }
        Map<String, AttributeData> attributesFromLdapMap = this.getAttributesMap(attributesFromLdap);
        List<AttributeDataModification> attributeDataModifications = this.collectAttributeModifications(propertiesAnnotations, attributesToPersistMap, attributesFromLdapMap, isSchemaUpdate, schemaModificationType, forceUpdate);
        if (LOG.isTraceEnabled()) {
            this.dumpAttributeDataModifications("attributeDataModifications before updateMergeChanges", attributeDataModifications);
        }
        this.updateMergeChanges(dnValue.toString(), entry, isSchemaUpdate | isConfigurationUpdate, entryClass, attributesFromLdapMap, attributeDataModifications, forceUpdate);
        if (LOG.isTraceEnabled()) {
            this.dumpAttributeDataModifications("attributeDataModifications after updateMergeChanges", attributeDataModifications);
        }
        LOG.debug(String.format("LDAP attributes for merge: %s", attributeDataModifications));
        this.merge(dnValue.toString(), objectClasses, attributeDataModifications, expirationValue);
        return null;
    }

    protected List<String> buildAttributesListForUpdate(Object entry, String[] objectClasses, List<PropertyAnnotation> propertiesAnnotations) {
        return this.getAttributesList(entry, propertiesAnnotations, false);
    }

    protected abstract <T> void updateMergeChanges(String var1, T var2, boolean var3, Class<?> var4, Map<String, AttributeData> var5, List<AttributeDataModification> var6, boolean var7);

    protected List<AttributeDataModification> collectAttributeModifications(List<PropertyAnnotation> propertiesAnnotations, Map<String, AttributeData> attributesToPersistMap, Map<String, AttributeData> attributesFromLdapMap, boolean isSchemaUpdate, AttributeDataModification.AttributeModificationType schemaModificationType, boolean forceUpdate) {
        ArrayList<AttributeDataModification> attributeDataModifications = new ArrayList<AttributeDataModification>();
        for (PropertyAnnotation propertiesAnnotation : propertiesAnnotations) {
            String propertyName = propertiesAnnotation.getPropertyName();
            Annotation ldapAttribute = ReflectHelper.getAnnotationByType(propertiesAnnotation.getAnnotations(), AttributeName.class);
            if (ldapAttribute == null) continue;
            String ldapAttributeName = ((AttributeName)ldapAttribute).name();
            if (StringHelper.isEmpty((String)ldapAttributeName)) {
                ldapAttributeName = propertyName;
            }
            ldapAttributeName = ldapAttributeName.toLowerCase();
            AttributeData attributeToPersist = attributesToPersistMap.get(ldapAttributeName);
            AttributeData attributeFromLdap = attributesFromLdapMap.get(ldapAttributeName);
            attributesToPersistMap.remove(ldapAttributeName);
            attributesFromLdapMap.remove(ldapAttributeName);
            AttributeName ldapAttributeAnnotation = (AttributeName)ldapAttribute;
            if (ldapAttributeAnnotation.ignoreDuringUpdate()) continue;
            if (attributeFromLdap != null && attributeToPersist != null) {
                if (attributeFromLdap.equals(attributeToPersist)) continue;
                if (this.isEmptyAttributeValues(attributeToPersist) && !ldapAttributeAnnotation.updateOnly()) {
                    attributeDataModifications.add(new AttributeDataModification(AttributeDataModification.AttributeModificationType.REMOVE, null, attributeFromLdap));
                    continue;
                }
                attributeDataModifications.add(new AttributeDataModification(AttributeDataModification.AttributeModificationType.REPLACE, attributeToPersist, attributeFromLdap));
                continue;
            }
            if (attributeFromLdap == null && attributeToPersist != null) {
                AttributeDataModification.AttributeModificationType modType;
                if (isSchemaUpdate && attributeToPersist.getValue() == null && Arrays.equals(attributeToPersist.getValues(), new Object[0])) continue;
                AttributeDataModification.AttributeModificationType attributeModificationType = modType = isSchemaUpdate ? schemaModificationType : AttributeDataModification.AttributeModificationType.ADD;
                if (AttributeDataModification.AttributeModificationType.ADD == modType) {
                    if (this.isEmptyAttributeValues(attributeToPersist)) {
                        if (!forceUpdate) continue;
                        attributeDataModifications.add(new AttributeDataModification(AttributeDataModification.AttributeModificationType.REMOVE, null, attributeToPersist));
                        continue;
                    }
                    modType = forceUpdate ? AttributeDataModification.AttributeModificationType.FORCE_UPDATE : modType;
                    attributeDataModifications.add(new AttributeDataModification(modType, attributeToPersist));
                    continue;
                }
                attributeDataModifications.add(new AttributeDataModification(AttributeDataModification.AttributeModificationType.REMOVE, null, attributeToPersist));
                continue;
            }
            if (attributeFromLdap != null && attributeToPersist == null) {
                if (ldapAttributeAnnotation.ignoreDuringRead() || ldapAttributeAnnotation.updateOnly() || this.isEmptyAttributeValues(attributeFromLdap) && this.isStoreFullEntry()) continue;
                attributeDataModifications.add(new AttributeDataModification(AttributeDataModification.AttributeModificationType.REMOVE, null, attributeFromLdap));
                continue;
            }
            if (!forceUpdate || attributeFromLdap != null || attributeToPersist != null) continue;
            attributeDataModifications.add(new AttributeDataModification(AttributeDataModification.AttributeModificationType.REMOVE, null, new AttributeData(ldapAttributeName, null)));
        }
        for (PropertyAnnotation propertiesAnnotation : propertiesAnnotations) {
            AttributeName ldapAttributeConfiguration2;
            Annotation ldapAttribute = ReflectHelper.getAnnotationByType(propertiesAnnotation.getAnnotations(), AttributesList.class);
            if (ldapAttribute == null) continue;
            HashMap<String, AttributeName> ldapAttributesConfiguration = new HashMap<String, AttributeName>();
            for (AttributeName ldapAttributeConfiguration2 : ((AttributesList)ldapAttribute).attributesConfiguration()) {
                ldapAttributesConfiguration.put(ldapAttributeConfiguration2.name(), ldapAttributeConfiguration2);
            }
            for (AttributeData attributeFromLdap : attributesFromLdapMap.values()) {
                String attributeName = attributeFromLdap.getName();
                if (OBJECT_CLASS.equalsIgnoreCase(attributeName) || (ldapAttributeConfiguration2 = (AttributeName)ldapAttributesConfiguration.get(attributeName)) != null && ldapAttributeConfiguration2.ignoreDuringUpdate() || attributesToPersistMap.containsKey(attributeName.toLowerCase()) || ldapAttributeConfiguration2 != null && (ldapAttributeConfiguration2 == null || ldapAttributeConfiguration2.ignoreDuringRead())) continue;
                attributeDataModifications.add(new AttributeDataModification(AttributeDataModification.AttributeModificationType.REMOVE, null, attributeFromLdap));
            }
            for (AttributeData attributeToPersist : attributesToPersistMap.values()) {
                String attributeName = attributeToPersist.getName();
                ldapAttributeConfiguration2 = (AttributeName)ldapAttributesConfiguration.get(attributeName);
                if (ldapAttributeConfiguration2 != null && ldapAttributeConfiguration2.ignoreDuringUpdate()) continue;
                AttributeData attributeFromLdap = attributesFromLdapMap.get(attributeName.toLowerCase());
                if (attributeFromLdap == null) {
                    AttributeDataModification.AttributeModificationType modType;
                    AttributeDataModification.AttributeModificationType attributeModificationType = modType = isSchemaUpdate ? schemaModificationType : AttributeDataModification.AttributeModificationType.ADD;
                    if (AttributeDataModification.AttributeModificationType.ADD.equals((Object)modType)) {
                        if (this.isEmptyAttributeValues(attributeToPersist)) continue;
                        attributeDataModifications.add(new AttributeDataModification(AttributeDataModification.AttributeModificationType.ADD, attributeToPersist));
                        continue;
                    }
                    attributeDataModifications.add(new AttributeDataModification(AttributeDataModification.AttributeModificationType.REMOVE, null, attributeToPersist));
                    continue;
                }
                if (attributeFromLdap != null && this.isEmptyAttributeValues(attributeToPersist)) {
                    if (this.isEmptyAttributeValues(attributeFromLdap) && this.isStoreFullEntry()) continue;
                    attributeDataModifications.add(new AttributeDataModification(AttributeDataModification.AttributeModificationType.REMOVE, null, attributeFromLdap));
                    continue;
                }
                if (attributeFromLdap.equals(attributeToPersist)) continue;
                if (this.isEmptyAttributeValues(attributeToPersist) && (ldapAttributeConfiguration2 == null || !ldapAttributeConfiguration2.updateOnly())) {
                    if (this.isEmptyAttributeValues(attributeFromLdap) && this.isStoreFullEntry()) continue;
                    attributeDataModifications.add(new AttributeDataModification(AttributeDataModification.AttributeModificationType.REMOVE, null, attributeFromLdap));
                    continue;
                }
                attributeDataModifications.add(new AttributeDataModification(AttributeDataModification.AttributeModificationType.REPLACE, attributeToPersist, attributeFromLdap));
            }
        }
        return attributeDataModifications;
    }

    protected boolean isStoreFullEntry() {
        return false;
    }

    protected boolean isEmptyAttributeValues(AttributeData attributeData) {
        Object[] attributeToPersistValues = attributeData.getValues();
        return ArrayHelper.isEmpty((Object[])attributeToPersistValues) || attributeToPersistValues.length == 1 && StringHelper.isEmpty((String)String.valueOf(attributeToPersistValues[0]));
    }

    protected abstract void merge(String var1, String[] var2, List<AttributeDataModification> var3, Integer var4);

    @Override
    public abstract <T> void removeByDn(String var1, String[] var2);

    @Override
    @Deprecated
    public void remove(String primaryKey) {
        this.removeByDn(primaryKey, null);
    }

    @Override
    public <T> void remove(String primaryKey, Class<T> entryClass) {
        String[] objectClasses = null;
        if (entryClass != null) {
            this.checkEntryClass(entryClass, false);
            objectClasses = this.getTypeObjectClasses(entryClass);
        }
        this.removeByDn(primaryKey, objectClasses);
    }

    @Override
    public abstract <T> void removeRecursivelyFromDn(String var1, String[] var2);

    @Override
    @Deprecated
    public void removeRecursively(String primaryKey) {
        this.removeRecursivelyFromDn(primaryKey, null);
    }

    @Override
    public <T> void removeRecursively(String primaryKey, Class<T> entryClass) {
        String[] objectClasses = null;
        if (entryClass != null) {
            this.checkEntryClass(entryClass, false);
            objectClasses = this.getTypeObjectClasses(entryClass);
        }
        this.removeRecursivelyFromDn(primaryKey, objectClasses);
    }

    @Override
    public boolean contains(Object entry) {
        if (entry == null) {
            throw new MappingException("Entry for check if exists is null");
        }
        Class<?> entryClass = entry.getClass();
        this.checkEntryClass(entryClass, false);
        String[] objectClasses = this.getObjectClasses(entry, entryClass);
        List<PropertyAnnotation> propertiesAnnotations = this.getEntryPropertyAnnotations(entryClass);
        Object dnValue = this.getDNValue(entry, entryClass);
        List<AttributeData> attributes = this.getAttributesListForPersist(entry, propertiesAnnotations);
        String[] ldapReturnAttributes = this.getAttributes(null, propertiesAnnotations, false);
        return this.contains(dnValue.toString(), entryClass, propertiesAnnotations, attributes, objectClasses, ldapReturnAttributes);
    }

    protected <T> boolean contains(Class<T> entryClass, String primaryKey, String[] ldapReturnAttributes) {
        if (StringHelper.isEmptyString((Object)primaryKey)) {
            throw new MappingException("DN to find entry is null");
        }
        this.checkEntryClass(entryClass, true);
        String[] objectClasses = this.getTypeObjectClasses(entryClass);
        List<PropertyAnnotation> propertiesAnnotations = this.getEntryPropertyAnnotations(entryClass);
        Map<String, PropertyAnnotation> propertiesAnnotationsMap = this.prepareEntryPropertiesTypes(entryClass, propertiesAnnotations);
        try {
            List<AttributeData> results = this.find(primaryKey, objectClasses, propertiesAnnotationsMap, ldapReturnAttributes);
            return results != null && results.size() > 0;
        }
        catch (EntryPersistenceException ex) {
            return false;
        }
    }

    @Override
    public <T> boolean contains(String baseDN, Class<T> entryClass, Filter filter) {
        this.checkEntryClass(entryClass, false);
        String[] objectClasses = this.getTypeObjectClasses(entryClass);
        List<PropertyAnnotation> propertiesAnnotations = this.getEntryPropertyAnnotations(entryClass);
        String[] ldapReturnAttributes = this.getAttributes(null, propertiesAnnotations, false);
        return this.contains(baseDN, objectClasses, entryClass, propertiesAnnotations, filter, ldapReturnAttributes);
    }

    protected <T> boolean contains(String baseDN, Class<T> entryClass, List<PropertyAnnotation> propertiesAnnotations, List<AttributeData> attributes, String[] objectClasses, String ... ldapReturnAttributes) {
        Filter[] attributesFilters = this.createAttributesFilter(attributes);
        Filter attributesFilter = null;
        if (attributesFilters != null) {
            attributesFilter = Filter.createANDFilter((Filter[])attributesFilters);
        }
        return this.contains(baseDN, objectClasses, entryClass, propertiesAnnotations, attributesFilter, ldapReturnAttributes);
    }

    protected abstract <T> boolean contains(String var1, String[] var2, Class<T> var3, List<PropertyAnnotation> var4, Filter var5, String[] var6);

    @Override
    public <T> boolean contains(String primaryKey, Class<T> entryClass) {
        return this.contains(entryClass, primaryKey, (String[])null);
    }

    public <T> T find(Class<T> entryClass, Object primaryKey) {
        return this.find(primaryKey, entryClass, null);
    }

    @Override
    public <T> T find(Object primaryKey, Class<T> entryClass, String[] ldapReturnAttributes) {
        if (StringHelper.isEmptyString((Object)primaryKey)) {
            throw new MappingException("DN to find entry is null");
        }
        this.checkEntryClass(entryClass, true);
        List<PropertyAnnotation> propertiesAnnotations = this.getEntryPropertyAnnotations(entryClass);
        Map<String, PropertyAnnotation> propertiesAnnotationsMap = this.prepareEntryPropertiesTypes(entryClass, propertiesAnnotations);
        return this.find(entryClass, primaryKey, ldapReturnAttributes, propertiesAnnotations, propertiesAnnotationsMap);
    }

    protected <T> String[] getAttributes(T entry, List<PropertyAnnotation> propertiesAnnotations, boolean isIgnoreAttributesList) {
        List<String> attributes = this.getAttributesList(entry, propertiesAnnotations, isIgnoreAttributesList);
        if (attributes == null) {
            return null;
        }
        return attributes.toArray(new String[0]);
    }

    protected <T> String[] getAttributes(Map<String, PropertyAnnotation> attributesMap) {
        if (attributesMap == null) {
            return null;
        }
        return attributesMap.keySet().toArray(new String[0]);
    }

    protected <T> List<String> getAttributesList(T entry, List<PropertyAnnotation> propertiesAnnotations, boolean isIgnoreAttributesList) {
        Map<String, PropertyAnnotation> attributesMap = this.getAttributesMap(entry, propertiesAnnotations, isIgnoreAttributesList);
        if (attributesMap == null) {
            return null;
        }
        return new ArrayList<String>(attributesMap.keySet());
    }

    protected <T> Map<String, PropertyAnnotation> getAttributesMap(T entry, List<PropertyAnnotation> propertiesAnnotations, boolean isIgnoreAttributesList) {
        HashMap<String, PropertyAnnotation> attributes = new HashMap<String, PropertyAnnotation>();
        for (PropertyAnnotation propertiesAnnotation : propertiesAnnotations) {
            Annotation ldapAttribute;
            String propertyName = propertiesAnnotation.getPropertyName();
            if (!isIgnoreAttributesList && (ldapAttribute = ReflectHelper.getAnnotationByType(propertiesAnnotation.getAnnotations(), AttributesList.class)) != null) {
                if (entry == null) {
                    return null;
                }
                List<AttributeData> attributesList = this.getAttributeDataListFromCustomAttributesList(entry, (AttributesList)ldapAttribute, propertyName);
                for (AttributeData attributeData : attributesList) {
                    String ldapAttributeName = attributeData.getName();
                    if (attributes.containsKey(ldapAttributeName)) continue;
                    attributes.put(ldapAttributeName, propertiesAnnotation);
                }
            }
            if ((ldapAttribute = ReflectHelper.getAnnotationByType(propertiesAnnotation.getAnnotations(), AttributeName.class)) == null) continue;
            String ldapAttributeName = ((AttributeName)ldapAttribute).name();
            if (StringHelper.isEmpty((String)ldapAttributeName)) {
                ldapAttributeName = propertyName;
            }
            if (attributes.containsKey(ldapAttributeName)) continue;
            attributes.put(ldapAttributeName, propertiesAnnotation);
        }
        if (attributes.size() == 0) {
            return null;
        }
        return attributes;
    }

    protected <T> Map<String, PropertyAnnotation> prepareEntryPropertiesTypes(Class<T> entryClass, List<PropertyAnnotation> propertiesAnnotations) {
        Map<String, PropertyAnnotation> propertiesAnnotationsMap = this.getAttributesMap(null, propertiesAnnotations, true);
        if (propertiesAnnotationsMap == null) {
            return new HashMap<String, PropertyAnnotation>(0);
        }
        this.preparePropertyAnnotationTypes(entryClass, propertiesAnnotationsMap);
        return propertiesAnnotationsMap;
    }

    protected <T> void preparePropertyAnnotationTypes(Class<T> entry, Map<String, PropertyAnnotation> propertiesAnnotationsMap) {
        for (PropertyAnnotation propertiesAnnotation : propertiesAnnotationsMap.values()) {
            String propertyName = propertiesAnnotation.getPropertyName();
            Class<?> parameterType = this.getSetterPropertyType(entry, propertyName);
            propertiesAnnotation.setParameterType(parameterType);
        }
    }

    private <T> Class<?> getSetterPropertyType(Class<T> entry, String propertyName) {
        Setter propertyValueSetter = this.getSetter(entry, propertyName);
        if (propertyValueSetter == null) {
            throw new MappingException("Entry should has setter for property " + propertyName);
        }
        Class<?> parameterType = ReflectHelper.getSetterType(propertyValueSetter);
        return parameterType;
    }

    private <T> T find(Class<T> entryClass, Object primaryKey, String[] ldapReturnAttributes, List<PropertyAnnotation> propertiesAnnotations, Map<String, PropertyAnnotation> propertiesAnnotationsMap) {
        HashMap<String, List<AttributeData>> entriesAttributes = new HashMap<String, List<AttributeData>>();
        Object[] currentLdapReturnAttributes = ldapReturnAttributes;
        if (ArrayHelper.isEmpty((Object[])currentLdapReturnAttributes)) {
            currentLdapReturnAttributes = this.getAttributes(null, propertiesAnnotations, false);
        }
        String[] objectClasses = this.getTypeObjectClasses(entryClass);
        List<AttributeData> ldapAttributes = this.find(primaryKey.toString(), objectClasses, propertiesAnnotationsMap, (String[])currentLdapReturnAttributes);
        entriesAttributes.put(String.valueOf(primaryKey), ldapAttributes);
        List<T> results = this.createEntities(entryClass, propertiesAnnotations, entriesAttributes);
        return results.get(0);
    }

    protected abstract List<AttributeData> find(String var1, String[] var2, Map<String, PropertyAnnotation> var3, String ... var4);

    protected boolean checkEntryClass(Class<?> entryClass, boolean isAllowSchemaEntry) {
        if (entryClass == null) {
            throw new MappingException("Entry class is null");
        }
        List<Annotation> entryAnnotations = ReflectHelper.getClassAnnotations(entryClass, LDAP_ENTRY_TYPE_ANNOTATIONS);
        Annotation ldapSchemaEntry = ReflectHelper.getAnnotationByType(entryAnnotations, SchemaEntry.class);
        Annotation ldapEntry = ReflectHelper.getAnnotationByType(entryAnnotations, DataEntry.class);
        if (isAllowSchemaEntry) {
            if (ldapSchemaEntry == null && ldapEntry == null) {
                throw new MappingException(String.format("Entry should has DataEntry or SchemaEntry annotation", entryClass));
            }
        } else if (ldapEntry == null) {
            throw new MappingException(String.format("Entry '%s' should has DataEntry annotation", entryClass));
        }
        return true;
    }

    protected boolean isUseEntryForceUpdate(Class<?> entryClass) {
        if (!this.isSupportForceUpdate()) {
            return false;
        }
        if (entryClass == null) {
            throw new MappingException("Entry class is null");
        }
        List<Annotation> entryAnnotations = ReflectHelper.getClassAnnotations(entryClass, LDAP_ENTRY_TYPE_ANNOTATIONS);
        Annotation dataEntry = ReflectHelper.getAnnotationByType(entryAnnotations, DataEntry.class);
        if (dataEntry == null) {
            return false;
        }
        return ((DataEntry)dataEntry).forceUpdate();
    }

    protected boolean isSupportForceUpdate() {
        return false;
    }

    protected boolean isSchemaEntry(Class<?> entryClass) {
        if (entryClass == null) {
            throw new MappingException("Entry class is null");
        }
        List<Annotation> entryAnnotations = ReflectHelper.getClassAnnotations(entryClass, LDAP_ENTRY_TYPE_ANNOTATIONS);
        return ReflectHelper.getAnnotationByType(entryAnnotations, SchemaEntry.class) != null;
    }

    protected boolean isConfigurationEntry(Class<?> entryClass) {
        if (entryClass == null) {
            throw new MappingException("Entry class is null");
        }
        List<Annotation> entryAnnotations = ReflectHelper.getClassAnnotations(entryClass, LDAP_ENTRY_TYPE_ANNOTATIONS);
        DataEntry dataEntry = (DataEntry)ReflectHelper.getAnnotationByType(entryAnnotations, DataEntry.class);
        if (dataEntry == null) {
            return false;
        }
        return dataEntry.configurationDefinition();
    }

    protected String[] getEntrySortByProperties(Class<?> entryClass) {
        if (entryClass == null) {
            throw new MappingException("Entry class is null");
        }
        List<Annotation> entryAnnotations = ReflectHelper.getClassAnnotations(entryClass, LDAP_ENTRY_TYPE_ANNOTATIONS);
        Annotation annotation = ReflectHelper.getAnnotationByType(entryAnnotations, DataEntry.class);
        if (annotation == null) {
            return null;
        }
        return ((DataEntry)annotation).sortBy();
    }

    protected String[] getEntrySortByNames(Class<?> entryClass) {
        if (entryClass == null) {
            throw new MappingException("Entry class is null");
        }
        List<Annotation> entryAnnotations = ReflectHelper.getClassAnnotations(entryClass, LDAP_ENTRY_TYPE_ANNOTATIONS);
        Annotation annotation = ReflectHelper.getAnnotationByType(entryAnnotations, DataEntry.class);
        if (annotation == null) {
            return null;
        }
        return ((DataEntry)annotation).sortByName();
    }

    @Override
    public String[] getObjectClasses(Object entry, Class<?> entryClass) {
        Object[] typeObjectClasses = this.getTypeObjectClasses(entryClass);
        String[] customObjectClasses = this.getCustomObjectClasses(entry, entryClass);
        if (ArrayHelper.isEmpty((Object[])typeObjectClasses)) {
            return customObjectClasses;
        }
        String[] mergedArray = (String[])ArrayHelper.arrayMerge((Object[][])new String[][]{typeObjectClasses, customObjectClasses});
        HashSet<String> objecClassSet = new HashSet<String>();
        objecClassSet.addAll(Arrays.asList(mergedArray));
        return objecClassSet.toArray(new String[0]);
    }

    protected String[] getTypeObjectClasses(Class<?> entryClass) {
        List<Annotation> entryAnnotations = ReflectHelper.getClassAnnotations(entryClass, LDAP_ENTRY_TYPE_ANNOTATIONS);
        Annotation ldapObjectClass = ReflectHelper.getAnnotationByType(entryAnnotations, ObjectClass.class);
        if (ldapObjectClass == null) {
            return EMPTY_STRING_ARRAY;
        }
        if (StringHelper.isEmpty((String)((ObjectClass)ldapObjectClass).value())) {
            return EMPTY_STRING_ARRAY;
        }
        return new String[]{((ObjectClass)ldapObjectClass).value()};
    }

    protected String[] getCustomObjectClasses(Object entry, Class<?> entryClass) {
        ArrayList<String> result = new ArrayList<String>();
        List<PropertyAnnotation> customObjectAnnotations = this.getEntryCustomObjectClassAnnotations(entryClass);
        Iterator<PropertyAnnotation> iterator = customObjectAnnotations.iterator();
        if (iterator.hasNext()) {
            PropertyAnnotation propertiesAnnotation = iterator.next();
            String propertyName = propertiesAnnotation.getPropertyName();
            Getter getter = this.getGetter(entryClass, propertyName);
            if (getter == null) {
                throw new MappingException("Entry should has getter for property " + propertyName);
            }
            Class<?> parameterType = this.getSetterPropertyType(entryClass, propertyName);
            boolean multiValued = this.isMultiValued(parameterType);
            AttributeData attribute = this.getAttributeData(propertyName, propertyName, getter, entry, multiValued, false);
            if (attribute != null) {
                for (String objectClass : attribute.getStringValues()) {
                    if (objectClass == null) continue;
                    result.add(objectClass);
                }
            }
        }
        return result.toArray(new String[0]);
    }

    protected void setCustomObjectClasses(Object entry, Class<?> entryClass, String[] objectClasses) {
        block1: {
            List<PropertyAnnotation> customObjectAnnotations = this.getEntryCustomObjectClassAnnotations(entryClass);
            Iterator<PropertyAnnotation> iterator = customObjectAnnotations.iterator();
            if (!iterator.hasNext()) break block1;
            PropertyAnnotation propertiesAnnotation = iterator.next();
            String propertyName = propertiesAnnotation.getPropertyName();
            Setter setter = this.getSetter(entryClass, propertyName);
            if (setter == null) {
                throw new MappingException("Entry should has setter for property " + propertyName);
            }
            AttributeData attribute = new AttributeData(propertyName, objectClasses);
            this.setPropertyValue(propertyName, setter, entry, attribute, false);
        }
    }

    protected String getDNPropertyName(Class<?> entryClass) {
        List<PropertyAnnotation> propertiesAnnotations = this.getEntryDnAnnotations(entryClass);
        if (propertiesAnnotations.size() == 0) {
            throw new MappingException("Entry should has property with annotation DN");
        }
        if (propertiesAnnotations.size() > 1) {
            throw new MappingException("Entry should has only one property with annotation DN");
        }
        return propertiesAnnotations.get(0).getPropertyName();
    }

    protected PropertyAnnotation getExpirationProperty(Class<?> entryClass) {
        List<PropertyAnnotation> propertiesAnnotations = this.getEntryExpirationAnnotations(entryClass);
        if (propertiesAnnotations.size() == 0) {
            return null;
        }
        if (propertiesAnnotations.size() > 1) {
            throw new MappingException("Entry should has only one property with annotation Expiration");
        }
        return propertiesAnnotations.get(0);
    }

    protected <T> List<T> createEntities(Class<T> entryClass, List<PropertyAnnotation> propertiesAnnotations, Map<String, List<AttributeData>> entriesAttributes) {
        return this.createEntities(entryClass, propertiesAnnotations, entriesAttributes, true);
    }

    protected <T> List<T> createEntities(Class<T> entryClass, List<PropertyAnnotation> propertiesAnnotations, Map<String, List<AttributeData>> entriesAttributes, boolean doSort) {
        String dnProperty = this.getDNPropertyName(entryClass);
        Setter dnSetter = this.getSetter(entryClass, dnProperty);
        if (dnSetter == null) {
            throw new MappingException("Entry should has getter for property " + dnProperty);
        }
        Object[] typeObjectClasses = this.getTypeObjectClasses(entryClass);
        Arrays.sort(typeObjectClasses);
        ArrayList<T> results = new ArrayList<T>(entriesAttributes.size());
        for (Map.Entry<String, List<AttributeData>> entryAttributes : entriesAttributes.entrySet()) {
            Annotation ldapAttribute;
            String propertyName;
            Object entry;
            String dn = entryAttributes.getKey();
            List<AttributeData> attributes = entryAttributes.getValue();
            Map<String, AttributeData> attributesMap = this.getAttributesMap(attributes);
            ArrayList<Object> customObjectClasses = null;
            try {
                Class<?> declaringClass = entryClass.getDeclaringClass();
                entry = declaringClass == null ? ReflectHelper.createObjectByDefaultConstructor(entryClass) : ReflectHelper.getConstructor(entryClass, declaringClass).newInstance(new Object[]{null});
            }
            catch (Exception ex) {
                throw new MappingException(String.format("Entry %s should has default constructor", entryClass));
            }
            results.add(entry);
            dnSetter.set(entry, dn);
            attributesMap.remove(dnProperty);
            for (PropertyAnnotation propertiesAnnotation : propertiesAnnotations) {
                propertyName = propertiesAnnotation.getPropertyName();
                ldapAttribute = ReflectHelper.getAnnotationByType(propertiesAnnotation.getAnnotations(), AttributeName.class);
                Annotation languageTag = ReflectHelper.getAnnotationByType(propertiesAnnotation.getAnnotations(), LanguageTag.class);
                if (ldapAttribute == null) continue;
                Object ldapAttributeName = ((AttributeName)ldapAttribute).name();
                if (StringHelper.isEmpty((String)ldapAttributeName)) {
                    ldapAttributeName = propertyName;
                }
                if (languageTag != null) {
                    Getter getter = this.getGetter(entryClass, propertyName);
                    if (getter == null) {
                        throw new MappingException("Entry should has getter for property " + propertyName);
                    }
                    Object propertyValue = getter.get(entry);
                    if (propertyValue == null) {
                        return null;
                    }
                    if (!(propertyValue instanceof LocalizedString)) {
                        throw new MappingException("Entry property should be LocalizedString");
                    }
                    LocalizedString localizedString = (LocalizedString)propertyValue;
                    String finalLdapAttributeName = ((String)ldapAttributeName).replace("Localized", "");
                    Map<String, AttributeData> filteredAttrs = attributesMap.entrySet().stream().filter(x -> ((String)x.getKey()).toLowerCase().startsWith(finalLdapAttributeName.toLowerCase())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                    this.loadLocalizedString(attributesMap, localizedString, filteredAttrs);
                    continue;
                }
                ldapAttributeName = ((String)ldapAttributeName).toLowerCase();
                AttributeData attributeData = attributesMap.get(ldapAttributeName);
                attributesMap.remove(ldapAttributeName);
                if (((AttributeName)ldapAttribute).ignoreDuringRead()) continue;
                Setter setter = this.getSetter(entryClass, propertyName);
                if (setter == null) {
                    throw new MappingException("Entry should has setter for property " + propertyName);
                }
                Annotation ldapJsonObject = ReflectHelper.getAnnotationByType(propertiesAnnotation.getAnnotations(), JsonObject.class);
                boolean jsonObject = ldapJsonObject != null;
                this.setPropertyValue(propertyName, setter, entry, attributeData, jsonObject);
            }
            for (PropertyAnnotation propertiesAnnotation : propertiesAnnotations) {
                propertyName = propertiesAnnotation.getPropertyName();
                ldapAttribute = ReflectHelper.getAnnotationByType(propertiesAnnotation.getAnnotations(), AttributesList.class);
                if (ldapAttribute == null) continue;
                HashMap<String, AttributeName> ldapAttributesConfiguration = new HashMap<String, AttributeName>();
                for (AttributeName ldapAttributeConfiguration : ((AttributesList)ldapAttribute).attributesConfiguration()) {
                    ldapAttributesConfiguration.put(ldapAttributeConfiguration.name(), ldapAttributeConfiguration);
                }
                Iterator<Map.Entry<String, AttributeData>> it = attributesMap.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<String, AttributeData> attributeEntry = it.next();
                    AttributeData entryAttribute = attributeEntry.getValue();
                    if (!OBJECT_CLASS.equalsIgnoreCase(entryAttribute.getName())) continue;
                    it.remove();
                    Object[] objectClasses = entryAttribute.getStringValues();
                    if (ArrayHelper.isEmpty((Object[])objectClasses)) continue;
                    if (customObjectClasses == null) {
                        customObjectClasses = new ArrayList<Object>();
                    }
                    for (Object objectClass : objectClasses) {
                        int idx = Arrays.binarySearch(typeObjectClasses, objectClass, new Comparator<String>(){

                            @Override
                            public int compare(String o1, String o2) {
                                return o1.toLowerCase().compareTo(o2.toLowerCase());
                            }
                        });
                        if (idx >= 0) continue;
                        customObjectClasses.add(objectClass);
                    }
                }
                List<Object> propertyValue = this.getCustomAttributesListFromAttributeData(entryClass, (AttributesList)ldapAttribute, propertyName, attributesMap.values(), ldapAttributesConfiguration);
                Setter setter = this.getSetter(entryClass, propertyName);
                if (setter == null) {
                    throw new MappingException("Entry should has setter for property " + propertyName);
                }
                if (doSort) {
                    Class<?> entryItemType = ReflectHelper.getListType(setter);
                    if (entryItemType == null) {
                        throw new MappingException("Entry property " + propertyName + " should has setter with specified element type");
                    }
                    this.sortAttributesListIfNeeded((AttributesList)ldapAttribute, entryItemType, propertyValue);
                }
                setter.set(entry, propertyValue);
            }
            if (customObjectClasses == null || customObjectClasses.size() <= 0) continue;
            this.setCustomObjectClasses(entry, entryClass, customObjectClasses.toArray(new String[0]));
        }
        return results;
    }

    private <T> List<Object> getCustomAttributesListFromAttributeData(Class<T> entryClass, AttributesList attributesList, String propertyName, Collection<AttributeData> attributes, Map<String, AttributeName> ldapAttributesConfiguration) {
        Class<?> parameterType;
        ArrayList<Object> resultList = new ArrayList<Object>();
        Setter setter = this.getSetter(entryClass, propertyName);
        if (setter == null) {
            throw new MappingException("Entry should has setter for property " + propertyName);
        }
        Class<?> entryItemType = ReflectHelper.getListType(setter);
        if (entryItemType == null) {
            throw new MappingException("Entry property " + propertyName + " should has setter with specified element type");
        }
        String entryPropertyName = attributesList.name();
        Setter entryPropertyNameSetter = this.getSetter(entryItemType, entryPropertyName);
        if (entryPropertyNameSetter == null) {
            throw new MappingException("Entry should has setter for property " + propertyName + "." + entryPropertyName);
        }
        String entryPropertyValue = attributesList.value();
        Setter entryPropertyValueSetter = this.getSetter(entryItemType, entryPropertyValue);
        if (entryPropertyValueSetter == null) {
            throw new MappingException("Entry should has getter for property " + propertyName + "." + entryPropertyValue);
        }
        String entryPropertyMultivalued = attributesList.multiValued();
        Setter entryPropertyMultivaluedSetter = null;
        if (StringHelper.isNotEmpty((String)entryPropertyMultivalued)) {
            entryPropertyMultivaluedSetter = this.getSetter(entryItemType, entryPropertyMultivalued);
        }
        if (entryPropertyMultivaluedSetter != null && !(parameterType = ReflectHelper.getSetterType(entryPropertyMultivaluedSetter)).equals(Boolean.TYPE)) {
            throw new MappingException("Entry should has getter for property " + propertyName + "." + entryPropertyMultivalued + " with boolean type");
        }
        for (AttributeData entryAttribute : attributes) {
            Object listItem;
            AttributeName ldapAttributeConfiguration;
            if (ldapAttributesConfiguration != null && (ldapAttributeConfiguration = ldapAttributesConfiguration.get(entryAttribute.getName())) != null && ldapAttributeConfiguration.ignoreDuringRead() || (listItem = this.getListItem(propertyName, entryPropertyNameSetter, entryPropertyValueSetter, entryPropertyMultivaluedSetter, entryItemType, entryAttribute)) == null) continue;
            resultList.add(listItem);
        }
        return resultList;
    }

    @Override
    public Class<?> getCustomAttributesListItemType(Object entry, AttributesList attributesList, String propertyName) {
        Class<?> entryClass = entry.getClass();
        Setter setter = this.getSetter(entryClass, propertyName);
        if (setter == null) {
            throw new MappingException("Entry should has setter for property " + propertyName);
        }
        return ReflectHelper.getListType(setter);
    }

    protected void loadLocalizedString(Map<String, AttributeData> attributesMap, LocalizedString localizedString, Map<String, AttributeData> filteredAttrs) {
        filteredAttrs.forEach((key, value) -> {
            AttributeData data = (AttributeData)attributesMap.get(key);
            if (data.getValues() != null && data.getValues().length == 1) {
                if (data.getValues()[0] instanceof Map) {
                    Map values = (Map)data.getValues()[0];
                    values.forEach((languageTag, val) -> {
                        if (languageTag instanceof String && val instanceof String) {
                            localizedString.setValue((String)val, Locale.forLanguageTag((String)languageTag));
                        }
                    });
                } else if (data.getValues()[0] instanceof String) {
                    String jsonStr = (String)data.getValues()[0];
                    JSONObject jsonObject = new JSONObject(jsonStr);
                    localizedString.loadFromJson(jsonObject, key);
                }
            }
        });
    }

    @Override
    public <T> List<T> createEntities(Class<T> entryClass, Map<String, List<AttributeData>> entriesAttributes) {
        this.checkEntryClass(entryClass, true);
        List<PropertyAnnotation> propertiesAnnotations = this.getEntryPropertyAnnotations(entryClass);
        return this.createEntities(entryClass, propertiesAnnotations, entriesAttributes);
    }

    private <T> void sortAttributesListIfNeeded(AttributesList ldapAttribute, Class<T> entryItemType, List<?> list) {
        if (!ldapAttribute.sortByName()) {
            return;
        }
        this.sortListByProperties(entryItemType, list, ldapAttribute.name());
    }

    protected <T> void sortEntriesIfNeeded(Class<T> entryClass, List<T> entries) {
        Object[] sortByProperties = this.getEntrySortByProperties(entryClass);
        if (ArrayHelper.isEmpty((Object[])sortByProperties)) {
            return;
        }
        this.sortListByProperties(entryClass, entries, (String[])sortByProperties);
    }

    @Override
    public <T> void importEntry(String dn, Class<T> entryClass, List<AttributeData> data) {
        this.checkEntryClass(entryClass, false);
        String[] objectClasses = this.getTypeObjectClasses(entryClass);
        this.persist(dn, objectClasses, data, 0);
    }

    @Override
    public <T> void sortListByProperties(Class<T> entryClass, List<T> entries, boolean caseSensetive, String ... sortByProperties) {
        if (entries == null) {
            throw new MappingException("Entries list to sort is null");
        }
        if (entries.size() == 0) {
            return;
        }
        if (sortByProperties == null || sortByProperties.length == 0) {
            throw new InvalidArgumentException("Invalid list of sortBy properties " + Arrays.toString(sortByProperties));
        }
        List<PropertyAnnotation> propertiesAnnotations = this.getEntryPropertyAnnotations(entryClass);
        Getter[][] propertyGetters = new Getter[sortByProperties.length][];
        for (int i = 0; i < sortByProperties.length; ++i) {
            String[] tmpProperties = sortByProperties[i].split("\\.");
            propertyGetters[i] = new Getter[tmpProperties.length];
            Class<Object> currentEntryClass = entryClass;
            for (int j = 0; j < tmpProperties.length; ++j) {
                if (j > 0) {
                    currentEntryClass = propertyGetters[i][j - 1].getReturnType();
                }
                String beanProperty = this.resolveBeanPropertyByAttribute(propertiesAnnotations, tmpProperties[j]);
                propertyGetters[i][j] = this.getGetter(currentEntryClass, beanProperty);
            }
            if (propertyGetters[i][tmpProperties.length - 1] == null) {
                throw new MappingException("Entry should has getteres for all properties " + sortByProperties[i]);
            }
            Class<?> propertyType = propertyGetters[i][tmpProperties.length - 1].getReturnType();
            if (propertyType == String.class || propertyType == Date.class || propertyType == Integer.class || propertyType == Integer.TYPE) continue;
            throw new MappingException("Entry properties should has String, Date or Integer type. Property: '" + tmpProperties[tmpProperties.length - 1] + "'");
        }
        PropertyComparator comparator = new PropertyComparator(propertyGetters, caseSensetive);
        Collections.sort(entries, comparator);
    }

    protected <T> void sortListByProperties(Class<T> entryClass, List<T> entries, String ... sortByProperties) {
        this.sortListByProperties(entryClass, entries, false, sortByProperties);
    }

    @Override
    public <T> Map<T, List<T>> groupListByProperties(Class<T> entryClass, List<T> entries, boolean caseSensetive, String groupByProperties, String sumByProperties) {
        if (entries == null) {
            throw new MappingException("Entries list to group is null");
        }
        if (entries.size() == 0) {
            return new HashMap(0);
        }
        if (StringHelper.isEmpty((String)groupByProperties)) {
            throw new InvalidArgumentException("List of groupBy properties is null");
        }
        Getter[] groupPropertyGetters = this.getEntryPropertyGetters(entryClass, groupByProperties, GROUP_BY_ALLOWED_DATA_TYPES);
        Setter[] groupPropertySetters = this.getEntryPropertySetters(entryClass, groupByProperties, GROUP_BY_ALLOWED_DATA_TYPES);
        Getter[] sumPropertyGetters = this.getEntryPropertyGetters(entryClass, sumByProperties, SUM_BY_ALLOWED_DATA_TYPES);
        Setter[] sumPropertySetter = this.getEntryPropertySetters(entryClass, sumByProperties, SUM_BY_ALLOWED_DATA_TYPES);
        return this.groupListByPropertiesImpl(entryClass, entries, caseSensetive, groupPropertyGetters, groupPropertySetters, sumPropertyGetters, sumPropertySetter);
    }

    private <T> Getter[] getEntryPropertyGetters(Class<T> entryClass, String properties, Class<?>[] allowedTypes) {
        if (StringHelper.isEmpty((String)properties)) {
            return null;
        }
        String[] tmpProperties = properties.split("\\,");
        Getter[] propertyGetters = new Getter[tmpProperties.length];
        for (int i = 0; i < tmpProperties.length; ++i) {
            propertyGetters[i] = this.getGetter(entryClass, tmpProperties[i].trim());
            if (propertyGetters[i] == null) {
                throw new MappingException("Entry should has getter for property " + tmpProperties[i]);
            }
            Class<?> returnType = propertyGetters[i].getReturnType();
            boolean found = false;
            for (Class<?> clazz : allowedTypes) {
                if (!ReflectHelper.assignableFrom(returnType, clazz)) continue;
                found = true;
                break;
            }
            if (found) continue;
            throw new MappingException("Entry property getter should has next data types " + Arrays.toString(allowedTypes));
        }
        return propertyGetters;
    }

    private <T> Setter[] getEntryPropertySetters(Class<T> entryClass, String properties, Class<?>[] allowedTypes) {
        if (StringHelper.isEmpty((String)properties)) {
            return null;
        }
        String[] tmpProperties = properties.split("\\,");
        Setter[] propertySetters = new Setter[tmpProperties.length];
        for (int i = 0; i < tmpProperties.length; ++i) {
            propertySetters[i] = this.getSetter(entryClass, tmpProperties[i].trim());
            if (propertySetters[i] == null) {
                throw new MappingException("Entry should has setter for property " + tmpProperties[i]);
            }
            Class<?> paramType = ReflectHelper.getSetterType(propertySetters[i]);
            boolean found = false;
            for (Class<?> clazz : allowedTypes) {
                if (!ReflectHelper.assignableFrom(paramType, clazz)) continue;
                found = true;
                break;
            }
            if (found) continue;
            throw new MappingException("Entry property setter should has next data types " + Arrays.toString(allowedTypes));
        }
        return propertySetters;
    }

    protected <T> Map<T, List<T>> groupListByProperties(Class<T> entryClass, List<T> entries, String groupByProperties, String sumByProperties) {
        return this.groupListByProperties(entryClass, entries, false, groupByProperties, sumByProperties);
    }

    private <T> Map<T, List<T>> groupListByPropertiesImpl(Class<T> entryClass, List<T> entries, boolean caseSensetive, Getter[] groupPropertyGetters, Setter[] groupPropertySetters, Getter[] sumProperyGetters, Setter[] sumPropertySetter) {
        HashMap keys = new HashMap();
        IdentityHashMap groups = new IdentityHashMap();
        for (T entry : entries) {
            ArrayList<T> groupValues;
            String key = this.getEntryKey(entry, caseSensetive, groupPropertyGetters);
            Object entryKey = keys.get(key);
            if (entryKey == null) {
                try {
                    entryKey = ReflectHelper.createObjectByDefaultConstructor(entryClass);
                }
                catch (Exception ex) {
                    throw new MappingException(String.format("Entry %s should has default constructor", entryClass), ex);
                }
                try {
                    ReflectHelper.copyObjectPropertyValues(entry, entryKey, groupPropertyGetters, groupPropertySetters);
                }
                catch (Exception ex) {
                    throw new MappingException("Failed to set values in group Entry", ex);
                }
                keys.put(key, entryKey);
            }
            if ((groupValues = (ArrayList<T>)groups.get(entryKey)) == null) {
                groupValues = new ArrayList<T>();
                groups.put(entryKey, groupValues);
            }
            try {
                if (sumProperyGetters != null) {
                    ReflectHelper.sumObjectPropertyValues(entryKey, entry, sumProperyGetters, sumPropertySetter);
                }
            }
            catch (Exception ex) {
                throw new MappingException("Failed to sum values in group Entry", ex);
            }
            groupValues.add(entry);
        }
        return groups;
    }

    private Map<String, AttributeData> getAttributesMap(List<AttributeData> attributes) {
        HashMap<String, AttributeData> attributesMap = new HashMap<String, AttributeData>(attributes.size());
        for (AttributeData attribute : attributes) {
            attributesMap.put(attribute.getName().toLowerCase(), attribute);
        }
        return attributesMap;
    }

    private AttributeData getAttributeData(String propertyName, String ldapAttributeName, Getter propertyValueGetter, Object entry, boolean multiValued, boolean jsonObject) {
        Object propertyValue = propertyValueGetter.get(entry);
        if (propertyValue == null) {
            return null;
        }
        AttributeData attributeData = this.getAttributeValues(propertyName, ldapAttributeName, jsonObject, propertyValue, multiValued);
        return attributeData;
    }

    private AttributeData getAttributeValues(String propertyName, String ldapAttributeName, boolean jsonObject, Object propertyValue, boolean multiValued) {
        Object[] attributeValues = new Object[1];
        boolean jsonValue = false;
        boolean nativeType = this.getNativeAttributeValue(propertyValue, attributeValues, multiValued);
        if (!nativeType) {
            if (propertyValue instanceof AttributeEnum) {
                attributeValues[0] = ((AttributeEnum)propertyValue).getValue();
            } else if (propertyValue instanceof AttributeEnum[]) {
                AttributeEnum[] propertyValues = (AttributeEnum[])propertyValue;
                attributeValues = new String[propertyValues.length];
                for (int i = 0; i < propertyValues.length; ++i) {
                    attributeValues[i] = propertyValues[i] == null ? null : propertyValues[i].getValue();
                }
            } else if (propertyValue instanceof String[]) {
                attributeValues = (String[])propertyValue;
            } else if (propertyValue instanceof Object[]) {
                attributeValues = (Object[])propertyValue;
            } else if (propertyValue instanceof List) {
                List propertyValueList = (List)propertyValue;
                attributeValues = new Object[propertyValueList.size()];
                int index = 0;
                Object[] nativeAttributeValue = new Object[1];
                for (Object tmpPropertyValue : propertyValueList) {
                    if (jsonObject) {
                        attributeValues[index++] = this.convertValueToJson(tmpPropertyValue);
                        continue;
                    }
                    if (this.getNativeAttributeValue(tmpPropertyValue, nativeAttributeValue, multiValued)) {
                        attributeValues[index++] = nativeAttributeValue[0];
                        continue;
                    }
                    attributeValues[index++] = StringHelper.toString(tmpPropertyValue);
                }
            } else if (jsonObject) {
                jsonValue = true;
                attributeValues[0] = this.convertValueToJson(propertyValue);
            } else {
                throw new MappingException("Entry property '" + propertyName + "' should has getter with String, String[], Boolean, Integer, Long, Date, List<String>, AttributeEnum or AttributeEnum[] return type or has annotation JsonObject");
            }
        }
        if (LOG.isDebugEnabled()) {
            String values = StringHelper.equalsIgnoreCase((String)USER_PASSWORD, (String)propertyName) ? MASKED : Arrays.toString(attributeValues);
            LOG.debug(String.format("Property: %s, LdapProperty: %s, PropertyValue: %s", propertyName, ldapAttributeName, values));
        }
        if (attributeValues.length == 0) {
            attributeValues = new String[]{};
        } else if (attributeValues.length == 1 && attributeValues[0] == null) {
            return null;
        }
        return new AttributeData(ldapAttributeName, attributeValues, (Boolean)multiValued, (Boolean)jsonValue);
    }

    private boolean getNativeAttributeValue(Object propertyValue, Object[] resultValue, boolean multiValued) {
        resultValue[0] = null;
        if (propertyValue instanceof String) {
            resultValue[0] = StringHelper.toString((Object)propertyValue);
        } else if (propertyValue instanceof Boolean) {
            resultValue[0] = propertyValue;
        } else if (propertyValue instanceof Integer) {
            resultValue[0] = propertyValue;
        } else if (propertyValue instanceof Long) {
            resultValue[0] = propertyValue;
        } else if (this.hasMapSupport() && propertyValue instanceof Map) {
            resultValue[0] = propertyValue;
        } else if (propertyValue instanceof Date) {
            resultValue[0] = multiValued ? this.getNativeDateMultiAttributeValue((Date)propertyValue) : this.getNativeDateAttributeValue((Date)propertyValue);
        } else {
            return false;
        }
        return true;
    }

    protected boolean hasMapSupport() {
        return false;
    }

    protected abstract Object getNativeDateAttributeValue(Date var1);

    protected Object getNativeDateMultiAttributeValue(Date dateValue) {
        return this.getNativeDateAttributeValue(dateValue);
    }

    protected boolean isAttributeMultivalued(Object[] values) {
        return values.length > 1;
    }

    protected Object convertValueToJson(Object propertyValue) {
        if (propertyValue == null) {
            return null;
        }
        try {
            String value = JSON_OBJECT_MAPPER.writeValueAsString(propertyValue);
            return value;
        }
        catch (Exception ex) {
            LOG.error("Failed to convert '{}' to json value:", propertyValue, (Object)ex);
            throw new MappingException(String.format("Failed to convert '%s' to json value", propertyValue));
        }
    }

    protected List<AttributeData> getAttributesListForPersist(Object entry, List<PropertyAnnotation> propertiesAnnotations) {
        ArrayList<AttributeData> attributes = new ArrayList<AttributeData>();
        for (PropertyAnnotation propertiesAnnotation : propertiesAnnotations) {
            List<AttributeData> listAttributes;
            String propertyName = propertiesAnnotation.getPropertyName();
            Annotation ldapAttribute = ReflectHelper.getAnnotationByType(propertiesAnnotation.getAnnotations(), AttributeName.class);
            Annotation languageTag = ReflectHelper.getAnnotationByType(propertiesAnnotation.getAnnotations(), LanguageTag.class);
            if (ldapAttribute != null) {
                if (languageTag != null) {
                    this.addAttributeDataFromLocalizedString(entry, ldapAttribute, propertyName, attributes);
                    continue;
                }
                AttributeData attribute = this.getAttributeDataFromAttribute(entry, ldapAttribute, propertiesAnnotation, propertyName);
                if (attribute == null) continue;
                attributes.add(attribute);
                continue;
            }
            ldapAttribute = ReflectHelper.getAnnotationByType(propertiesAnnotation.getAnnotations(), AttributesList.class);
            if (ldapAttribute == null || (listAttributes = this.getAttributeDataListFromCustomAttributesList(entry, (AttributesList)ldapAttribute, propertyName)) == null) continue;
            attributes.addAll(listAttributes);
        }
        return attributes;
    }

    private AttributeData getAttributeDataFromAttribute(Object entry, Annotation ldapAttribute, PropertyAnnotation propertiesAnnotation, String propertyName) {
        Getter getter;
        Class<?> entryClass = entry.getClass();
        String ldapAttributeName = ((AttributeName)ldapAttribute).name();
        if (StringHelper.isEmpty((String)ldapAttributeName)) {
            ldapAttributeName = propertyName;
        }
        if ((getter = this.getGetter(entryClass, propertyName)) == null) {
            throw new MappingException("Entry should has getter for property " + propertyName);
        }
        Class<?> parameterType = this.getSetterPropertyType(entryClass, propertyName);
        boolean multiValued = this.isMultiValued(parameterType);
        Annotation ldapJsonObject = ReflectHelper.getAnnotationByType(propertiesAnnotation.getAnnotations(), JsonObject.class);
        boolean jsonObject = ldapJsonObject != null;
        AttributeData attribute = this.getAttributeData(propertyName, ldapAttributeName, getter, entry, multiValued, jsonObject);
        Annotation passwordObject = ReflectHelper.getAnnotationByType(propertiesAnnotation.getAnnotations(), Password.class);
        if (passwordObject != null) {
            attribute = new PasswordAttributeData(attribute, ((Password)passwordObject).skipHashed());
        }
        return attribute;
    }

    protected void addAttributeDataFromLocalizedString(Object entry, Annotation ldapAttribute, String propertyName, List<AttributeData> attributes) {
        Class<?> entryClass = entry.getClass();
        Getter getter = this.getGetter(entryClass, propertyName);
        if (getter == null) {
            throw new MappingException("Entry should has getter for property " + propertyName);
        }
        Object propertyValue = getter.get(entry);
        if (propertyValue == null) {
            return;
        }
        if (!(propertyValue instanceof LocalizedString)) {
            throw new MappingException("Entry property should be LocalizedString");
        }
        LocalizedString localizedString = (LocalizedString)propertyValue;
        String ldapAttributeName = ((AttributeName)ldapAttribute).name();
        AttributeData attributeDataLocalized = this.getAttributeDataFromLocalizedString(ldapAttributeName, localizedString);
        if (attributeDataLocalized != null) {
            attributes.add(attributeDataLocalized);
        }
    }

    protected AttributeData getAttributeDataFromLocalizedString(String ldapAttributeName, LocalizedString localizedString) {
        AttributeData attributeData = new AttributeData(ldapAttributeName, new String[1]);
        JSONObject jsonObject = new JSONObject();
        localizedString.getLanguageTags().forEach(languageTag -> {
            String key = localizedString.addLdapLanguageTag(ldapAttributeName, languageTag);
            String value = localizedString.getValue(languageTag);
            jsonObject.put(key, (Object)value);
        });
        attributeData.getValues()[0] = jsonObject.toString();
        return attributeData;
    }

    @Override
    public List<AttributeData> getAttributeDataListFromCustomAttributesList(Object entry, AttributesList attributesList, String propertyName) {
        Class<?> propertyType;
        String entryPropertyName;
        Class<?> entryClass = entry.getClass();
        ArrayList<AttributeData> listAttributes = new ArrayList<AttributeData>();
        Getter getter = this.getGetter(entryClass, propertyName);
        if (getter == null) {
            throw new MappingException("Entry should has getter for property " + propertyName);
        }
        Object propertyValue = getter.get(entry);
        if (propertyValue == null) {
            return null;
        }
        if (!(propertyValue instanceof List)) {
            throw new MappingException("Entry property should has List base type");
        }
        Class<?> elementType = ReflectHelper.getListType(getter);
        Getter entryPropertyNameGetter = this.getGetter(elementType, entryPropertyName = attributesList.name());
        if (entryPropertyNameGetter == null) {
            throw new MappingException("Entry should has getter for property " + propertyName + "." + entryPropertyName);
        }
        String entryPropertyValue = attributesList.value();
        Getter entryPropertyValueGetter = this.getGetter(elementType, entryPropertyValue);
        if (entryPropertyValueGetter == null) {
            throw new MappingException("Entry should has getter for property " + propertyName + "." + entryPropertyValue);
        }
        String entryPropertyMultivalued = attributesList.multiValued();
        Getter entryPropertyMultivaluedGetter = null;
        if (StringHelper.isNotEmpty((String)entryPropertyMultivalued)) {
            entryPropertyMultivaluedGetter = this.getGetter(elementType, entryPropertyMultivalued);
        }
        if (entryPropertyMultivaluedGetter != null && !(propertyType = entryPropertyMultivaluedGetter.getReturnType()).equals(Boolean.TYPE)) {
            throw new MappingException("Entry should has getter for property " + propertyName + "." + entryPropertyMultivalued + " with boolean type");
        }
        for (Object entryAttribute : (List)propertyValue) {
            AttributeData attribute;
            Boolean multiValued = null;
            if (entryPropertyMultivaluedGetter != null) {
                multiValued = (boolean)((Boolean)entryPropertyMultivaluedGetter.get(entryAttribute));
            }
            if ((attribute = this.getAttributeData(propertyName, entryPropertyNameGetter, entryPropertyValueGetter, entryAttribute, Boolean.TRUE.equals(multiValued), false)) == null) {
                String ldapAttributeName = this.getDbCustomAttributeName(entryPropertyNameGetter, entryAttribute);
                if (ldapAttributeName == null) continue;
                listAttributes.add(new AttributeData(ldapAttributeName, null));
                continue;
            }
            if (multiValued == null) {
                multiValued = attribute.getValues().length > 1;
            }
            attribute.setMultiValued(multiValued);
            listAttributes.add(attribute);
        }
        return listAttributes;
    }

    @Override
    public List<Object> getCustomAttributesListFromAttributeDataList(Object entry, AttributesList attributesList, String propertyName, Collection<AttributeData> attributes) {
        Class<?> entryClass = entry.getClass();
        return this.getCustomAttributesListFromAttributeData(entryClass, attributesList, propertyName, attributes, null);
    }

    @Override
    public <T> List<PropertyAnnotation> getEntryPropertyAnnotations(Class<T> entryClass) {
        List<PropertyAnnotation> annotations = this.getEntryClassAnnotations(entryClass, "property_", LDAP_ENTRY_PROPERTY_ANNOTATIONS);
        return annotations;
    }

    protected <T> List<PropertyAnnotation> getEntryDnAnnotations(Class<T> entryClass) {
        return this.getEntryClassAnnotations(entryClass, "dn_", LDAP_DN_PROPERTY_ANNOTATION);
    }

    protected <T> List<PropertyAnnotation> getEntryExpirationAnnotations(Class<T> entryClass) {
        return this.getEntryClassAnnotations(entryClass, "exp_", LDAP_EXPIRATION_PROPERTY_ANNOTATION);
    }

    protected <T> List<PropertyAnnotation> getEntryCustomObjectClassAnnotations(Class<T> entryClass) {
        return this.getEntryClassAnnotations(entryClass, "custom_", LDAP_CUSTOM_OBJECT_CLASS_PROPERTY_ANNOTATION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> List<PropertyAnnotation> getEntryClassAnnotations(Class<T> entryClass, String keyCategory, Class<?>[] annotationTypes) {
        String key = keyCategory + entryClass.getName();
        List<PropertyAnnotation> annotations = this.classAnnotations.get(key);
        if (annotations == null) {
            Object object = CLASS_ANNOTATIONS_LOCK;
            synchronized (object) {
                annotations = this.classAnnotations.get(key);
                if (annotations == null) {
                    Map<String, List<Annotation>> annotationsMap = ReflectHelper.getPropertiesAnnotations(entryClass, annotationTypes);
                    annotations = this.convertToPropertyAnnotationList(annotationsMap);
                    this.classAnnotations.put(key, annotations);
                }
            }
        }
        return annotations;
    }

    private List<PropertyAnnotation> convertToPropertyAnnotationList(Map<String, List<Annotation>> annotations) {
        ArrayList<PropertyAnnotation> result = new ArrayList<PropertyAnnotation>(annotations.size());
        for (Map.Entry<String, List<Annotation>> entry : annotations.entrySet()) {
            result.add(new PropertyAnnotation(entry.getKey(), entry.getValue()));
        }
        Collections.sort(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> Getter getGetter(Class<T> entryClass, String propertyName) {
        String key = entryClass.getName() + "." + propertyName;
        Getter getter = this.classGetters.get(key);
        if (getter == null) {
            Object object = CLASS_GETTERS_LOCK;
            synchronized (object) {
                getter = this.classGetters.get(key);
                if (getter == null) {
                    getter = ReflectHelper.getGetter(entryClass, propertyName);
                    this.classGetters.put(key, getter);
                }
            }
        }
        return getter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> Setter getSetter(Class<T> entryClass, String propertyName) {
        String key = entryClass.getName() + "." + propertyName;
        Setter setter = this.classSetters.get(key);
        if (setter == null) {
            Object object = CLASS_SETTERS_LOCK;
            synchronized (object) {
                setter = this.classSetters.get(key);
                if (setter == null) {
                    setter = ReflectHelper.getSetter(entryClass, propertyName);
                    this.classSetters.put(key, setter);
                }
            }
        }
        return setter;
    }

    private AttributeData getAttributeData(String propertyName, Getter propertyNameGetter, Getter propertyValueGetter, Object entry, boolean multiValued, boolean jsonObject) {
        String ldapAttributeName = this.getDbCustomAttributeName(propertyNameGetter, entry);
        if (ldapAttributeName == null) {
            return null;
        }
        return this.getAttributeData(propertyName, ldapAttributeName, propertyValueGetter, entry, multiValued, jsonObject);
    }

    private String getDbCustomAttributeName(Getter propertyNameGetter, Object entry) {
        Object ldapAttributeName = propertyNameGetter.get(entry);
        if (ldapAttributeName == null) {
            return null;
        }
        return ldapAttributeName.toString();
    }

    private void setPropertyValue(String propertyName, Setter propertyValueSetter, Object entry, AttributeData attribute, boolean jsonObject) {
        if (attribute == null) {
            return;
        }
        LOG.debug(String.format("LdapProperty: %s, AttributeName: %s, AttributeValue: %s", propertyName, attribute.getName(), Arrays.toString(attribute.getValues())));
        Class<?> parameterType = ReflectHelper.getSetterType(propertyValueSetter);
        if (parameterType.equals(String.class)) {
            Object value = attribute.getValue();
            if (value instanceof Date) {
                value = this.encodeTime((Date)value);
            }
            propertyValueSetter.set(entry, String.valueOf(value));
        } else if (parameterType.equals(Boolean.class) || parameterType.equals(Boolean.TYPE)) {
            propertyValueSetter.set(entry, this.toBooleanValue(attribute));
        } else if (parameterType.equals(Integer.class) || parameterType.equals(Integer.TYPE)) {
            propertyValueSetter.set(entry, this.toIntegerValue(attribute));
        } else if (parameterType.equals(Long.class) || parameterType.equals(Long.TYPE)) {
            propertyValueSetter.set(entry, this.toLongValue(attribute));
        } else if (parameterType.equals(Date.class)) {
            if (attribute.getValue() == null) {
                propertyValueSetter.set(entry, null);
            } else {
                propertyValueSetter.set(entry, attribute.getValue() instanceof Date ? (Date)attribute.getValue() : this.decodeTime(String.valueOf(attribute.getValue())));
            }
        } else if (parameterType.equals(String[].class)) {
            propertyValueSetter.set(entry, attribute.getStringValues());
        } else if (ReflectHelper.assignableFrom(parameterType, List.class)) {
            if (jsonObject) {
                Object[] values = attribute.getValues();
                ArrayList<Object> jsonValues = new ArrayList<Object>(values.length);
                for (Object value : values) {
                    Object jsonValue = this.convertJsonToValue(ReflectHelper.getListType(propertyValueSetter), value);
                    jsonValues.add(jsonValue);
                }
                propertyValueSetter.set(entry, jsonValues);
            } else {
                List<?> resultValues = this.attributeToTypedList(ReflectHelper.getListType(propertyValueSetter), attribute);
                propertyValueSetter.set(entry, resultValues);
            }
        } else {
            if (ReflectHelper.assignableFrom(parameterType, AttributeEnum.class)) {
                try {
                    propertyValueSetter.set(entry, parameterType.getMethod("resolveByValue", String.class).invoke(parameterType.getEnumConstants()[0], attribute.getValue()));
                }
                catch (Exception ex) {
                    throw new MappingException("Failed to resolve Enum '" + parameterType + "' by value '" + attribute.getValue() + "'", ex);
                }
            }
            if (ReflectHelper.assignableFrom(parameterType, AttributeEnum[].class)) {
                Method enumResolveByValue;
                Class<?> itemType = parameterType.getComponentType();
                try {
                    enumResolveByValue = itemType.getMethod("resolveByValue", String.class);
                }
                catch (Exception ex) {
                    throw new MappingException("Failed to resolve Enum '" + parameterType + "' by value '" + Arrays.toString(attribute.getValues()) + "'", ex);
                }
                Object[] attributeValues = attribute.getValues();
                AttributeEnum[] ldapEnums = (AttributeEnum[])ReflectHelper.createArray(itemType, attributeValues.length);
                for (int i = 0; i < attributeValues.length; ++i) {
                    try {
                        ldapEnums[i] = (AttributeEnum)enumResolveByValue.invoke(itemType.getEnumConstants()[0], attributeValues[i]);
                        continue;
                    }
                    catch (Exception ex) {
                        throw new MappingException("Failed to resolve Enum '" + parameterType + "' by value '" + Arrays.toString(attribute.getValues()) + "'", ex);
                    }
                }
                propertyValueSetter.set(entry, ldapEnums);
            } else if (jsonObject) {
                Object stringValue = attribute.getValue();
                Object jsonValue = this.convertJsonToValue(parameterType, stringValue);
                propertyValueSetter.set(entry, jsonValue);
            } else {
                throw new MappingException("Entry property '" + propertyName + "' should has setter with String, Boolean, Integer, Long, Date, String[], List<String>, AttributeEnum or AttributeEnum[] parameter type or has annotation JsonObject");
            }
        }
    }

    private List<?> attributeToTypedList(Class<?> listType, AttributeData attributeData) {
        if (listType.equals(String.class)) {
            ArrayList<String> result = new ArrayList<String>();
            for (Object value : attributeData.getValues()) {
                String resultValue = value instanceof Date ? this.encodeTime((Date)value) : String.valueOf(value);
                result.add(resultValue);
            }
            return result;
        }
        return Arrays.asList(attributeData.getValues());
    }

    private Boolean toBooleanValue(AttributeData attribute) {
        Boolean propertyValue = null;
        Object propertyValueObject = attribute.getValue();
        if (propertyValueObject != null) {
            propertyValue = propertyValueObject instanceof Boolean ? (Boolean)propertyValueObject : Boolean.valueOf(String.valueOf(propertyValueObject));
        }
        return propertyValue;
    }

    private Integer toIntegerValue(AttributeData attribute) {
        Integer propertyValue = null;
        Object propertyValueObject = attribute.getValue();
        if (propertyValueObject != null) {
            propertyValue = propertyValueObject instanceof Integer ? (Integer)propertyValueObject : (propertyValueObject instanceof Long ? Integer.valueOf(((Long)propertyValueObject).intValue()) : Integer.valueOf(String.valueOf(propertyValueObject)));
        }
        return propertyValue;
    }

    private Long toLongValue(AttributeData attribute) {
        Long propertyValue = null;
        Object propertyValueObject = attribute.getValue();
        if (propertyValueObject != null) {
            propertyValue = propertyValueObject instanceof Long ? (Long)propertyValueObject : (propertyValueObject instanceof Integer ? Long.valueOf(((Integer)propertyValueObject).longValue()) : Long.valueOf(String.valueOf(propertyValueObject)));
        }
        return propertyValue;
    }

    protected Object convertJsonToValue(Class<?> parameterType, Object propertyValue) {
        try {
            Object jsonValue = JSON_OBJECT_MAPPER.readValue(String.valueOf(propertyValue), parameterType);
            return jsonValue;
        }
        catch (Exception ex) {
            String msg = String.format("Failed to convert json value '%s' to object of type %s", propertyValue, parameterType);
            LOG.error(msg, (Throwable)ex);
            throw new MappingException(msg, ex);
        }
    }

    private Object getListItem(String propertyName, Setter propertyNameSetter, Setter propertyValueSetter, Setter entryPropertyMultivaluedSetter, Class<?> classType, AttributeData attribute) {
        Object result;
        if (attribute == null) {
            return null;
        }
        try {
            result = ReflectHelper.createObjectByDefaultConstructor(classType);
        }
        catch (Exception ex) {
            throw new MappingException(String.format("Entry %s should has default constructor", classType));
        }
        propertyNameSetter.set(result, attribute.getName());
        this.setPropertyValue(propertyName, propertyValueSetter, result, attribute, false);
        if (entryPropertyMultivaluedSetter != null && attribute.getMultiValued() != null) {
            entryPropertyMultivaluedSetter.set(result, attribute.getMultiValued());
        }
        return result;
    }

    protected <T> Object getDNValue(Object entry) {
        Class<?> entryClass = entry.getClass();
        return this.getDNValue(entry, entryClass);
    }

    protected <T> Object getDNValue(Object entry, Class<T> entryClass) {
        String dnProperty = this.getDNPropertyName(entryClass);
        Getter dnGetter = this.getGetter(entryClass, dnProperty);
        if (dnGetter == null) {
            throw new MappingException("Entry should has getter for property " + dnProperty);
        }
        Object dnValue = dnGetter.get(entry);
        if (StringHelper.isEmptyString((Object)dnValue)) {
            throw new MappingException("Entry should has not null base DN property value");
        }
        return dnValue;
    }

    protected <T> Integer getExpirationValue(Object entry, Class<T> entryClass, boolean merge) {
        PropertyAnnotation expirationProperty = this.getExpirationProperty(entryClass);
        if (expirationProperty == null) {
            return null;
        }
        String expirationPropertyName = expirationProperty.getPropertyName();
        Expiration expirationAnnotation = (Expiration)ReflectHelper.getAnnotationByType(expirationProperty.getAnnotations(), Expiration.class);
        if (merge && expirationAnnotation.ignoreDuringUpdate()) {
            return null;
        }
        if (expirationPropertyName == null) {
            return null;
        }
        Getter expirationGetter = this.getGetter(entryClass, expirationPropertyName);
        if (expirationGetter == null) {
            throw new MappingException("Entry should has getter for property " + expirationGetter);
        }
        Class<?> propertyType = expirationGetter.getReturnType();
        if (propertyType != Integer.class && propertyType != Integer.TYPE) {
            throw new MappingException("Entry expiration property should has Integer type. Property: '" + expirationGetter + "'");
        }
        Object expirationValue = expirationGetter.get(entry);
        if (expirationValue == null) {
            return null;
        }
        Integer resultExpirationValue = expirationValue instanceof Integer ? (Integer)expirationValue : Integer.valueOf((Integer)expirationValue);
        if (resultExpirationValue < 0) {
            resultExpirationValue = 0;
        }
        return resultExpirationValue;
    }

    private <T> String getEntryKey(T entry, boolean caseSensetive, Getter[] propertyGetters) {
        StringBuilder sb = new StringBuilder("key");
        for (Getter getter : propertyGetters) {
            sb.append("__").append(getter.get(entry));
        }
        if (caseSensetive) {
            return sb.toString();
        }
        return sb.toString().toLowerCase();
    }

    private Map<String, AttributeData> getAttributesDataMap(List<AttributeData> attributesData) {
        HashMap<String, AttributeData> result = new HashMap<String, AttributeData>();
        for (AttributeData attributeData : attributesData) {
            result.put(attributeData.getName(), attributeData);
        }
        return result;
    }

    private String getEntryKey(Object dnValue, boolean caseSensetive, List<PropertyAnnotation> propertiesAnnotations, List<AttributeData> attributesData) {
        StringBuilder sb = new StringBuilder("_HASH__").append(String.valueOf(dnValue).toLowerCase()).append("__");
        ArrayList<String> processedProperties = new ArrayList<String>();
        Map<String, AttributeData> attributesDataMap = this.getAttributesDataMap(attributesData);
        for (PropertyAnnotation propertiesAnnotation : propertiesAnnotations) {
            Annotation ldapAttribute = ReflectHelper.getAnnotationByType(propertiesAnnotation.getAnnotations(), AttributeName.class);
            if (ldapAttribute == null) continue;
            String ldapAttributeName = ((AttributeName)ldapAttribute).name();
            if (StringHelper.isEmpty((String)ldapAttributeName)) {
                ldapAttributeName = propertiesAnnotation.getPropertyName();
            }
            processedProperties.add(ldapAttributeName);
            Object[] values = null;
            AttributeData attributeData = attributesDataMap.get(ldapAttributeName);
            if (attributeData != null && attributeData.getValues() != null) {
                values = attributeData.getStringValues();
                Arrays.sort(values);
            }
            this.addPropertyWithValuesToKey(sb, ldapAttributeName, (String[])values);
        }
        for (AttributeData attributeData : attributesData) {
            if (processedProperties.contains(attributeData.getName())) continue;
            this.addPropertyWithValuesToKey(sb, attributeData.getName(), attributeData.getStringValues());
        }
        if (caseSensetive) {
            return sb.toString();
        }
        return sb.toString().toLowerCase();
    }

    protected String resolveBeanPropertyByAttribute(List<PropertyAnnotation> propertiesAnnotations, String attributeName) {
        for (PropertyAnnotation propertiesAnnotation : propertiesAnnotations) {
            String propertyName = propertiesAnnotation.getPropertyName();
            Annotation ldapAttribute = ReflectHelper.getAnnotationByType(propertiesAnnotation.getAnnotations(), AttributeName.class);
            if (ldapAttribute == null) continue;
            String ldapAttributeName = ((AttributeName)ldapAttribute).name();
            if (StringHelper.isEmpty((String)ldapAttributeName)) {
                ldapAttributeName = propertyName;
            }
            if (!StringHelper.equalsIgnoreCase((String)attributeName, (String)(ldapAttributeName = ldapAttributeName.toLowerCase()))) continue;
            return propertiesAnnotation.getPropertyName();
        }
        return attributeName;
    }

    private void addPropertyWithValuesToKey(StringBuilder sb, String propertyName, String[] values) {
        sb.append(':').append(propertyName).append('=');
        if (values == null) {
            sb.append("null");
        } else if (values.length == 1) {
            sb.append(values[0]);
        } else {
            Object[] tmpValues = (String[])values.clone();
            Arrays.sort(tmpValues);
            for (int i = 0; i < tmpValues.length; ++i) {
                sb.append((String)tmpValues[i]);
                if (i >= tmpValues.length - 1) continue;
                sb.append(';');
            }
        }
    }

    @Override
    public int getHashCode(Object entry) {
        if (entry == null) {
            throw new MappingException("Entry to persist is null");
        }
        Class<?> entryClass = entry.getClass();
        this.checkEntryClass(entryClass, false);
        List<PropertyAnnotation> propertiesAnnotations = this.getEntryPropertyAnnotations(entryClass);
        Object dnValue = this.getDNValue(entry, entryClass);
        List<AttributeData> attributes = this.getAttributesListForPersist(entry, propertiesAnnotations);
        String key = this.getEntryKey(dnValue, false, propertiesAnnotations, attributes);
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Entry key HashCode is: %s", key.hashCode()));
        }
        return key.hashCode();
    }

    protected byte[][] toBinaryValues(String[] attributeValues) {
        byte[][] binaryValues = new byte[attributeValues.length][];
        for (int i = 0; i < attributeValues.length; ++i) {
            binaryValues[i] = Base64.decodeBase64((String)attributeValues[i]);
        }
        return binaryValues;
    }

    protected <T> Filter createFilterByEntry(Object entry, Class<T> entryClass, List<AttributeData> attributes) {
        Filter[] attributesFilters = this.createAttributesFilter(attributes);
        Filter attributesFilter = null;
        if (attributesFilters != null) {
            attributesFilter = Filter.createANDFilter((Filter[])attributesFilters);
        }
        String[] objectClasses = this.getObjectClasses(entry, entryClass);
        return this.addObjectClassFilter(attributesFilter, objectClasses);
    }

    protected Filter excludeObjectClassFilters(Filter genericFilter) {
        return this.filterProcessor.excludeFilter(genericFilter, new Filter[]{FilterProcessor.OBJECT_CLASS_EQUALITY_FILTER, FilterProcessor.OBJECT_CLASS_PRESENCE_FILTER});
    }

    protected Filter[] createAttributesFilter(List<AttributeData> attributes) {
        if (attributes == null || attributes.size() == 0) {
            return null;
        }
        ArrayList<Filter> results = new ArrayList<Filter>(attributes.size());
        for (AttributeData attribute : attributes) {
            String attributeName = attribute.getName();
            for (Object value : attribute.getValues()) {
                Filter filter = Filter.createEqualityFilter((String)attributeName, (Object)value);
                if (attribute.getMultiValued() != null) {
                    filter.multiValued(attribute.getMultiValued());
                }
                results.add(filter);
            }
        }
        return results.toArray(new Filter[results.size()]);
    }

    protected Filter addObjectClassFilter(Filter filter, String[] objectClasses) {
        if (objectClasses.length == 0) {
            return filter;
        }
        Filter[] objectClassFilter = new Filter[objectClasses.length];
        for (int i = 0; i < objectClasses.length; ++i) {
            objectClassFilter[i] = Filter.createEqualityFilter((String)OBJECT_CLASS, (Object)objectClasses[i]).multiValued();
        }
        Filter searchFilter = Filter.createANDFilter((Filter[])objectClassFilter);
        if (filter != null) {
            searchFilter = Filter.createANDFilter((Filter[])new Filter[]{Filter.createANDFilter((Filter[])objectClassFilter), filter});
        }
        return searchFilter;
    }

    protected boolean isMultiValued(Class<?> parameterType) {
        if (parameterType == null) {
            return false;
        }
        boolean isMultiValued = parameterType.equals(String[].class) || ReflectHelper.assignableFrom(parameterType, List.class) || ReflectHelper.assignableFrom(parameterType, AttributeEnum[].class);
        return isMultiValued;
    }

    protected abstract Date decodeTime(String var1);

    protected abstract String encodeTime(Date var1);

    @Override
    public void setPersistenceExtension(PersistenceExtension persistenceExtension) {
        this.persistenceExtension = persistenceExtension;
        if (this.operationService != null) {
            this.operationService.setPersistenceExtension(persistenceExtension);
        }
    }

    @Override
    public <T> AttributeType getAttributeType(String primaryKey, Class<T> entryClass, String propertyName) {
        throw new UnsupportedOperationException("Method not implemented.");
    }

    protected void dumpAttributes(String variableName, List<AttributeData> attributesToPersist) {
        System.out.println("\n" + variableName + ": START");
        for (AttributeData attribute : attributesToPersist) {
            System.out.println(String.format("%s\t\t%s\t%b", attribute.getName(), Arrays.toString(attribute.getValues()), attribute.getMultiValued()));
        }
        System.out.println(variableName + ": END");
    }

    protected void dumpAttributeDataModifications(String variableName, List<AttributeDataModification> attributeDataModifications) {
        System.out.println("\n" + variableName + ": START");
        for (AttributeDataModification modification : attributeDataModifications) {
            AttributeData attribute;
            String newValues = "[]";
            String oldValues = "[]";
            if (modification.getAttribute() != null && modification.getAttribute().getValues() != null) {
                newValues = Arrays.toString(modification.getAttribute().getValues());
            }
            if (modification.getOldAttribute() != null && modification.getOldAttribute().getValues() != null) {
                oldValues = Arrays.toString(modification.getOldAttribute().getValues());
            }
            if ((attribute = modification.getAttribute()) == null) {
                attribute = modification.getOldAttribute();
            }
            System.out.println(String.format("%s\t\t%s\t%b\t\t%s\t->\t%s", attribute.getName(), modification.getModificationType().name(), attribute.getMultiValued(), oldValues, newValues));
        }
        System.out.println(variableName + ": END");
    }

    private String maskSensetiveData(List<AttributeData> attributes) {
        if (attributes == null) {
            return null;
        }
        boolean added = false;
        StringBuilder sb = new StringBuilder("[");
        for (AttributeData attr : attributes) {
            if (added) {
                sb.append(", ");
            }
            if (StringHelper.equalsIgnoreCase((String)USER_PASSWORD, (String)attr.getName())) {
                AttributeData clonedAttr = new AttributeData(attr.getName(), MASKED, attr.getMultiValued(), attr.getJsonValue());
                sb.append(clonedAttr);
            } else {
                sb.append(attr);
            }
            added = true;
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    public PersistenceMetadata getPersistenceMetadata(String primaryKey) {
        throw new UnsupportedOperationException("Method not implemented.");
    }

    @Override
    public Map<String, Map<String, AttributeType>> getTableColumnsMap() {
        return this.operationService.getTableColumnsMap();
    }

    protected static final class LineLenghtComparator<T>
    implements Comparator<T>,
    Serializable {
        private static final long serialVersionUID = 575848841116711467L;
        private boolean ascending;

        public LineLenghtComparator(boolean ascending) {
            this.ascending = ascending;
        }

        @Override
        public int compare(T entry1, T entry2) {
            if (entry1 == null && entry2 == null) {
                return 0;
            }
            if (entry1 == null && entry2 != null) {
                return -1;
            }
            if (entry1 != null && entry2 == null) {
                return 1;
            }
            int result = entry1.toString().length() - entry2.toString().length();
            if (this.ascending) {
                return result;
            }
            return -result;
        }
    }

    protected static final class PropertyComparator<T>
    implements Comparator<T>,
    Serializable {
        private static final long serialVersionUID = 574848841116711467L;
        private Getter[][] propertyGetters;
        private boolean caseSensetive;

        private PropertyComparator(Getter[][] propertyGetters, boolean caseSensetive) {
            this.propertyGetters = propertyGetters;
            this.caseSensetive = caseSensetive;
        }

        @Override
        public int compare(T entry1, T entry2) {
            Getter[] curPropertyGetters;
            if (entry1 == null && entry2 == null) {
                return 0;
            }
            if (entry1 == null && entry2 != null) {
                return -1;
            }
            if (entry1 != null && entry2 == null) {
                return 1;
            }
            int result = 0;
            Getter[][] getterArray = this.propertyGetters;
            int n = getterArray.length;
            for (int i = 0; i < n && (result = this.compare(entry1, entry2, curPropertyGetters = getterArray[i])) == 0; ++i) {
            }
            return result;
        }

        public int compare(T entry1, T entry2, Getter[] propertyGetters) {
            Object value1 = ReflectHelper.getPropertyValue(entry1, propertyGetters);
            Object value2 = ReflectHelper.getPropertyValue(entry2, propertyGetters);
            if (value1 == null && value2 == null) {
                return 0;
            }
            if (value1 == null && value2 != null) {
                return -1;
            }
            if (value1 != null && value2 == null) {
                return 1;
            }
            if (value1 instanceof Date) {
                return ((Date)value1).compareTo((Date)value2);
            }
            if (value1 instanceof Integer) {
                return ((Integer)value1).compareTo((Integer)value2);
            }
            if (value1 instanceof String && value2 instanceof String) {
                if (this.caseSensetive) {
                    return ((String)value1).compareTo((String)value2);
                }
                return ((String)value1).toLowerCase().compareTo(((String)value2).toLowerCase());
            }
            return 0;
        }
    }
}

