/*
 * Decompiled with CFR 0.152.
 */
package io.jans.orm.ldap.impl;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.Modification;
import com.unboundid.ldap.sdk.ModificationType;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.util.StaticUtils;
import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.annotation.AttributeName;
import io.jans.orm.event.DeleteNotifier;
import io.jans.orm.exception.AuthenticationException;
import io.jans.orm.exception.EntryDeleteException;
import io.jans.orm.exception.EntryPersistenceException;
import io.jans.orm.exception.MappingException;
import io.jans.orm.exception.operation.ConnectionException;
import io.jans.orm.exception.operation.SearchException;
import io.jans.orm.exception.operation.SearchScopeException;
import io.jans.orm.impl.BaseEntryManager;
import io.jans.orm.ldap.impl.LdapBatchOperationWraper;
import io.jans.orm.ldap.impl.LdapEntryManagerFactory;
import io.jans.orm.ldap.impl.LdapFilterConverter;
import io.jans.orm.ldap.impl.LdapSearchScopeConverter;
import io.jans.orm.ldap.impl.LdifDataUtility;
import io.jans.orm.ldap.operation.LdapOperationService;
import io.jans.orm.ldap.operation.impl.LdapOperationServiceImpl;
import io.jans.orm.model.AttributeData;
import io.jans.orm.model.AttributeDataModification;
import io.jans.orm.model.AttributeType;
import io.jans.orm.model.BatchOperation;
import io.jans.orm.model.DefaultBatchOperation;
import io.jans.orm.model.EntryData;
import io.jans.orm.model.PagedResult;
import io.jans.orm.model.SortOrder;
import io.jans.orm.model.base.LocalizedString;
import io.jans.orm.reflect.property.Getter;
import io.jans.orm.reflect.property.PropertyAnnotation;
import io.jans.orm.search.filter.Filter;
import io.jans.orm.util.ArrayHelper;
import io.jans.orm.util.StringHelper;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapEntryManager
extends BaseEntryManager<LdapOperationService>
implements Serializable {
    private static final long serialVersionUID = -2544614410981223105L;
    private static final Logger LOG = LoggerFactory.getLogger(LdapEntryManager.class);
    private static final LdapFilterConverter LDAP_FILTER_CONVERTER = new LdapFilterConverter();
    private static final LdapSearchScopeConverter LDAP_SEARCH_SCOPE_CONVERTER = new LdapSearchScopeConverter();
    private List<DeleteNotifier> subscribers;

    public LdapEntryManager() {
    }

    public LdapEntryManager(LdapOperationServiceImpl operationService) {
        this.operationService = operationService;
        this.subscribers = new LinkedList<DeleteNotifier>();
    }

    public boolean destroy() {
        if (this.operationService == null) {
            return true;
        }
        return this.getOperationService().destroy();
    }

    public LdapOperationServiceImpl getOperationService() {
        return (LdapOperationServiceImpl)this.operationService;
    }

    public void addDeleteSubscriber(DeleteNotifier subscriber) {
        this.subscribers.add(subscriber);
    }

    public void removeDeleteSubscriber(DeleteNotifier subscriber) {
        this.subscribers.remove(subscriber);
    }

    public Void merge(Object entry) {
        Class<?> entryClass = entry.getClass();
        this.checkEntryClass(entryClass, true);
        if (this.isSchemaEntry(entryClass)) {
            if (this.getSupportedLDAPVersion() > 2) {
                return this.merge(entry, true, false, AttributeDataModification.AttributeModificationType.ADD);
            }
            throw new UnsupportedOperationException("Server doesn't support dynamic schema modifications");
        }
        boolean configurationEntry = this.isConfigurationEntry(entryClass);
        return this.merge(entry, false, configurationEntry, null);
    }

    protected <T> void updateMergeChanges(String baseDn, T entry, boolean isConfigurationUpdate, Class<?> entryClass, Map<String, AttributeData> attributesFromLdapMap, List<AttributeDataModification> attributeDataModifications, boolean forceUpdate) {
        if (this.getSupportedLDAPVersion() > 2 && !isConfigurationUpdate) {
            Object[] objectClasses = this.getObjectClasses(entry, entryClass);
            Object[] objectClassesFromLdap = attributesFromLdapMap.get("objectClass".toLowerCase()).getStringValues();
            if (!Arrays.equals(objectClassesFromLdap, objectClasses)) {
                attributeDataModifications.add(new AttributeDataModification(AttributeDataModification.AttributeModificationType.REPLACE, new AttributeData("objectClass", objectClasses), new AttributeData("objectClass", objectClassesFromLdap)));
            }
        }
    }

    public void remove(Object entry) {
        Class<?> entryClass = entry.getClass();
        this.checkEntryClass(entryClass, true);
        if (this.isSchemaEntry(entryClass)) {
            if (this.getSupportedLDAPVersion() <= 2) {
                throw new UnsupportedOperationException("Server doesn't support dynamic schema modifications");
            }
            this.merge(entry, true, false, AttributeDataModification.AttributeModificationType.REMOVE);
            return;
        }
        Object dnValue = this.getDNValue(entry, entryClass);
        LOG.debug(String.format("LDAP entry to remove: %s", dnValue.toString()));
        this.remove(dnValue.toString(), entryClass);
    }

    protected void persist(String dn, String[] objectClasses, List<AttributeData> attributes, Integer expiration) {
        ArrayList<Attribute> ldapAttributes = new ArrayList<Attribute>(attributes.size());
        for (AttributeData attribute : attributes) {
            String attributeName = attribute.getName();
            Object[] attributeValues = attribute.getStringValues();
            if (!ArrayHelper.isNotEmpty((Object[])attributeValues) || !StringHelper.isNotEmpty((String)attributeValues[0])) continue;
            if (this.getOperationService().isCertificateAttribute(attributeName)) {
                byte[][] binaryValues = this.toBinaryValues((String[])attributeValues);
                ldapAttributes.add(new Attribute(attributeName + ";binary", binaryValues));
                continue;
            }
            ldapAttributes.add(new Attribute(attributeName, (String[])attributeValues));
        }
        try {
            boolean result = this.getOperationService().addEntry(dn, ldapAttributes);
            if (!result) {
                throw new EntryPersistenceException(String.format("Failed to persist entry: %s", dn));
            }
        }
        catch (ConnectionException ex) {
            throw new EntryPersistenceException(String.format("Failed to persist entry: %s", dn), ex.getCause());
        }
        catch (Exception ex) {
            throw new EntryPersistenceException(String.format("Failed to persist entry: %s", dn), (Throwable)ex);
        }
    }

    public void merge(String dn, String[] objectClasses, List<AttributeDataModification> attributeDataModifications, Integer expiration) {
        try {
            boolean result;
            ArrayList<Modification> modifications = new ArrayList<Modification>(attributeDataModifications.size());
            for (AttributeDataModification attributeDataModification : attributeDataModifications) {
                AttributeData attribute = attributeDataModification.getAttribute();
                AttributeData oldAttribute = attributeDataModification.getOldAttribute();
                String attributeName = null;
                Object[] attributeValues = null;
                if (attribute != null) {
                    attributeName = attribute.getName();
                    attributeValues = this.convertValuesToStringValues(attribute.getValues());
                }
                String oldAttributeName = null;
                Object[] oldAttributeValues = null;
                if (oldAttribute != null) {
                    oldAttributeName = oldAttribute.getName();
                    oldAttributeValues = this.convertValuesToStringValues(oldAttribute.getValues());
                }
                Modification modification = null;
                if (AttributeDataModification.AttributeModificationType.ADD.equals((Object)attributeDataModification.getModificationType())) {
                    modification = this.createModification(ModificationType.ADD, attributeName, (String[])attributeValues);
                } else if (AttributeDataModification.AttributeModificationType.REMOVE.equals((Object)attributeDataModification.getModificationType())) {
                    modification = this.createModification(ModificationType.DELETE, oldAttributeName, (String[])oldAttributeValues);
                } else if (AttributeDataModification.AttributeModificationType.REPLACE.equals((Object)attributeDataModification.getModificationType())) {
                    if (attributeValues.length == 1) {
                        modification = this.createModification(ModificationType.REPLACE, attributeName, (String[])attributeValues);
                    } else {
                        Object[] oldValues = (String[])ArrayHelper.arrayClone((Object[])oldAttributeValues);
                        Object[] newValues = (String[])ArrayHelper.arrayClone((Object[])attributeValues);
                        Arrays.sort(oldValues);
                        Arrays.sort(newValues);
                        boolean[] retainOldValues = new boolean[oldValues.length];
                        Arrays.fill(retainOldValues, false);
                        ArrayList<Object> addValues = new ArrayList<Object>();
                        ArrayList<Object> removeValues = new ArrayList<Object>();
                        for (Object value : newValues) {
                            int idx = Arrays.binarySearch(oldValues, value, new Comparator<String>(){

                                @Override
                                public int compare(String o1, String o2) {
                                    return o1.toLowerCase().compareTo(o2.toLowerCase());
                                }
                            });
                            if (idx >= 0) {
                                retainOldValues[idx] = true;
                                continue;
                            }
                            addValues.add(value);
                        }
                        for (int i = 0; i < oldValues.length; ++i) {
                            if (retainOldValues[i]) continue;
                            removeValues.add(oldValues[i]);
                        }
                        if (removeValues.size() > 0) {
                            Modification removeModification = this.createModification(ModificationType.DELETE, attributeName, removeValues.toArray(new String[removeValues.size()]));
                            modifications.add(removeModification);
                        }
                        if (addValues.size() > 0) {
                            Modification addModification = this.createModification(ModificationType.ADD, attributeName, addValues.toArray(new String[addValues.size()]));
                            modifications.add(addModification);
                        }
                    }
                }
                if (modification == null) continue;
                modifications.add(modification);
            }
            if (modifications.size() > 0 && !(result = this.getOperationService().updateEntry(dn, (List<Modification>)modifications))) {
                throw new EntryPersistenceException(String.format("Failed to update entry: %s", dn));
            }
        }
        catch (ConnectionException ex) {
            throw new EntryPersistenceException(String.format("Failed to update entry: %s", dn), ex.getCause());
        }
        catch (Exception ex) {
            throw new EntryPersistenceException(String.format("Failed to update entry: %s", dn), (Throwable)ex);
        }
    }

    public <T> void removeByDn(String dn, String[] objectClasses) {
        try {
            for (DeleteNotifier subscriber : this.subscribers) {
                subscriber.onBeforeRemove(dn, objectClasses);
            }
            this.getOperationService().delete(dn);
            for (DeleteNotifier subscriber : this.subscribers) {
                subscriber.onAfterRemove(dn, objectClasses);
            }
        }
        catch (Exception ex) {
            throw new EntryDeleteException(String.format("Failed to remove entry: %s", dn), (Throwable)ex);
        }
    }

    public <T> int remove(String baseDN, Class<T> entryClass, Filter filter, int count) {
        if (StringHelper.isEmptyString((Object)baseDN)) {
            throw new MappingException("Base DN to find entries is null");
        }
        this.checkEntryClass(entryClass, false);
        String[] objectClasses = this.getTypeObjectClasses(entryClass);
        List propertiesAnnotations = this.getEntryPropertyAnnotations(entryClass);
        Filter searchFilter = objectClasses.length > 0 ? this.addObjectClassFilter(filter, objectClasses) : filter;
        DeleteBatchOperation batchOperation = new DeleteBatchOperation(this);
        try {
            LdapBatchOperationWraper batchOperationWraper = new LdapBatchOperationWraper(batchOperation, this, entryClass, propertiesAnnotations);
            this.getOperationService().search(baseDN, this.toLdapFilter(searchFilter), this.toLdapSearchScope(io.jans.orm.model.SearchScope.SUB), batchOperationWraper, 0, count, 100, null, "dn");
        }
        catch (Exception ex) {
            throw new EntryDeleteException(String.format("Failed to delete entries with baseDN: %s, filter: %s", baseDN, searchFilter), (Throwable)ex);
        }
        return batchOperation.getCountEntries();
    }

    public <T> void removeRecursivelyFromDn(String dn, String[] objectClasses) {
        try {
            if (this.getOperationService().getConnectionProvider().isSupportsSubtreeDeleteRequestControl()) {
                for (DeleteNotifier subscriber : this.subscribers) {
                    subscriber.onBeforeRemove(dn, objectClasses);
                }
                this.getOperationService().deleteRecursively(dn);
                for (DeleteNotifier subscriber : this.subscribers) {
                    subscriber.onAfterRemove(dn, objectClasses);
                }
            } else {
                this.removeSubtreeThroughIteration(dn, objectClasses);
            }
        }
        catch (Exception ex) {
            throw new EntryDeleteException(String.format("Failed to remove entry: %s", dn), (Throwable)ex);
        }
    }

    private void removeSubtreeThroughIteration(String dn, String[] objectClasses) {
        io.jans.orm.model.SearchScope scope = io.jans.orm.model.SearchScope.SUB;
        PagedResult<EntryData> searchResult = null;
        try {
            searchResult = this.getOperationService().search(dn, this.toLdapFilter(Filter.createPresenceFilter((String)"objectClass")), this.toLdapSearchScope(scope), null, 0, 0, 0, null, "dn");
        }
        catch (SearchScopeException ex) {
            throw new AuthenticationException(String.format("Failed to convert scope: %s", scope), (Throwable)ex);
        }
        catch (SearchException ex) {
            throw new EntryDeleteException(String.format("Failed to find sub-entries of entry '%s' for removal", dn), (Throwable)ex);
        }
        ArrayList<String> removeEntriesDn = new ArrayList<String>(searchResult.getEntriesCount());
        for (EntryData entry : searchResult.getEntries()) {
            removeEntriesDn.add(entry.getAttributeData("dn").getStringValues()[0]);
        }
        Collections.sort(removeEntriesDn, LINE_LENGHT_COMPARATOR);
        for (String removeEntryDn : removeEntriesDn) {
            this.removeByDn(removeEntryDn, objectClasses);
        }
    }

    protected List<AttributeData> find(String dn, String[] objectClasses, Map<String, PropertyAnnotation> propertiesAnnotationsMap, String ... ldapReturnAttributes) {
        try {
            EntryData result = this.getOperationService().lookup(dn, ldapReturnAttributes);
            if (result != null) {
                return result.getAttributeData();
            }
        }
        catch (Exception ex) {
            throw new EntryPersistenceException(String.format("Failed to find entry: %s", dn), (Throwable)ex);
        }
        throw new EntryPersistenceException(String.format("Failed to find entry: %s", dn));
    }

    public <T> List<T> findEntries(String baseDN, Class<T> entryClass, Filter filter, io.jans.orm.model.SearchScope scope, String[] ldapReturnAttributes, BatchOperation<T> batchOperation, int start, int count, int chunkSize) {
        if (StringHelper.isEmptyString((Object)baseDN)) {
            throw new MappingException("Base DN to find entries is null");
        }
        this.checkEntryClass(entryClass, false);
        String[] objectClasses = this.getTypeObjectClasses(entryClass);
        List propertiesAnnotations = this.getEntryPropertyAnnotations(entryClass);
        Object[] currentLdapReturnAttributes = ldapReturnAttributes;
        if (ArrayHelper.isEmpty((Object[])currentLdapReturnAttributes)) {
            currentLdapReturnAttributes = this.getAttributes(null, propertiesAnnotations, false);
        }
        Filter searchFilter = objectClasses.length > 0 ? this.addObjectClassFilter(filter, objectClasses) : filter;
        PagedResult<EntryData> searchResult = null;
        try {
            LdapBatchOperationWraper<T> batchOperationWraper = new LdapBatchOperationWraper<T>(batchOperation, this, entryClass, propertiesAnnotations);
            searchResult = this.getOperationService().search(baseDN, this.toLdapFilter(searchFilter), this.toLdapSearchScope(scope), batchOperationWraper, start, count, chunkSize, null, (String[])currentLdapReturnAttributes);
        }
        catch (Exception ex) {
            throw new EntryPersistenceException(String.format("Failed to find entries with baseDN: %s, filter: %s", baseDN, searchFilter), (Throwable)ex);
        }
        if (searchResult.getEntriesCount() == 0) {
            return new ArrayList(0);
        }
        List<T> entries = this.createEntities(entryClass, propertiesAnnotations, searchResult.getEntries());
        this.sortEntriesIfNeeded(entryClass, entries);
        return entries;
    }

    public <T> PagedResult<T> findPagedEntries(String baseDN, Class<T> entryClass, Filter filter, String[] ldapReturnAttributes, String sortBy, SortOrder sortOrder, int start, int count, int chunkSize) {
        PagedResult<EntryData> searchResponse;
        if (StringHelper.isEmptyString((Object)baseDN)) {
            throw new MappingException("Base DN to find entries is null");
        }
        this.checkEntryClass(entryClass, false);
        String[] objectClasses = this.getTypeObjectClasses(entryClass);
        List propertiesAnnotations = this.getEntryPropertyAnnotations(entryClass);
        Object[] currentLdapReturnAttributes = ldapReturnAttributes;
        if (ArrayHelper.isEmpty((Object[])currentLdapReturnAttributes)) {
            currentLdapReturnAttributes = this.getAttributes(null, propertiesAnnotations, false);
        }
        Filter searchFilter = objectClasses.length > 0 ? this.addObjectClassFilter(filter, objectClasses) : filter;
        try {
            searchResponse = this.getOperationService().searchPagedEntries(baseDN, this.toLdapFilter(searchFilter), this.toLdapSearchScope(io.jans.orm.model.SearchScope.SUB), start, count, chunkSize, sortBy, sortOrder, (String[])currentLdapReturnAttributes);
        }
        catch (Exception ex) {
            throw new EntryPersistenceException(String.format("Failed to find entries with baseDN: %s, filter: %s", baseDN, searchFilter), (Throwable)ex);
        }
        PagedResult result = new PagedResult();
        result.setEntriesCount(searchResponse.getEntriesCount());
        result.setTotalEntriesCount(searchResponse.getTotalEntriesCount());
        result.setStart(start);
        List<Object> entries = new ArrayList(0);
        if (searchResponse.getEntriesCount() > 0) {
            entries = this.createEntitiesVirtualListView(entryClass, propertiesAnnotations, searchResponse.getEntries());
        }
        result.setEntries(entries);
        return result;
    }

    protected <T> boolean contains(String baseDN, String[] objectClasses, Class<T> entryClass, List<PropertyAnnotation> propertiesAnnotations, Filter filter, String[] ldapReturnAttributes) {
        PagedResult<EntryData> searchResult;
        block4: {
            if (StringHelper.isEmptyString((Object)baseDN)) {
                throw new MappingException("Base DN to check contain entries is null");
            }
            Filter searchFilter = objectClasses.length > 0 ? this.addObjectClassFilter(filter, objectClasses) : filter;
            io.jans.orm.model.SearchScope scope = io.jans.orm.model.SearchScope.SUB;
            searchResult = null;
            try {
                searchResult = this.getOperationService().search(baseDN, this.toLdapFilter(searchFilter), this.toLdapSearchScope(scope), null, 0, 1, 1, null, ldapReturnAttributes);
            }
            catch (SearchScopeException ex) {
                throw new AuthenticationException(String.format("Failed to convert scope: %s", scope), (Throwable)ex);
            }
            catch (SearchException ex) {
                if (32 == ex.getErrorCode()) break block4;
                throw new EntryPersistenceException(String.format("Failed to find entry with baseDN: %s, filter: %s", baseDN, searchFilter), (Throwable)ex);
            }
        }
        return searchResult != null && searchResult.getEntriesCount() > 0;
    }

    protected <T> List<T> createEntities(Class<T> entryClass, List<PropertyAnnotation> propertiesAnnotations, List<EntryData> searchResultEntries) {
        ArrayList result = new ArrayList(searchResultEntries.size());
        HashMap<String, List> entriesAttributes = new HashMap<String, List>(100);
        int count = 0;
        for (EntryData entry : searchResultEntries) {
            entriesAttributes.put(entry.getDN(), entry.getAttributeData());
            if (++count < 100) continue;
            List currentResult = this.createEntities(entryClass, propertiesAnnotations, entriesAttributes);
            result.addAll(currentResult);
            entriesAttributes = new HashMap(100);
            count = 0;
        }
        List currentResult = this.createEntities(entryClass, propertiesAnnotations, entriesAttributes);
        result.addAll(currentResult);
        return result;
    }

    private <T> List<T> createEntitiesVirtualListView(Class<T> entryClass, List<PropertyAnnotation> propertiesAnnotations, List<EntryData> searchResultEntries) {
        LinkedList result = new LinkedList();
        LinkedHashMap entriesAttributes = new LinkedHashMap(100);
        int count = 0;
        for (EntryData entry : searchResultEntries) {
            ++count;
            LinkedList attributeDataLinkedList = new LinkedList();
            attributeDataLinkedList.addAll(entry.getAttributeData());
            entriesAttributes.put(entry.getDN(), attributeDataLinkedList);
            if (count < 100) continue;
            LinkedList currentResult = new LinkedList();
            currentResult.addAll(this.createEntities(entryClass, propertiesAnnotations, entriesAttributes, false));
            result.addAll(currentResult);
            entriesAttributes = new LinkedHashMap(100);
            count = 0;
        }
        List currentResult = this.createEntities(entryClass, propertiesAnnotations, entriesAttributes, false);
        result.addAll(currentResult);
        return result;
    }

    protected List<AttributeData> getAttributeDataListFromLocalizedString(String ldapAttributeName, LocalizedString localizedString) {
        ArrayList<AttributeData> listAttributes = new ArrayList<AttributeData>();
        localizedString.getLanguageTags().forEach(languageTag -> {
            String value = localizedString.getValue(languageTag);
            String ldapAttributeNameLocalized = ldapAttributeName.replace("Localized", "");
            String key = localizedString.addLdapLanguageTag(ldapAttributeNameLocalized, languageTag);
            AttributeData attributeData = new AttributeData(key, (Object)value);
            listAttributes.add(attributeData);
        });
        return listAttributes;
    }

    protected void loadLocalizedString(Map<String, AttributeData> attributesMap, LocalizedString localizedString, Map<String, AttributeData> filteredAttrs) {
        filteredAttrs.forEach((key, value) -> {
            AttributeData data = (AttributeData)attributesMap.get(key);
            String[] keyParts = key.split(";");
            if (keyParts.length == 1) {
                localizedString.setValue(data.getValue().toString());
            } else if (keyParts.length == 2) {
                String lagTag = keyParts[1].replace("lang-", "");
                localizedString.setValue(data.getValue().toString(), Locale.forLanguageTag(lagTag));
            }
        });
    }

    public <T> boolean authenticate(String baseDN, Class<T> entryClass, String userName, String password) {
        if (StringHelper.isEmptyString((Object)baseDN)) {
            throw new MappingException("Base DN to count entries is null");
        }
        this.checkEntryClass(entryClass, false);
        String[] objectClasses = this.getTypeObjectClasses(entryClass);
        Filter searchFilter = Filter.createEqualityFilter((String)"uid", (Object)userName);
        if (objectClasses.length > 0) {
            searchFilter = this.addObjectClassFilter(searchFilter, objectClasses);
        }
        io.jans.orm.model.SearchScope scope = io.jans.orm.model.SearchScope.SUB;
        try {
            PagedResult<EntryData> searchResult = this.getOperationService().search(baseDN, this.toLdapFilter(searchFilter), this.toLdapSearchScope(scope), null, 0, 1, 1, null, LdapOperationService.UID_ARRAY);
            if (searchResult == null || searchResult.getEntriesCount() != 1) {
                return false;
            }
            String bindDn = ((EntryData)searchResult.getEntries().get(0)).getDN();
            return this.getOperationService().authenticate(bindDn, password, null);
        }
        catch (ConnectionException ex) {
            throw new AuthenticationException(String.format("Failed to authenticate user: %s", userName), (Throwable)ex);
        }
        catch (SearchScopeException ex) {
            throw new AuthenticationException(String.format("Failed to convert scope: %s", scope), (Throwable)ex);
        }
        catch (SearchException ex) {
            throw new AuthenticationException(String.format("Failed to find user DN: %s", userName), (Throwable)ex);
        }
    }

    @Deprecated
    public boolean authenticate(String bindDn, String password) {
        return this.authenticate(bindDn, null, password);
    }

    public <T> boolean authenticate(String bindDn, Class<T> entryClass, String password) {
        try {
            return this.getOperationService().authenticate(bindDn, password, null);
        }
        catch (Exception ex) {
            throw new AuthenticationException(String.format("Failed to authenticate DN: %s", bindDn), (Throwable)ex);
        }
    }

    public <T> int countEntries(String baseDN, Class<T> entryClass, Filter filter) {
        return this.countEntries(baseDN, entryClass, filter, null);
    }

    public <T> int countEntries(String baseDN, Class<T> entryClass, Filter filter, io.jans.orm.model.SearchScope scope) {
        PagedResult<EntryData> searchResult;
        CountBatchOperation batchOperation;
        String[] ldapReturnAttributes;
        if (StringHelper.isEmptyString((Object)baseDN)) {
            throw new MappingException("Base DN to count entries is null");
        }
        this.checkEntryClass(entryClass, false);
        String[] objectClasses = this.getTypeObjectClasses(entryClass);
        Filter searchFilter = objectClasses.length > 0 ? this.addObjectClassFilter(filter, objectClasses) : filter;
        io.jans.orm.model.SearchScope searchScope = scope;
        if (searchScope == null) {
            searchScope = io.jans.orm.model.SearchScope.SUB;
        }
        if (io.jans.orm.model.SearchScope.BASE == searchScope) {
            ldapReturnAttributes = new String[]{"numsubordinates"};
            batchOperation = null;
        } else {
            ldapReturnAttributes = new String[]{""};
            batchOperation = new CountBatchOperation();
        }
        try {
            LdapBatchOperationWraper batchOperationWraper = null;
            if (batchOperation != null) {
                batchOperationWraper = new LdapBatchOperationWraper(batchOperation);
            }
            searchResult = this.getOperationService().search(baseDN, this.toLdapFilter(searchFilter), this.toLdapSearchScope(searchScope), batchOperationWraper, 0, 0, 100, null, ldapReturnAttributes);
        }
        catch (Exception ex) {
            throw new EntryPersistenceException(String.format("Failed to calculate the number of entries with baseDN: %s, filter: %s", baseDN, searchFilter), (Throwable)ex);
        }
        if (io.jans.orm.model.SearchScope.BASE != searchScope) {
            return batchOperation.getCountEntries();
        }
        if (searchResult.getEntriesCount() != 1) {
            throw new EntryPersistenceException(String.format("Failed to calculate the number of entries due to missing result entry with baseDN: %s, filter: %s", baseDN, searchFilter));
        }
        Integer result = (Integer)((EntryData)searchResult.getEntries().get(0)).getAttributeData("numsubordinates").getValue();
        if (result == null) {
            throw new EntryPersistenceException(String.format("Failed to calculate the number of entries due to missing attribute 'numsubordinates' with baseDN: %s, filter: %s", baseDN, searchFilter));
        }
        return result;
    }

    public String encodeTime(String baseDN, Date date) {
        if (date == null) {
            return null;
        }
        return StaticUtils.encodeGeneralizedTime((Date)date);
    }

    protected String encodeTime(Date date) {
        return this.encodeTime(null, date);
    }

    public Date decodeTime(String baseDN, String date) {
        if (date == null) {
            return null;
        }
        try {
            return StaticUtils.decodeGeneralizedTime((String)date);
        }
        catch (ParseException ex) {
            LOG.error("Failed to parse generalized time {}", (Object)date, (Object)ex);
            return null;
        }
    }

    protected Date decodeTime(String date) {
        return this.decodeTime(null, date);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadLdifFileContent(String ldifFileContent) {
        LDAPConnection connection = null;
        try {
            connection = this.getOperationService().getConnection();
            ResultCode result = LdifDataUtility.instance().importLdifFileContent(connection, ldifFileContent);
            boolean bl = ResultCode.SUCCESS.equals((Object)result);
            return bl;
        }
        catch (Exception ex) {
            LOG.error("Failed to load ldif file", (Throwable)ex);
            boolean bl = false;
            return bl;
        }
        finally {
            if (connection != null) {
                this.getOperationService().releaseConnection(connection);
            }
        }
    }

    public List<AttributeData> exportEntry(String dn) {
        try {
            EntryData result = this.getOperationService().lookup(dn, null);
            if (result != null) {
                return result.getAttributeData();
            }
            return null;
        }
        catch (ConnectionException | SearchException ex) {
            throw new EntryPersistenceException(String.format("Failed to find entry: %s", dn), ex);
        }
    }

    public <T> List<AttributeData> exportEntry(String dn, String objectClass) {
        return this.exportEntry(dn);
    }

    public int getSupportedLDAPVersion() {
        return this.getOperationService().getSupportedLDAPVersion();
    }

    private Modification createModification(ModificationType modificationType, String attributeName, String ... attributeValues) {
        Object realAttributeName = attributeName;
        if (this.getOperationService().isCertificateAttribute((String)realAttributeName)) {
            realAttributeName = (String)realAttributeName + ";binary";
            byte[][] binaryValues = this.toBinaryValues(attributeValues);
            return new Modification(modificationType, (String)realAttributeName, binaryValues);
        }
        return new Modification(modificationType, (String)realAttributeName, attributeValues);
    }

    private String[] convertValuesToStringValues(Object ... attributeValues) {
        if (attributeValues == null) {
            return null;
        }
        String[] attributeStringValues = new String[attributeValues.length];
        for (int i = 0; i < attributeValues.length; ++i) {
            attributeStringValues[i] = attributeValues[i] instanceof Date ? StaticUtils.encodeGeneralizedTime((Date)((Date)attributeValues[i])) : attributeValues[i].toString();
        }
        return attributeStringValues;
    }

    private com.unboundid.ldap.sdk.Filter toLdapFilter(Filter genericFilter) throws SearchException {
        return LDAP_FILTER_CONVERTER.convertToLdapFilter(this.filterProcessor.excludeLowerFilter(genericFilter));
    }

    private SearchScope toLdapSearchScope(io.jans.orm.model.SearchScope scope) throws SearchScopeException {
        return LDAP_SEARCH_SCOPE_CONVERTER.convertToLdapSearchScope(scope);
    }

    public boolean hasBranchesSupport(String dn) {
        return true;
    }

    public boolean hasExpirationSupport(String primaryKey) {
        return false;
    }

    public String getPersistenceType() {
        return LdapEntryManagerFactory.PERSISTENCE_TYPE;
    }

    public String getPersistenceType(String primaryKey) {
        return LdapEntryManagerFactory.PERSISTENCE_TYPE;
    }

    public PersistenceEntryManager getPersistenceEntryManager(String persistenceType) {
        if (LdapEntryManagerFactory.PERSISTENCE_TYPE.equals(persistenceType)) {
            return this;
        }
        return null;
    }

    public String[] getObjectClasses(Object entry, Class<?> entryClass) {
        String[] ojectClasses = super.getObjectClasses(entry, entryClass);
        HashSet<String> objecClassSet = new HashSet<String>();
        objecClassSet.add("top");
        objecClassSet.addAll(Arrays.asList(ojectClasses));
        return objecClassSet.toArray(new String[0]);
    }

    protected Object getNativeDateAttributeValue(Date dateValue) {
        return this.encodeTime(dateValue);
    }

    protected void addAttributeDataFromLocalizedString(Object entry, Annotation ldapAttribute, String propertyName, List<AttributeData> attributes) {
        Class<?> entryClass = entry.getClass();
        Getter getter = this.getGetter(entryClass, propertyName);
        if (getter == null) {
            throw new MappingException("Entry should has getter for property " + propertyName);
        }
        Object propertyValue = getter.get(entry);
        if (propertyValue == null) {
            return;
        }
        if (!(propertyValue instanceof LocalizedString)) {
            throw new MappingException("Entry property should be LocalizedString");
        }
        LocalizedString localizedString = (LocalizedString)propertyValue;
        String ldapAttributeName = ((AttributeName)ldapAttribute).name();
        List<AttributeData> listAttributes = this.getAttributeDataListFromLocalizedString(ldapAttributeName, localizedString);
        if (listAttributes != null) {
            attributes.addAll(listAttributes);
        }
    }

    public <T> AttributeType getAttributeType(String primaryKey, Class<T> entryClass, String propertyName) {
        this.checkEntryClass(entryClass, false);
        String[] objectClasses = this.getTypeObjectClasses(entryClass);
        LdapOperationServiceImpl ldapOperationService = this.getOperationService();
        for (String objectClass : objectClasses) {
            Set<String> attributes = ldapOperationService.getAttributes(objectClass);
            if (!attributes.contains(propertyName.toLowerCase())) continue;
            String type = ldapOperationService.getAttributeType(propertyName.toLowerCase());
            return new AttributeType(propertyName, propertyName.toLowerCase(), type, null);
        }
        return null;
    }

    private static final class DeleteBatchOperation<T>
    extends DefaultBatchOperation<T> {
        private int countEntries = 0;
        private LdapEntryManager ldapEntryManager;

        public DeleteBatchOperation(LdapEntryManager ldapEntryManager) {
            this.ldapEntryManager = ldapEntryManager;
        }

        public void performAction(List<T> entries) {
            for (T entity : entries) {
                try {
                    Class<?> entryClass = entity.getClass();
                    String dnValue = this.ldapEntryManager.getDNValue(entity, entryClass).toString();
                    if (this.ldapEntryManager.hasBranchesSupport(dnValue)) {
                        this.ldapEntryManager.removeRecursively(dnValue, entryClass);
                    } else {
                        this.ldapEntryManager.remove(dnValue, entryClass);
                    }
                    LOG.trace("Removed {}", (Object)dnValue);
                }
                catch (Exception e) {
                    LOG.error("Failed to remove entry, entity: " + entity, (Throwable)e);
                }
            }
        }

        public boolean collectSearchResult(int size) {
            this.countEntries += size;
            return false;
        }

        public int getCountEntries() {
            return this.countEntries;
        }
    }

    private static class CountBatchOperation<T>
    extends DefaultBatchOperation<T> {
        private int countEntries = 0;

        private CountBatchOperation() {
        }

        public void performAction(List<T> entries) {
        }

        public boolean collectSearchResult(int size) {
            this.countEntries += size;
            return false;
        }

        public int getCountEntries() {
            return this.countEntries;
        }
    }
}

