/*
 * Decompiled with CFR 0.152.
 */
package io.jans.orm.couchbase.model;

import com.couchbase.client.java.json.JsonObject;
import java.util.HashSet;
import java.util.Set;

public class ConvertedExpression {
    private String expression;
    private JsonObject queryParameters;
    private boolean consistency;
    private Set<String> singleLevelParameters;

    private ConvertedExpression(String expression, JsonObject queryParameters) {
        this.expression = expression;
        this.queryParameters = queryParameters;
        this.singleLevelParameters = new HashSet<String>();
    }

    private ConvertedExpression(String expression, JsonObject queryParameters, boolean consistency) {
        this(expression, queryParameters);
        this.consistency = consistency;
    }

    public static ConvertedExpression build(String expression, JsonObject queryParameters, boolean consistency) {
        return new ConvertedExpression(expression, queryParameters, consistency);
    }

    public static ConvertedExpression build(String expression, JsonObject queryParameters, String queryParameter, boolean consistency) {
        ConvertedExpression convertedExpression = new ConvertedExpression(expression, queryParameters, consistency);
        convertedExpression.getSingleLevelParameters().add(queryParameter);
        return convertedExpression;
    }

    public String expression() {
        return this.expression;
    }

    public JsonObject getQueryParameters() {
        return this.queryParameters;
    }

    public boolean consistency() {
        return this.consistency;
    }

    public void consistency(boolean consistency) {
        this.consistency = consistency;
    }

    public Set<String> getSingleLevelParameters() {
        return this.singleLevelParameters;
    }

    public String toString() {
        return "ConvertedExpression [expression=" + this.expression + ", queryParameters=" + this.queryParameters + ", consistency=" + this.consistency + ", singleLevelParameters=" + this.singleLevelParameters + "]";
    }
}

