/*
 * Decompiled with CFR 0.152.
 */
package io.jans.kc.spi.custom.impl;

import io.jans.kc.spi.custom.JansThinBridgeInitException;
import io.jans.kc.spi.custom.JansThinBridgeProvider;
import io.jans.kc.spi.custom.JansThinBridgeProviderFactory;
import io.jans.kc.spi.custom.impl.DefaultJansThinBridgeProvider;
import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.PersistenceEntryManagerFactory;
import io.jans.orm.model.PersistenceConfiguration;
import io.jans.orm.service.PersistanceFactoryService;
import io.jans.orm.service.StandalonePersistanceFactoryService;
import io.jans.orm.util.properties.FileConfiguration;
import io.jans.util.security.PropertiesDecrypter;
import io.jans.util.security.StringEncrypter;
import java.io.File;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;

public class DefaultJansThinBridgeProviderFactory
implements JansThinBridgeProviderFactory {
    private static final Logger log = Logger.getLogger(DefaultJansThinBridgeProviderFactory.class);
    private static final String DEFAULT_CONFIG_FILENAME = "jans.properties";
    private static final String SALT_FILENAME = "salt";
    private static final String PROVIDER_ID = "kc-jans-thin-bridge-default";
    private final PersistanceFactoryService persistenceFactoryService;
    private final PersistenceConfiguration persistenceConfiguration;
    private final PersistenceEntryManager persistenceEntryManager;

    public DefaultJansThinBridgeProviderFactory() {
        String salt;
        log.info((Object)"Establishing connection with janssen database");
        this.persistenceFactoryService = new StandalonePersistanceFactoryService();
        this.persistenceConfiguration = this.persistenceFactoryService.loadPersistenceConfiguration(DEFAULT_CONFIG_FILENAME);
        if (this.persistenceConfiguration == null) {
            throw new JansThinBridgeInitException("Failed to load persistence configuration from file. \n+ Jans configuration base directory: " + this.getJansConfigurationBaseDir() + "\n+ Jans configuration default file: jans.properties");
        }
        Object confdir = this.persistenceConfiguration.getConfiguration().getString("confDir");
        if (!StringUtils.isNotBlank((CharSequence)confdir)) {
            confdir = this.getJansConfigurationBaseDir() + File.separator + "conf" + File.separator;
        }
        if (!StringUtils.isNotBlank((CharSequence)(salt = this.cryptographicSaltFromFile((String)confdir + SALT_FILENAME)))) {
            throw new JansThinBridgeInitException("Failed to load cryptographic material from configuration");
        }
        this.persistenceEntryManager = this.createPersistenceEntryManager(this.persistenceConfiguration, this.persistenceFactoryService, salt);
        log.info((Object)"Connection established to janssen database");
    }

    public JansThinBridgeProvider create(KeycloakSession session) {
        return new DefaultJansThinBridgeProvider(this.persistenceEntryManager);
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return PROVIDER_ID;
    }

    private final String cryptographicSaltFromFile(String path) {
        FileConfiguration cryptoconfig = new FileConfiguration(path);
        return cryptoconfig.getString("encodeSalt");
    }

    private final Properties preparePersistenceProperties(PersistenceConfiguration persistenceConfiguration, String salt) {
        try {
            FileConfiguration config = persistenceConfiguration.getConfiguration();
            Properties connprops = config.getProperties();
            return PropertiesDecrypter.decryptAllProperties((StringEncrypter)StringEncrypter.defaultInstance(), (Properties)connprops, (String)salt);
        }
        catch (StringEncrypter.EncryptionException e) {
            throw new JansThinBridgeInitException("Failed to decrypt persistence connection parameters", e);
        }
    }

    private final PersistenceEntryManager createPersistenceEntryManager(PersistenceConfiguration config, PersistanceFactoryService persistenceFactoryService, String salt) {
        Properties persistconnprops = this.preparePersistenceProperties(config, salt);
        PersistenceEntryManagerFactory peManagerFactory = persistenceFactoryService.getPersistenceEntryManagerFactory(config);
        return peManagerFactory.createEntryManager(persistconnprops);
    }

    private final String getJansConfigurationBaseDir() {
        if (System.getProperty("jans.base") != null) {
            return System.getProperty("jans.base");
        }
        if (System.getProperty("catalina.base") != null && System.getProperty("catalina.base.ignore") == null) {
            return System.getProperty("catalina.base");
        }
        if (System.getProperty("catalina.home") != null) {
            return System.getProperty("catalina.home");
        }
        return null;
    }
}

