/*
 * Decompiled with CFR 0.152.
 */
package io.jans.util.io;

import java.io.InputStream;
import java.util.Date;

public class DownloadWrapper {
    private InputStream stream;
    private String name;
    private String contentType;
    private Date modificationDate;
    private int contentLength;

    public DownloadWrapper(InputStream stream, String name, String contentType, Date modificationDate) {
        this(stream, name, contentType, modificationDate, 0);
    }

    public DownloadWrapper(InputStream stream, String name, String contentType, Date modificationDate, int contentLength) {
        this.stream = stream;
        this.name = name;
        this.contentType = contentType;
        this.modificationDate = modificationDate != null ? new Date(modificationDate.getTime()) : null;
        this.contentLength = contentLength;
    }

    public InputStream getStream() {
        return this.stream;
    }

    public String getName() {
        return this.name;
    }

    public String getContentType() {
        return this.contentType;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public void setContentLength(int contentLength) {
        this.contentLength = contentLength;
    }

    public Date getModificationDate() {
        return this.modificationDate != null ? new Date(this.modificationDate.getTime()) : null;
    }

    public void setModificationDate(Date modificationDate) {
        this.modificationDate = modificationDate != null ? new Date(modificationDate.getTime()) : null;
    }

    public boolean isReady() {
        return this.stream != null && this.name != null && this.contentType != null && this.modificationDate != null && this.contentLength >= 0;
    }

    public String toString() {
        return String.format("FileDownloadWrapper [contentLength=%s, contentType=%s, modificationDate=%s, name=%s, stream=%s]", this.contentLength, this.contentType, this.modificationDate, this.name, this.stream);
    }
}

