/*
 * Decompiled with CFR 0.152.
 */
package io.jans.service.document.store.provider;

import io.jans.service.document.store.conf.DocumentStoreConfiguration;
import io.jans.service.document.store.conf.DocumentStoreType;
import io.jans.service.document.store.conf.LocalDocumentStoreConfiguration;
import io.jans.service.document.store.exception.DocumentException;
import io.jans.service.document.store.exception.WriteDocumentException;
import io.jans.service.document.store.provider.DocumentStoreProvider;
import io.jans.util.StringHelper;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class LocalDocumentStoreProvider
extends DocumentStoreProvider<String> {
    @Inject
    private Logger log;
    @Inject
    private DocumentStoreConfiguration documentStoreConfiguration;
    private LocalDocumentStoreConfiguration localDocumentStoreConfiguration;
    private String baseLocation;

    @PostConstruct
    public void init() {
        this.localDocumentStoreConfiguration = this.documentStoreConfiguration.getLocalConfiguration();
    }

    @Override
    public void create() {
        this.log.debug("Starting LocalDocumentStoreProvider ...");
        if (StringHelper.isEmpty((String)this.localDocumentStoreConfiguration.getBaseLocation())) {
            String osName = System.getProperty("os.name");
            if (StringHelper.isNotEmpty((String)osName) && osName.toLowerCase().startsWith("windows")) {
                this.baseLocation = "";
                return;
            }
            throw new IllegalArgumentException("Base location should not be empty");
        }
        this.baseLocation = new File(this.localDocumentStoreConfiguration.getBaseLocation()).getAbsolutePath();
    }

    public void configure(DocumentStoreConfiguration documentStoreConfiguration) {
        this.log = LoggerFactory.getLogger(DocumentStoreConfiguration.class);
        this.documentStoreConfiguration = documentStoreConfiguration;
    }

    @Override
    @PreDestroy
    public void destroy() {
        this.log.debug("Destroying LocalDocumentStoreProvider");
        this.log.debug("Destroyed LocalDocumentStoreProvider");
    }

    @Override
    public DocumentStoreType getProviderType() {
        return DocumentStoreType.LOCAL;
    }

    @Override
    public boolean hasDocument(String path) {
        this.log.debug("Has document: '{}'", (Object)path);
        if (StringHelper.isEmpty((String)path)) {
            throw new IllegalArgumentException("Specified path should not be empty!");
        }
        File file = this.buildFilePath(path);
        return file.exists();
    }

    @Override
    public String saveDocument(String path, String description, String documentContent, Charset charset, String module) {
        String string;
        block9: {
            this.log.debug("Save document: '{}'", (Object)path);
            File file = this.buildFilePath(path);
            if (!this.createParentPath(file)) {
                return null;
            }
            FileOutputStream os = FileUtils.openOutputStream((File)file);
            try {
                IOUtils.write((String)documentContent, (OutputStream)os, (Charset)charset);
                os.flush();
                string = path;
                if (os == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    this.log.error("Failed to write document to file '{}'", (Object)file.getAbsolutePath(), (Object)ex);
                    throw new WriteDocumentException(ex);
                }
            }
            os.close();
        }
        return string;
    }

    @Override
    public String saveDocumentStream(String path, String description, InputStream documentStream, String module) {
        String string;
        block9: {
            this.log.debug("Save document from stream: '{}'", (Object)path);
            File file = this.buildFilePath(path);
            if (!this.createParentPath(file)) {
                return null;
            }
            FileOutputStream os = FileUtils.openOutputStream((File)file);
            try {
                IOUtils.copy((InputStream)documentStream, (OutputStream)os);
                os.flush();
                string = path;
                if (os == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    this.log.error("Failed to write document from stream to file '{}'", (Object)file.getAbsolutePath(), (Object)ex);
                    throw new WriteDocumentException(ex);
                }
            }
            os.close();
        }
        return string;
    }

    @Override
    public String saveBinaryDocumentStream(String path, String description, InputStream documentStream, String module) {
        return this.saveDocumentStream(path, description, documentStream, module);
    }

    @Override
    public String readDocument(String path, Charset charset) {
        this.log.debug("Read document: '{}'", (Object)path);
        File file = this.buildFilePath(path);
        if (!this.createParentPath(file)) {
            return null;
        }
        try {
            return FileUtils.readFileToString((File)file, (Charset)charset);
        }
        catch (Exception ex) {
            this.log.error("Failed to read document from file '{}'", (Object)file.getAbsolutePath(), (Object)ex);
            throw new DocumentException(ex);
        }
    }

    @Override
    public InputStream readDocumentAsStream(String path) {
        this.log.debug("Read document as stream: '{}'", (Object)path);
        File file = this.buildFilePath(path);
        try {
            return new BufferedInputStream(FileUtils.openInputStream((File)file));
        }
        catch (Exception ex) {
            this.log.error("Failed to read document as stream from file '{}'", (Object)file.getAbsolutePath(), (Object)ex);
            throw new DocumentException(ex);
        }
    }

    @Override
    public InputStream readBinaryDocumentAsStream(String path) {
        return this.readDocumentAsStream(path);
    }

    @Override
    public String renameDocument(String currentPath, String destinationPath) {
        this.log.debug("Rename document: '{}' -> '{}'", (Object)currentPath, (Object)destinationPath);
        File currentFile = this.buildFilePath(currentPath);
        File destinationFile = this.buildFilePath(destinationPath);
        if (!this.removeDocument(destinationPath)) {
            this.log.error("Failed to remove destination file '{}'", (Object)destinationFile.getAbsolutePath());
            return null;
        }
        try {
            currentFile.renameTo(destinationFile);
            return destinationPath;
        }
        catch (Exception ex) {
            this.log.error("Failed to rename to destination file '{}'", (Object)destinationFile.getAbsolutePath(), (Object)ex);
            throw new DocumentException(ex);
        }
    }

    @Override
    public boolean removeDocument(String path) {
        this.log.debug("Remove document: '{}'", (Object)path);
        if (!this.hasDocument(path)) {
            return true;
        }
        File file = this.buildFilePath(path);
        if (!this.createParentPath(file)) {
            return false;
        }
        return FileUtils.deleteQuietly((File)file);
    }

    private boolean createParentPath(File file) {
        try {
            FileUtils.forceMkdirParent((File)file);
            return true;
        }
        catch (IOException ex) {
            this.log.error("Failed to create path to file '{}'", (Object)file.getAbsolutePath(), (Object)ex);
            return false;
        }
    }

    private File buildFilePath(String path) {
        String filePath = this.baseLocation + File.separator + path;
        return new File(filePath);
    }

    @Override
    public List<String> findDocumentsByModules(List<String> moduleList, String ... attributes) {
        throw new RuntimeException("Not yet implemented");
    }
}

