/*
 * Decompiled with CFR 0.152.
 */
package io.jans.service.message.provider;

import io.jans.service.message.model.config.MessageConfiguration;
import io.jans.service.message.model.config.MessageProviderType;
import io.jans.service.message.provider.AbstractMessageProvider;
import io.jans.service.message.provider.MessageProvider;
import io.jans.service.message.provider.NullMessageProvider;
import io.jans.service.message.provider.PostgresMessageProvider;
import io.jans.service.message.provider.RedisMessageProvider;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;

@ApplicationScoped
public class MessageProviderFactory {
    public static final String MESSAGE_PROVIDER_THREAD_NAME = "MessageProviderThread";
    @Inject
    private Logger log;
    @Inject
    private MessageConfiguration messageConfiguration;
    @Inject
    @Any
    private Instance<MessageProvider> instance;
    private ExecutorService executorService;
    private MessageProvider messageProvider;

    @PostConstruct
    public void create() {
        this.executorService = Executors.newCachedThreadPool(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable);
                thread.setName(MessageProviderFactory.MESSAGE_PROVIDER_THREAD_NAME);
                thread.setDaemon(true);
                return thread;
            }
        });
    }

    @PreDestroy
    public void destroy() {
        this.shutdown();
    }

    @Produces
    @ApplicationScoped
    public MessageProvider getMessageProvider() {
        this.log.debug("Started to create message provider");
        this.messageProvider = this.getMessageProvider(this.messageConfiguration);
        return this.messageProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageProvider getMessageProvider(MessageConfiguration messageConfiguration) {
        MessageProviderType messageProviderType = messageConfiguration.getMessageProviderType();
        AbstractMessageProvider messageProvider = null;
        switch (messageProviderType) {
            case DISABLED: {
                messageProvider = (AbstractMessageProvider)this.instance.select(NullMessageProvider.class, new Annotation[0]).get();
                break;
            }
            case REDIS: {
                messageProvider = (AbstractMessageProvider)this.instance.select(RedisMessageProvider.class, new Annotation[0]).get();
                break;
            }
            case POSTGRES: {
                messageProvider = (AbstractMessageProvider)this.instance.select(PostgresMessageProvider.class, new Annotation[0]).get();
            }
        }
        if (messageProvider == null) {
            throw new RuntimeException("Failed to initialize messageProvider, messageProvider is unsupported: " + messageProviderType);
        }
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            messageProvider.create(this.executorService);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
        return messageProvider;
    }

    public int getActiveCount() {
        return ((ThreadPoolExecutor)this.executorService).getActiveCount();
    }

    public int getPoolSize() {
        return ((ThreadPoolExecutor)this.executorService).getPoolSize();
    }

    public void shutdown() {
        if (this.messageProvider != null) {
            this.log.info("Starting message provider shutdown...");
            this.messageProvider.shutdown();
            this.messageProvider = null;
        }
        if (this.executorService != null) {
            this.log.info("Starting message provider thread pool shutdown...");
            this.executorService.shutdownNow();
            this.executorService = null;
        }
        this.log.info("Successfully stopped message provider pool");
    }
}

