/*
 * Decompiled with CFR 0.152.
 */
package io.jans.service.cache;

import io.jans.service.cache.RedisConfiguration;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisPoolConfig;

public abstract class AbstractRedisProvider {
    protected RedisConfiguration redisConfiguration;

    public AbstractRedisProvider(RedisConfiguration redisConfiguration) {
        this.redisConfiguration = redisConfiguration;
        HostAndPort.setLocalhost((String)"127.0.0.1");
    }

    public JedisPoolConfig createPoolConfig() {
        JedisPoolConfig poolConfig = new JedisPoolConfig();
        poolConfig.setMaxTotal(this.redisConfiguration.getMaxTotalConnections());
        poolConfig.setMaxIdle(this.redisConfiguration.getMaxIdleConnections());
        poolConfig.setMinIdle(2);
        return poolConfig;
    }

    public RedisConfiguration getRedisConfiguration() {
        return this.redisConfiguration;
    }

    public void testConnection() {
        this.put(2, "testKey", "testValue");
        if (!"testValue".equals(this.get("testKey"))) {
            throw new RuntimeException("Failed to connect to redis server. Configuration: " + this.redisConfiguration);
        }
    }

    public boolean isConnected() {
        this.put(2, "testKey", "testValue");
        return "testValue".equals(this.get("testKey"));
    }

    public abstract void create();

    public abstract void destroy();

    public abstract Object getDelegate();

    public abstract boolean hasKey(String var1);

    public abstract Object get(String var1);

    public abstract void remove(String var1);

    public abstract void clear();

    public abstract void put(int var1, String var2, Object var3);

    public abstract void put(String var1, Object var2);
}

