/*
 * Decompiled with CFR 0.152.
 */
package io.jans.model.tokenstatus;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Base64;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.Deflater;

public class StatusList {
    private BitSet list;
    private final int bits;
    private final int divisor;

    public StatusList(int bits) {
        this.divisor = 8 / bits;
        this.list = new BitSet(bits);
        this.bits = bits;
    }

    public static StatusList fromEncoded(String encoded, int bits) throws IOException {
        StatusList newList = new StatusList(bits);
        newList.decode(encoded);
        return newList;
    }

    public String encodeAsString() throws IOException {
        byte[] byteArray = this.list.toByteArray();
        byte[] zipped = StatusList.compress(byteArray);
        return Base64.getUrlEncoder().withoutPadding().encodeToString(zipped);
    }

    public byte[] encodeAsBytes() throws IOException {
        byte[] byteArray = this.list.toByteArray();
        return StatusList.compress(byteArray);
    }

    public Map<String, Object> encodeAsJSON() throws IOException {
        String encodedList = this.encodeAsString();
        HashMap<String, Object> object = new HashMap<String, Object>();
        object.put("bits", this.bits);
        object.put("lst", encodedList);
        return object;
    }

    public void decode(String input) throws IOException {
        byte[] zipped = Base64.getUrlDecoder().decode(input + "=".repeat((4 - input.length() % 4) % 4));
        this.list = BitSet.valueOf(StatusList.decompress(zipped));
    }

    public void set(int pos, int value) {
        for (int i = 0; i < this.bits; ++i) {
            boolean bitValue = (value >> i & 1) == 1;
            this.list.set(pos * this.bits + i, bitValue);
        }
    }

    public void validateSetValue(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("Status value can't be less then 0.");
        }
        switch (this.bits) {
            case 1: {
                if (value > 1) {
                    throw new IllegalArgumentException("Value can't be more then 1. With bits " + this.bits + ".");
                }
                return;
            }
            case 2: {
                if (value > 3) {
                    throw new IllegalArgumentException("Value can't be more then 3. With bits " + this.bits + ".");
                }
                return;
            }
            case 4: {
                if (value > 15) {
                    throw new IllegalArgumentException("Value can't be more then 15. With bits " + this.bits + ".");
                }
                return;
            }
            case 8: {
                if (value > 255) {
                    throw new IllegalArgumentException("Value can't be more then 255. With bits " + this.bits + ".");
                }
                return;
            }
        }
        throw new IllegalArgumentException(String.format("Status value can't be %s. With bits %s.", value, this.bits));
    }

    public int get(int pos) {
        int value = 0;
        for (int i = 0; i < this.bits; ++i) {
            if (!this.list.get(pos * this.bits + i)) continue;
            value |= 1 << i;
        }
        return value;
    }

    public int getBitSetLength() {
        return this.list.length();
    }

    public String toString() {
        StringBuilder val = new StringBuilder();
        int size = this.list.length() / 8 * this.divisor;
        for (int x = 0; x < size; ++x) {
            val.append(Integer.toHexString(this.get(x)));
        }
        return val.toString();
    }

    private static byte[] compress(byte[] data) throws IOException {
        Deflater deflater = new Deflater(9);
        deflater.setInput(data);
        deflater.finish();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(data.length);
        byte[] buffer = new byte[1024];
        while (!deflater.finished()) {
            int count = deflater.deflate(buffer);
            outputStream.write(buffer, 0, count);
        }
        outputStream.close();
        return outputStream.toByteArray();
    }

    /*
     * Exception decompiling
     */
    private static byte[] decompress(byte[] data) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public int getBits() {
        return this.bits;
    }

    public int getDivisor() {
        return this.divisor;
    }

    public String getLst() throws IOException {
        return this.encodeAsString();
    }
}

