/*
 * Decompiled with CFR 0.152.
 */
package io.jans.config;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import io.jans.config.CustomProperty;
import io.jans.model.ldap.GluuLdapConfiguration;
import io.jans.orm.couchbase.model.CouchbaseConnectionConfiguration;
import io.jans.orm.sql.model.SqlConnectionConfiguration;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.List;

@XmlRootElement(name="oxIDPAuthConf")
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonPropertyOrder(value={"type", "name", "level", "priority", "enabled", "version", "fields", "config"})
@XmlType(propOrder={"type", "name", "level", "priority", "enabled", "version", "fields", "config"})
public class IDPAuthConf {
    private String type;
    private String name;
    private int level;
    private int priority;
    private boolean enabled;
    private List<CustomProperty> fields = new ArrayList<CustomProperty>();
    private int version;
    private JsonNode config;

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public List<CustomProperty> getFields() {
        return this.fields;
    }

    public void setFields(List<CustomProperty> fields) {
        this.fields = fields;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public JsonNode getConfig() {
        return this.config;
    }

    public void setConfig(JsonNode config) {
        this.config = config;
    }

    public GluuLdapConfiguration asLdapConfiguration() {
        return this.read(GluuLdapConfiguration.class);
    }

    public CouchbaseConnectionConfiguration asCouchbaseConfiguration() {
        return this.read(CouchbaseConnectionConfiguration.class);
    }

    public SqlConnectionConfiguration asSqlConfiguration() {
        return this.read(SqlConnectionConfiguration.class);
    }

    public static ObjectMapper createJsonMapper() {
        JacksonAnnotationIntrospector jackson = new JacksonAnnotationIntrospector();
        ObjectMapper mapper = new ObjectMapper();
        mapper.getDeserializationConfig().with((AnnotationIntrospector)jackson);
        mapper.getSerializationConfig().with((AnnotationIntrospector)jackson);
        return mapper;
    }

    private <T> T read(Class<T> clazz) {
        try {
            if (this.config != null) {
                return (T)IDPAuthConf.createJsonMapper().treeToValue((TreeNode)this.config, clazz);
            }
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
        return null;
    }
}

