/*
 * Decompiled with CFR 0.152.
 */
package io.jans.service;

import io.jans.util.StringHelper;
import io.jans.util.security.PropertiesDecrypter;
import io.jans.util.security.StringEncrypter;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.Properties;
import org.slf4j.Logger;

@ApplicationScoped
public class EncryptionService {
    @Inject
    private Logger log;
    @Inject
    private StringEncrypter stringEncrypter;

    public String decrypt(String encryptedString) throws StringEncrypter.EncryptionException {
        if (StringHelper.isEmpty((String)encryptedString)) {
            return null;
        }
        return this.stringEncrypter.decrypt(encryptedString);
    }

    public String decrypt(String encryptedValue, boolean returnSource) {
        String resultValue;
        block3: {
            if (encryptedValue == null) {
                return encryptedValue;
            }
            resultValue = returnSource ? encryptedValue : null;
            try {
                resultValue = this.stringEncrypter.decrypt(encryptedValue);
            }
            catch (Exception ex) {
                if (returnSource) break block3;
                this.log.error(String.format("Failed to decrypt value: '%s'", encryptedValue, ex));
            }
        }
        return resultValue;
    }

    public String encrypt(String unencryptedString) throws StringEncrypter.EncryptionException {
        if (StringHelper.isEmpty((String)unencryptedString)) {
            return null;
        }
        return this.stringEncrypter.encrypt(unencryptedString);
    }

    public Properties decryptProperties(Properties connectionProperties) {
        return PropertiesDecrypter.decryptProperties((StringEncrypter)this.stringEncrypter, (Properties)connectionProperties);
    }

    public Properties decryptAllProperties(Properties connectionProperties) {
        return PropertiesDecrypter.decryptAllProperties((StringEncrypter)this.stringEncrypter, (Properties)connectionProperties);
    }
}

