/*
 * Decompiled with CFR 0.152.
 */
package io.jans.service.custom;

import io.jans.model.SearchRequest;
import io.jans.model.custom.script.CustomScriptType;
import io.jans.model.custom.script.model.CustomScript;
import io.jans.orm.model.PagedResult;
import io.jans.orm.model.SortOrder;
import io.jans.orm.search.filter.Filter;
import io.jans.service.OrganizationService;
import io.jans.service.custom.script.AbstractCustomScriptService;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@ApplicationScoped
public class CustomScriptService
extends AbstractCustomScriptService {
    private static final long serialVersionUID = -7670016078535552193L;
    @Inject
    private OrganizationService organizationService;

    public String baseDn() {
        return String.format("ou=scripts,%s", this.organizationService.getDnForOrganization(null));
    }

    public PagedResult<CustomScript> searchScripts(String pattern, String sortBy, String sortOrder, Integer startIndex, int limit, int maximumRecCount, CustomScriptType type) {
        this.log.debug("Search CustomScript with param - pattern:{}, sortBy:{}, sortOrder:{}, startIndex:{}, limit:{}, maximumRecCount:{}, type:{}", new Object[]{pattern, sortBy, sortOrder, startIndex, limit, maximumRecCount, type});
        Filter searchFilter = null;
        String[] targetArray = new String[]{pattern};
        boolean useLowercaseFilter = this.isLowercaseFilter(this.baseDn());
        searchFilter = useLowercaseFilter ? Filter.createORFilter((Filter[])new Filter[]{Filter.createSubstringFilter((Filter)Filter.createLowercaseFilter((String)"description"), null, (String[])targetArray, null), Filter.createSubstringFilter((Filter)Filter.createLowercaseFilter((String)"displayName"), null, (String[])targetArray, null)}) : Filter.createORFilter((Filter[])new Filter[]{Filter.createSubstringFilter((String)"description", null, (String[])targetArray, null), Filter.createSubstringFilter((String)"displayName", null, (String[])targetArray, null)});
        Filter filter = searchFilter;
        if (type != null) {
            Filter typeFilter = Filter.createEqualityFilter((String)"jansScrTyp", (Object)type);
            filter = Filter.createANDFilter((Filter[])new Filter[]{searchFilter, typeFilter});
        }
        return this.persistenceEntryManager.findPagedEntries(this.baseDn(), CustomScript.class, filter, null, sortBy, SortOrder.getByValue((String)sortOrder), startIndex.intValue(), limit, maximumRecCount);
    }

    /*
     * WARNING - void declaration
     */
    public PagedResult<CustomScript> searchScripts(SearchRequest searchRequest, CustomScriptType type) {
        void var6_11;
        this.log.info("Search CustomScript with searchRequest - searchRequest:{}, type:{}", (Object)searchRequest, (Object)type);
        Filter searchFilter = null;
        ArrayList<Filter> filters = new ArrayList<Filter>();
        if (searchRequest.getFilterAssertionValue() != null && !searchRequest.getFilterAssertionValue().isEmpty()) {
            for (String string : searchRequest.getFilterAssertionValue()) {
                String[] stringArray = new String[]{string};
                boolean useLowercaseFilter = this.isLowercaseFilter(this.baseDn());
                if (useLowercaseFilter) {
                    filters.add(Filter.createORFilter((Filter[])new Filter[]{Filter.createSubstringFilter((Filter)Filter.createLowercaseFilter((String)"description"), null, (String[])stringArray, null), Filter.createSubstringFilter((Filter)Filter.createLowercaseFilter((String)"displayName"), null, (String[])stringArray, null)}));
                    continue;
                }
                filters.add(Filter.createORFilter((Filter[])new Filter[]{Filter.createSubstringFilter((String)"description", null, (String[])stringArray, null), Filter.createSubstringFilter((String)"displayName", null, (String[])stringArray, null)}));
            }
            searchFilter = Filter.createORFilter(filters);
        }
        this.log.trace("CustomScript pattern searchFilter:{}", searchFilter);
        ArrayList<Filter> fieldValueFilters = new ArrayList<Filter>();
        if (searchRequest.getFieldValueMap() != null && !searchRequest.getFieldValueMap().isEmpty()) {
            for (Map.Entry<String, String> entry : searchRequest.getFieldValueMap().entrySet()) {
                Filter dataFilter = Filter.createEqualityFilter((String)entry.getKey(), (Object)entry.getValue());
                this.log.trace("CustomScript dataFilter:{}", (Object)dataFilter);
                this.log.trace("CustomScript entry.getKey():{}, entry.getValue():{}, entry.getValue().getClass():{}", new Object[]{entry.getKey(), entry.getValue(), entry.getValue() != null ? entry.getValue().getClass() : " "});
                fieldValueFilters.add(Filter.createANDFilter((Filter[])new Filter[]{dataFilter}));
            }
            searchFilter = Filter.createANDFilter((Filter[])new Filter[]{Filter.createORFilter(filters), Filter.createANDFilter(fieldValueFilters)});
        }
        this.log.trace("CustomScript pattern and field searchFilter:{}", (Object)searchFilter);
        Filter filter = searchFilter;
        this.log.debug("filter:{}", (Object)filter);
        if (type != null) {
            Filter filter2 = Filter.createEqualityFilter((String)"jansScrTyp", (Object)type);
            Filter filter3 = Filter.createANDFilter((Filter[])new Filter[]{searchFilter, filter2});
        }
        this.log.trace("Searching CustomScript Flow with filter:{}", (Object)var6_11);
        return this.persistenceEntryManager.findPagedEntries(this.baseDn(), CustomScript.class, (Filter)var6_11, null, searchRequest.getSortBy(), SortOrder.getByValue((String)searchRequest.getSortOrder()), searchRequest.getStartIndex().intValue(), searchRequest.getCount().intValue(), searchRequest.getMaxCount());
    }

    public List<CustomScript> findActiveCustomScripts() {
        Filter filter = Filter.createEqualityFilter((String)"jansEnabled", (Object)true);
        List activeScripts = this.persistenceEntryManager.findEntries(this.baseDn(), CustomScript.class, filter, 0);
        this.log.debug(" activeScripts:{}", (Object)activeScripts);
        return activeScripts;
    }
}

