/*
 * Decompiled with CFR 0.152.
 */
package io.jans.service.document.store.service;

import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.search.filter.Filter;
import io.jans.service.document.store.model.Document;
import io.jans.util.StringHelper;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;

@ApplicationScoped
public class DBDocumentService
implements Serializable {
    private static final long serialVersionUID = 65734145678106186L;
    public static final String inum = "inum";
    public static final String displayName = "displayName";
    public static final String description = "description";
    public static final String jansFilePath = "jansFilePath";
    @Inject
    private Logger logger;
    @Inject
    private Instance<PersistenceEntryManager> persistenceEntryManagerInstance;
    private PersistenceEntryManager persistenceEntryManager;

    public DBDocumentService() {
    }

    public DBDocumentService(PersistenceEntryManager persistenceEntryManager) {
        this.persistenceEntryManager = persistenceEntryManager;
    }

    @PostConstruct
    public void init() {
        this.persistenceEntryManager = this.persistenceEntryManagerInstance.isResolvable() ? (PersistenceEntryManager)this.persistenceEntryManagerInstance.get() : null;
    }

    public void addDocument(Document document) throws Exception {
        document.setCreationDate(new Date());
        this.persistenceEntryManager.persist((Object)document);
    }

    public void removeDocument(Document document) throws Exception {
        this.persistenceEntryManager.remove((Object)document);
    }

    public Document getDocumentByInum(String inum) throws Exception {
        Document result = null;
        try {
            result = (Document)this.persistenceEntryManager.find(Document.class, (Object)this.getDnForDocument(inum));
        }
        catch (Exception e) {
            this.logger.error("Not able to find the document. Here is the exception message ", (Throwable)e);
        }
        return result;
    }

    public void updateDocument(Document document) throws Exception {
        this.persistenceEntryManager.merge((Object)document);
    }

    public String generateInumForNewDocument() throws Exception {
        Document document = new Document();
        String newInum = null;
        String newDn = null;
        newInum = this.generateInumForNewDocumentImpl();
        newDn = this.getDnForDocument(newInum);
        document.setDn(newDn);
        return newInum;
    }

    public List<Document> searchDocuments(String pattern, int sizeLimit) {
        Filter searchFilter = null;
        if (StringHelper.isNotEmpty((String)pattern)) {
            String[] targetArray = new String[]{pattern};
            Filter displayNameFilter = Filter.createSubstringFilter((String)displayName, null, (String[])targetArray, null);
            Filter descriptionFilter = Filter.createSubstringFilter((String)description, null, (String[])targetArray, null);
            searchFilter = Filter.createORFilter((Filter[])new Filter[]{displayNameFilter, descriptionFilter});
        }
        List<Document> result = new ArrayList<Document>();
        try {
            result = this.persistenceEntryManager.findEntries(this.baseDn(), Document.class, searchFilter, sizeLimit);
            return result;
        }
        catch (Exception e) {
            this.logger.error("Failed to find Document : ", (Throwable)e);
            return result;
        }
    }

    private String generateInumForNewDocumentImpl() throws Exception {
        return UUID.randomUUID().toString();
    }

    public List<Document> getAllDocumentsList(int size) {
        try {
            List documents = this.persistenceEntryManager.findEntries(this.baseDn(), Document.class, null, size);
            return documents;
        }
        catch (Exception e) {
            this.logger.error("Failed to find Document: ", (Throwable)e);
            return new ArrayList<Document>();
        }
    }

    public Document getDocumentByDn(String dn) throws Exception {
        return (Document)this.persistenceEntryManager.find(Document.class, (Object)dn);
    }

    public Document getDocumentByDisplayName(String displayName) throws Exception {
        Filter filter;
        String baseDn = this.baseDn();
        List documents = this.persistenceEntryManager.findEntries(baseDn, Document.class, filter = Filter.createEqualityFilter((String)displayName, (Object)displayName).multiValued());
        if (documents != null && documents.size() > 0) {
            return (Document)documents.get(0);
        }
        return null;
    }

    public List<Document> findAllDocuments(String[] returnAttributes) {
        String baseDn = this.baseDn();
        List result = this.persistenceEntryManager.findEntries(baseDn, Document.class, null, returnAttributes);
        return result;
    }

    public List<Document> findDocumentsListByModules(List<String> jansModules, String ... returnAttributes) {
        String baseDn = this.baseDn();
        if (jansModules == null || jansModules.size() == 0) {
            return this.findAllDocuments(returnAttributes);
        }
        ArrayList<Filter> jansModuleFilters = new ArrayList<Filter>();
        for (String jansModule : jansModules) {
            Filter filter = Filter.createEqualityFilter((String)"jansService", (Object)jansModule);
            jansModuleFilters.add(filter);
        }
        Filter filter = Filter.createORFilter(jansModuleFilters);
        List documents = this.persistenceEntryManager.findEntries(baseDn, Document.class, filter, returnAttributes);
        return documents;
    }

    public String getDnForDocument(String inum) throws Exception {
        String baseDn = this.baseDn();
        if (StringHelper.isEmpty((String)inum)) {
            return baseDn;
        }
        return String.format("inum=%s,%s", inum, baseDn);
    }

    public String baseDn() {
        return String.format("ou=document,%s", "o=jans");
    }

    public List<Document> getDocumentsByFilePath(String filePath) {
        Filter searchFilter = null;
        if (StringHelper.isNotEmpty((String)filePath)) {
            String[] targetArray = new String[]{filePath};
            Filter displayNameFilter = Filter.createSubstringFilter((String)jansFilePath, null, (String[])targetArray, null);
            searchFilter = Filter.createORFilter((Filter[])new Filter[]{displayNameFilter});
        }
        List<Document> result = new ArrayList<Document>();
        try {
            result = this.persistenceEntryManager.findEntries(this.getDnForDocument(null), Document.class, searchFilter, 100);
            return result;
        }
        catch (Exception e) {
            this.logger.error("Failed to find Document : ", (Throwable)e);
            return result;
        }
    }
}

