/*
 * Decompiled with CFR 0.152.
 */
package io.jans.orm.search.filter;

import io.jans.orm.search.filter.FilterType;
import io.jans.orm.util.ArrayHelper;
import io.jans.orm.util.StringHelper;
import java.util.List;

public class Filter {
    private FilterType type;
    private Filter[] filters;
    private String filterString;
    private String attributeName;
    private Object assertionValue;
    private String subInitial;
    private String[] subAny;
    private String subFinal;
    private Boolean multiValued;
    private int multiValuedCount;

    public Filter(FilterType type) {
        this.type = type;
    }

    public Filter(FilterType type, Filter ... filters) {
        this(type);
        this.filters = filters;
    }

    public Filter(FilterType type, String filterString) {
        this(type);
        this.filterString = filterString;
    }

    public Filter(FilterType type, Filter filter, Object assertionValue) {
        this(type);
        this.filters = new Filter[]{filter};
        this.assertionValue = assertionValue;
    }

    public Filter(FilterType type, String attributeName, Object assertionValue) {
        this(type);
        this.attributeName = attributeName;
        this.assertionValue = assertionValue;
    }

    public Filter(FilterType type, String attributeName, String subInitial, String[] subAny, String subFinal) {
        this(type);
        this.attributeName = attributeName;
        this.subInitial = subInitial;
        this.subAny = subAny;
        this.subFinal = subFinal;
    }

    public Filter(FilterType type, Filter filter, String subInitial, String[] subAny, String subFinal) {
        this(type);
        this.filters = new Filter[]{filter};
        this.subInitial = subInitial;
        this.subAny = subAny;
        this.subFinal = subFinal;
    }

    @Deprecated
    public static Filter create(String filterString) {
        return new Filter(FilterType.RAW, filterString);
    }

    public static Filter createPresenceFilter(String attributeName) {
        return new Filter(FilterType.PRESENCE, attributeName, null);
    }

    public static Filter createEqualityFilter(String attributeName, Object assertionValue) {
        return new Filter(FilterType.EQUALITY, attributeName, assertionValue);
    }

    public static Filter createEqualityFilter(Filter filter, Object assertionValue) {
        return new Filter(FilterType.EQUALITY, filter, assertionValue);
    }

    public static Filter createNOTFilter(Filter filter) {
        return new Filter(FilterType.NOT, filter);
    }

    public static Filter createLowercaseFilter(String attributeName) {
        return new Filter(FilterType.LOWERCASE, attributeName, null);
    }

    public static Filter createLessOrEqualFilter(String attributeName, Object assertionValue) {
        return new Filter(FilterType.LESS_OR_EQUAL, attributeName, assertionValue);
    }

    public static Filter createGreaterOrEqualFilter(String attributeName, Object assertionValue) {
        return new Filter(FilterType.GREATER_OR_EQUAL, attributeName, assertionValue);
    }

    public static Filter createApproximateMatchFilter(String attributeName, String assertionValue) {
        return new Filter(FilterType.APPROXIMATE_MATCH, attributeName, (Object)assertionValue);
    }

    public static Filter createSubstringFilter(String attributeName, String subInitial, String[] subAny, String subFinal) {
        return new Filter(FilterType.SUBSTRING, attributeName, subInitial, subAny, subFinal);
    }

    public static Filter createSubstringFilter(Filter filter, String subInitial, String[] subAny, String subFinal) {
        return new Filter(FilterType.SUBSTRING, filter, subInitial, subAny, subFinal);
    }

    public static Filter createORFilter(Filter ... filters) {
        return new Filter(FilterType.OR, filters);
    }

    public static Filter createORFilter(List<Filter> filters) {
        return new Filter(FilterType.OR, filters.toArray(new Filter[0]));
    }

    public static Filter createANDFilter(Filter ... filters) {
        return new Filter(FilterType.AND, filters);
    }

    public static Filter createANDFilter(List<Filter> filters) {
        return new Filter(FilterType.AND, filters.toArray(new Filter[0]));
    }

    public final FilterType getType() {
        return this.type;
    }

    public final void setType(FilterType type) {
        this.type = type;
    }

    public final Filter[] getFilters() {
        return this.filters;
    }

    public final void setFilters(Filter[] filters) {
        this.filters = filters;
    }

    public final String getFilterString() {
        return this.filterString;
    }

    public final void setFilterString(String filterString) {
        this.filterString = filterString;
    }

    public final String getAttributeName() {
        return this.attributeName;
    }

    public final void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public final Object getAssertionValue() {
        return this.assertionValue;
    }

    public final void setAssertionValue(Object assertionValue) {
        this.assertionValue = assertionValue;
    }

    public final String getSubInitial() {
        return this.subInitial;
    }

    public final void setSubInitial(String subInitial) {
        this.subInitial = subInitial;
    }

    public final String[] getSubAny() {
        return this.subAny;
    }

    public final void setSubAny(String[] subAny) {
        this.subAny = subAny;
    }

    public final String getSubFinal() {
        return this.subFinal;
    }

    public final void setSubFinal(String subFinal) {
        this.subFinal = subFinal;
    }

    public final Boolean getMultiValued() {
        return this.multiValued;
    }

    public int getMultiValuedCount() {
        return this.multiValuedCount;
    }

    public Filter multiValued() {
        return this.multiValued(1);
    }

    public Filter multiValued(int multiValuedCount) {
        this.multiValued = Boolean.TRUE;
        this.multiValuedCount = multiValuedCount;
        return this;
    }

    public Filter multiValued(Boolean multiValued) {
        this.multiValued = multiValued;
        this.multiValuedCount = 1;
        return this;
    }

    public Filter clone() {
        Filter clonedFilter = new Filter(this.type);
        clonedFilter.filters = this.filters;
        clonedFilter.filterString = this.filterString;
        clonedFilter.attributeName = this.attributeName;
        clonedFilter.assertionValue = this.assertionValue;
        clonedFilter.subInitial = this.subInitial;
        clonedFilter.subAny = this.subAny;
        clonedFilter.subFinal = this.subFinal;
        clonedFilter.multiValued = this.multiValued;
        clonedFilter.multiValuedCount = this.multiValuedCount;
        return clonedFilter;
    }

    public String toString() {
        if (FilterType.RAW == this.type) {
            return this.filterString;
        }
        StringBuilder sb = new StringBuilder("(");
        if ((FilterType.NOT == this.type || FilterType.AND == this.type || FilterType.OR == this.type) && this.filters != null) {
            sb.append(this.type.getSign());
            for (Filter filter : this.filters) {
                sb.append(filter.toString());
            }
            sb.append(")");
            return sb.toString();
        }
        if (FilterType.EQUALITY == this.type || FilterType.LESS_OR_EQUAL == this.type || FilterType.GREATER_OR_EQUAL == this.type) {
            if (ArrayHelper.isNotEmpty((Object[])this.filters)) {
                return sb.append(this.filters[0].toString()).append(this.type.getSign()).append(this.assertionValue).append(')').toString();
            }
            return sb.append(this.toStringAttributeName()).append(this.type.getSign()).append(this.assertionValue).append(')').toString();
        }
        if (FilterType.PRESENCE == this.type) {
            return sb.append(this.toStringAttributeName()).append("=").append(this.type.getSign()).append(')').toString();
        }
        if (FilterType.APPROXIMATE_MATCH == this.type) {
            return sb.append(this.toStringAttributeName()).append(this.type.getSign()).append("=").append(this.assertionValue).append(')').toString();
        }
        if (FilterType.SUBSTRING == this.type) {
            String sign = this.type.getSign();
            String attributeName = this.attributeName;
            String endSign = "";
            if (ArrayHelper.isNotEmpty((Object[])this.filters)) {
                attributeName = this.filters[0].toString();
                endSign = ")";
            }
            sb.append(attributeName).append(endSign).append(sign);
            if (this.subInitial != null) {
                sb.append(this.subInitial);
                sb.append('*');
            }
            if (this.subAny != null) {
                sb.append('*');
                for (String s : this.subAny) {
                    sb.append(s);
                    sb.append('*');
                }
            }
            if (this.subFinal != null) {
                sb.append('*');
                sb.append(this.subFinal);
            }
            sb.append(')');
            return sb.toString().replaceAll("\\*\\*", "*");
        }
        if (FilterType.LOWERCASE == this.type) {
            return sb.append("lower(\"").append(this.attributeName).append("\")").toString();
        }
        return super.toString();
    }

    private String toStringAttributeName() {
        if (StringHelper.isNotEmpty((String)this.attributeName)) {
            return this.attributeName;
        }
        if (ArrayHelper.isNotEmpty((Object[])this.filters)) {
            return this.filters[0].toString();
        }
        return "";
    }
}

