/*
 * Decompiled with CFR 0.152.
 */
package io.jans.orm.util;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;

public class ValueHelper {
    private static final Boolean[] EMPTY_BOOLEAN_ARRAY = new Boolean[0];
    private static final Long[] EMPTY_LONG_ARRAY = new Long[0];
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final BigDecimal[] EMPTY_BIG_DECIMAL_ARRAY = new BigDecimal[0];

    protected ValueHelper() {
    }

    public static Boolean toBoolean(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        try {
            return Boolean.parseBoolean(value.toString());
        }
        catch (RuntimeException ex) {
            return null;
        }
    }

    public static Boolean[] toBooleanArray(Object values) {
        if (values == null) {
            return null;
        }
        if (values instanceof List) {
            List valuesList = (List)values;
            if (valuesList.size() == 0) {
                return EMPTY_BOOLEAN_ARRAY;
            }
            Boolean[] result = new Boolean[valuesList.size()];
            int idx = 0;
            for (Object value : valuesList) {
                result[idx++] = ValueHelper.toBoolean(value);
            }
            return result;
        }
        if (values.getClass().isArray()) {
            Object[] valuesArray = (Object[])values;
            if (valuesArray.length == 0) {
                return EMPTY_BOOLEAN_ARRAY;
            }
            Boolean[] result = new Boolean[valuesArray.length];
            for (int i = 0; i < valuesArray.length; ++i) {
                result[i] = ValueHelper.toBoolean(valuesArray[i]);
            }
            return result;
        }
        return new Boolean[]{ValueHelper.toBoolean(values)};
    }

    public static List<Boolean> toBooleanList(Object[] values) {
        if (values == null) {
            return null;
        }
        return Arrays.asList(ValueHelper.toBooleanArray(values));
    }

    public static Long toLong(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Integer) {
            return ((Integer)value).longValue();
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).longValue();
        }
        try {
            return Long.parseLong(value.toString());
        }
        catch (RuntimeException ex) {
            return null;
        }
    }

    public static Long[] toLongArray(Object values) {
        if (values == null) {
            return null;
        }
        if (values instanceof List) {
            List valuesList = (List)values;
            if (valuesList.size() == 0) {
                return EMPTY_LONG_ARRAY;
            }
            Long[] result = new Long[valuesList.size()];
            int idx = 0;
            for (Object value : valuesList) {
                result[idx++] = ValueHelper.toLong(value);
            }
            return result;
        }
        if (values.getClass().isArray()) {
            Object[] valuesArray = (Object[])values;
            if (valuesArray.length == 0) {
                return EMPTY_LONG_ARRAY;
            }
            Long[] result = new Long[valuesArray.length];
            for (int i = 0; i < valuesArray.length; ++i) {
                result[i] = ValueHelper.toLong(valuesArray[i]);
            }
            return result;
        }
        return new Long[]{ValueHelper.toLong(values)};
    }

    public static List<Long> toLongList(Object[] values) {
        if (values == null) {
            return null;
        }
        return Arrays.asList(ValueHelper.toLongArray(values));
    }

    public static BigDecimal toBigDecimal(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value instanceof Long) {
            return new BigDecimal((Long)value);
        }
        if (value instanceof Integer) {
            return new BigDecimal((Integer)value);
        }
        try {
            return new BigDecimal(value.toString());
        }
        catch (RuntimeException ex) {
            return null;
        }
    }

    public static BigDecimal[] toBigDecimalArray(Object values) {
        if (values == null) {
            return null;
        }
        if (values instanceof List) {
            List valuesList = (List)values;
            if (valuesList.size() == 0) {
                return EMPTY_BIG_DECIMAL_ARRAY;
            }
            BigDecimal[] result = new BigDecimal[valuesList.size()];
            int idx = 0;
            for (Object value : valuesList) {
                result[idx++] = ValueHelper.toBigDecimal(value);
            }
            return result;
        }
        if (values.getClass().isArray()) {
            Object[] valuesArray = (Object[])values;
            if (valuesArray.length == 0) {
                return EMPTY_BIG_DECIMAL_ARRAY;
            }
            BigDecimal[] result = new BigDecimal[valuesArray.length];
            for (int i = 0; i < valuesArray.length; ++i) {
                result[i] = ValueHelper.toBigDecimal(valuesArray[i]);
            }
            return result;
        }
        return new BigDecimal[]{ValueHelper.toBigDecimal(values)};
    }

    public static List<BigDecimal> toBigDecimalList(Object[] values) {
        if (values == null) {
            return null;
        }
        return Arrays.asList(ValueHelper.toBigDecimalArray(values));
    }

    public static Long[] toJavaLongArrayFromBigDecimalList(List<BigDecimal> numbers) {
        if (numbers == null) {
            return EMPTY_LONG_ARRAY;
        }
        Long[] result = new Long[numbers.size()];
        int idx = 0;
        for (BigDecimal number : numbers) {
            result[idx++] = number.longValue();
        }
        return result;
    }

    public static String toString(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        try {
            return value.toString();
        }
        catch (RuntimeException ex) {
            return null;
        }
    }

    public static String[] toStringArray(Object values) {
        if (values == null) {
            return null;
        }
        if (values instanceof List) {
            List valuesList = (List)values;
            if (valuesList.size() == 0) {
                return EMPTY_STRING_ARRAY;
            }
            String[] result = new String[valuesList.size()];
            int idx = 0;
            for (Object value : valuesList) {
                result[idx++] = ValueHelper.toString(value);
            }
            return result;
        }
        if (values.getClass().isArray()) {
            Object[] valuesArray = (Object[])values;
            if (valuesArray.length == 0) {
                return EMPTY_STRING_ARRAY;
            }
            String[] result = new String[valuesArray.length];
            for (int i = 0; i < valuesArray.length; ++i) {
                result[i] = ValueHelper.toString(valuesArray[i]);
            }
            return result;
        }
        return new String[]{ValueHelper.toString(values)};
    }

    public static List<String> toStringList(Object[] values) {
        if (values == null) {
            return null;
        }
        return Arrays.asList(ValueHelper.toStringArray(values));
    }
}

