/*
 * Decompiled with CFR 0.152.
 */
package io.jans.service.cache;

import io.jans.service.cache.AbstractCacheProvider;
import io.jans.service.cache.CacheConfiguration;
import io.jans.service.cache.CacheProviderType;
import io.jans.service.cache.InMemoryConfiguration;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.concurrent.TimeUnit;
import net.jodah.expiringmap.ExpirationPolicy;
import net.jodah.expiringmap.ExpiringMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class InMemoryCacheProvider
extends AbstractCacheProvider<ExpiringMap> {
    @Inject
    private Logger log;
    @Inject
    private CacheConfiguration cacheConfiguration;
    private ExpiringMap<String, Object> map = ExpiringMap.builder().build();
    private InMemoryConfiguration inMemoryConfiguration;

    @PostConstruct
    public void init() {
        this.inMemoryConfiguration = this.cacheConfiguration.getInMemoryConfiguration();
    }

    @Override
    public void create() {
        this.log.debug("Starting InMemoryCacheProvider ...");
        try {
            this.map = ExpiringMap.builder().expirationPolicy(ExpirationPolicy.CREATED).variableExpiration().build();
            this.log.debug("InMemoryCacheProvider started.");
        }
        catch (Exception e) {
            throw new IllegalStateException("Error starting InMemoryCacheProvider", e);
        }
    }

    public void configure(CacheConfiguration cacheConfiguration) {
        this.log = LoggerFactory.getLogger(InMemoryCacheProvider.class);
        this.cacheConfiguration = cacheConfiguration;
    }

    @Override
    @PreDestroy
    public void destroy() {
        this.log.debug("Destroying InMemoryCacheProvider");
        this.map.clear();
        this.log.debug("Destroyed InMemoryCacheProvider");
    }

    @Override
    public ExpiringMap getDelegate() {
        return this.map;
    }

    @Override
    public boolean hasKey(String key) {
        return this.map.containsKey((Object)key);
    }

    @Override
    public Object get(String key) {
        return this.map.get((Object)key);
    }

    @Override
    public void put(int expirationInSeconds, String key, Object object) {
        this.map.remove((Object)key);
        expirationInSeconds = expirationInSeconds >= 0 ? expirationInSeconds : this.inMemoryConfiguration.getDefaultPutExpiration();
        this.map.put((Object)key, object, ExpirationPolicy.CREATED, (long)expirationInSeconds, TimeUnit.SECONDS);
    }

    @Override
    public void remove(String key) {
        this.map.remove((Object)key);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    public void setCacheConfiguration(CacheConfiguration cacheConfiguration) {
        this.cacheConfiguration = cacheConfiguration;
    }

    @Override
    public CacheProviderType getProviderType() {
        return CacheProviderType.IN_MEMORY;
    }
}

