/*
 * Decompiled with CFR 0.152.
 */
package io.jans.service.cache;

import io.jans.service.cache.AbstractCacheProvider;
import io.jans.service.cache.CacheConfiguration;
import io.jans.service.cache.CacheProviderType;
import io.jans.service.cache.MemcachedConfiguration;
import io.jans.service.cache.MemcachedConnectionFactoryType;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import net.spy.memcached.AddrUtil;
import net.spy.memcached.BinaryConnectionFactory;
import net.spy.memcached.ConnectionFactory;
import net.spy.memcached.DefaultConnectionFactory;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.internal.OperationFuture;
import net.spy.memcached.ops.OperationStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class MemcachedProvider
extends AbstractCacheProvider<MemcachedClient> {
    @Inject
    private Logger log;
    @Inject
    private CacheConfiguration cacheConfiguration;
    private MemcachedConfiguration memcachedConfiguration;
    private MemcachedClient client;

    public void setCacheConfiguration(CacheConfiguration cacheConfiguration) {
        this.cacheConfiguration = cacheConfiguration;
    }

    @PostConstruct
    public void init() {
        this.memcachedConfiguration = this.cacheConfiguration.getMemcachedConfiguration();
    }

    @Override
    public void create() {
        this.log.debug("Starting MemcachedProvider ...");
        try {
            Object connectionFactory = this.memcachedConfiguration.getConnectionFactoryType() == MemcachedConnectionFactoryType.BINARY ? new BinaryConnectionFactory(this.memcachedConfiguration.getMaxOperationQueueLength(), this.memcachedConfiguration.getBufferSize()) : new DefaultConnectionFactory(this.memcachedConfiguration.getMaxOperationQueueLength(), this.memcachedConfiguration.getBufferSize());
            this.client = new MemcachedClient((ConnectionFactory)connectionFactory, AddrUtil.getAddresses((String)this.memcachedConfiguration.getServers()));
            this.testConnection();
            this.log.debug("MemcachedProvider started.");
        }
        catch (Exception e) {
            throw new IllegalStateException("Error starting MemcachedProvider", e);
        }
    }

    public void configure(CacheConfiguration cacheConfiguration) {
        this.log = LoggerFactory.getLogger(MemcachedProvider.class);
        this.cacheConfiguration = cacheConfiguration;
    }

    private void testConnection() {
        this.put(2, "connectionTest", "connectionTestValue");
        if (!"connectionTestValue".equals(this.get("connectionTest"))) {
            throw new IllegalStateException("Error starting MemcachedProvider. Please check memcached configuration: " + this.memcachedConfiguration);
        }
    }

    public boolean isConnected() {
        this.put(2, "connectionTest", "connectionTestValue");
        return "connectionTestValue".equals(this.get("connectionTest"));
    }

    @Override
    @PreDestroy
    public void destroy() {
        this.log.debug("Destroying MemcachedProvider");
        try {
            this.client.shutdown();
            this.log.debug("Destroyed MemcachedProvider");
        }
        catch (RuntimeException e) {
            throw new IllegalStateException("Error destroying MemcachedProvider", e);
        }
    }

    @Override
    public MemcachedClient getDelegate() {
        return this.client;
    }

    @Override
    public boolean hasKey(String key) {
        Object value = this.get(key);
        return value != null;
    }

    @Override
    public Object get(String key) {
        try {
            if (key == null) {
                return null;
            }
            Object o = this.client.get(key);
            this.log.trace("get - key: " + key + ", value:" + o);
            return o;
        }
        catch (Exception e) {
            this.log.error("Failed to fetch object by key: " + key, (Throwable)e);
            return null;
        }
    }

    @Override
    public void put(int expirationInSeconds, String key, Object object) {
        try {
            int expiration = expirationInSeconds > 0 ? expirationInSeconds : this.memcachedConfiguration.getDefaultPutExpiration();
            OperationFuture set = this.client.set(key, expiration, object);
            OperationStatus status = set.getStatus();
            this.log.trace("set - key:" + key + ", expiration: " + expiration + ", status:" + status + ", get:" + this.get(key));
        }
        catch (Exception e) {
            this.log.error("Failed to put object in cache, key: " + key, (Throwable)e);
        }
    }

    @Override
    public void remove(String key) {
        try {
            this.client.delete(key);
            this.log.trace("delete - key:" + key);
        }
        catch (Exception e) {
            this.log.error("Failed to remove object from cache, key: " + key, (Throwable)e);
        }
    }

    @Override
    public void clear() {
        this.client.flush();
        this.log.trace("cleared");
    }

    @Override
    public CacheProviderType getProviderType() {
        return CacheProviderType.MEMCACHED;
    }
}

