/*
 * Decompiled with CFR 0.152.
 */
package io.jans.service.cache;

import io.jans.service.cache.AbstractCacheProvider;
import io.jans.service.cache.AbstractRedisProvider;
import io.jans.service.cache.CacheConfiguration;
import io.jans.service.cache.CacheProviderType;
import io.jans.service.cache.RedisConfiguration;
import io.jans.service.cache.RedisProviderFactory;
import io.jans.util.security.StringEncrypter;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class RedisProvider
extends AbstractCacheProvider<AbstractRedisProvider> {
    public static final int DEFAULT_PUT_EXPIRATION_IN_SECONDS = 60;
    @Inject
    private Logger log;
    @Inject
    private CacheConfiguration cacheConfiguration;
    @Inject
    private StringEncrypter stringEncrypter;
    private AbstractRedisProvider redisProvider;
    private int defaultPutExpiration = 60;

    @PostConstruct
    public void init() {
    }

    @Override
    public void create() {
        try {
            RedisConfiguration redisConfiguration = this.cacheConfiguration.getRedisConfiguration();
            this.decryptPassword(redisConfiguration);
            this.log.debug("Starting RedisProvider ... configuration:" + redisConfiguration);
            this.defaultPutExpiration = redisConfiguration.getDefaultPutExpiration() > 0 ? redisConfiguration.getDefaultPutExpiration() : 60;
            this.redisProvider = RedisProviderFactory.create(this.cacheConfiguration.getRedisConfiguration());
            this.redisProvider.create();
            this.log.debug("RedisProvider started.");
        }
        catch (Exception e) {
            this.log.error("Failed to start RedisProvider.");
            this.log.error("Log Error", (Throwable)e);
            throw new IllegalStateException("Error starting RedisProvider", e);
        }
    }

    public void configure(CacheConfiguration cacheConfiguration, StringEncrypter stringEncrypter) {
        this.log = LoggerFactory.getLogger(RedisProvider.class);
        this.cacheConfiguration = cacheConfiguration;
        this.stringEncrypter = stringEncrypter;
    }

    public void setCacheConfiguration(CacheConfiguration cacheConfiguration) {
        this.cacheConfiguration = cacheConfiguration;
    }

    private void decryptPassword(RedisConfiguration redisConfiguration) {
        try {
            String encryptedPassword = redisConfiguration.getPassword();
            if (StringUtils.isNotBlank((CharSequence)encryptedPassword)) {
                redisConfiguration.setPassword(this.stringEncrypter.decrypt(encryptedPassword));
                this.log.trace("Decrypted redis password successfully.");
            }
        }
        catch (StringEncrypter.EncryptionException e) {
            this.log.error("Error during redis password decryption", (Throwable)e);
        }
    }

    public boolean isConnected() {
        return this.redisProvider.isConnected();
    }

    @Override
    @PreDestroy
    public void destroy() {
        this.log.debug("Destroying RedisProvider");
        this.redisProvider.destroy();
        this.log.debug("Destroyed RedisProvider");
    }

    @Override
    public AbstractRedisProvider getDelegate() {
        return this.redisProvider;
    }

    @Override
    public boolean hasKey(String key) {
        if (key == null) {
            return false;
        }
        return this.redisProvider.hasKey(key);
    }

    @Override
    public Object get(String key) {
        if (key == null) {
            return null;
        }
        return this.redisProvider.get(key);
    }

    @Override
    public void put(int expirationInSeconds, String key, Object object) {
        this.redisProvider.put(expirationInSeconds > 0 ? expirationInSeconds : this.defaultPutExpiration, key, object);
    }

    @Override
    public void remove(String key) {
        this.redisProvider.remove(key);
    }

    @Override
    public void clear() {
        this.redisProvider.clear();
    }

    @Override
    public CacheProviderType getProviderType() {
        return CacheProviderType.REDIS;
    }
}

