/*
 * Decompiled with CFR 0.152.
 */
package io.jans.service;

import io.jans.model.SmtpConfiguration;
import io.jans.model.SmtpConnectProtectionType;
import io.jans.util.StringHelper;
import io.jans.util.security.SecurityProviderUtility;
import jakarta.activation.CommandMap;
import jakarta.activation.MailcapCommandMap;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.mail.Address;
import jakarta.mail.Authenticator;
import jakarta.mail.BodyPart;
import jakarta.mail.Message;
import jakarta.mail.Multipart;
import jakarta.mail.PasswordAuthentication;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Properties;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.smime.SMIMECapabilitiesAttribute;
import org.bouncycastle.asn1.smime.SMIMECapability;
import org.bouncycastle.asn1.smime.SMIMECapabilityVector;
import org.bouncycastle.asn1.smime.SMIMEEncryptionKeyPreferenceAttribute;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoGeneratorBuilder;
import org.bouncycastle.mail.smime.SMIMEException;
import org.bouncycastle.mail.smime.SMIMESignedGenerator;
import org.bouncycastle.mail.smime.SMIMEUtil;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.util.Store;
import org.slf4j.Logger;

@RequestScoped
@Named
public class MailService {
    @Inject
    private Logger log;
    @Inject
    private SmtpConfiguration smtpConfiguration;
    private long connectionTimeout = 5000L;
    private KeyStore keyStore = null;
    private PrivateKey privateKey = null;
    private X509Certificate[] x509Certificates = null;
    private boolean isReadyForSign = false;

    @PostConstruct
    public void init() {
        MailcapCommandMap mc = (MailcapCommandMap)CommandMap.getDefaultCommandMap();
        mc.addMailcap("text/html;; x-java-content-handler=com.sun.mail.handlers.text_html");
        mc.addMailcap("text/xml;; x-java-content-handler=com.sun.mail.handlers.text_xml");
        mc.addMailcap("text/plain;; x-java-content-handler=com.sun.mail.handlers.text_plain");
        mc.addMailcap("multipart/*;; x-java-content-handler=com.sun.mail.handlers.multipart_mixed");
        mc.addMailcap("message/rfc822;; x-java-content- handler=com.sun.mail.handlers.message_rfc822");
        try {
            String keystoreFile = this.smtpConfiguration.getKeyStore();
            String keystoreSecret = this.smtpConfiguration.getKeyStorePasswordDecrypted();
            String keystoreAlias = this.smtpConfiguration.getKeyStoreAlias();
            String keystoreSigningAlgorithm = this.smtpConfiguration.getSigningAlgorithm();
            if (keystoreFile == null || keystoreSecret == null || keystoreAlias == null || keystoreSigningAlgorithm == null) {
                return;
            }
            SecurityProviderUtility.KeyStorageType keystoreType = SecurityProviderUtility.solveKeyStorageType((String)keystoreFile);
            FileInputStream is = new FileInputStream(keystoreFile);
            switch (keystoreType) {
                case JKS_KS: {
                    this.keyStore = KeyStore.getInstance("JKS");
                    break;
                }
                case PKCS12_KS: {
                    this.keyStore = KeyStore.getInstance("PKCS12", SecurityProviderUtility.getBCProvider());
                    break;
                }
                case BCFKS_KS: {
                    this.keyStore = KeyStore.getInstance("BCFKS", SecurityProviderUtility.getBCProvider());
                }
            }
            this.keyStore.load(is, keystoreSecret.toCharArray());
            Certificate[] certificates = null;
            this.privateKey = (PrivateKey)this.keyStore.getKey(keystoreAlias, keystoreSecret.toCharArray());
            certificates = this.keyStore.getCertificateChain(keystoreAlias);
            if (certificates != null) {
                this.x509Certificates = new X509Certificate[certificates.length];
                for (int i = 0; i < certificates.length; ++i) {
                    this.x509Certificates[i] = (X509Certificate)certificates[i];
                }
            }
            this.isReadyForSign = this.privateKey != null && this.x509Certificates != null && keystoreSigningAlgorithm != null;
        }
        catch (Exception ex) {
            this.isReadyForSign = false;
            this.log.error(ex.getMessage(), (Throwable)ex);
        }
    }

    public boolean sendMail(String to, String subject, String body) {
        String from = this.smtpConfiguration.getFromEmailAddress();
        return this.sendMail(from, from, to, to, subject, body, "");
    }

    public boolean sendMail(String to, String subject, String message, String htmlMessage) {
        String from = this.smtpConfiguration.getFromEmailAddress();
        return this.sendMail(from, from, to, to, subject, message, htmlMessage);
    }

    public boolean sendMail(String from, String fromDisplayName, String to, String toDisplayName, String subject, String message, String htmlMessage) {
        return this.sendMail(from, fromDisplayName, to, null, subject, message, htmlMessage, false);
    }

    public boolean sendMailSigned(String from, String fromDisplayName, String to, String toDisplayName, String subject, String message, String htmlMessage) {
        return this.sendMail(from, fromDisplayName, to, null, subject, message, htmlMessage, true);
    }

    public long getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(long connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    private boolean sendMail(String from, String fromDisplayName, String to, String toDisplayName, String subject, String message, String htmlMessage, boolean signMessage) {
        String mailFromName;
        if (this.smtpConfiguration == null) {
            this.log.error("Failed to send message from '{}' to '{}' because the SMTP configuration isn't valid!", (Object)from, (Object)to);
            return false;
        }
        this.log.debug("Host name: " + this.smtpConfiguration.getHost() + ", port: " + this.smtpConfiguration.getPort() + ", connection time out: " + this.connectionTimeout);
        String mailFrom = from;
        if (StringHelper.isEmpty((String)mailFrom)) {
            mailFrom = this.smtpConfiguration.getFromEmailAddress();
        }
        if (StringHelper.isEmpty((String)(mailFromName = fromDisplayName))) {
            mailFromName = this.smtpConfiguration.getFromName();
        }
        Properties props = new Properties();
        props.put("mail.from", mailFrom);
        SmtpConnectProtectionType smtpConnectProtect = this.smtpConfiguration.getConnectProtection();
        if (smtpConnectProtect == SmtpConnectProtectionType.START_TLS) {
            props.put("mail.transport.protocol", "smtp");
            props.put("mail.smtp.host", this.smtpConfiguration.getHost());
            props.put("mail.smtp.port", (Object)this.smtpConfiguration.getPort());
            props.put("mail.smtp.connectiontimeout", (Object)this.connectionTimeout);
            props.put("mail.smtp.timeout", (Object)this.connectionTimeout);
            props.put("mail.smtp.socketFactory.class", "com.sun.mail.util.MailSSLSocketFactory");
            props.put("mail.smtp.socketFactory.port", (Object)this.smtpConfiguration.getPort());
            if (this.smtpConfiguration.isServerTrust()) {
                props.put("mail.smtp.ssl.trust", this.smtpConfiguration.getHost());
            }
            props.put("mail.smtp.starttls.enable", (Object)true);
            props.put("mail.smtp.starttls.required", (Object)true);
        } else if (smtpConnectProtect == SmtpConnectProtectionType.SSL_TLS) {
            props.put("mail.transport.protocol.rfc822", "smtps");
            props.put("mail.smtps.host", this.smtpConfiguration.getHost());
            props.put("mail.smtps.port", (Object)this.smtpConfiguration.getPort());
            props.put("mail.smtps.connectiontimeout", (Object)this.connectionTimeout);
            props.put("mail.smtps.timeout", (Object)this.connectionTimeout);
            props.put("mail.smtp.socketFactory.class", "com.sun.mail.util.MailSSLSocketFactory");
            props.put("mail.smtp.socketFactory.port", (Object)this.smtpConfiguration.getPort());
            if (this.smtpConfiguration.isServerTrust()) {
                props.put("mail.smtp.ssl.trust", this.smtpConfiguration.getHost());
            }
            props.put("mail.smtp.ssl.enable", (Object)true);
        } else {
            props.put("mail.transport.protocol", "smtp");
            props.put("mail.smtp.host", this.smtpConfiguration.getHost());
            props.put("mail.smtp.port", (Object)this.smtpConfiguration.getPort());
            props.put("mail.smtp.connectiontimeout", (Object)this.connectionTimeout);
            props.put("mail.smtp.timeout", (Object)this.connectionTimeout);
        }
        Session session = null;
        if (this.smtpConfiguration.isRequiresAuthentication()) {
            if (smtpConnectProtect == SmtpConnectProtectionType.SSL_TLS) {
                props.put("mail.smtps.auth", "true");
            } else {
                props.put("mail.smtp.auth", "true");
            }
            final String userName = this.smtpConfiguration.getSmtpAuthenticationAccountUsername();
            final String password = this.smtpConfiguration.getSmtpAuthenticationAccountPasswordDecrypted();
            session = Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(userName, password);
                }
            });
        } else {
            session = Session.getInstance((Properties)props, null);
        }
        MimeMessage msg = new MimeMessage(session);
        try {
            msg.setFrom((Address)new InternetAddress(mailFrom, mailFromName));
            if (StringHelper.isEmpty((String)toDisplayName)) {
                msg.setRecipients(Message.RecipientType.TO, to);
            } else {
                msg.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(to, toDisplayName));
            }
            msg.setSubject(subject, "UTF-8");
            msg.setSentDate(new Date());
            if (StringHelper.isEmpty((String)htmlMessage)) {
                msg.setText(message + "\n", "UTF-8", "plain");
            } else {
                MimeBodyPart textPart = new MimeBodyPart();
                textPart.setText(message, "UTF-8", "plain");
                MimeBodyPart htmlPart = new MimeBodyPart();
                htmlPart.setText(htmlMessage, "UTF-8", "html");
                MimeMultipart mp = new MimeMultipart("alternative");
                mp.addBodyPart((BodyPart)textPart);
                mp.addBodyPart((BodyPart)htmlPart);
                msg.setContent((Multipart)mp);
                String signingAlgorithm = this.smtpConfiguration.getSigningAlgorithm();
                if (signMessage && this.isReadyForSign) {
                    MimeMultipart multiPart = MailService.createMultipartWithSignature(this.privateKey, this.x509Certificates, signingAlgorithm, msg);
                    msg.setContent((Multipart)multiPart);
                }
            }
            Transport.send((Message)msg);
        }
        catch (Exception ex) {
            this.log.error("Failed to send message", (Throwable)ex);
            return false;
        }
        return true;
    }

    private static ASN1EncodableVector generateSignedAttributes(X509Certificate cert) throws CertificateParsingException {
        ASN1EncodableVector signedAttrs = new ASN1EncodableVector();
        SMIMECapabilityVector caps = new SMIMECapabilityVector();
        caps.addCapability(SMIMECapability.aES256_CBC);
        caps.addCapability(SMIMECapability.dES_EDE3_CBC);
        caps.addCapability(SMIMECapability.rC2_CBC, 128);
        signedAttrs.add((ASN1Encodable)new SMIMECapabilitiesAttribute(caps));
        signedAttrs.add((ASN1Encodable)new SMIMEEncryptionKeyPreferenceAttribute(SMIMEUtil.createIssuerAndSerialNumberFor((X509Certificate)cert)));
        return signedAttrs;
    }

    public static MimeMultipart createMultipartWithSignature(PrivateKey key, X509Certificate cert, String signingAlgorithm, MimeMessage mm) throws CertificateEncodingException, CertificateParsingException, OperatorCreationException, SMIMEException {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        certList.add(cert);
        JcaCertStore certs = new JcaCertStore(certList);
        ASN1EncodableVector signedAttrs = MailService.generateSignedAttributes(cert);
        SMIMESignedGenerator gen = new SMIMESignedGenerator();
        if (signingAlgorithm == null || signingAlgorithm.isEmpty()) {
            signingAlgorithm = cert.getSigAlgName();
        }
        gen.addSignerInfoGenerator(new JcaSimpleSignerInfoGeneratorBuilder().setProvider(SecurityProviderUtility.getBCProvider()).setSignedAttributeGenerator(new AttributeTable(signedAttrs)).build(signingAlgorithm, key, cert));
        gen.addCertificates((Store)certs);
        return gen.generate(mm);
    }

    public static MimeMultipart createMultipartWithSignature(PrivateKey key, X509Certificate[] inCerts, String signingAlgorithm, MimeMessage mm) throws CertificateEncodingException, CertificateParsingException, OperatorCreationException, SMIMEException {
        JcaCertStore certs = new JcaCertStore(Arrays.asList(inCerts));
        ASN1EncodableVector signedAttrs = MailService.generateSignedAttributes(inCerts[0]);
        SMIMESignedGenerator gen = new SMIMESignedGenerator();
        if (signingAlgorithm == null || signingAlgorithm.isEmpty()) {
            signingAlgorithm = inCerts[0].getSigAlgName();
        }
        gen.addSignerInfoGenerator(new JcaSimpleSignerInfoGeneratorBuilder().setProvider(SecurityProviderUtility.getBCProvider()).setSignedAttributeGenerator(new AttributeTable(signedAttrs)).build(signingAlgorithm, key, inCerts[0]));
        gen.addCertificates((Store)certs);
        return gen.generate(mm);
    }
}

