/*
 * Decompiled with CFR 0.152.
 */
package io.jans.service;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.SerializationUtils;
import org.slf4j.Logger;

@ApplicationScoped
public class ObjectSerializationService {
    @Inject
    private Logger log;

    public boolean saveObject(String path, Serializable obj, boolean append) {
        FileOutputStream fos;
        File file = new File(path);
        try {
            fos = new FileOutputStream(file, append);
        }
        catch (FileNotFoundException ex) {
            this.log.error("Faield to serialize to file: '{}'. Error: ", (Object)path, (Object)ex);
            return false;
        }
        try (GZIPOutputStream gos = new GZIPOutputStream(new BufferedOutputStream(fos));){
            SerializationUtils.serialize((Serializable)obj, (OutputStream)gos);
            gos.flush();
        }
        catch (IOException ex) {
            this.log.error("Faield to serialize to file: '{}'. Error: ", (Object)path, (Object)ex);
            return false;
        }
        return true;
    }

    public boolean saveObject(String path, Serializable obj) {
        return this.saveObject(path, obj, false);
    }

    public Object loadObject(String path) {
        FileInputStream fis;
        File file = new File(path);
        if (!file.exists()) {
            this.log.trace("File '{}' is not exist", (Object)path);
            return null;
        }
        try {
            fis = new FileInputStream(file);
        }
        catch (FileNotFoundException ex) {
            this.log.error("Faield to deserialize from file: '{}'. Error: ", (Object)path, (Object)ex);
            return null;
        }
        Object obj = null;
        try (GZIPInputStream gis = new GZIPInputStream(new BufferedInputStream(fis));){
            obj = SerializationUtils.deserialize((InputStream)gis);
        }
        catch (IOException ex) {
            this.log.error("Faield to deserialize from file: '{}'. Error: ", (Object)path, (Object)ex);
            return null;
        }
        return obj;
    }

    public void cleanup(String path) {
        File file = new File(path);
        FileUtils.deleteQuietly((File)file);
    }
}

