/*
 * Decompiled with CFR 0.152.
 */
package io.jans.service.util;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.spi.InjectionPoint;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class Resources {
    private static Map<String, Logger> CACHE = new HashMap<String, Logger>();

    @Produces
    public Logger getLogger(InjectionPoint ip) {
        Class<?> clazz = ip.getMember().getDeclaringClass();
        String clazzName = clazz.getName();
        Logger cached = CACHE.get(clazzName);
        if (cached != null) {
            return cached;
        }
        Logger logger = LoggerFactory.getLogger(clazz);
        CACHE.put(clazzName, logger);
        return logger;
    }
}

