/*
 * Decompiled with CFR 0.152.
 */
package io.jans.orm.ldap.impl;

import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.PersistenceEntryManagerFactory;
import io.jans.orm.exception.operation.ConfigurationException;
import io.jans.orm.ldap.impl.LdapEntryManager;
import io.jans.orm.ldap.operation.impl.LdapAuthConnectionProvider;
import io.jans.orm.ldap.operation.impl.LdapConnectionProvider;
import io.jans.orm.ldap.operation.impl.LdapOperationServiceImpl;
import io.jans.orm.service.BaseFactoryService;
import io.jans.orm.util.PropertiesHelper;
import io.jans.orm.util.StringHelper;
import jakarta.enterprise.context.ApplicationScoped;
import java.util.HashMap;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class LdapEntryManagerFactory
implements PersistenceEntryManagerFactory {
    public static final String PERSISTENCE_TYPE = PersistenceEntryManager.PERSITENCE_TYPES.ldap.name();
    public static final String LDAP_DEFAULT_PROPERTIES_FILE = "jans-ldap.properties";
    public static final String PROPERTIES_FILE = "jans-ldap%s.properties";
    private static final Logger LOG = LoggerFactory.getLogger(LdapEntryManagerFactory.class);

    public String getPersistenceType() {
        return PERSISTENCE_TYPE;
    }

    public HashMap<String, String> getConfigurationFileNames(String alias) {
        Object usedAlias = StringHelper.isEmpty((String)alias) ? "" : "." + alias;
        HashMap<String, String> confs = new HashMap<String, String>();
        String confFileName = String.format(PROPERTIES_FILE, usedAlias);
        confs.put(PERSISTENCE_TYPE + (String)usedAlias, confFileName);
        return confs;
    }

    public LdapEntryManager createEntryManager(Properties conf) {
        Properties entryManagerConf = PropertiesHelper.filterProperties((Properties)conf, (String)"#");
        LdapConnectionProvider connectionProvider = new LdapConnectionProvider(entryManagerConf);
        connectionProvider.create();
        if (!connectionProvider.isCreated()) {
            throw new ConfigurationException(String.format("Failed to create LDAP connection pool! Result code: '%s'", connectionProvider.getCreationResultCode()));
        }
        LOG.debug("Created connectionProvider '{}' with code '{}'", (Object)connectionProvider, (Object)connectionProvider.getCreationResultCode());
        LdapAuthConnectionProvider bindConnectionProvider = new LdapAuthConnectionProvider(entryManagerConf);
        connectionProvider.create();
        if (!bindConnectionProvider.isCreated()) {
            throw new ConfigurationException(String.format("Failed to create LDAP bind connection pool! Result code: '%s'", bindConnectionProvider.getCreationResultCode()));
        }
        LOG.debug("Created bindConnectionProvider '{}' with code '{}'", (Object)bindConnectionProvider, (Object)bindConnectionProvider.getCreationResultCode());
        LdapEntryManager ldapEntryManager = new LdapEntryManager(new LdapOperationServiceImpl(connectionProvider, bindConnectionProvider));
        LOG.info("Created LdapEntryManager: {}", (Object)ldapEntryManager.getOperationService());
        return ldapEntryManager;
    }

    public void initStandalone(BaseFactoryService persistanceFactoryService) {
    }
}

