/*
 * Decompiled with CFR 0.152.
 */
package io.jans.orm.ldap.operation.impl;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DeleteRequest;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionPool;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPInterface;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.LDAPSearchException;
import com.unboundid.ldap.sdk.Modification;
import com.unboundid.ldap.sdk.ModificationType;
import com.unboundid.ldap.sdk.ModifyRequest;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchRequest;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.ldap.sdk.controls.SimplePagedResultsControl;
import com.unboundid.ldap.sdk.controls.SubtreeDeleteRequestControl;
import com.unboundid.ldap.sdk.schema.AttributeTypeDefinition;
import com.unboundid.ldap.sdk.schema.ObjectClassDefinition;
import com.unboundid.ldif.LDIFChangeRecord;
import com.unboundid.util.StaticUtils;
import io.jans.orm.exception.AuthenticationException;
import io.jans.orm.exception.MappingException;
import io.jans.orm.exception.SearchEntryException;
import io.jans.orm.exception.operation.ConnectionException;
import io.jans.orm.exception.operation.DuplicateEntryException;
import io.jans.orm.exception.operation.SearchException;
import io.jans.orm.extension.PersistenceExtension;
import io.jans.orm.ldap.exception.InvalidSimplePageControlException;
import io.jans.orm.ldap.impl.LdapBatchOperationWraper;
import io.jans.orm.ldap.operation.LdapOperationService;
import io.jans.orm.ldap.operation.impl.LdapConnectionProvider;
import io.jans.orm.ldap.operation.watch.OperationDurationUtil;
import io.jans.orm.model.AttributeData;
import io.jans.orm.model.AttributeType;
import io.jans.orm.model.BatchOperation;
import io.jans.orm.model.EntryData;
import io.jans.orm.model.PagedResult;
import io.jans.orm.model.PersistenceMetadata;
import io.jans.orm.model.SortOrder;
import io.jans.orm.operation.auth.PasswordEncryptionHelper;
import io.jans.orm.operation.auth.PasswordEncryptionMethod;
import io.jans.orm.util.ArrayHelper;
import io.jans.orm.util.Pair;
import io.jans.orm.util.StringHelper;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapOperationServiceImpl
implements LdapOperationService {
    private static final Logger LOG = LoggerFactory.getLogger(LdapOperationServiceImpl.class);
    private LdapConnectionProvider connectionProvider;
    private LdapConnectionProvider bindConnectionProvider;
    private PersistenceExtension persistenceExtension;
    private static Map<String, List<String>> OBJECT_CLASS_DATA_TYPES = new HashMap<String, List<String>>();
    private static Map<String, List<String>> OBJECT_CLASS_TREE = new HashMap<String, List<String>>();
    private static Map<String, Class<?>> ATTRIBUTE_DATA_TYPES = new HashMap();
    private static final Map<String, Class<?>> OID_SYNTAX_CLASS_MAPPING;
    protected static final String[] NO_STRINGS;

    private LdapOperationServiceImpl() {
    }

    public LdapOperationServiceImpl(LdapConnectionProvider connectionProvider) {
        this(connectionProvider, null);
        this.populateAttributeDataTypesMapping(this.getSubschemaSubentry());
    }

    public LdapOperationServiceImpl(LdapConnectionProvider connectionProvider, LdapConnectionProvider bindConnectionProvider) {
        this.connectionProvider = connectionProvider;
        this.bindConnectionProvider = bindConnectionProvider;
        this.populateAttributeDataTypesMapping(this.getSubschemaSubentry());
    }

    @Override
    public LdapConnectionProvider getConnectionProvider() {
        return this.connectionProvider;
    }

    @Override
    public void setConnectionProvider(LdapConnectionProvider connectionProvider) {
        this.connectionProvider = connectionProvider;
    }

    @Override
    public LdapConnectionProvider getBindConnectionProvider() {
        return this.bindConnectionProvider;
    }

    @Override
    public void setBindConnectionProvider(LdapConnectionProvider bindConnectionProvider) {
        this.bindConnectionProvider = bindConnectionProvider;
    }

    @Override
    public LDAPConnectionPool getConnectionPool() {
        return this.connectionProvider.getConnectionPool();
    }

    @Override
    public LDAPConnection getConnection() throws LDAPException {
        return this.connectionProvider.getConnection();
    }

    @Override
    public void releaseConnection(LDAPConnection connection) {
        if (connection != null) {
            this.connectionProvider.releaseConnection(connection);
        }
    }

    public boolean authenticate(String bindDn, String password, String objectClass) throws ConnectionException, SearchException, AuthenticationException {
        try {
            return this.authenticateImpl(bindDn, password);
        }
        catch (LDAPException ex) {
            throw new ConnectionException("Failed to authenticate dn", (Throwable)ex);
        }
    }

    private boolean authenticateImpl(String bindDn, String password) throws LDAPException, ConnectionException, SearchException {
        Instant startTime = OperationDurationUtil.instance().now();
        boolean result = false;
        ArrayList<PasswordEncryptionMethod> additionalPasswordMethods = this.connectionProvider.getAdditionalPasswordMethods();
        if (this.persistenceExtension != null || !additionalPasswordMethods.isEmpty()) {
            EntryData entryData = this.lookup(bindDn, "userPassword");
            if (entryData == null) {
                throw new ConnectionException("Failed to find user by dn");
            }
            Object userPasswordObj = null;
            for (AttributeData attribute : entryData.getAttributeData()) {
                if (!StringHelper.equalsIgnoreCase((String)attribute.getName(), (String)"userPassword")) continue;
                userPasswordObj = attribute.getValue();
            }
            String userPassword = null;
            if (userPasswordObj instanceof String) {
                userPassword = (String)userPasswordObj;
            }
            if (userPassword != null) {
                if (this.persistenceExtension != null) {
                    result = this.persistenceExtension.compareHashedPasswords(password, userPassword);
                } else {
                    PasswordEncryptionMethod storedPasswordMethod = PasswordEncryptionHelper.findAlgorithm((String)userPassword);
                    if (additionalPasswordMethods.contains(storedPasswordMethod)) {
                        LOG.debug("Authenticating '{}' using internal authentication mechanism '{}'", (Object)bindDn, (Object)storedPasswordMethod);
                        result = PasswordEncryptionHelper.compareCredentials((String)password, (String)userPassword);
                    }
                }
            }
        } else {
            result = this.bindConnectionProvider == null ? this.authenticateConnectionPoolImpl(bindDn, password) : this.authenticateBindConnectionPoolImpl(bindDn, password);
        }
        Duration duration = OperationDurationUtil.instance().duration(startTime);
        OperationDurationUtil.instance().logDebug("LDAP operation: bind, duration: {}, dn: {}", new Object[]{duration, bindDn});
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean authenticateConnectionPoolImpl(String bindDn, String password) throws LDAPException, ConnectionException {
        boolean loggedIn = false;
        if (bindDn == null) {
            return loggedIn;
        }
        boolean closeConnection = false;
        LDAPConnection connection = this.connectionProvider.getConnection();
        try {
            closeConnection = true;
            BindResult r = connection.bind(bindDn, password);
            if (r.getResultCode() == ResultCode.SUCCESS) {
                loggedIn = true;
            }
        }
        finally {
            this.connectionProvider.releaseConnection(connection);
            if (closeConnection) {
                this.connectionProvider.closeDefunctConnection(connection);
            }
        }
        return loggedIn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean authenticateBindConnectionPoolImpl(String bindDn, String password) throws LDAPException, ConnectionException {
        if (bindDn == null) {
            return false;
        }
        LDAPConnection connection = this.bindConnectionProvider.getConnection();
        try {
            BindResult r = connection.bind(bindDn, password);
            boolean bl = r.getResultCode() == ResultCode.SUCCESS;
            return bl;
        }
        finally {
            this.bindConnectionProvider.releaseConnection(connection);
        }
    }

    @Override
    public <T> PagedResult<EntryData> search(String dn, Filter filter, SearchScope scope, LdapBatchOperationWraper<T> batchOperationWraper, int start, int count, int pageSize, Control[] controls, String ... attributes) throws SearchException {
        Instant startTime = OperationDurationUtil.instance().now();
        PagedResult<EntryData> result = this.searchImpl(dn, filter, scope, batchOperationWraper, start, count, pageSize, controls, attributes);
        Duration duration = OperationDurationUtil.instance().duration(startTime);
        OperationDurationUtil.instance().logDebug("LDAP operation: search, duration: {}, dn: {}, filter: {}, scope: {}, batchOperationWraper: {}, start: {}, searchLimit: {}, count: {}, controls: {}, attributes: {}", new Object[]{duration, dn, filter, scope, batchOperationWraper, start, pageSize, count, controls, attributes});
        return result;
    }

    private <T> PagedResult<EntryData> searchImpl(String dn, Filter filter, SearchScope scope, LdapBatchOperationWraper<T> batchOperationWraper, int start, int count, int pageSize, Control[] controls, String ... attributes) throws SearchException {
        BatchOperation<T> batchOperation = null;
        if (batchOperationWraper != null) {
            batchOperation = batchOperationWraper.getBatchOperation();
        }
        if (LOG.isTraceEnabled() && StringHelper.equalsIgnoreCase((String)dn, (String)"o=gluu")) {
            LOG.trace("Search in whole LDAP tree", (Throwable)new Exception());
        }
        SearchRequest searchRequest = attributes == null ? new SearchRequest(dn, scope, filter, new String[0]) : new SearchRequest(dn, scope, filter, attributes);
        LinkedList<EntryData> searchResultList = new LinkedList<EntryData>();
        SearchResult searchResult = null;
        if (pageSize > 0 || start > 0) {
            if (pageSize == 0) {
                pageSize = 100;
            }
            LDAPConnection ldapConnection = null;
            try {
                ldapConnection = this.getConnection();
                ASN1OctetString cookie = null;
                SimplePagedResponse simplePagedResponse = null;
                if (start > 0) {
                    try {
                        simplePagedResponse = this.scrollSimplePagedResultsControl(ldapConnection, dn, filter, scope, controls, start);
                        cookie = simplePagedResponse.getCookie();
                    }
                    catch (InvalidSimplePageControlException ex) {
                        throw new LDAPSearchException(ex.getResultCode(), "Failed to scroll to specified start", (Throwable)((Object)ex));
                    }
                    catch (LDAPException ex) {
                        throw new LDAPSearchException(ex.getResultCode(), "Failed to scroll to specified start", (Throwable)ex);
                    }
                }
                if (cookie != null && cookie.getValueLength() == 0) {
                    PagedResult result = new PagedResult();
                    result.setEntries(searchResultList);
                    result.setEntriesCount(searchResultList.size());
                    result.setStart(start);
                    PagedResult pagedResult = result;
                    return pagedResult;
                }
                List<EntryData> lastResult = null;
                int resultCount = 0;
                int lastCountRows = 0;
                do {
                    int currentLimit = pageSize;
                    if (count > 0) {
                        currentLimit = Math.min(pageSize, count - resultCount);
                    }
                    searchRequest.setControls(new Control[]{new SimplePagedResultsControl(currentLimit, cookie)});
                    this.setControls(searchRequest, controls);
                    searchResult = ldapConnection.search(searchRequest);
                    if (!ResultCode.SUCCESS.equals((Object)searchResult.getResultCode())) {
                        throw new SearchEntryException(String.format("Failed to search entries with baseDN: %s, filter: %s", dn, filter));
                    }
                    lastResult = this.getEntryDataList(searchResult);
                    lastCountRows = lastResult.size();
                    boolean collectSearchResult = true;
                    if (batchOperation != null) {
                        collectSearchResult = batchOperation.collectSearchResult(searchResult.getEntryCount());
                    }
                    if (collectSearchResult) {
                        searchResultList.addAll(lastResult);
                    }
                    if (batchOperation != null) {
                        List<T> entries = batchOperationWraper.createEntities(lastResult);
                        batchOperation.performAction(entries);
                    }
                    cookie = null;
                    try {
                        SimplePagedResultsControl c = SimplePagedResultsControl.get((SearchResult)searchResult);
                        if (c != null) {
                            cookie = c.getCookie();
                        }
                    }
                    catch (LDAPException ex) {
                        LOG.error("Error while accessing cookies" + ex.getMessage());
                    }
                    if (count > 0 && resultCount >= count) break;
                    if (lastCountRows >= currentLimit) continue;
                } while (cookie != null && cookie.getValueLength() > 0 && lastCountRows > 0);
            }
            catch (LDAPException ex) {
                throw new SearchException("Failed to scroll to specified start", (Throwable)ex, ex.getResultCode().intValue());
            }
            finally {
                this.releaseConnection(ldapConnection);
            }
        } else {
            this.setControls(searchRequest, controls);
            try {
                searchResult = this.getConnectionPool().search(searchRequest);
                if (!ResultCode.SUCCESS.equals((Object)searchResult.getResultCode())) {
                    throw new SearchEntryException(String.format("Failed to ssearch entries with baseDN: %s, filter: %s", dn, filter));
                }
                List<EntryData> lastResult = this.getEntryDataList(searchResult);
                boolean collectSearchResult = true;
                if (batchOperation != null) {
                    collectSearchResult = batchOperation.collectSearchResult(searchResult.getEntryCount());
                }
                if (collectSearchResult) {
                    searchResultList.addAll(lastResult);
                }
                if (batchOperation != null) {
                    List<T> entries = batchOperationWraper.createEntities(lastResult);
                    batchOperation.performAction(entries);
                }
            }
            catch (LDAPSearchException ex) {
                throw new SearchException(ex.getMessage(), (Throwable)ex, ex.getResultCode().intValue());
            }
        }
        PagedResult result = new PagedResult();
        result.setEntries(searchResultList);
        result.setEntriesCount(searchResultList.size());
        result.setStart(start);
        return result;
    }

    private SimplePagedResponse scrollSimplePagedResultsControl(LDAPConnection ldapConnection, String dn, Filter filter, SearchScope scope, Control[] controls, int start) throws LDAPException, InvalidSimplePageControlException {
        SearchRequest searchRequest = new SearchRequest(dn, scope, filter, new String[]{"dn"});
        int currentStartIndex = start;
        ASN1OctetString cookie = null;
        SearchResult searchResult = null;
        do {
            int pageSize = Math.min(currentStartIndex, 100);
            searchRequest.setControls(new Control[]{new SimplePagedResultsControl(pageSize, cookie, true)});
            this.setControls(searchRequest, controls);
            searchResult = ldapConnection.search(searchRequest);
            currentStartIndex -= searchResult.getEntryCount();
            try {
                SimplePagedResultsControl c = SimplePagedResultsControl.get((SearchResult)searchResult);
                if (c == null) continue;
                cookie = c.getCookie();
            }
            catch (LDAPException ex) {
                LOG.error("Error while accessing cookie", (Throwable)ex);
                throw new InvalidSimplePageControlException(ex.getResultCode(), "Error while accessing cookie");
            }
        } while (cookie != null && cookie.getValueLength() > 0 && currentStartIndex > 0);
        return new SimplePagedResponse(cookie, searchResult);
    }

    @Override
    public <T> PagedResult<EntryData> searchPagedEntries(String dn, Filter filter, SearchScope scope, int startIndex, int count, int pageSize, String sortBy, SortOrder sortOrder, String ... attributes) throws Exception {
        Instant startTime = OperationDurationUtil.instance().now();
        PagedResult<EntryData> result = this.searchSearchResultEntryListImpl(dn, filter, scope, startIndex, count, pageSize, sortBy, sortOrder, attributes);
        Duration duration = OperationDurationUtil.instance().duration(startTime);
        OperationDurationUtil.instance().logDebug("LDAP operation: search_result_list, duration: {}, dn: {}, filter: {}, scope: {}, startIndex: {}, count: {}, pageSize: {}, sortBy: {}, sortOrder: {}, attributes: {}, result: {}", new Object[]{duration, dn, filter, scope, startIndex, count, pageSize, sortBy, sortOrder, attributes, result});
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PagedResult<EntryData> searchSearchResultEntryListImpl(String dn, Filter filter, SearchScope scope, int start, int count, int pageSize, String sortBy, SortOrder sortOrder, String ... attributes) throws LDAPException, Exception {
        List<Object> searchResultEntryList = new ArrayList();
        int totalResults = 0;
        ASN1OctetString resumeCookie = null;
        LDAPConnection conn = null;
        try {
            SearchResult searchResult;
            List searchEntries;
            conn = this.getConnection();
            SearchRequest searchRequest = new SearchRequest(dn, scope, filter, attributes);
            do {
                searchResult = this.nextSearchResult(conn, searchRequest, pageSize, resumeCookie);
                searchEntries = searchResult.getSearchEntries();
                resumeCookie = this.getSearchResultCookie(searchResult);
            } while ((totalResults += searchEntries.size()) < start && resumeCookie != null);
            if (totalResults > start) {
                int lowerBound = searchEntries.size() - (totalResults - start);
                int upperBound = Math.min(searchEntries.size(), lowerBound + count);
                searchResultEntryList.addAll(searchEntries.subList(lowerBound, upperBound));
            }
            while (resumeCookie != null && totalResults < count + start) {
                searchResult = this.nextSearchResult(conn, searchRequest, pageSize, resumeCookie);
                searchEntries = searchResult.getSearchEntries();
                searchResultEntryList.addAll(searchEntries);
                totalResults += searchEntries.size();
                resumeCookie = this.getSearchResultCookie(searchResult);
            }
            if (totalResults > count + start) {
                searchResultEntryList = searchResultEntryList.subList(0, count);
            }
            while (resumeCookie != null) {
                searchResult = this.nextSearchResult(conn, searchRequest, pageSize, resumeCookie);
                searchEntries = searchResult.getSearchEntries();
                totalResults += searchEntries.size();
                resumeCookie = this.getSearchResultCookie(searchResult);
            }
            if (StringUtils.isNotEmpty((CharSequence)sortBy)) {
                boolean ascending = sortOrder == null || sortOrder.equals((Object)SortOrder.ASCENDING);
                searchResultEntryList = this.sortListByAttributes(searchResultEntryList, SearchResultEntry.class, false, ascending, sortBy);
            }
        }
        finally {
            this.releaseConnection(conn);
        }
        List<EntryData> entryDataList = this.getEntryDataList(searchResultEntryList);
        PagedResult result = new PagedResult();
        result.setEntries(entryDataList);
        result.setEntriesCount(entryDataList.size());
        result.setTotalEntriesCount(totalResults);
        result.setStart(start);
        return result;
    }

    private ASN1OctetString getSearchResultCookie(SearchResult searchResult) throws Exception {
        SimplePagedResultsControl responseControl = SimplePagedResultsControl.get((SearchResult)searchResult);
        return responseControl.moreResultsToReturn() ? responseControl.getCookie() : null;
    }

    private SearchResult nextSearchResult(LDAPConnection connection, SearchRequest searchRequest, int pageSize, ASN1OctetString resumeCookie) throws Exception {
        searchRequest.setControls(new Control[]{new SimplePagedResultsControl(pageSize, resumeCookie)});
        SearchResult result = connection.search(searchRequest);
        if (!ResultCode.SUCCESS.equals((Object)result.getResultCode())) {
            String msgErr = "Search operation returned: " + result.getResultCode();
            LOG.error(msgErr);
            throw new Exception(msgErr);
        }
        return result;
    }

    private void setControls(SearchRequest searchRequest, Control ... controls) {
        if (!ArrayHelper.isEmpty((Object[])controls)) {
            Control[] newControls = ArrayHelper.isEmpty((Object[])searchRequest.getControls()) ? controls : (Control[])ArrayHelper.arrayMerge((Object[][])new Control[][]{searchRequest.getControls(), controls});
            searchRequest.setControls(newControls);
        }
    }

    @Override
    public EntryData lookup(String dn, String ... attributes) throws ConnectionException, SearchException {
        Instant startTime = OperationDurationUtil.instance().now();
        EntryData result = this.lookupImpl(dn, attributes);
        Duration duration = OperationDurationUtil.instance().duration(startTime);
        OperationDurationUtil.instance().logDebug("LDAP operation: lookup, duration: {}, dn: {}, attributes: {}", new Object[]{duration, dn, attributes});
        return result;
    }

    private EntryData lookupImpl(String dn, String ... attributes) throws SearchException {
        try {
            SearchResultEntry searchResultEntry = attributes == null ? this.getConnectionPool().getEntry(dn) : this.getConnectionPool().getEntry(dn, attributes);
            EntryData result = this.getEntryData(searchResultEntry);
            if (result != null) {
                return result;
            }
        }
        catch (Exception ex) {
            throw new ConnectionException("Failed to lookup entry", (Throwable)ex);
        }
        throw new SearchException(String.format("Failed to lookup entry by DN: '%s'", dn));
    }

    @Override
    public boolean addEntry(String dn, Collection<Attribute> attributes) throws DuplicateEntryException, ConnectionException {
        Instant startTime = OperationDurationUtil.instance().now();
        boolean result = this.addEntryImpl(dn, attributes);
        Duration duration = OperationDurationUtil.instance().duration(startTime);
        OperationDurationUtil.instance().logDebug("LDAP operation: add, duration: {}, dn: {}, attributes: {}", new Object[]{duration, dn, attributes});
        return result;
    }

    private boolean addEntryImpl(String dn, Collection<Attribute> attributes) throws DuplicateEntryException {
        if (this.persistenceExtension != null) {
            this.updateUserPasswordAttribute(attributes);
        }
        try {
            LDAPResult result = this.getConnectionPool().add(dn, attributes);
            if (result.getResultCode().getName().equalsIgnoreCase("success")) {
                return true;
            }
        }
        catch (LDAPException ex) {
            int errorCode = ex.getResultCode().intValue();
            if (errorCode == 68) {
                throw new DuplicateEntryException();
            }
            if (errorCode == 50) {
                throw new ConnectionException("LDAP config error: insufficient access rights.", (Throwable)ex);
            }
            if (errorCode == 3) {
                throw new ConnectionException("LDAP Error: time limit exceeded", (Throwable)ex);
            }
            if (errorCode == 65) {
                throw new ConnectionException("LDAP config error: schema violation contact LDAP admin.", (Throwable)ex);
            }
            throw new ConnectionException("Error adding entry to directory. LDAP error number " + errorCode, (Throwable)ex);
        }
        return false;
    }

    @Deprecated
    protected boolean updateEntry(String dn, Collection<Attribute> attrs) throws DuplicateEntryException, ConnectionException {
        ArrayList<Modification> mods = new ArrayList<Modification>();
        for (Attribute attribute : attrs) {
            String attributeName = attribute.getName();
            String attributeValue = attribute.getValue();
            if (attributeName.equalsIgnoreCase("objectClass") || attributeName.equalsIgnoreCase("dn") || attributeName.equalsIgnoreCase("userPassword") || attributeValue == null) continue;
            mods.add(new Modification(ModificationType.REPLACE, attributeName, attributeValue));
        }
        return this.updateEntry(dn, (List<Modification>)mods);
    }

    @Override
    public boolean updateEntry(String dn, List<Modification> modifications) throws DuplicateEntryException, ConnectionException {
        Instant startTime = OperationDurationUtil.instance().now();
        boolean result = this.updateEntryImpl(dn, modifications);
        Duration duration = OperationDurationUtil.instance().duration(startTime);
        OperationDurationUtil.instance().logDebug("LDAP operation: modify, duration: {}, dn: {}, modifications: {}", new Object[]{duration, dn, modifications});
        return result;
    }

    private boolean updateEntryImpl(String dn, List<Modification> modifications) throws DuplicateEntryException {
        if (this.persistenceExtension != null) {
            this.updateUserPasswordModification(modifications);
        }
        ModifyRequest modifyRequest = new ModifyRequest(dn, modifications);
        return this.modifyEntry(modifyRequest);
    }

    protected boolean modifyEntry(ModifyRequest modifyRequest) throws DuplicateEntryException, ConnectionException {
        LDAPResult modifyResult = null;
        try {
            modifyResult = this.getConnectionPool().modify(modifyRequest);
            return ResultCode.SUCCESS.equals((Object)modifyResult.getResultCode());
        }
        catch (LDAPException ex) {
            int errorCode = ex.getResultCode().intValue();
            if (errorCode == 50) {
                throw new ConnectionException("LDAP config error: insufficient access rights.", (Throwable)ex);
            }
            if (errorCode == 3) {
                throw new ConnectionException("LDAP Error: time limit exceeded", (Throwable)ex);
            }
            if (errorCode == 65) {
                throw new ConnectionException("LDAP config error: schema violation contact LDAP admin.", (Throwable)ex);
            }
            throw new ConnectionException("Error updating entry in directory. LDAP error number " + errorCode, (Throwable)ex);
        }
    }

    @Override
    public boolean delete(String dn) throws ConnectionException {
        Instant startTime = OperationDurationUtil.instance().now();
        boolean result = this.deleteImpl(dn);
        Duration duration = OperationDurationUtil.instance().duration(startTime);
        OperationDurationUtil.instance().logDebug("LDAP operation: delete, duration: {}, dn: {}", new Object[]{duration, dn});
        return result;
    }

    private boolean deleteImpl(String dn) {
        try {
            LDAPResult result = this.getConnectionPool().delete(dn);
            return ResultCode.SUCCESS.equals((Object)result.getResultCode());
        }
        catch (Exception ex) {
            throw new ConnectionException("Failed to delete entry", (Throwable)ex);
        }
    }

    @Override
    public boolean deleteRecursively(String dn) throws ConnectionException {
        Instant startTime = OperationDurationUtil.instance().now();
        boolean result = this.deleteRecursivelyImpl(dn);
        Duration duration = OperationDurationUtil.instance().duration(startTime);
        OperationDurationUtil.instance().logDebug("LDAP operation: delete_tree, duration: {}, dn: {}", new Object[]{duration, dn});
        return result;
    }

    protected boolean deleteRecursivelyImpl(String dn) {
        try {
            DeleteRequest deleteRequest = new DeleteRequest(dn);
            deleteRequest.addControl((Control)new SubtreeDeleteRequestControl());
            LDAPResult result = this.getConnectionPool().delete(deleteRequest);
            return ResultCode.SUCCESS.equals((Object)result.getResultCode());
        }
        catch (Exception ex) {
            throw new ConnectionException("Failed to delete entry", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processChange(LDIFChangeRecord ldifRecord) throws LDAPException {
        LDAPConnection connection = this.getConnection();
        try {
            LDAPResult ldapResult = ldifRecord.processChange((LDAPInterface)connection);
            boolean bl = ResultCode.SUCCESS.equals((Object)ldapResult.getResultCode());
            return bl;
        }
        finally {
            this.releaseConnection(connection);
        }
    }

    @Override
    public int getSupportedLDAPVersion() {
        return this.connectionProvider.getSupportedLDAPVersion();
    }

    @Override
    public String getSubschemaSubentry() {
        return this.connectionProvider.getSubschemaSubentry();
    }

    @Override
    public boolean destroy() {
        boolean result = true;
        if (this.connectionProvider != null) {
            try {
                this.connectionProvider.closeConnectionPool();
            }
            catch (Exception ex) {
                LOG.error("Failed to close connection pool correctly");
                result = false;
            }
        }
        if (this.bindConnectionProvider != null) {
            try {
                this.bindConnectionProvider.closeConnectionPool();
            }
            catch (Exception ex) {
                LOG.error("Failed to close bind connection pool correctly");
                result = false;
            }
        }
        return result;
    }

    private EntryData getEntryData(SearchResultEntry entry) {
        List<AttributeData> attributeData = this.getAttributeDataList(entry);
        if (attributeData == null) {
            return null;
        }
        EntryData result = new EntryData(entry.getDN(), attributeData);
        return result;
    }

    private List<AttributeData> getAttributeDataList(SearchResultEntry entry) {
        if (entry == null) {
            return null;
        }
        ArrayList<AttributeData> result = new ArrayList<AttributeData>();
        for (Attribute attribute : entry.getAttributes()) {
            int i;
            Object[] attributeValues = NO_STRINGS;
            String attributeName = attribute.getName();
            if (LOG.isTraceEnabled() && attribute.needsBase64Encoding()) {
                LOG.trace("Found binary attribute: " + attributeName + ". Is defined in LDAP config: " + this.isBinaryAttribute(attributeName));
            }
            if (attribute.needsBase64Encoding()) {
                boolean binaryAttribute = this.isBinaryAttribute(attributeName);
                boolean certificateAttribute = this.isCertificateAttribute(attributeName);
                if (binaryAttribute || certificateAttribute) {
                    byte[][] attributeValuesByteArrays = attribute.getValueByteArrays();
                    if (attributeValuesByteArrays != null) {
                        attributeValues = new String[attributeValuesByteArrays.length];
                        for (i = 0; i < attributeValuesByteArrays.length; ++i) {
                            attributeValues[i] = Base64.encodeBase64String((byte[])attributeValuesByteArrays[i]);
                            LOG.trace("Binary attribute: " + attribute.getName() + " value (hex): " + Hex.encodeHexString((byte[])attributeValuesByteArrays[i]) + " value (base64): " + attributeValues[i]);
                        }
                    }
                } else {
                    attributeValues = attribute.getValues();
                }
                if (certificateAttribute) {
                    attributeName = this.getCertificateAttributeName(attributeName);
                }
            } else {
                attributeValues = attribute.getValues();
                String attributeNameLower = attribute.getName().toLowerCase();
                Class<?> attributeType = ATTRIBUTE_DATA_TYPES.get(attributeNameLower);
                if (attributeType != null) {
                    Object[] attributeValuesTyped;
                    if (attributeType.equals(Integer.class)) {
                        attributeValuesTyped = new Integer[attributeValues.length];
                        for (i = 0; i < attributeValues.length; ++i) {
                            try {
                                if (attributeValues[i] == null) continue;
                                attributeValuesTyped[i] = Integer.valueOf((String)attributeValues[i]);
                                continue;
                            }
                            catch (NumberFormatException ex) {
                                attributeValuesTyped[i] = null;
                                LOG.debug("Failed to parse integer", (Throwable)ex);
                            }
                        }
                        attributeValues = attributeValuesTyped;
                    } else if (attributeType.equals(Boolean.class)) {
                        attributeValuesTyped = new Boolean[attributeValues.length];
                        for (i = 0; i < attributeValues.length; ++i) {
                            if (attributeValues[i] == null) continue;
                            String lowerValue = StringHelper.toLowerCase((String)((String)attributeValues[i]));
                            attributeValuesTyped[i] = lowerValue.equals("true") || lowerValue.equals("t") || lowerValue.equals("yes") || lowerValue.equals("y") || lowerValue.equals("on") || lowerValue.equals("1") ? Boolean.TRUE : (lowerValue.equals("false") || lowerValue.equals("f") || lowerValue.equals("no") || lowerValue.equals("n") || lowerValue.equals("off") || lowerValue.equals("0") ? Boolean.FALSE : null);
                        }
                        attributeValues = attributeValuesTyped;
                    } else if (attributeType.equals(Date.class)) {
                        attributeValuesTyped = new Date[attributeValues.length];
                        for (i = 0; i < attributeValues.length; ++i) {
                            if (attributeValues[i] == null) continue;
                            try {
                                attributeValuesTyped[i] = StaticUtils.decodeGeneralizedTime((String)((String)attributeValues[i]));
                                continue;
                            }
                            catch (Exception ex) {
                                attributeValuesTyped[i] = null;
                                LOG.debug("Failed to parse date", (Throwable)ex);
                            }
                        }
                        attributeValues = attributeValuesTyped;
                    }
                }
            }
            boolean multiValued = attributeValues.length > 1;
            AttributeData tmpAttribute = new AttributeData(attributeName, attributeValues, Boolean.valueOf(multiValued));
            result.add(tmpAttribute);
        }
        return result;
    }

    private List<EntryData> getEntryDataList(SearchResult searchResult) {
        List searchResultEntries = searchResult.getSearchEntries();
        List<EntryData> entryDataList = this.getEntryDataList(searchResultEntries);
        return entryDataList;
    }

    private List<EntryData> getEntryDataList(List<SearchResultEntry> searchResultEntries) {
        SearchResultEntry entry;
        List<AttributeData> attributeDataList;
        LinkedList<EntryData> entryDataList = new LinkedList<EntryData>();
        Iterator<SearchResultEntry> iterator = searchResultEntries.iterator();
        while (iterator.hasNext() && (attributeDataList = this.getAttributeDataList(entry = iterator.next())) != null) {
            EntryData entryData = new EntryData(entry.getDN(), attributeDataList);
            entryDataList.add(entryData);
        }
        return entryDataList;
    }

    @Override
    public boolean isBinaryAttribute(String attributeName) {
        return this.connectionProvider.isBinaryAttribute(attributeName);
    }

    @Override
    public boolean isCertificateAttribute(String attributeName) {
        return this.connectionProvider.isCertificateAttribute(attributeName);
    }

    @Override
    public String getCertificateAttributeName(String attributeName) {
        return this.connectionProvider.getCertificateAttributeName(attributeName);
    }

    private void updateUserPasswordAttribute(Collection<Attribute> attributes) {
        Iterator<Attribute> it = attributes.iterator();
        while (it.hasNext()) {
            Attribute attribute = it.next();
            if (!StringHelper.equalsIgnoreCase((String)"userPassword", (String)attribute.getName())) continue;
            it.remove();
            Attribute newAttribute = new Attribute(attribute.getName(), this.createStoragePassword(attribute.getValues()));
            attributes.add(newAttribute);
            break;
        }
    }

    private void updateUserPasswordModification(List<Modification> modifications) {
        Iterator<Modification> it = modifications.iterator();
        while (it.hasNext()) {
            Modification modification = it.next();
            if (!StringHelper.equalsIgnoreCase((String)"userPassword", (String)modification.getAttributeName())) continue;
            it.remove();
            Modification newModification = new Modification(modification.getModificationType(), modification.getAttributeName(), this.createStoragePassword(modification.getValues()));
            modifications.add(newModification);
            break;
        }
    }

    public String[] createStoragePassword(String[] passwords) {
        if (ArrayHelper.isEmpty((Object[])passwords)) {
            return passwords;
        }
        String[] results = new String[passwords.length];
        for (int i = 0; i < passwords.length; ++i) {
            if (this.persistenceExtension == null) continue;
            results[i] = this.persistenceExtension.createHashedPassword(passwords[i]);
        }
        return results;
    }

    @Override
    public <T> List<T> sortListByAttributes(List<T> searchResultEntries, Class<T> cls, boolean caseSensitive, boolean ascending, String ... sortByAttributes) {
        if (searchResultEntries == null) {
            throw new MappingException("Entries list to sort is null");
        }
        if (searchResultEntries.size() == 0) {
            return searchResultEntries;
        }
        SearchResultEntryComparator comparator = new SearchResultEntryComparator(sortByAttributes, caseSensitive, ascending);
        Object[] dummyArr = (Object[])Array.newInstance(cls, 0);
        Object[] array = searchResultEntries.toArray(dummyArr);
        Arrays.sort(array, comparator);
        return Arrays.asList(array);
    }

    private void populateAttributeDataTypesMapping(String schemaEntryDn) {
        try {
            if (ATTRIBUTE_DATA_TYPES.size() == 0) {
                SearchResultEntry entry = this.getConnectionPool().getEntry(schemaEntryDn, new String[]{"attributeTypes", "objectClasses"});
                Attribute attrAttributeTypes = entry.getAttribute("attributeTypes");
                Attribute objectClassAttributeTypes = entry.getAttribute("objectClasses");
                this.populateAttributeTypes(attrAttributeTypes);
                this.populateObjectClassTypes(objectClassAttributeTypes);
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    private void populateAttributeTypes(Attribute attrAttributeTypes) throws LDAPException {
        HashMap<String, Pair> tmpMap = new HashMap<String, Pair>();
        for (String strAttributeType : attrAttributeTypes.getValues()) {
            AttributeTypeDefinition attrTypeDef = new AttributeTypeDefinition(strAttributeType);
            String[] names = attrTypeDef.getNames();
            if (names == null) continue;
            for (String name : names) {
                tmpMap.put(name, new Pair((Object)attrTypeDef.getBaseSyntaxOID(), (Object)attrTypeDef.getSuperiorType()));
            }
        }
        for (String name : tmpMap.keySet()) {
            Pair pair;
            Pair currPair = (Pair)tmpMap.get(name);
            String sup = (String)currPair.getSecond();
            if (currPair.getFirst() != null || sup == null || (pair = (Pair)tmpMap.get(sup)) == null) continue;
            currPair.setFirst((Object)((String)pair.getFirst()));
        }
        for (String name : tmpMap.keySet()) {
            Class<?> cls;
            String syntaxOID = (String)((Pair)tmpMap.get(name)).getFirst();
            if (syntaxOID == null || (cls = OID_SYNTAX_CLASS_MAPPING.get(syntaxOID)) == null) continue;
            ATTRIBUTE_DATA_TYPES.put(name.toLowerCase(), cls);
        }
    }

    private void populateObjectClassTypes(Attribute objectClassAttributeTypes) throws LDAPException {
        for (String strObjectClassAttributeType : objectClassAttributeTypes.getValues()) {
            String[] objectClassNames;
            ObjectClassDefinition objectClassTypeDef = new ObjectClassDefinition(strObjectClassAttributeType);
            HashSet<String> attributeNamesSet = new HashSet<String>();
            attributeNamesSet.addAll(Arrays.asList(objectClassTypeDef.getRequiredAttributes()));
            attributeNamesSet.addAll(Arrays.asList(objectClassTypeDef.getOptionalAttributes()));
            ArrayList attributeNamesList = new ArrayList(attributeNamesSet);
            for (String objectClassName : objectClassNames = objectClassTypeDef.getNames()) {
                String objectClassNameLower = objectClassName.toLowerCase();
                OBJECT_CLASS_DATA_TYPES.put(objectClassNameLower, attributeNamesList);
                OBJECT_CLASS_TREE.put(objectClassNameLower, Arrays.asList(objectClassTypeDef.getSuperiorClasses()));
            }
        }
    }

    @Override
    public Set<String> getAttributes(String objectClass) {
        String objectClassNameLower = objectClass.toLowerCase();
        TreeSet<String> attributeNamesSet = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        List<String> attributNames = OBJECT_CLASS_DATA_TYPES.get(objectClassNameLower);
        attributeNamesSet.addAll(attributNames);
        List<String> subObjectClasses = OBJECT_CLASS_TREE.get(objectClassNameLower);
        for (String subObjectClass : subObjectClasses) {
            List<String> subAttributeNames = OBJECT_CLASS_DATA_TYPES.get(subObjectClass.toLowerCase());
            attributeNamesSet.addAll(subAttributeNames);
        }
        return attributeNamesSet;
    }

    @Override
    public String getAttributeType(String attributeName) {
        return ATTRIBUTE_DATA_TYPES.get(attributeName.toLowerCase()).getSimpleName();
    }

    public boolean isConnected() {
        return this.connectionProvider.isConnected();
    }

    public void setPersistenceExtension(PersistenceExtension persistenceExtension) {
        this.persistenceExtension = persistenceExtension;
    }

    public boolean isSupportObjectClass(String objectClass) {
        return true;
    }

    public PersistenceMetadata getPersistenceMetadata(String primaryKey) {
        throw new UnsupportedOperationException("Method not implemented.");
    }

    public Map<String, Map<String, AttributeType>> getTableColumnsMap() {
        throw new UnsupportedOperationException("Method not implemented.");
    }

    static {
        NO_STRINGS = new String[0];
        OID_SYNTAX_CLASS_MAPPING = new HashMap();
        OID_SYNTAX_CLASS_MAPPING.put("1.3.6.1.4.1.1466.115.121.1.7", Boolean.class);
        OID_SYNTAX_CLASS_MAPPING.put("1.3.6.1.4.1.1466.115.121.1.11", String.class);
        OID_SYNTAX_CLASS_MAPPING.put("1.3.6.1.4.1.1466.115.121.1.15", String.class);
        OID_SYNTAX_CLASS_MAPPING.put("1.3.6.1.4.1.1466.115.121.1.12", String.class);
        OID_SYNTAX_CLASS_MAPPING.put("1.3.6.1.4.1.1466.115.121.1.22", String.class);
        OID_SYNTAX_CLASS_MAPPING.put("1.3.6.1.4.1.1466.115.121.1.24", Date.class);
        OID_SYNTAX_CLASS_MAPPING.put("1.3.6.1.4.1.1466.115.121.1.26", String.class);
        OID_SYNTAX_CLASS_MAPPING.put("1.3.6.1.4.1.1466.115.121.1.27", Integer.class);
        OID_SYNTAX_CLASS_MAPPING.put("1.3.6.1.4.1.1466.115.121.1.36", String.class);
        OID_SYNTAX_CLASS_MAPPING.put("1.3.6.1.4.1.1466.115.121.1.41", String.class);
        OID_SYNTAX_CLASS_MAPPING.put("1.3.6.1.4.1.1466.115.121.1.50", String.class);
    }

    private class SimplePagedResponse {
        private ASN1OctetString cookie;
        private SearchResult lastSearchResult;

        public SimplePagedResponse(ASN1OctetString cookie, SearchResult lastSearchResult) {
            this.cookie = cookie;
            this.lastSearchResult = lastSearchResult;
        }

        public ASN1OctetString getCookie() {
            return this.cookie;
        }

        public SearchResult getLastSearchResult() {
            return this.lastSearchResult;
        }
    }

    private static final class SearchResultEntryComparator<T>
    implements Comparator<T>,
    Serializable {
        private static final long serialVersionUID = 574848841116711467L;
        private String[] sortByAttributes;
        private boolean caseSensitive;
        private boolean ascending;

        private SearchResultEntryComparator(String[] sortByAttributes, boolean caseSensitive, boolean ascending) {
            this.sortByAttributes = sortByAttributes;
            this.caseSensitive = caseSensitive;
            this.ascending = ascending;
        }

        @Override
        public int compare(T entry1, T entry2) {
            int result = 0;
            if (entry1 == null) {
                result = entry2 == null ? 0 : -1;
            } else if (entry2 == null) {
                result = 1;
            } else {
                String currSortByAttribute;
                String[] stringArray = this.sortByAttributes;
                int n = stringArray.length;
                for (int i = 0; i < n && (result = this.compare(entry1, entry2, currSortByAttribute = stringArray[i])) == 0; ++i) {
                }
            }
            if (!this.ascending) {
                result *= -1;
            }
            return result;
        }

        public int compare(T entry1, T entry2, String attributeName) {
            int result = 0;
            try {
                if (entry1 instanceof SearchResultEntry) {
                    SearchResultEntry resultEntry1 = (SearchResultEntry)entry1;
                    SearchResultEntry resultEntry2 = (SearchResultEntry)entry2;
                    String value1 = resultEntry1.getAttributeValue(attributeName);
                    String value2 = resultEntry2.getAttributeValue(attributeName);
                    if (value1 == null) {
                        result = value2 == null ? 0 : -1;
                    } else if (value2 == null) {
                        result = 1;
                    } else {
                        Class<?> cls = ATTRIBUTE_DATA_TYPES.get(attributeName);
                        if (cls != null) {
                            if (cls.equals(Integer.class)) {
                                return resultEntry1.getAttributeValueAsInteger(attributeName).compareTo(resultEntry2.getAttributeValueAsInteger(attributeName));
                            }
                            if (cls.equals(Boolean.class)) {
                                return resultEntry1.getAttributeValueAsBoolean(attributeName).compareTo(resultEntry2.getAttributeValueAsBoolean(attributeName));
                            }
                            if (cls.equals(Date.class)) {
                                return resultEntry1.getAttributeValueAsDate(attributeName).compareTo(resultEntry2.getAttributeValueAsDate(attributeName));
                            }
                        }
                        result = this.caseSensitive ? value1.compareTo(value2) : value1.toLowerCase().compareTo(value2.toLowerCase());
                    }
                }
            }
            catch (Exception e) {
                LOG.error("Error occurred when comparing entries with SearchResultEntryComparator");
                LOG.error(e.getMessage(), (Throwable)e);
            }
            return result;
        }
    }
}

