/*
 * Decompiled with CFR 0.152.
 */
package io.jans.service;

import io.jans.service.message.provider.MessageInterface;
import io.jans.service.message.provider.MessageProvider;
import io.jans.service.message.pubsub.PubSubInterface;
import jakarta.inject.Inject;
import org.slf4j.Logger;

public abstract class BaseMessageService
implements MessageInterface {
    public static int DEFAULT_EXPIRATION = 60;
    @Inject
    private Logger log;

    @Override
    public void subscribe(PubSubInterface pubSubAdapter, String ... channels) {
        MessageProvider messageProvider = this.getMessageProvider();
        if (messageProvider == null) {
            this.log.error("Message provider is invalid!");
            return;
        }
        this.log.trace("Subscribe '{}' for channels '{}'", (Object)pubSubAdapter, (Object)channels);
        messageProvider.subscribe(pubSubAdapter, channels);
    }

    @Override
    public void unsubscribe(PubSubInterface pubSubAdapter) {
        MessageProvider messageProvider = this.getMessageProvider();
        if (messageProvider == null) {
            this.log.error("Message provider is invalid!");
            return;
        }
        this.log.trace("Unsubscribe '{}'", (Object)pubSubAdapter);
        messageProvider.unsubscribe(pubSubAdapter);
    }

    @Override
    public boolean publish(String channel, String message) {
        MessageProvider messageProvider = this.getMessageProvider();
        if (messageProvider == null) {
            this.log.error("Message provider is invalid!");
            return false;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("Publish '{}' to channel '{}'", (Object)message, (Object)channel);
        }
        boolean result = messageProvider.publish(channel, message);
        return result;
    }

    protected abstract MessageProvider getMessageProvider();
}

