/*
 * Decompiled with CFR 0.152.
 */
package io.jans.service.message.provider;

import io.jans.orm.sql.operation.impl.SqConnectionProviderPool;
import io.jans.service.cache.RedisProvider;
import io.jans.service.message.model.config.MessageConfiguration;
import io.jans.service.message.model.config.MessageProviderType;
import io.jans.service.message.model.config.PostgresMessageConfiguration;
import io.jans.service.message.provider.AbstractMessageProvider;
import io.jans.service.message.pubsub.PubSubInterface;
import io.jans.util.StringHelper;
import io.jans.util.security.StringEncrypter;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.postgresql.PGConnection;
import org.postgresql.PGNotification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class PostgresMessageProvider
extends AbstractMessageProvider<SqConnectionProviderPool> {
    @Inject
    private Logger log;
    @Inject
    private MessageConfiguration messageConfiguration;
    @Inject
    private StringEncrypter stringEncrypter;
    private ConcurrentHashMap<Integer, List<PostgresMessageListener>> subscibedPubSubs;
    private SqConnectionProviderPool \u0441onnectionProviderPool;
    private ExecutorService executorService;

    @PostConstruct
    public void init() {
    }

    @Override
    @PreDestroy
    public void destroy() {
        this.log.debug("Destroying PostgresProvider");
        this.shutdown();
        if (this.\u0441onnectionProviderPool != null) {
            this.\u0441onnectionProviderPool.destroy();
        }
        this.log.debug("Destroyed PostgresProvider");
    }

    @Override
    public void create(ExecutorService executorService) {
        this.executorService = executorService;
        this.subscibedPubSubs = new ConcurrentHashMap();
        try {
            PostgresMessageConfiguration postgresMessageConfiguration = this.messageConfiguration.getPostgresConfiguration();
            Properties connectionProperties = this.toPostgresProperties(postgresMessageConfiguration);
            this.log.debug("Starting PostgresMessageProvider messages ... configuration {}", (Object)postgresMessageConfiguration);
            this.\u0441onnectionProviderPool = new SqConnectionProviderPool(connectionProperties);
            this.\u0441onnectionProviderPool.create();
            if (!this.\u0441onnectionProviderPool.isCreated()) {
                throw new IllegalStateException(String.format("Failed to create SQL connection pool for messaging! Result code: '%d'", this.\u0441onnectionProviderPool.getCreationResultCode()));
            }
            this.log.debug("PostgresMessageProvider message was started.");
        }
        catch (Exception ex) {
            this.log.error("Failed to start PostgresProvider messages", (Throwable)ex);
            throw new IllegalStateException("Failed to create SQL connection pool for messaging!", ex);
        }
    }

    public void configure(MessageConfiguration messageConfiguration, StringEncrypter stringEncrypter) {
        this.log = LoggerFactory.getLogger(RedisProvider.class);
        this.messageConfiguration = messageConfiguration;
        this.stringEncrypter = stringEncrypter;
    }

    private Properties toPostgresProperties(PostgresMessageConfiguration postgresMessageConfiguration) {
        Properties connectionProperties = new Properties();
        this.setProperty(connectionProperties, "jdbc.driver.class-name", postgresMessageConfiguration.getDriverClassName());
        this.setProperty(connectionProperties, "db.schema.name", postgresMessageConfiguration.getDbSchemaName());
        this.setProperty(connectionProperties, "connection.uri", postgresMessageConfiguration.getConnectionUri());
        this.setProperty(connectionProperties, "auth.userName", postgresMessageConfiguration.getAuthUserName());
        String password = postgresMessageConfiguration.getAuthUserPassword();
        try {
            if (StringUtils.isNotBlank((CharSequence)password)) {
                password = this.stringEncrypter.decrypt(password);
                this.log.trace("Decrypted Postgres password successfully.");
            }
        }
        catch (StringEncrypter.EncryptionException e) {
            this.log.error("Error during Postgres password decryption", (Throwable)e);
        }
        this.setProperty(connectionProperties, "auth.userPassword", password);
        if (postgresMessageConfiguration.getConnectionPoolMaxTotal() != null) {
            this.setProperty(connectionProperties, "connection.pool.max-total", postgresMessageConfiguration.getConnectionPoolMaxTotal().toString());
        }
        if (postgresMessageConfiguration.getConnectionPoolMaxIdle() != null) {
            this.setProperty(connectionProperties, "connection.pool.max-idle", postgresMessageConfiguration.getConnectionPoolMaxIdle().toString());
        }
        if (postgresMessageConfiguration.getConnectionPoolMinIdle() != null) {
            this.setProperty(connectionProperties, "connection.pool.min-idle", postgresMessageConfiguration.getConnectionPoolMinIdle().toString());
        }
        return connectionProperties;
    }

    public void setProperty(Properties connectionProperties, String propertyName, String propertyValue) {
        if (StringHelper.isNotEmpty((String)propertyValue)) {
            connectionProperties.setProperty(propertyName, propertyValue);
        }
    }

    public boolean isConnected() {
        return this.\u0441onnectionProviderPool.isConnected();
    }

    @Override
    public SqConnectionProviderPool getDelegate() {
        return this.\u0441onnectionProviderPool;
    }

    @Override
    public MessageProviderType getProviderType() {
        return MessageProviderType.POSTGRES;
    }

    @Override
    public void subscribe(PubSubInterface pubSub, String ... channels) {
        this.log.info("Starting new thread(s) for subscribing to Postgres channels {}", Arrays.asList(channels));
        ArrayList<PostgresMessageListener> listeners = new ArrayList<PostgresMessageListener>();
        int countChannels = 0;
        for (String channel : channels) {
            Connection conn = this.\u0441onnectionProviderPool.getConnection();
            try {
                PostgresMessageListener postgresMessageListener = new PostgresMessageListener(pubSub, conn);
                postgresMessageListener.subscribe(channel);
                listeners.add(postgresMessageListener);
                this.executorService.execute(postgresMessageListener);
                pubSub.onSubscribe(channel, ++countChannels);
            }
            catch (SQLException ex) {
                this.log.error(String.format("Failed to subscribe to Postgres channel {}", channel));
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Exception ex2) {
                        this.log.error(String.format("Failed to release connection after subscribe attempt to Postgres channel {}", channel));
                    }
                }
                throw new IllegalStateException(String.format("Failed to subscribe to Postgres channel {}", channel), ex);
            }
        }
        this.subscibedPubSubs.put(System.identityHashCode(pubSub), listeners);
    }

    @Override
    public void unsubscribe(PubSubInterface pubSub) {
        this.log.info("Starting end subscription to Postgres for {}", (Object)pubSub);
        int pubSubIdentifier = System.identityHashCode(pubSub);
        List<PostgresMessageListener> listeners = this.subscibedPubSubs.get(pubSubIdentifier);
        if (listeners == null) {
            this.log.warn("PubSub {} in unsubscribe request is not registered", (Object)pubSub);
            return;
        }
        this.unsubscribe(listeners);
        this.subscibedPubSubs.remove(pubSubIdentifier);
        this.log.info("Sent request to end subscription to Postgres for {}", (Object)pubSub);
    }

    private void unsubscribe(List<PostgresMessageListener> listeners) {
        Iterator<PostgresMessageListener> it = listeners.iterator();
        while (it.hasNext()) {
            PostgresMessageListener listener = it.next();
            try {
                listener.unsubscribe();
                it.remove();
                PubSubInterface pubSub = listener.getPubSub();
                pubSub.onUnsubscribe(listener.getChannel(), listeners.size());
            }
            catch (Throwable ex) {
                this.log.error("Failed to unsubscribe for {}", (Object)listener.getPubSub());
            }
        }
    }

    @Override
    public boolean publish(String channel, String message) {
        CompletableFuture.runAsync(() -> {
            try (Connection conn = this.\u0441onnectionProviderPool.getConnection();
                 Statement stmt = conn.createStatement();){
                stmt.execute(String.format("NOTIFY %s, '%s'", channel, Base64.encodeBase64String((byte[])message.getBytes())));
            }
            catch (SQLException ex) {
                this.log.error("Failed to publish message to channel {}", (Object)channel, (Object)ex);
            }
        });
        return true;
    }

    @Override
    public void shutdown() {
        for (List<PostgresMessageListener> listeners : this.subscibedPubSubs.values()) {
            this.unsubscribe(listeners);
        }
        this.subscibedPubSubs.clear();
    }

    class PostgresMessageListener
    implements Runnable {
        private PubSubInterface pubSub;
        private String channel;
        private Connection conn;
        private PGConnection pgConn;
        private boolean active;

        PostgresMessageListener(PubSubInterface pubSub, Connection conn) throws SQLException {
            this.pubSub = pubSub;
            this.conn = conn;
            this.pgConn = conn.unwrap(PGConnection.class);
            this.active = true;
        }

        public PubSubInterface getPubSub() {
            return this.pubSub;
        }

        public String getChannel() {
            return this.channel;
        }

        public void subscribe(String channel) throws SQLException {
            this.channel = channel;
            try (Statement stmt = this.conn.createStatement();){
                stmt.execute("LISTEN " + channel);
            }
        }

        public void unsubscribe() throws SQLException {
            this.active = false;
            try (Statement stmt = this.conn.createStatement();){
                stmt.execute("UNLISTEN " + this.channel);
            }
            this.conn.close();
        }

        @Override
        public void run() {
            PostgresMessageConfiguration postgresMessageConfiguration = PostgresMessageProvider.this.messageConfiguration.getPostgresConfiguration();
            int messageWaitMillis = postgresMessageConfiguration.getMessageWaitMillis();
            int messageSleepThreadTime = postgresMessageConfiguration.getMessageSleepThreadTime();
            try {
                while (this.active) {
                    PGNotification[] notifications = this.pgConn.getNotifications(messageWaitMillis);
                    if (notifications != null) {
                        for (int i = 0; i < notifications.length; ++i) {
                            this.pubSub.onMessage(notifications[i].getName(), new String(Base64.decodeBase64((String)notifications[i].getParameter()), StandardCharsets.UTF_8));
                        }
                    }
                    Thread.sleep(messageSleepThreadTime);
                }
            }
            catch (SQLException notifications) {
            }
            catch (InterruptedException ex) {
                PostgresMessageProvider.this.log.error("Error during reading messages", (Throwable)ex);
            }
        }
    }
}

