/*
 * Decompiled with CFR 0.152.
 */
package io.jans.service.custom.script;

import io.jans.model.ScriptLocationType;
import io.jans.model.SimpleCustomProperty;
import io.jans.model.SimpleExtendedCustomProperty;
import io.jans.model.custom.script.CustomScriptType;
import io.jans.model.custom.script.conf.CustomScriptConfiguration;
import io.jans.model.custom.script.model.CustomScript;
import io.jans.model.custom.script.type.BaseExternalType;
import io.jans.service.cdi.async.Asynchronous;
import io.jans.service.cdi.event.Scheduled;
import io.jans.service.cdi.event.UpdateScriptEvent;
import io.jans.service.custom.inject.ReloadScript;
import io.jans.service.custom.script.AbstractCustomScriptService;
import io.jans.service.custom.script.ExternalScriptService;
import io.jans.service.custom.script.ExternalTypeCreator;
import io.jans.service.timer.event.TimerEvent;
import io.jans.service.timer.schedule.TimerSchedule;
import io.jans.util.StringHelper;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.BeforeDestroyed;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import jakarta.servlet.ServletContext;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;

@ApplicationScoped
public class CustomScriptManager {
    public static final String CUSTOM_SCRIPT_MODIFIED_EVENT_TYPE = "customScriptModifiedEvent";
    public static final int DEFAULT_INTERVAL = 30;
    protected static final String[] CUSTOM_SCRIPT_CHECK_ATTRIBUTES = new String[]{"dn", "inum", "jansRevision", "jansScrTyp", "jansModuleProperty", "jansEnabled"};
    @Inject
    protected Logger log;
    @Inject
    private Event<TimerEvent> timerEvent;
    @Inject
    protected ExternalTypeCreator externalTypeCreator;
    @Inject
    protected AbstractCustomScriptService customScriptService;
    @Inject
    @ReloadScript
    private Event<String> event;
    @Inject
    private Instance<ExternalScriptService> externalScriptServiceInstance;
    protected List<CustomScriptType> supportedCustomScriptTypes;
    private Map<String, CustomScriptConfiguration> customScriptConfigurations;
    private AtomicBoolean isActive;
    private long lastFinishedTime;
    private Map<CustomScriptType, List<CustomScriptConfiguration>> customScriptConfigurationsByScriptType;
    private boolean initialized = false;

    @Asynchronous
    public void initTimer(List<CustomScriptType> supportedCustomScriptTypes) {
        this.supportedCustomScriptTypes = supportedCustomScriptTypes;
        this.configure();
        int delay = 30;
        this.reload(true);
        this.timerEvent.fire((Object)new TimerEvent(new TimerSchedule(30, 30), (Object)new UpdateScriptEvent(), new Annotation[]{Scheduled.Literal.INSTANCE}));
        this.initialized = true;
    }

    protected void configure() {
        this.isActive = new AtomicBoolean(false);
        this.lastFinishedTime = System.currentTimeMillis();
    }

    public void reloadTimerEvent(@Observes @Scheduled UpdateScriptEvent updateScriptEvent) {
        if (this.isActive.get()) {
            return;
        }
        if (!this.isActive.compareAndSet(false, true)) {
            return;
        }
        try {
            this.reload(false);
        }
        catch (Throwable ex) {
            this.log.error("Exception happened while reloading custom scripts configuration", ex);
        }
        finally {
            this.isActive.set(false);
            this.lastFinishedTime = System.currentTimeMillis();
            this.log.trace("Last finished time '{}'", (Object)new Date(this.lastFinishedTime));
        }
    }

    public void destroy(@BeforeDestroyed(value=ApplicationScoped.class) ServletContext init) {
        this.log.debug("Destroying custom scripts configurations");
        if (this.customScriptConfigurations == null) {
            return;
        }
        for (Map.Entry<String, CustomScriptConfiguration> customScriptConfigurationEntry : this.customScriptConfigurations.entrySet()) {
            this.destroyCustomScript(customScriptConfigurationEntry.getValue());
        }
    }

    private void reload(boolean syncUpdate) {
        boolean modified = this.reloadImpl();
        if (modified) {
            this.updateScriptServices(syncUpdate);
        }
    }

    protected void updateScriptServices(boolean syncUpdate) {
        if (syncUpdate) {
            for (ExternalScriptService externalScriptService : this.externalScriptServiceInstance) {
                if (!this.supportedCustomScriptTypes.contains((Object)externalScriptService.getCustomScriptType())) continue;
                externalScriptService.reload(CUSTOM_SCRIPT_MODIFIED_EVENT_TYPE);
            }
        } else {
            this.event.fire((Object)CUSTOM_SCRIPT_MODIFIED_EVENT_TYPE);
        }
    }

    private boolean reloadImpl() {
        List<Object> customScripts = this.supportedCustomScriptTypes.isEmpty() ? new ArrayList() : this.customScriptService.findCustomScripts(this.supportedCustomScriptTypes, CUSTOM_SCRIPT_CHECK_ATTRIBUTES);
        ReloadResult reloadResult = this.reloadCustomScriptConfigurations(this.customScriptConfigurations, customScripts);
        this.customScriptConfigurations = reloadResult.getCustomScriptConfigurations();
        this.customScriptConfigurationsByScriptType = this.groupCustomScriptConfigurationsByScriptType(this.customScriptConfigurations);
        return reloadResult.isModified();
    }

    private ReloadResult reloadCustomScriptConfigurations(Map<String, CustomScriptConfiguration> customScriptConfigurations, List<CustomScript> newCustomScripts) {
        HashMap<Object, Object> newCustomScriptConfigurations;
        boolean modified = false;
        if (customScriptConfigurations == null) {
            newCustomScriptConfigurations = new HashMap();
            modified = true;
        } else {
            newCustomScriptConfigurations = new HashMap<String, CustomScriptConfiguration>(customScriptConfigurations);
        }
        ArrayList<String> newSupportedCustomScriptInums = new ArrayList<String>();
        for (CustomScript newCustomScript : newCustomScripts) {
            if (!newCustomScript.isEnabled()) continue;
            if (ScriptLocationType.FILE == newCustomScript.getLocationType()) {
                long fileModifiactionTime = this.getFileModificationTime(newCustomScript.getLocationPath());
                newCustomScript.setRevision(newCustomScript.getRevision() + fileModifiactionTime);
            }
            String newSupportedCustomScriptInum = StringHelper.toLowerCase((String)newCustomScript.getInum());
            newSupportedCustomScriptInums.add(newSupportedCustomScriptInum);
            CustomScriptConfiguration prevCustomScriptConfiguration = (CustomScriptConfiguration)newCustomScriptConfigurations.get(newSupportedCustomScriptInum);
            if (prevCustomScriptConfiguration != null && prevCustomScriptConfiguration.getCustomScript().getRevision() == newCustomScript.getRevision()) continue;
            if (prevCustomScriptConfiguration != null) {
                this.destroyCustomScript(prevCustomScriptConfiguration);
            }
            CustomScript loadedCustomScript = this.customScriptService.getCustomScriptByDn(newCustomScript.getScriptType().getCustomScriptModel(), newCustomScript.getDn());
            HashMap<String, SimpleCustomProperty> newConfigurationAttributes = new HashMap<String, SimpleCustomProperty>();
            List<SimpleExtendedCustomProperty> simpleCustomProperties = loadedCustomScript.getConfigurationProperties();
            if (simpleCustomProperties == null) {
                simpleCustomProperties = new ArrayList<SimpleExtendedCustomProperty>(0);
            }
            for (SimpleCustomProperty simpleCustomProperty : simpleCustomProperties) {
                newConfigurationAttributes.put(simpleCustomProperty.getValue1(), simpleCustomProperty);
            }
            if (ScriptLocationType.FILE == loadedCustomScript.getLocationType()) {
                String scriptFromFile;
                long fileModifiactionTime = this.getFileModificationTime(loadedCustomScript.getLocationPath());
                loadedCustomScript.setRevision(loadedCustomScript.getRevision() + fileModifiactionTime);
                if (fileModifiactionTime != 0L && StringHelper.isNotEmpty((String)(scriptFromFile = this.loadFromFile(loadedCustomScript.getLocationPath())))) {
                    loadedCustomScript.setScript(scriptFromFile);
                }
            }
            BaseExternalType newCustomScriptExternalType = this.externalTypeCreator.createExternalType(loadedCustomScript, newConfigurationAttributes);
            CustomScriptConfiguration customScriptConfiguration = new CustomScriptConfiguration(loadedCustomScript, newCustomScriptExternalType, newConfigurationAttributes);
            newCustomScriptConfigurations.put(newSupportedCustomScriptInum, customScriptConfiguration);
            modified = true;
        }
        Iterator it = newCustomScriptConfigurations.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry externalAuthenticatorConfigurationEntry = it.next();
            String prevSupportedCustomScriptInum = (String)externalAuthenticatorConfigurationEntry.getKey();
            if (newSupportedCustomScriptInums.contains(prevSupportedCustomScriptInum)) continue;
            this.destroyCustomScript((CustomScriptConfiguration)externalAuthenticatorConfigurationEntry.getValue());
            it.remove();
            modified = true;
        }
        return new ReloadResult(newCustomScriptConfigurations, modified);
    }

    private String loadFromFile(String locationPath) {
        try {
            String scriptFromFile = FileUtils.readFileToString((File)new File(locationPath), (Charset)StandardCharsets.UTF_8);
            if (this.log.isTraceEnabled()) {
                this.log.trace("Loaded from file: {}, script: {}", (Object)locationPath, (Object)scriptFromFile);
            }
            return scriptFromFile;
        }
        catch (IOException ex) {
            this.log.error("Failed to load script from '{}'", (Object)locationPath);
            return null;
        }
    }

    private long getFileModificationTime(String locationPath) {
        File scriptFile = new File(locationPath);
        if (scriptFile.exists()) {
            return scriptFile.lastModified();
        }
        return 0L;
    }

    private boolean destroyCustomScript(CustomScriptConfiguration customScriptConfiguration) {
        String customScriptInum = customScriptConfiguration.getInum();
        boolean result = this.executeCustomScriptDestroy(customScriptConfiguration);
        if (!result) {
            this.log.error("Failed to destroy custom script '{}' correctly", (Object)customScriptInum);
        }
        return result;
    }

    private Map<CustomScriptType, List<CustomScriptConfiguration>> groupCustomScriptConfigurationsByScriptType(Map<String, CustomScriptConfiguration> customScriptConfigurations) {
        EnumMap<CustomScriptType, List<CustomScriptConfiguration>> newCustomScriptConfigurationsByScriptType = new EnumMap<CustomScriptType, List<CustomScriptConfiguration>>(CustomScriptType.class);
        for (CustomScriptType customScriptType : this.supportedCustomScriptTypes) {
            ArrayList customConfigurationsByScriptType = new ArrayList();
            newCustomScriptConfigurationsByScriptType.put(customScriptType, customConfigurationsByScriptType);
        }
        for (CustomScriptConfiguration customScriptConfiguration : customScriptConfigurations.values()) {
            CustomScriptType customScriptType = customScriptConfiguration.getCustomScript().getScriptType();
            List customConfigurationsByScriptType = (List)newCustomScriptConfigurationsByScriptType.get((Object)customScriptType);
            if (customConfigurationsByScriptType == null) continue;
            customConfigurationsByScriptType.add(customScriptConfiguration);
        }
        return newCustomScriptConfigurationsByScriptType;
    }

    public boolean executeCustomScriptDestroy(CustomScriptConfiguration customScriptConfiguration) {
        try {
            this.log.debug("Executing python 'destroy' custom script method");
            BaseExternalType externalType = customScriptConfiguration.getExternalType();
            Map<String, SimpleCustomProperty> configurationAttributes = customScriptConfiguration.getConfigurationAttributes();
            return externalType.destroy(configurationAttributes);
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(customScriptConfiguration.getCustomScript(), ex);
            return false;
        }
    }

    public CustomScriptConfiguration getCustomScriptConfigurationByInum(String inum) {
        return this.customScriptConfigurations.get(inum);
    }

    public List<CustomScriptConfiguration> getCustomScriptConfigurationsByScriptType(CustomScriptType customScriptType) {
        List<CustomScriptConfiguration> tmpCustomScriptConfigurationsByScriptType = this.customScriptConfigurationsByScriptType.get((Object)customScriptType);
        if (tmpCustomScriptConfigurationsByScriptType == null) {
            tmpCustomScriptConfigurationsByScriptType = new ArrayList<CustomScriptConfiguration>(0);
        }
        return new ArrayList<CustomScriptConfiguration>(tmpCustomScriptConfigurationsByScriptType);
    }

    public List<CustomScriptConfiguration> getCustomScriptConfigurations() {
        return new ArrayList<CustomScriptConfiguration>(this.customScriptConfigurations.values());
    }

    public List<CustomScriptType> getSupportedCustomScriptTypes() {
        return this.supportedCustomScriptTypes;
    }

    public boolean isSupportedType(CustomScriptType customScriptType) {
        return this.supportedCustomScriptTypes.contains((Object)customScriptType);
    }

    public void saveScriptError(CustomScript customScript, Exception exception) {
        this.externalTypeCreator.saveScriptError(customScript, exception);
    }

    public void clearScriptError(CustomScript customScript) {
        this.externalTypeCreator.clearScriptError(customScript);
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    private class ReloadResult {
        private Map<String, CustomScriptConfiguration> customScriptConfigurations;
        private boolean modified;

        ReloadResult(Map<String, CustomScriptConfiguration> customScriptConfigurations, boolean modified) {
            this.customScriptConfigurations = customScriptConfigurations;
            this.modified = modified;
        }

        public Map<String, CustomScriptConfiguration> getCustomScriptConfigurations() {
            return this.customScriptConfigurations;
        }

        public boolean isModified() {
            return this.modified;
        }
    }
}

