/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.rmi.client;

import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.Hashtable;
import javax.jcr.Repository;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.apache.jackrabbit.rmi.client.ClientAdapterFactory;
import org.apache.jackrabbit.rmi.client.LocalAdapterFactory;
import org.apache.jackrabbit.rmi.client.SafeClientRepository;
import org.apache.jackrabbit.rmi.remote.RemoteRepository;

@Deprecated(forRemoval=true)
public class ClientRepositoryFactory
implements ObjectFactory {
    public static final String URL_PARAMETER = "url";
    private LocalAdapterFactory factory;

    public ClientRepositoryFactory() {
        this(new ClientAdapterFactory());
    }

    public ClientRepositoryFactory(LocalAdapterFactory factory) {
        this.factory = factory;
    }

    public Repository getRepository(final String url) throws MalformedURLException, NotBoundException, ClassCastException, RemoteException {
        return new SafeClientRepository(this.factory){

            @Override
            protected RemoteRepository getRemoteRepository() throws RemoteException {
                try {
                    return (RemoteRepository)Naming.lookup(url);
                }
                catch (MalformedURLException e) {
                    throw new RemoteException("Malformed URL: " + url, e);
                }
                catch (NotBoundException e) {
                    throw new RemoteException("No target found: " + url, e);
                }
                catch (ClassCastException e) {
                    throw new RemoteException("Unknown target: " + url, e);
                }
            }
        };
    }

    public Object getObjectInstance(Object object, Name name, Context context, Hashtable environment) {
        Reference reference;
        RefAddr url;
        if (object instanceof Reference && (url = (reference = (Reference)object).get(URL_PARAMETER)) != null && url.getContent() != null) {
            try {
                return this.getRepository(url.getContent().toString());
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }
}

